/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.graph.GraphFont;
import oracle.dss.graph.UIGraphFontAttribute;

public class FontUnderLineTool
extends JToggleButton
implements DataviewTool,
ActionListener {
    Object m_selectedObject;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    private ResourceBundle rBundle;
    private boolean m_enable = true;

    public FontUnderLineTool() {
        this.addActionListener(this);
        this.setEnabled(false);
        this.setIcon(this.makeImage("images/underline.gif"));
        this.setRolloverIcon(this.makeImage("images/l_underline.gif"));
        this.setRolloverSelectedIcon(this.makeImage("images/l_underline.gif"));
        this.setBorder(null);
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
        this.setToolTipText(this.rBundle.getString("FontUnderLine"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        if (controllerEvent == null) {
            return;
        }
        if (controllerEvent.getComponentHandle() == null || controllerEvent.getComponentHandle().getComponent() == null) {
            this.m_selectedObject = null;
            this.setEnabled(false);
            return;
        }
        if (controllerEvent.getComponentHandle().getComponent() == this.m_selectedObject) {
            return;
        }
        Object object = controllerEvent.getComponentHandle().getComponent();
        this.m_enable = false;
        if (object instanceof UIGraphFontAttribute) {
            this.m_selectedObject = object;
            this.setEnabled(true);
            int n = ((UIGraphFontAttribute)this.m_selectedObject).getUIGraphFont().getGraphFontStyle();
            if (n == 0 || n == 1 || n == 2 || n == 3) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
        }
        this.m_enable = true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null || !this.m_enable) {
            return;
        }
        if (actionEvent.getSource() == this) {
            GraphFont graphFont = (GraphFont)((UIGraphFontAttribute)this.m_selectedObject).getUIGraphFont();
            int n = graphFont.getGraphFontStyle();
            if (this.isSelected()) {
                if (n == 0) {
                    graphFont.setGraphFontStyle(4);
                }
                if (n == 1) {
                    graphFont.setGraphFontStyle(5);
                }
                if (n == 2) {
                    graphFont.setGraphFontStyle(6);
                }
                if (n == 3) {
                    graphFont.setGraphFontStyle(7);
                }
            } else {
                if (n == 4) {
                    graphFont.setGraphFontStyle(0);
                }
                if (n == 5) {
                    graphFont.setGraphFontStyle(1);
                }
                if (n == 6) {
                    graphFont.setGraphFontStyle(2);
                }
                if (n == 7) {
                    graphFont.setGraphFontStyle(3);
                }
            }
        }
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    public void update() {
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    public void cleanUp() {
    }
}

