/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.gui.InsertButton;
import oracle.dss.util.gui.LimitedTextDocument;
import oracle.dss.util.gui.ViewTextField;

public abstract class BaseAxis
extends BasePanel
implements PropertyChangeListener,
ItemListener,
ActionListener,
CaretListener {
    protected ResourceBundle rBundle;
    private boolean m_bSuperCalled = true;
    private String[] tokenArray;
    protected JCheckBox m_showAxis;
    protected InsertButton m_insert;
    protected FontButton m_fontButton;
    protected ViewTextField m_axisTitle;
    protected JPanel m_axisTitlePanel;
    protected JPanel m_axisLinePanel;
    protected JLabel m_lineLabel;
    protected JLabel m_optionsLabel;
    protected JLabel m_axisLineLabel1;
    protected LineWidth m_lineWidth;
    protected JPanel m_lineWidthPanel;
    protected BIColorChoice m_colorButton;
    protected int m_alignment;
    protected Font m_font;
    protected Color m_oldAxisColor;
    protected String m_oldAxisTitle;
    protected int m_oldLineWidth;
    protected JLabel m_axisLineLabel2;
    protected boolean m_bFontNameChange;
    protected boolean m_bFontStyleChange;
    protected boolean m_bFontSizeChange;
    protected boolean m_bHorizontalAlignmentChange;
    protected boolean m_bFontColorChange;
    protected boolean m_bFontBackgroundColorChange;
    protected boolean m_bTextRotationChange;
    protected boolean m_bColorPaletteSet;
    protected JPanel axisLinePanel;
    protected JPanel m_optionsLabelPanel;
    protected JPanel m_axisLineSeparatorPanel;
    protected JPanel m_optionSeparatorPanel;
    protected ArrayTwoDModel m_colorPalette;
    protected String m_oldFontName;
    protected String m_newFontName;
    protected String m_applicationName;
    protected int m_oldFontStyle;
    protected int m_newFontStyle;
    protected int m_oldFontSize;
    protected int m_newFontSize;
    protected int m_oldHAlignment;
    protected int m_newHAlignment;
    protected int m_oldRotation;
    protected int m_newRotation;
    protected int m_errorTypes = 65535;
    protected ErrorHandler m_eh;
    protected Color m_oldFontColor;
    protected Color m_newFontColor;
    protected Color m_oldFontBackgroundColor;
    protected Color m_newFontBackgroundColor;
    protected Color m_lColor;
    protected TokenSubstitution m_token;
    protected NumberFormat m_numFormat;
    protected boolean m_bLineWidthChanged;
    protected boolean m_bLineColorChanged;
    protected boolean m_bTitleVisibleChanged;
    protected boolean m_bTitleFontNameChanged;
    protected boolean m_bTitleFontBoldChanged;
    protected boolean m_bTitleFontItalicChanged;
    protected boolean m_bTitleFontUnderlineChanged;
    protected boolean m_bTitleFontSizeChanged;
    protected boolean m_bTitleAlignmentChanged;
    protected boolean m_bTitleFontColorChanged;
    protected boolean m_bTitleRotationChanged;
    protected boolean m_bTitleTextChanged;
    protected boolean m_bLabelFontNameChanged;
    protected boolean m_bLabelFontBoldChanged;
    protected boolean m_bLabelFontItalicChanged;
    protected boolean m_bLabelFontUnderlineChanged;
    protected boolean m_bLabelFontSizeChanged;
    protected boolean m_bLabelAlignmentChanged;
    protected boolean m_bLabelFontColorChanged;
    protected boolean m_bLabelRotationChanged;
    protected Dimension prefSize;
    protected boolean insertButtonVisible = true;
    public static final String PROPERTY_LINE_WIDTH = "LineWidth";
    public static final String PROPERTY_AXIS_COLOR = "AxisColor";
    public static final String PROPERTY_AXIS_TITLE = "AxisTitle";
    public static final String PROPERTY_AXIS_VISIBLE = "AxisVisible";
    public static final int ALL_ERRORS_AND_WARNINGS = 65535;
    public static final int NONE = 0;
    public static final int ALL_ERRORS = 1;
    public static final int WARNINGS = 2;
    public static final int NON_DATA_ERRORS = 4;

    public BaseAxis(Graph graph) {
        super(graph);
        this.updateResourceBundle(graph.getLocale());
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_showAxis = new JCheckBox();
        this.m_showAxis.setAlignmentY(1.0f);
        this.m_token = graph.getTokenSubstitution();
        this.m_insert = new InsertButton(this.m_token.getListItems());
        if (this.m_token != null) {
            this.tokenArray = this.m_token.getListItems();
            int n = 0;
            while (n < this.tokenArray.length) {
                this.tokenArray[n] = this.m_token.getToken(this.tokenArray[n]);
                ++n;
            }
        }
        this.m_insert.setAlignmentY(1.0f);
        this.m_fontButton = new FontButton();
        this.m_fontButton.setCustomColorsEnabled(graph.isCustomColorsEnabled());
        this.m_fontButton.setAlignmentY(1.0f);
        this.initTitleFontButton(this.m_fontButton);
        this.m_fontButton.setPaneLocale(graph.getLocale());
        this.m_insert.setLocale(graph.getLocale());
        this.m_insert.setType(0);
        this.m_showAxis.setForeground(this.m_label.getForeground());
        this.m_insert.setForeground(this.m_label.getForeground());
        this.m_fontButton.setForeground(this.m_label.getForeground());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.m_showAxis);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentY(1.0f);
        jPanel2.add((Component)((Object)this.m_insert));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(this.m_fontButton);
        JPanel jPanel3 = new JPanel(new FlowLayout(2, 0, 0));
        jPanel3.setAlignmentY(1.0f);
        jPanel3.add(jPanel2);
        jPanel.add(jPanel3);
        int n = this.m_showAxis.getPreferredSize().width + jPanel2.getPreferredSize().width;
        int n2 = Math.max(jPanel2.getPreferredSize().height, this.m_showAxis.getPreferredSize().height);
        jPanel.setPreferredSize(new Dimension(n, n2));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n2));
        LimitedTextDocument limitedTextDocument = new LimitedTextDocument(1024, this.tokenArray);
        String string = this.m_token.getTokenString(this.m_graph.getUIFootnote().getUnParseText());
        this.m_axisTitle = new ViewTextField(limitedTextDocument, string, 0);
        this.m_axisTitle.setComponentOrientation(this.getOrientation());
        this.m_axisTitle.setPreferredSize(new Dimension(400, 25));
        this.m_axisTitle.setMinimumSize(this.m_axisTitle.getPreferredSize());
        this.m_axisTitle.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, this.m_axisTitle.getPreferredSize().height));
        this.m_axisTitlePanel = new JPanel();
        this.m_axisTitlePanel.setLayout(new BoxLayout(this.m_axisTitlePanel, 1));
        this.m_axisTitlePanel.add(jPanel);
        this.m_axisTitlePanel.add(Box.createVerticalStrut(5));
        this.m_axisTitlePanel.add(this.m_axisTitle);
        n = Math.max(jPanel.getPreferredSize().width, this.m_axisTitle.getPreferredSize().width);
        n2 = jPanel.getPreferredSize().height + 5 + this.m_axisTitle.getPreferredSize().height;
        this.m_axisTitlePanel.setPreferredSize(new Dimension(n, n2));
        this.m_axisTitlePanel.setMinimumSize(this.m_axisTitlePanel.getPreferredSize());
        this.m_axisTitlePanel.setMaximumSize(new Dimension(this.getToolkit().getScreenSize().width, n2));
        this.m_axisLinePanel = new JPanel();
        this.m_axisLinePanel.setLayout(new BoxLayout(this.m_axisLinePanel, 1));
        this.m_lineLabel = new JLabel();
        this.m_optionsLabel = new JLabel();
        this.m_optionsLabelPanel = new JPanel();
        this.m_optionsLabelPanel.setLayout(new BoxLayout(this.m_optionsLabelPanel, 1));
        this.m_optionsLabelPanel.add(this.m_optionsLabel);
        this.m_optionsLabelPanel.add(Box.createVerticalStrut(5));
        this.axisLinePanel = new JPanel();
        this.axisLinePanel.setLayout(new BoxLayout(this.axisLinePanel, 0));
        this.m_axisLineLabel1 = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Line thickness")));
        this.m_axisLineLabel1.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Line thickness")));
        this.m_lineWidth = new LineWidth();
        this.m_lineWidth.setForeground(this.m_label.getForeground());
        this.m_axisLineLabel1.setLabelFor(this.m_lineWidth);
        this.m_lineWidthPanel = new JPanel();
        this.m_lineWidthPanel.setLayout(new BoxLayout(this.m_lineWidthPanel, 0));
        this.m_lineWidthPanel.add(this.m_axisLineLabel1);
        this.m_lineWidthPanel.add(Box.createHorizontalStrut(12));
        this.m_lineWidthPanel.add(this.m_lineWidth);
        this.m_lineWidthPanel.add(Box.createHorizontalStrut(24));
        this.axisLinePanel.add(this.m_lineWidthPanel);
        this.m_axisLineLabel2 = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Line color")));
        this.m_axisLineLabel2.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Line color")));
        this.axisLinePanel.add(this.m_axisLineLabel2);
        this.axisLinePanel.add(Box.createHorizontalStrut(12));
        this.m_colorButton = new BIColorChoice();
        this.m_colorButton.setCustomColorsEnabled(graph.isCustomColorsEnabled());
        this.m_axisLineLabel2.setLabelFor((Component)((Object)this.m_colorButton));
        this.axisLinePanel.add((Component)((Object)this.m_colorButton));
        this.m_axisLinePanel.add(this.m_lineLabel);
        this.m_axisLinePanel.add(Box.createVerticalStrut(5));
        this.m_axisLinePanel.add(this.axisLinePanel);
        this.m_mainPanel.add(this.m_axisTitlePanel);
        this.m_axisLineSeparatorPanel = new JPanel();
        this.m_axisLineSeparatorPanel.setLayout(new BoxLayout(this.m_axisLineSeparatorPanel, 1));
        this.m_axisLineSeparatorPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.m_axisLineSeparatorPanel);
        this.m_mainPanel.add(this.m_axisLinePanel);
        this.m_optionSeparatorPanel = new JPanel();
        this.m_optionSeparatorPanel.setLayout(new BoxLayout(this.m_optionSeparatorPanel, 1));
        this.m_optionSeparatorPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.m_optionSeparatorPanel);
        this.m_mainPanel.add(this.m_optionsLabelPanel);
        jPanel.setAlignmentX(0.0f);
        this.m_axisTitle.setAlignmentX(0.0f);
        this.m_lineLabel.setAlignmentX(0.0f);
        this.axisLinePanel.setAlignmentX(0.0f);
        this.m_optionsLabel.setAlignmentX(0.0f);
        this.m_optionsLabelPanel.setAlignmentX(0.0f);
        int n3 = 0;
        n = this.m_axisTitlePanel.getPreferredSize().width;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < (n = this.m_axisLinePanel.getPreferredSize().width)) {
            n3 = n;
        }
        if (n3 < (n = this.m_optionsLabelPanel.getPreferredSize().width)) {
            n3 = n;
        }
        n = n3 + 10 + 10;
        n2 = this.m_mainPanel.getPreferredSize().height + this.m_label.getPreferredSize().height + 10 + 10 + 15;
        this.prefSize = new Dimension(n, n2);
        this.m_fontButton.addPropertyChangeListener(this);
        this.m_colorButton.addPropertyChangeListener(this);
        this.m_lineWidth.addItemListener(this);
        this.m_showAxis.addItemListener(this);
        this.m_axisTitle.addCaretListener(this);
        this.m_insert.addActionListener(this);
        this.m_applicationName = this.rBundle.getString("Graph");
    }

    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.m_token = graph.getTokenSubstitution();
        this.m_insert.removeActionListener(this);
        this.m_insert.setModel(new DefaultComboBoxModel<String>(this.m_token.getListItems()));
        this.m_insert.addActionListener(this);
        this.initTitleFontButton(this.m_fontButton);
        this.m_bLineWidthChanged = false;
        this.m_bLineColorChanged = false;
        this.m_bTitleVisibleChanged = false;
        this.m_bTitleFontNameChanged = false;
        this.m_bTitleFontBoldChanged = false;
        this.m_bTitleFontItalicChanged = false;
        this.m_bTitleFontUnderlineChanged = false;
        this.m_bTitleFontSizeChanged = false;
        this.m_bTitleAlignmentChanged = false;
        this.m_bTitleFontColorChanged = false;
        this.m_bTitleRotationChanged = false;
        this.m_bLabelFontNameChanged = false;
        this.m_bLabelFontBoldChanged = false;
        this.m_bLabelFontItalicChanged = false;
        this.m_bLabelFontUnderlineChanged = false;
        this.m_bLabelFontSizeChanged = false;
        this.m_bLabelAlignmentChanged = false;
        this.m_bLabelFontColorChanged = false;
        this.m_bLabelRotationChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_colorButton.setCustomColorsEnabled(graph.isCustomColorsEnabled());
    }

    public void setColorPalette(Color[][] colorArray) {
        if (colorArray != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel(colorArray);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        this.m_fontButton.setColorPalette(this.m_colorPalette);
        if (this.m_lColor != null) {
            this.m_colorButton.setSelectedColor((Color)this.m_colorButton.getColorPalette().getData(0, 0));
            this.m_colorButton.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)this.m_lColor)) {
                    this.m_colorButton.setColorPalette(FontButton.getNewColorPalette(this.m_colorButton.getColorPalette(), this.m_lColor, this.m_bColorPaletteSet));
                }
                this.m_colorButton.setSelectedColor(this.m_lColor);
            } else {
                this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(this.m_lColor));
            }
        }
        this.m_colorButton.setColorPalette((TwoDModel)this.m_colorPalette);
    }

    public Color[][] getColorPalette() {
        return FontButton.getColorArray(this.m_colorButton.getColorPalette());
    }

    public void setApplicationName(String string) {
        this.m_applicationName = string;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.m_eh = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setInsertButtonVisible(boolean bl) {
        this.m_insert.setVisible(bl);
        this.insertButtonVisible = bl;
    }

    public boolean isInsertButtonVisible() {
        return this.insertButtonVisible;
    }

    protected void updateResourceBundle(Locale locale) {
        if (locale != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", locale);
            this.m_numFormat = NumberFormat.getNumberInstance(locale);
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
            this.m_numFormat = NumberFormat.getNumberInstance();
        }
        this.m_numFormat.setMinimumFractionDigits(2);
        this.m_numFormat.setMaximumFractionDigits(2);
    }

    protected boolean isGraphHorizontal() {
        switch (this.m_graph.getGraphType()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return true;
            }
        }
        return false;
    }

    protected void initTitleFontButton(FontButton fontButton) {
        int n = 7;
        int n2 = 1;
        if (this.m_graph.getGraphType() > 14) {
            int n3 = 30;
            fontButton.setAlignmentButtonMask(n3);
        } else {
            fontButton.setAlignmentButtonMask(0);
        }
        fontButton.setStyleButtonMask(n);
        fontButton.setColorComponentMask(n2);
    }

    protected void initFontButton(FontButton fontButton) {
        int n = 7;
        int n2 = 1;
        int n3 = 14;
        fontButton.setStyleButtonMask(n);
        fontButton.setAlignmentButtonMask(0);
        fontButton.setColorComponentMask(n2);
        fontButton.setRotationButtonMask(n3);
    }

    protected int convertToFontButtonConstants(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    protected int convertFromFontButtonConstants(int n) {
        int n2;
        switch (n) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_insert.setLocale(locale);
    }

    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.m_axisTitle) {
            String string = this.m_axisTitle.getText();
            if (string.length() > 0) {
                this.m_showAxis.setSelected(true);
                this.firePropertyChange(PROPERTY_AXIS_TITLE, this.m_oldAxisTitle, string);
                this.m_oldAxisTitle = string;
                this.m_bTitleTextChanged = true;
            } else {
                this.m_showAxis.setSelected(false);
                this.firePropertyChange(PROPERTY_AXIS_TITLE, this.m_oldAxisTitle, string);
                this.m_bTitleTextChanged = true;
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            if (itemEvent.getSource() == this.m_showAxis) {
                this.firePropertyChange(PROPERTY_AXIS_VISIBLE, false, true);
                this.m_bTitleVisibleChanged = true;
            } else if (itemEvent.getSource() == this.m_lineWidth) {
                int n = this.m_lineWidth.getSelectedIndex();
                this.firePropertyChange(PROPERTY_LINE_WIDTH, this.m_oldLineWidth, n);
                this.m_oldLineWidth = n;
                this.m_bLineWidthChanged = true;
            }
        } else if (itemEvent.getStateChange() == 2 && itemEvent.getSource() == this.m_showAxis) {
            this.firePropertyChange(PROPERTY_AXIS_VISIBLE, true, false);
            this.m_bTitleVisibleChanged = true;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        boolean bl;
        String string;
        boolean bl2 = false;
        if (propertyChangeEvent.getSource() == this.m_colorButton) {
            if (propertyChangeEvent.getPropertyName().equals("selectedColor")) {
                Color color = this.m_colorButton.getSelectedColor();
                this.m_lineWidth.setCellColor(color);
                this.firePropertyChange(PROPERTY_AXIS_COLOR, this.m_oldAxisColor, color);
                this.m_oldAxisColor = color;
                this.m_bLineColorChanged = true;
            }
            return;
        }
        if (propertyChangeEvent.getSource() == this.m_fontButton) {
            bl2 = true;
        }
        if ((string = propertyChangeEvent.getPropertyName()) == "fontDialogCancelled" && !(bl = ((Boolean)(object = (Boolean)propertyChangeEvent.getNewValue())).booleanValue())) {
            if (this.m_bFontNameChange) {
                this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                if (bl2) {
                    this.m_font = new Font(this.m_newFontName, this.m_font.getStyle(), this.m_axisTitle.getFont().getSize());
                    this.m_axisTitle.setFont(this.m_font);
                    this.m_bTitleFontNameChanged = true;
                } else {
                    this.m_bLabelFontNameChanged = true;
                }
                this.m_bFontNameChange = false;
            }
            if (this.m_bFontStyleChange) {
                this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                int n = this.m_oldFontStyle ^ this.m_newFontStyle;
                if (bl2) {
                    if (this.m_newFontStyle >= 4) {
                        this.m_axisTitle.setUnderline(true);
                    } else {
                        this.m_axisTitle.setUnderline(false);
                    }
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if ((this.m_newFontStyle & 1) != 0) {
                        bl3 = true;
                    }
                    if ((this.m_newFontStyle & 2) != 0) {
                        bl4 = true;
                    }
                    this.m_font = new Font(this.m_font.getName(), this.m_newFontStyle, this.m_axisTitle.getFont().getSize());
                    this.m_axisTitle.setFont(new Font(this.m_font.getName(), ViewStyle.fontStyle(bl3, bl4), this.m_axisTitle.getFont().getSize()));
                    if ((n & 1) != 0) {
                        this.m_bTitleFontBoldChanged = true;
                    }
                    if ((n & 2) != 0) {
                        this.m_bTitleFontItalicChanged = true;
                    }
                    if ((n & 4) != 0) {
                        this.m_bTitleFontUnderlineChanged = true;
                    }
                } else {
                    if ((n & 1) != 0) {
                        this.m_bLabelFontBoldChanged = true;
                    }
                    if ((n & 2) != 0) {
                        this.m_bLabelFontItalicChanged = true;
                    }
                    if ((n & 4) != 0) {
                        this.m_bLabelFontUnderlineChanged = true;
                    }
                }
                this.m_bFontStyleChange = false;
            }
            if (this.m_bFontSizeChange) {
                this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                this.m_bFontSizeChange = false;
                if (bl2) {
                    this.m_bTitleFontSizeChanged = true;
                } else {
                    this.m_bLabelFontSizeChanged = true;
                }
            }
            if (this.m_bHorizontalAlignmentChange) {
                this.firePropertyChange("fontHorizontalAlignment", this.m_oldHAlignment, this.m_newHAlignment);
                if (bl2) {
                    this.m_axisTitle.setHorizontalAlignment(this.m_newHAlignment);
                    this.m_bTitleAlignmentChanged = true;
                } else {
                    this.m_bLabelAlignmentChanged = true;
                }
                this.m_bHorizontalAlignmentChange = false;
            }
            if (this.m_bFontColorChange) {
                this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                if (bl2) {
                    this.m_axisTitle.setForeground(this.m_newFontColor);
                    this.m_bTitleFontColorChanged = true;
                } else {
                    this.m_bLabelFontColorChanged = true;
                }
                this.m_bFontColorChange = false;
            }
            if (this.m_bFontBackgroundColorChange) {
                this.firePropertyChange("fontBackgroundColor", this.m_oldFontBackgroundColor, this.m_newFontBackgroundColor);
                if (bl2) {
                    this.m_axisTitle.setBackground(this.m_newFontBackgroundColor);
                }
                this.m_bFontBackgroundColorChange = false;
            }
            if (this.m_bTextRotationChange) {
                this.firePropertyChange("textRotation", this.m_oldRotation, this.m_newRotation);
                this.m_bTextRotationChange = false;
                if (bl2) {
                    this.m_bTitleRotationChanged = true;
                } else {
                    this.m_bLabelRotationChanged = true;
                }
            }
            this.m_axisTitle.repaint();
        }
        if (string == "fontHorizontalAlignment") {
            object = (Integer)propertyChangeEvent.getOldValue();
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if (!this.m_bHorizontalAlignmentChange) {
                this.m_oldHAlignment = (Integer)object;
            }
            this.m_newHAlignment = n;
            if ((Integer)object != this.m_newHAlignment) {
                this.m_bHorizontalAlignmentChange = true;
            }
        }
        if (string == "fontColor") {
            if (!this.m_bFontColorChange) {
                this.m_oldFontColor = (Color)propertyChangeEvent.getOldValue();
            }
            this.m_newFontColor = (Color)propertyChangeEvent.getNewValue();
            if ((Color)propertyChangeEvent.getOldValue() != this.m_newFontColor) {
                this.m_bFontColorChange = true;
            }
        }
        if (string == "fontBackgroundColor") {
            if (!this.m_bFontBackgroundColorChange) {
                this.m_oldFontBackgroundColor = (Color)propertyChangeEvent.getOldValue();
            }
            this.m_newFontBackgroundColor = (Color)propertyChangeEvent.getNewValue();
            if ((Color)propertyChangeEvent.getOldValue() != this.m_newFontBackgroundColor) {
                this.m_bFontBackgroundColorChange = true;
            }
        }
        if (string == "fontName") {
            object = (String)propertyChangeEvent.getOldValue();
            if (!this.m_bFontNameChange) {
                this.m_oldFontName = object;
            }
            this.m_newFontName = (String)propertyChangeEvent.getNewValue();
            if (object != this.m_newFontName) {
                this.m_bFontNameChange = true;
            }
        }
        if (string == "fontStyle") {
            object = (Integer)propertyChangeEvent.getOldValue();
            if (!this.m_bFontStyleChange) {
                this.m_oldFontStyle = (Integer)object;
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.m_newFontStyle = n;
            if ((Integer)object != this.m_newFontStyle) {
                this.m_bFontStyleChange = true;
            }
        }
        if (string == "fontSize") {
            object = (Integer)propertyChangeEvent.getOldValue();
            if (!this.m_bFontSizeChange) {
                this.m_oldFontSize = (Integer)object;
            }
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            this.m_newFontSize = n;
            if ((Integer)object != this.m_newFontSize) {
                this.m_bFontSizeChange = true;
            }
        }
        if (string == "textRotation") {
            object = (Integer)propertyChangeEvent.getOldValue();
            Integer n = (Integer)propertyChangeEvent.getNewValue();
            if (!this.m_bTextRotationChange) {
                this.m_oldRotation = (Integer)object;
            }
            this.m_newRotation = n;
            if ((Integer)object != this.m_newRotation) {
                this.m_bTextRotationChange = true;
            }
        }
    }

    public void setErrorTypes(int n) {
        this.m_errorTypes = n;
    }

    public int getErrorTypes() {
        return this.m_errorTypes;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.m_insert && (string = this.m_insert.getSelectedItem()) != null) {
            String string2 = this.m_axisTitle.getText();
            String string3 = String.valueOf(string2.substring(0, this.m_axisTitle.getCaretPosition())) + this.m_token.getToken(string) + string2.substring(this.m_axisTitle.getCaretPosition(), string2.length());
            this.firePropertyChange(PROPERTY_AXIS_TITLE, string2, string3);
            String string4 = String.valueOf(string2.substring(0, this.m_axisTitle.getCaretPosition())) + this.m_token.getToken(string);
            this.m_axisTitle.setText(string3);
            this.m_axisTitle.requestFocus();
            if (string4.length() > 1024) {
                this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
            } else {
                this.m_axisTitle.setCaretPosition(string4.length());
            }
        }
    }

    public void cleanUp() {
        this.m_axisLineLabel1.setLabelFor(null);
        this.axisLinePanel.remove(this.m_lineWidth);
        this.m_lineWidth.removeItemListener(this);
        this.m_lineWidth.cleanUp();
        this.m_lineWidth = null;
        this.m_fontButton.removePropertyChangeListener(this);
        this.m_colorButton.removePropertyChangeListener(this);
        this.m_showAxis.removeItemListener(this);
        this.m_axisTitle.removeCaretListener(this);
        this.m_insert.removeActionListener(this);
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        super.cleanUp();
    }
}

