/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.Line;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Y3DMarkerGrid
extends BaseGraphComponent
implements Line {
    protected static final int ATTR_LINECOLOR = 0;
    protected static final int ATTR_LINEWIDTH = 1;
    protected static final int ATTR_STYLE_MAXID = 2;
    protected String lineColor = GraphDefaultValues.getY3DMarkerGridLineColor();
    protected int lineWidth = GraphDefaultValues.getY3DMarkerGridLineWidth();

    public Y3DMarkerGrid(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getCubeRiserGridY();
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setLineColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(0);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setLineWidth(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, n);
            this.setPropertyOverrideFlags(1);
        }
    }

    protected String getComponentName() {
        return "Y3DMarkerGrid";
    }

    protected int getStylePropertyCount() {
        return 2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("lineColor", BaseGraphComponent.toHexString(this.getLineColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("lineWidth", this.getLineWidth());
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("lineColor");
        if (propertyNode != null) {
            this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("lineWidth")) != null) {
            this.setLineWidth(propertyNode.getValueAsInteger());
        }
    }

    protected void resetStyle() {
        this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(this.lineColor)));
        this.setLineWidth(this.lineWidth);
        super.resetStyle();
    }
}

