/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseMajorTick;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;

public class Y2MajorTick
extends BaseMajorTick {
    public Y2MajorTick(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getY2MajorGrid();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.visible = GraphDefaultValues.isY2MajorTickVisible();
        this.lineColor = GraphDefaultValues.getY2MajorTickLineColor();
        this.lineWidth = GraphDefaultValues.getY2MajorTickLineWidth();
        this.lineStyle = GraphDefaultValues.getY2MajorTickLineStyle();
        this.tickStyle = GraphDefaultValues.getY2MajorTickStyle();
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getTickStyle() {
        return this.m_pfj.getY2MajorGridStyle();
    }

    public void setTickStyle(int n) {
        if (n < 0 || n > 4) {
            this.m_graph.getErrorHandler().log("invalid style", "oracle.dss.graph.Y2MajorTick", "setTickStyle(int style)");
        } else {
            this.m_pfj.setY2MajorGridStyle(n);
            this.setPropertyOverrideFlags(4);
        }
    }

    public boolean isVisible() {
        return this.m_pfj.getY2MajorGridDisplay();
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setY2MajorGridDisplay(bl);
        this.setPropertyOverrideFlags(2);
    }

    protected String getComponentName() {
        return "Y2MajorTick";
    }
}

