/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIStockMarker;
import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class StockMarker
extends BaseDataComponent
implements UIStockMarker {
    protected static final int ATTR_FALLINGCOLOR = 0;
    protected static final int ATTR_RISINGCOLOR = 1;
    protected static final int ATTR_STYLE_MAXID = 2;
    protected int fallingColor = GraphDefaultValues.getStockMarkerFallingColor();
    protected int risingColor = GraphDefaultValues.getStockMarkerRisingColor();
    private static final String a_fallingColor = "fallingColor";
    private static final String a_risingColor = "risingColor";

    public StockMarker(Graph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    public int getStockMarkerType(int n, int n2) {
        double d;
        double d2;
        switch (this.m_graph.getGraphType()) {
            case 70: {
                if (this.m_graph.isDataRowShownAsASeries()) {
                    d2 = this.getValue(n, 0 + 4 * n2);
                    d = this.getValue(n, 3 + 4 * n2);
                    break;
                }
                d2 = this.getValue(0 + 4 * n2, n);
                d = this.getValue(3 + 4 * n2, n);
                break;
            }
            case 71: {
                if (this.m_graph.isDataRowShownAsASeries()) {
                    d2 = this.getValue(n, 0 + 5 * n2);
                    d = this.getValue(n, 3 + 5 * n2);
                    break;
                }
                d2 = this.getValue(0 + 5 * n2, n);
                d = this.getValue(3 + 5 * n2, n);
                break;
            }
            case 72: {
                if (this.m_graph.isDataRowShownAsASeries()) {
                    d2 = this.getValue(n, 0 + 2 * n2);
                    d = this.getValue(n, 1 + 2 * n2);
                    break;
                }
                d2 = this.getValue(0 + 2 * n2, n);
                d = this.getValue(1 + 2 * n2, n);
                break;
            }
            case 84: {
                if (this.m_graph.isDataRowShownAsASeries()) {
                    d2 = this.getValue(n, 0 + 3 * n2);
                    d = this.getValue(n, 1 + 3 * n2);
                    break;
                }
                d2 = this.getValue(0 + 3 * n2, n);
                d = this.getValue(1 + 3 * n2, n);
                break;
            }
            default: {
                return 3;
            }
        }
        if (d == d2) {
            return 2;
        }
        if (d > d2) {
            return 1;
        }
        return 0;
    }

    public void setFallingColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getStockFallingRiser(), color);
        this.setPropertyOverrideFlags(0);
    }

    public Color getFallingColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getStockFallingRiser());
    }

    public void setRisingColor(Color color) {
        this.m_pfj.setFillColor(this.m_pfj.getStockRisingRiser(), color);
        this.setPropertyOverrideFlags(1);
    }

    public Color getRisingColor() {
        return this.m_pfj.getFillColor(this.m_pfj.getStockRisingRiser());
    }

    protected String getComponentName() {
        return "StockMarker";
    }

    protected int getStylePropertyCount() {
        return 2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty(a_fallingColor);
        if (propertyNode != null) {
            this.setFallingColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty(a_risingColor)) != null) {
            this.setRisingColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty(a_fallingColor, BaseGraphComponent.toHexString(this.getFallingColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty(a_risingColor, BaseGraphComponent.toHexString(this.getRisingColor().getRGB()));
            bl2 = true;
        }
        return bl2;
    }

    protected void resetStyle() {
        this.setFallingColor(new Color(this.fallingColor));
        this.setRisingColor(new Color(this.risingColor));
        super.resetStyle();
    }

    private double getValue(int n, int n2) {
        Object object = ((DataCallback)this.m_graph.getDataFilter()).getValue(n, n2);
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        return 0.0;
    }
}

