/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseDataComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.LabelPosition;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Slice
extends BaseDataComponent
implements LabelPosition {
    protected static final int ATTR_LABELPOSITION = 0;
    protected static final int ATTR_STYLE_MAXID = 1;
    protected int labelPosition = GraphDefaultValues.getLabelPosition();

    public Slice(Graph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    public int getLabelPosition() {
        return this.m_pfj.getPieFeelerTextDisplay();
    }

    public void setLabelPosition(int n) {
        if (n < 0 || n > 3) {
            this.m_graph.getErrorHandler().log("invalid label position", "oracle.dss.graph.Slice", "setLabelPosition(int position)");
        } else {
            this.m_pfj.setPieFeelerTextDisplay(n);
            this.setPropertyOverrideFlags(0);
        }
    }

    protected String convertLabelPositionToString(int n) {
        String string = "LP_OUTSIDE_WITH_FEELER";
        switch (n) {
            case 0: {
                string = "LP_NO_LABELS";
                break;
            }
            case 1: {
                string = "LP_OUTSIDE_WITH_FEELER";
                break;
            }
            case 2: {
                string = "LP_OUTSIDE_WITHOUT_FEELER";
                break;
            }
            case 3: {
                string = "LP_INSIDE";
            }
        }
        return string;
    }

    protected int convertLabelPositionToInt(String string) {
        if (string.equals("LP_NO_LABELS")) {
            return 0;
        }
        if (string.equals("LP_OUTSIDE_WITH_FEELER")) {
            return 1;
        }
        if (string.equals("LP_OUTSIDE_WITHOUT_FEELER")) {
            return 2;
        }
        if (string.equals("LP_INSIDE")) {
            return 3;
        }
        return -1;
    }

    protected String getComponentName() {
        return "Slice";
    }

    protected int getStylePropertyCount() {
        return 1;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("labelPosition", this.convertLabelPositionToString(this.getLabelPosition()));
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("labelPosition");
        if (propertyNode != null) {
            this.setLabelPosition(this.convertLabelPositionToInt(propertyNode.getValueAsString()));
        }
    }

    protected void resetStyle() {
        this.setLabelPosition(this.labelPosition);
        super.resetStyle();
    }
}

