/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.WordWrapEnabled;
import oracle.dss.graph.BaseTickLabel;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UITickLabel;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class O1TickLabel
extends BaseTickLabel
implements UITickLabel,
WordWrapEnabled {
    protected static final int ATTR_WORDWRAPENABLED = 4;
    protected static final int ATTR_TICKLABELWRAPPED = 5;
    protected static final int ATTR_TICKLABELSKIPMODE = 6;
    protected static final int ATTR_TICKLABELSKIPCOUNT = 7;
    protected static final int ATTR_TICKLABELSKIPFIRST = 8;
    protected static final int ATTR_AUTOROTATION = 9;
    protected static final int ATTR_STYLE_MAXID = 10;
    protected int tickLabelSkipMode;
    protected int tickLabelSkipCount;
    protected int tickLabelSkipFirst;
    protected int autoRotation;
    protected boolean tickLabelWrapped;
    protected boolean wordWrapEnabled;
    protected IdentObj m_identObj2;

    public O1TickLabel(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getO1Label();
        this.m_identObj2 = this.m_pfj.getO1DrillLabel();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.tickLabelSkipMode = GraphDefaultValues.getTickLabelSkipMode();
        this.tickLabelSkipCount = GraphDefaultValues.getTickLabelSkipCount();
        this.tickLabelSkipFirst = GraphDefaultValues.getTickLabelSkipFirst();
        this.fontColor = new Color(GraphDefaultValues.getO1TickFontColor());
        this.fontStyle = GraphDefaultValues.getO1TickFontStyle();
        this.fontSize = GraphDefaultValues.getO1TickFontSize();
        this.fontTypeface = GraphDefaultValues.getO1TickFontTypeface();
        this.textRotation = GraphDefaultValues.getO1TickTextRotation();
        this.autoRotation = GraphDefaultValues.getO1TickAutoRotation();
        this.graphProportionalFontSize = GraphDefaultValues.getO1TickGraphProportionalFontSize();
        this.textFittingAutomatic = GraphDefaultValues.isO1TickTextFittingAutomatic();
        this.tickLabelStaggered = GraphDefaultValues.isO1TickLabelStaggered();
        this.tickLabelWrapped = GraphDefaultValues.isO1TickLabelWrapped();
        this.wordWrapEnabled = GraphDefaultValues.isO1TickWordWrapEnabled();
        this.horizontalAlignment = GraphDefaultValues.getO1TickHorizontalAlignment();
    }

    public boolean selectObject(int n, int n2) {
        if (n2 >= 0) {
            IdentObj identObj = new IdentObj(this.m_identObj);
            boolean bl = this.m_pfj.getNestedLabels();
            int n3 = 0;
            if (bl) {
                n3 = this.m_pfj.getO1LabelCallBack().getNumLevels();
            }
            if (n3 > 0 && (n < 0 || n >= n3)) {
                n = n3 - 1;
            }
            if (bl) {
                identObj.setMiscID(n);
            }
            identObj.setGroupID(n2);
            this.m_pfj.setSelection(identObj);
            if (identObj.equals(this.m_pfj.getSelectionID())) {
                return true;
            }
        }
        return false;
    }

    protected int getStylePropertyCount() {
        return 10;
    }

    void setAutoHorizAlignment() {
        boolean bl = this.m_graph.isHorizontal();
        int n = this.m_graph.getGraphType();
        int n2 = this.m_pfj.getTextRotation(this.m_identObj);
        int n3 = this.m_pfj.getTextJustHoriz(this.m_identObj);
        boolean bl2 = false;
        if (n >= 0 && n <= 14) {
            bl2 = true;
        }
        if (bl) {
            switch (n2) {
                case 0: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 1;
                }
            }
        } else {
            switch (n2) {
                case 0: {
                    if (bl2) {
                        n3 = 0;
                        break;
                    }
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 0;
                }
            }
        }
        if (n3 != this.m_pfj.getTextJustHoriz(this.m_identObj)) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, n3);
        }
    }

    public boolean isTextFittingAutomatic() {
        return this.m_pfj.getAutofit(this.m_identObj);
    }

    public void setTextFittingAutomatic(boolean bl) {
        this.m_pfj.setAutofit(this.m_identObj, bl);
    }

    public int getAutomaticRotation() {
        return this.m_pfj.getO1LabelAutoAngle();
    }

    public void setAutomaticRotation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setAutomaticRotation(int orient)");
        } else {
            this.m_pfj.setO1LabelAutoAngle(n);
            this.setPropertyOverrideFlags(9);
        }
    }

    public void setHorizontalAlignment(int n) {
        super.setHorizontalAlignment(n);
        int n2 = this.convertSwingHAlignmentToPFJ(n);
        if (n2 != -1) {
            this.m_pfj.setTextJustHoriz(this.m_identObj2, n2);
        }
    }

    public void setTextRotation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int orient)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, n);
            this.setAutoHorizAlignment();
            this.setPropertyOverrideFlags(1);
        }
    }

    public int getTickLabelSkipCount() {
        return this.m_pfj.getSkipCount(this.m_identObj);
    }

    public void setTickLabelSkipCount(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid Tick Label Skip count", "oracle.dss.graph.O1TickLabel", "setTickLabelSkipCount(int count)");
        } else {
            this.m_pfj.setSkipCount(this.m_identObj, n);
            this.setPropertyOverrideFlags(7);
        }
    }

    public int getTickLabelSkipFirst() {
        return this.m_pfj.getSkipBegin(this.m_identObj);
    }

    public void setTickLabelSkipFirst(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid first tick label", this.getClass().getName(), "setTickLabelSkipFirst (int first)");
        } else {
            this.m_pfj.setSkipBegin(this.m_identObj, n);
            this.setPropertyOverrideFlags(8);
        }
    }

    public int getTickLabelSkipMode() {
        return this.m_pfj.getAutoSkip(this.m_identObj);
    }

    public void setTickLabelSkipMode(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid TickLabelSkipMode", this.getClass().getName(), "void setTickLabelSkipMode( int mode )");
        } else {
            this.m_pfj.setAutoSkip(this.m_identObj, n);
            this.setPropertyOverrideFlags(6);
        }
    }

    public boolean isTickLabelStaggered() {
        return this.m_pfj.getLabelStagger(this.m_identObj);
    }

    public void setTickLabelStaggered(boolean bl) {
        this.m_pfj.setLabelStagger(this.m_identObj, bl);
        this.setPropertyOverrideFlags(3);
    }

    public boolean isTickLabelWrapped() {
        return this.m_pfj.getTextWrap(this.m_identObj);
    }

    public void setTickLabelWrapped(boolean bl) {
        this.m_pfj.setTextWrap(this.m_identObj, bl);
        this.setPropertyOverrideFlags(5);
    }

    public boolean isWordWrapEnabled() {
        return this.m_pfj.getTextWrap(this.m_identObj);
    }

    public void setWordWrapEnabled(boolean bl) {
        this.m_pfj.setTextWrap(this.m_identObj, bl);
        this.m_pfj.setTextWrap(this.m_identObj2, bl);
        this.setPropertyOverrideFlags(4);
    }

    protected String getComponentName() {
        return "O1TickLabel";
    }

    protected String convertTickLabelSkipModeToString(int n) {
        String string = "TLS_NOSKIP";
        switch (n) {
            case 0: {
                string = "TLS_NOSKIP";
                break;
            }
            case 1: {
                string = "TLS_AUTOMATIC";
                break;
            }
            case 2: {
                string = "TLS_MANUAL";
            }
        }
        return string;
    }

    protected int convertTickLabelSkipModeToInt(String string) {
        if (string.equals("TLS_NOSKIP")) {
            return 0;
        }
        if (string.equals("TLS_AUTOMATIC")) {
            return 1;
        }
        if (string.equals("TLS_MANUAL")) {
            return 2;
        }
        return -1;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("tickLabelSkipMode");
        if (propertyNode != null) {
            this.setTickLabelSkipMode(this.convertTickLabelSkipModeToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("tickLabelSkipCount")) != null) {
            this.setTickLabelSkipCount(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("tickLabelSkipFirst")) != null) {
            this.setTickLabelSkipFirst(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("automaticRotation")) != null) {
            String string = propertyNode.getValueAsString();
            if (string.equals("AR_NO_ROTATE")) {
                this.setAutomaticRotation(0);
            } else if (string.equals("AR_HORIZ_ROTATE_90")) {
                this.setAutomaticRotation(1);
            } else if (string.equals("AR_HORIZ_ROTATE_270")) {
                this.setAutomaticRotation(2);
            }
        }
        if ((propertyNode = objectNode.getProperty("tickLabelWrapped")) != null) {
            this.setTickLabelWrapped(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("wordWrapEnabled")) != null) {
            this.setWordWrapEnabled(propertyNode.getValueAsBoolean());
        }
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(6)) {
            objectNode.addProperty("tickLabelSkipMode", this.convertTickLabelSkipModeToString(this.getTickLabelSkipMode()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(7)) {
            objectNode.addProperty("tickLabelSkipCount", this.getTickLabelSkipCount());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(8)) {
            objectNode.addProperty("tickLabelSkipFirst", this.getTickLabelSkipFirst());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(9)) {
            if (this.getAutomaticRotation() == 0) {
                objectNode.addProperty("automaticRotation", "AR_NO_ROTATE");
            } else if (this.getAutomaticRotation() == 1) {
                objectNode.addProperty("automaticRotation", "AR_HORIZ_ROTATE_90");
            } else if (this.getAutomaticRotation() == 2) {
                objectNode.addProperty("automaticRotation", "AR_HORIZ_ROTATE_270");
            }
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode.addProperty("tickLabelWrapped", this.isTickLabelWrapped());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("wordWrapEnabled", this.isWordWrapEnabled());
            bl2 = true;
        }
        return bl2;
    }

    public void resetStyle() {
        this.setWordWrapEnabled(this.wordWrapEnabled);
        this.setTickLabelWrapped(this.tickLabelWrapped);
        this.setTickLabelSkipMode(this.tickLabelSkipMode);
        this.setTickLabelSkipCount(this.tickLabelSkipCount);
        this.setTickLabelSkipFirst(this.tickLabelSkipFirst);
        this.setAutomaticRotation(this.autoRotation);
        super.resetStyle();
    }
}

