/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JFrame;
import oracle.bali.ewt.painter.PaintContext;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.PaginationRecord;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.graph.Graph;
import oracle.dss.graph.PFJ;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;

public class GraphPrinter
extends ViewPrinter {
    private boolean oldFitToContainer;
    private boolean m_insuffSapce;
    private int pageNum;
    private int scaleFont = -1;
    private int m_selectedIndex;
    private Rectangle pagingControlBounds;
    private Graph graph;
    private PFJ pfj;
    private JFrame m_frame;

    public GraphPrinter(Graph graph) {
        super(graph);
        this.graph = graph;
        this.pfj = this.graph.getPFJ();
    }

    public int getViewPrinterType() {
        return 2;
    }

    public boolean startPrint() {
        return this.startPrint(false);
    }

    public boolean startPrint(boolean bl) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "startPrint");
            return false;
        }
        this.oldFitToContainer = this.graph.isFitToContainer();
        if (this.graph.getParent() == null) {
            this.m_frame = new JFrame();
            this.graph.setSize(400, 400);
            this.m_frame.getContentPane().add("Center", this.graph);
            this.m_frame.pack();
            this.graph.setFitToContainer(false);
        }
        if (this.paperHeight - (this.topMargin + this.bottomMargin) < 20 || this.paperWidth - (this.leftMargin + this.rightMargin) < 20) {
            this.logInsuffMsg("startPrint");
            return false;
        }
        this.m_insuffSapce = false;
        this.graph.firePrintBegin(this.graph);
        try {
            this.currLogPage.setHPos(this.graph.getGraphModel().getDataAccess().getEdgeCurrentHPos(2));
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.graph.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "startPrint");
        }
        this.graph.setPrintOrPreviewMode(true);
        this.saveTitlesFocus();
        this.graph.repaint();
        this.m_selectedIndex = 0;
        this.m_seqPageNumber = 0;
        this.pIndex = -1;
        return true;
    }

    public void endPrint() {
        try {
            int n = -1;
            if (this.currLogPage.getHPos() != null) {
                n = this.currLogPage.getHPos().length - 1;
            }
            this.changePageEdgeCurrentHPos(this.currLogPage.getHPos(), n);
        }
        catch (DataException dataException) {
            this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "endPrint");
        }
        this.m_insuffSapce = false;
        this.restoreTitlesFocus();
        this.graph.setPrintOrPreviewMode(false);
        this.graph.setFitToContainer(this.oldFitToContainer);
        this.m_bPreviewMode = false;
        this.pIndex = -1;
        this.graph.firePrintEnd(this.graph);
        if (this.m_frame != null) {
            this.m_frame.remove(this.graph);
        }
        this.m_frame = null;
    }

    public boolean isFirstPhysicalPage() {
        return true;
    }

    public boolean isLastPhysicalPage() {
        return true;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
        this.setDataview(graph);
    }

    public void setScaleFontSize(int n) {
        this.scaleFont = n;
    }

    public int getScaleFontSize() {
        return this.scaleFont;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void printPages(PrintJob printJob, boolean bl) {
        try {
            try {
                this.dimension = printJob.getPageDimension();
                int n = 1;
                this.printableWidth = this.dimension.width - (this.leftMargin + this.rightMargin);
                if (this.printableWidth < 20) {
                    this.logInsuffMsg("printPages");
                    Object var7_5 = null;
                    this.endPrint();
                    return;
                }
                this.currentLogicalPage = bl;
                int[] nArray = null;
                if (bl) {
                    nArray = this.currLogPage.getHPos();
                } else if (this.rangeType == 1) {
                    nArray = this.graph.getGraphModel().getDataAccess().getFirstHPos(2);
                } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > 0) {
                    nArray = (int[])this.m_selectedHPos.elementAt(0);
                }
                if (nArray == null) {
                    nArray = new int[]{};
                }
                while (nArray != null) {
                    if (!bl) {
                        this.changePageEdgeCurrentHPos(nArray, nArray.length - 1);
                    }
                    this.fetchAllData();
                    Graphics graphics = printJob.getGraphics();
                    this.record = new PaginationRecord();
                    this.record.pageNum = n++;
                    ++this.m_seqPageNumber;
                    this.viewLogPage.setHPos(nArray);
                    this.calcMargins(graphics);
                    this.printableHeight = this.dimension.height - (this.topMargin + this.bottomMargin);
                    if (this.printableHeight < 20) {
                        this.logInsuffMsg("printPages");
                        break;
                    }
                    this.printToGraphics(graphics, null);
                    this.printHeaderAndFooter(graphics);
                    graphics.dispose();
                    if (!bl) {
                        if (this.rangeType == 1) {
                            nArray = this.graph.getGraphModel().getDataAccess().getNextHPos(2, nArray);
                            continue;
                        }
                        ++this.m_selectedIndex;
                        if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
                            nArray = (int[])this.m_selectedHPos.elementAt(this.m_selectedIndex);
                            continue;
                        }
                        nArray = null;
                        continue;
                    }
                    nArray = null;
                }
            }
            catch (DataException dataException) {
                this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "printPages");
                Object var7_7 = null;
                this.endPrint();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.endPrint();
            throw throwable;
        }
        Object var7_6 = null;
        this.endPrint();
    }

    public boolean printPage(Graphics graphics) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "printPage");
            return false;
        }
        int n = this.leftMargin;
        int n2 = this.topMargin;
        this.leftMargin = 0;
        this.topMargin = 0;
        this.printableWidth = this.viewDim.width;
        this.printableHeight = this.viewDim.height;
        this.printToGraphics(graphics, null);
        this.leftMargin = n;
        this.topMargin = n2;
        return true;
    }

    protected void printToGraphics(Graphics graphics, PaginationRecord paginationRecord) {
        PaintContext paintContext;
        Shape shape = graphics.getClip();
        int n = this.printableHeight;
        graphics.translate(this.leftMargin, this.topMargin);
        graphics.setClip(null);
        int n2 = 0;
        try {
            n2 = this.graph.getGraphModel().getDataAccess().getLayerCount(2);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        this.calcAdornmentsDimension(this.printableWidth);
        int n3 = 0;
        int n4 = 0;
        int n5 = this.leftMargin;
        int n6 = this.topMargin;
        if (this.printableHeight < 20) {
            this.logInsuffMsg("printToGraphics");
            return;
        }
        if (this.m_topFormattedText != null) {
            graphics.setClip(0, 0, this.printableWidth, this.topFTAHeight);
            this.m_topFormattedText.print(new Dimension(this.printableWidth, this.topFTAHeight), graphics);
            graphics.translate(0, this.topFTAHeight);
            n6 += this.topFTAHeight;
            this.printableHeight -= this.topFTAHeight;
        }
        if (this.graph.isPagingControlVisible() && this.graph.getPagingControlPosition() == 0 && n2 > 0) {
            this.pagingControlBounds = this.graph.getPagingControl().getPagingComponent().getPageBounds(null, null, 0, 0, this.printableWidth, this.printableHeight);
            this.printableHeight -= this.pagingControlBounds.height;
            n6 += this.pagingControlBounds.height;
            graphics.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.graph.getPagingControl().getPagingComponent().validate();
            paintContext = this.graph.getPagingControl().getPagingComponent().getPrintPaintContext(graphics);
            this.graph.getPagingControl().getPagingComponent().printPage(paintContext, null, graphics);
            graphics.translate(0, this.pagingControlBounds.height);
        }
        if (this.title.isVisible()) {
            this.title.setSize(this.printableWidth, this.title.getPreferredSize().height);
            n4 = this.title.getPreferredSize().height;
            n3 = this.title.getPreferredSize().width;
            if (n3 > this.printableWidth) {
                n3 = this.printableWidth;
            }
            this.title.setSize(this.printableWidth, n4);
            this.titleHeight = n4;
            graphics.setClip(0, 0, this.printableWidth, this.titleHeight);
            this.title.print(graphics);
            graphics.translate(0, this.titleHeight);
            n6 += this.titleHeight;
            this.printableHeight -= this.titleHeight;
            this.title.setSize(this.oldTitleSize);
        }
        if (this.subtitle.isVisible()) {
            this.subtitle.setSize(this.printableWidth, this.subtitle.getPreferredSize().height);
            n4 = this.subtitle.getPreferredSize().height;
            n3 = this.subtitle.getPreferredSize().width;
            if (n3 > this.printableWidth) {
                n3 = this.printableWidth;
            }
            this.subtitle.setSize(this.printableWidth, n4);
            this.subtitleHeight = n4;
            graphics.setClip(0, 0, this.printableWidth, this.subtitleHeight);
            this.subtitle.print(graphics);
            graphics.translate(0, this.subtitleHeight);
            this.printableHeight -= (n6 += this.subtitleHeight);
            this.subtitle.setSize(this.oldSubtitleSize);
        }
        if (this.printableHeight < 20) {
            this.logInsuffMsg("printToGraphics");
            return;
        }
        if (this.graph.isPagingControlVisible() && this.graph.getPagingControlPosition() == 1 && n2 > 0) {
            this.pagingControlBounds = this.graph.getPagingControl().getPagingComponent().getPageBounds(null, null, 0, 0, this.printableWidth, this.printableHeight);
            this.printableHeight -= this.pagingControlBounds.height;
            n6 += this.pagingControlBounds.height;
            graphics.setClip(0, 0, this.pagingControlBounds.width, this.pagingControlBounds.height);
            this.graph.getPagingControl().getPagingComponent().validate();
            paintContext = this.graph.getPagingControl().getPagingComponent().getPrintPaintContext(graphics);
            this.graph.getPagingControl().getPagingComponent().printPage(paintContext, null, graphics);
            graphics.translate(0, this.pagingControlBounds.height);
        }
        graphics.setClip(null);
        Dimension dimension = this.pfj.getSize();
        int n7 = 0;
        int n8 = 0;
        if (this.scaleFont == -1) {
            this.graph.saveFontSizes();
        }
        this.printableHeight = this.printableHeight - this.footnoteHeight - this.bottomFTAHeight;
        if (this.printableHeight < 20) {
            this.logInsuffMsg("printToGraphics");
            return;
        }
        if (this.m_graphPrintScaleType == 0) {
            n7 = this.printableWidth < dimension.width ? this.printableWidth : dimension.width;
            n8 = this.printableHeight < dimension.height ? this.printableHeight : dimension.height;
            graphics.setClip(0, 0, n7, n8);
        } else if (this.m_graphPrintScaleType == 3) {
            if (this.scaleFont == -1) {
                this.graph.applyFontSizes((float)this.printableHeight / (float)this.pfj.getSize().height);
            }
            this.pfj.setSize(this.printableWidth, this.printableHeight);
            graphics.setClip(0, 0, this.printableWidth, this.printableHeight);
        } else if (this.m_graphPrintScaleType == 4) {
            float f = (float)this.printableWidth / (float)dimension.width;
            float f2 = (float)this.printableHeight / (float)dimension.height;
            float f3 = f < f2 ? f : f2;
            int n9 = (int)((float)dimension.width * f3);
            int n10 = (int)((float)dimension.height * f3);
            if (this.scaleFont == -1) {
                this.graph.applyFontSizes((float)n10 / (float)this.pfj.getSize().height);
            }
            this.pfj.setSize(n9, n10);
            graphics.setClip(0, 0, n9, n10);
        } else if (this.m_graphPrintScaleType == 1 && this.printZoomFactor != 100) {
            int n11 = dimension.width * this.printZoomFactor / 100;
            int n12 = dimension.height * this.printZoomFactor / 100;
            n7 = this.printableWidth < n11 ? this.printableWidth : n11;
            n8 = this.printableHeight < n12 ? this.printableHeight : n12;
            if (this.scaleFont == -1) {
                this.graph.applyFontSizes((float)n12 / (float)this.pfj.getSize().height);
            }
            this.pfj.setSize(n11, n12);
            graphics.setClip(0, 0, n7, n8);
        }
        boolean bl = false;
        if (this.graph.isDrillingEnabled()) {
            bl = true;
            this.graph.setDrillingEnabled(false);
        }
        this.pfj.calcWithoutDrawing();
        if (bl) {
            this.graph.setDrillingEnabled(true);
        }
        this.pfj.print(graphics);
        this.pfj.setSize(dimension);
        if (this.scaleFont == -1) {
            this.graph.resetFontSizes();
            this.pfj.calcWithoutDrawing();
        }
        this.printableHeight = n;
        graphics.translate(0, -n6);
        n6 = 0;
        if (this.footnote.isVisible()) {
            int n13 = this.printableHeight + this.topMargin - (this.bottomFTAHeight + this.footnoteHeight);
            graphics.translate(0, n13);
            n6 += n13;
            this.footnote.setSize(this.printableWidth, this.footnote.getPreferredSize().height);
            n4 = this.footnote.getPreferredSize().height;
            n3 = this.footnote.getPreferredSize().width;
            if (n3 > this.printableWidth) {
                n3 = this.printableWidth;
            }
            this.footnote.setSize(this.printableWidth, n4);
            this.footnoteHeight = n4;
            graphics.setClip(0, 0, this.printableWidth, this.footnoteHeight);
            this.footnote.print(graphics);
            graphics.translate(0, this.footnoteHeight);
            n6 += this.footnoteHeight;
            this.footnote.setSize(this.oldFootnoteSize);
        }
        if (this.m_bottomFormattedText != null) {
            if (!this.footnote.isVisible()) {
                int n14 = this.printableHeight + this.topMargin - (this.bottomFTAHeight + this.footnoteHeight);
                graphics.translate(0, n14);
                n6 += n14;
            }
            graphics.setClip(0, 0, this.printableWidth, this.bottomFTAHeight);
            this.m_bottomFormattedText.print(new Dimension(this.printableWidth, this.bottomFTAHeight), graphics);
            graphics.translate(0, this.bottomFTAHeight);
            n6 += this.bottomFTAHeight;
        }
        graphics.translate(-n5, -n6);
        graphics.setClip(shape);
    }

    public boolean goToFirstPage() {
        return this.prepareFirstPage(null);
    }

    public boolean prepareFirstPage(Graphics graphics) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "prepareFirstPage");
            return false;
        }
        this.pageNum = 0;
        this.m_seqPageNumber = 0;
        if (this.rangeType == 1) {
            try {
                this.viewLogPage.setHPos(this.graph.getGraphModel().getDataAccess().getFirstHPos(2));
                this.viewLogPageNum = 0;
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
                this.graph.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "prepareFirstPage");
            }
        } else if (this.rangeType == 0) {
            this.viewLogPage.setHPos(this.currLogPage.getHPos());
            this.viewLogPageNum = 0;
        } else if (this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex) {
            this.viewLogPage.setHPos((int[])this.m_selectedHPos.elementAt(this.m_selectedIndex));
            this.viewLogPageNum = 0;
        } else {
            return false;
        }
        this.checkDataSourceLogPage();
        this.fetchAllData();
        if (this.checkForNoData()) {
            return false;
        }
        this.record = new PaginationRecord();
        this.record.pageNum = ++this.pageNum;
        ++this.m_seqPageNumber;
        this.printableWidth = this.paperWidth - (this.leftMargin + this.rightMargin);
        this.calcMargins(graphics);
        this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        if (this.printableHeight < 20 || this.printableWidth < 20) {
            this.logInsuffMsg("prepareFirstPage");
            this.m_insuffSapce = true;
            return false;
        }
        return true;
    }

    public boolean hasNextPage() {
        if (this.m_insuffSapce) {
            return false;
        }
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "hasNextPage");
            return false;
        }
        try {
            if (this.rangeType == 1 && this.graph.getGraphModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos()) != null) {
                boolean bl = true;
                return bl;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                boolean bl = true;
                return bl;
            }
        }
        catch (DataException dataException) {
            this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "hasNextPage");
        }
        return false;
    }

    public boolean goToNextPage() {
        return this.prepareNextPage(null);
    }

    public boolean prepareNextPage(Graphics graphics) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "prepareNextPage");
            return false;
        }
        int[] nArray = null;
        try {
            if (this.rangeType == 1) {
                nArray = this.graph.getGraphModel().getDataAccess().getNextHPos(2, this.viewLogPage.getHPos());
            } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedHPos.size() > this.m_selectedIndex + 1) {
                nArray = (int[])this.m_selectedHPos.elementAt(++this.m_selectedIndex);
            }
        }
        catch (DataException dataException) {
            this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "prepareNextPage");
        }
        if (nArray != null) {
            this.viewLogPage.setHPos(nArray);
            ++this.viewLogPageNum;
            try {
                this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
            }
            catch (DataException dataException) {
                this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "prepareNextPage");
            }
            this.fetchAllData();
            if (this.checkForNoData()) {
                return false;
            }
            ++this.m_seqPageNumber;
            this.record.pageNum = ++this.pageNum;
            this.calcMargins(graphics);
            this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        }
        return true;
    }

    public boolean hasPrevPage() {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "hasPrevPage");
            return false;
        }
        try {
            if (this.rangeType == 1 && this.graph.getGraphModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos()) != null) {
                boolean bl = true;
                return bl;
            }
            if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (DataException dataException) {
            this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "hasPrevPage");
        }
        return false;
    }

    public boolean goToPrevPage() {
        return this.preparePrevPage(null);
    }

    public boolean preparePrevPage(Graphics graphics) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "preparePrevPage");
            return false;
        }
        int[] nArray = null;
        try {
            if (this.rangeType == 1) {
                nArray = this.graph.getGraphModel().getDataAccess().getPrevHPos(2, this.viewLogPage.getHPos());
            } else if (this.rangeType == 2 && this.m_selectedHPos != null && this.m_selectedIndex > 0) {
                nArray = (int[])this.m_selectedHPos.elementAt(--this.m_selectedIndex);
            }
        }
        catch (DataException dataException) {
            this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "preparePrevPage");
        }
        if (nArray != null) {
            try {
                this.viewLogPage.setHPos(nArray);
                --this.viewLogPageNum;
                this.changePageEdgeCurrentHPos(this.viewLogPage.getHPos(), this.viewLogPage.getHPos().length - 1);
            }
            catch (DataException dataException) {
                this.graph.getErrorHandler().error(dataException, this.getClass().getName(), "preparePrevPage");
            }
            this.fetchAllData();
            if (this.checkForNoData()) {
                return false;
            }
            this.record.pageNum = --this.pageNum;
            --this.m_seqPageNumber;
            this.calcMargins(graphics);
            this.printableHeight = this.paperHeight - (this.topMargin + this.bottomMargin);
        }
        return true;
    }

    public boolean setLogicalPage(int[] nArray) {
        if (this.graph.isDataUnavailable()) {
            this.graph.getErrorHandler().log("data is unavailable to print", this.getClass().getName(), "setLogicalPage");
            return false;
        }
        super.setLogicalPage(nArray);
        this.fetchAllData();
        return true;
    }

    protected void setDataview(Dataview dataview) {
        super.setDataview(dataview);
        if (dataview instanceof Graph) {
            this.title = (Title)((Graph)this.dataView).getDataviewTitle();
            this.subtitle = (Subtitle)((Graph)this.dataView).getDataviewSubtitle();
            this.footnote = (Footnote)((Graph)this.dataView).getDataviewFootnote();
        }
    }

    protected boolean checkForNoData() {
        return false;
    }

    protected void fetchAllData() {
        try {
            int n = this.graph.getModel().getDataAccess().getEdgeExtent(1);
            if (n > 0) {
                this.fetchRowBlock(0, n - 1);
                this.graph.getPFJ().setLazyDataFetchMessage(null);
                this.graph.setDirty(true);
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            this.graph.getErrorHandler().error(edgeOutOfRangeException, this.getClass().getName(), "fetchAllData");
        }
    }

    protected void resetCurrentLogicalPage() {
        this.fetchAllData();
    }

    private void logInsuffMsg(String string) {
        this.graph.getErrorHandler().log("Insufficient space to print the View", this.getClass().getName(), string);
    }
}

