/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.DataTickLabelInfo;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.TickLabelCallback;
import oracle.dss.graph.pfj.NumberFormatCallBack;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.SeriesOutOfRangeException;

public class GraphNumberFormatCallback
extends NumberFormatCallBack {
    protected Graph m_graph;
    protected int m_row;
    protected int m_column;
    protected int m_valueType;
    private static final String m_method_toString = "public String toString( double dVal )";

    public GraphNumberFormatCallback(Graph graph) {
        this.m_graph = graph;
    }

    private ViewFormat _getMarkerTextViewFormat(int n) {
        return this.m_graph.getMarkerText().getViewFormat(n);
    }

    public ViewFormat getMarkerTextViewFormat(int n, int n2) {
        ViewFormat viewFormat = null;
        try {
            viewFormat = this.m_graph.getSeries().isAssignedToY2(n % this.m_graph.getSeriesObjectCount()) ? this._getMarkerTextViewFormat(2) : this._getMarkerTextViewFormat(1);
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        return viewFormat;
    }

    public ViewFormat getMarkerTextViewFormat(int n) {
        ViewFormat viewFormat = null;
        int n2 = this.m_graph.getGraphType();
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 42: 
            case 47: 
            case 48: 
            case 49: 
            case 54: 
            case 67: 
            case 68: 
            case 93: 
            case 94: 
            case 102: {
                viewFormat = this._getMarkerTextViewFormat(1);
                this.m_valueType = 63;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 69: {
                try {
                    if (this.m_graph.getSeries().isAssignedToY2(n % this.m_graph.getSeriesObjectCount())) {
                        viewFormat = this._getMarkerTextViewFormat(2);
                        this.m_valueType = 64;
                        break;
                    }
                    viewFormat = this._getMarkerTextViewFormat(1);
                    this.m_valueType = 63;
                }
                catch (SeriesOutOfRangeException seriesOutOfRangeException) {}
                break;
            }
            case 61: 
            case 62: 
            case 65: 
            case 66: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 89: 
            case 91: {
                if (this.m_valueType == 62) {
                    viewFormat = this._getMarkerTextViewFormat(0);
                    break;
                }
                if (this.m_valueType == 63) {
                    viewFormat = this._getMarkerTextViewFormat(1);
                    break;
                }
                if (this.m_valueType == 64) {
                    viewFormat = this._getMarkerTextViewFormat(2);
                    break;
                }
                if (this.m_valueType != 65) break;
                viewFormat = this._getMarkerTextViewFormat(3);
                break;
            }
            case 71: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                if (this.getValueType().equals("VOLUME")) {
                    viewFormat = this._getMarkerTextViewFormat(4);
                    break;
                }
                viewFormat = this._getMarkerTextViewFormat(1);
                break;
            }
            default: {
                viewFormat = new ViewFormat();
                this.m_graph.getErrorHandler().log("Unexpected GraphType", "oracle.dss.graph.GraphNumberFormatCallback", "getMarkerTextViewFormat");
            }
        }
        return viewFormat;
    }

    public String toString(double d) {
        boolean bl = false;
        ViewFormat viewFormat = null;
        DataAccess dataAccess = null;
        QDR qDR = null;
        boolean bl2 = this.m_graph.isDataRowShownAsASeries();
        GraphFormatManager graphFormatManager = this.m_graph.getGraphFormatManager();
        switch (this.getLabelType()) {
            case 0: {
                BaseDataAxis baseDataAxis;
                int n;
                int n2;
                if (this.isY1AxisLabel()) {
                    n2 = 67;
                    n = 48;
                    baseDataAxis = this.m_graph.getY1Axis();
                    viewFormat = this.m_graph.getY1Axis().getViewFormat();
                } else if (this.isY2AxisLabel()) {
                    n2 = 68;
                    n = 53;
                    baseDataAxis = this.m_graph.getY2Axis();
                    viewFormat = this.m_graph.getY2Axis().getViewFormat();
                } else if (this.isX1AxisLabel()) {
                    n2 = 66;
                    n = 43;
                    baseDataAxis = this.m_graph.getX1Axis();
                    viewFormat = this.m_graph.getX1Axis().getViewFormat();
                } else {
                    n2 = 67;
                    baseDataAxis = this.m_graph.getY1Axis();
                    n = 48;
                    viewFormat = this.m_graph.getY1Axis().getViewFormat();
                }
                double d2 = this.getAxisMax();
                double d3 = this.getAxisMin();
                double d4 = this.getAxisStep();
                boolean bl3 = baseDataAxis.isScaledLogarithmic();
                double d5 = baseDataAxis.getLogarithmicBase();
                int n3 = this.m_graph.getGraphType();
                if (n3 == 23 || n3 == 30 || n3 == 35 || n3 == 40 || n3 == 47 || n3 == 54) {
                    bl = true;
                }
                if (this.isY2AxisLabel() && n3 == 102) {
                    bl = true;
                }
                TickLabelCallback tickLabelCallback = this.m_graph.getTickLabelCallback(n);
                DataTickLabelInfo dataTickLabelInfo = new DataTickLabelInfo(this.getAxisLabelOrdinalPosition(), d);
                String string = null;
                if (tickLabelCallback != null) {
                    string = tickLabelCallback.getTickLabel(dataTickLabelInfo, n);
                }
                if (tickLabelCallback == null || string == null) {
                    return graphFormatManager.formatAxisValue(d, viewFormat, d2, d3, d4, n2, bl, bl3, d5);
                }
                return string;
            }
            case 1: {
                int n = this.m_graph.getSliceLabel().getTextType();
                if (1 == n || 3 == n) {
                    bl = true;
                }
                viewFormat = this.m_graph.getSliceLabel().getViewFormat();
                this.calculateColumnAndRow();
                dataAccess = this.m_graph.getGraphModel().getDataAccess();
                qDR = new DataComponentInfo(this.m_row, this.m_column).getQDR(dataAccess, 1);
                return graphFormatManager.formatPieValue(d, viewFormat, bl, qDR, false);
            }
            case 2: {
                viewFormat = this.m_graph.getSliceLabel().getViewFormat();
                return graphFormatManager.formatPieValue(d, viewFormat, false, null, false);
            }
            case 3: 
            case 5: {
                int n = this.m_graph.getGraphType();
                if (n == 23 || n == 30 || n == 35 || n == 40 || n == 47 || n == 54) {
                    bl = true;
                }
                this.calculateColumnAndRow();
                viewFormat = this.getMarkerTextViewFormat(this.getSeries());
                dataAccess = this.m_graph.getGraphModel().getDataAccess();
                qDR = new DataComponentInfo(this.m_row, this.m_column).getQDR(dataAccess, 1);
                String string = graphFormatManager.formatDataValue(d, viewFormat, this.m_valueType, this.m_column, this.m_row, bl, qDR, false);
                return string;
            }
            case 4: {
                this.calculateColumnAndRow();
                dataAccess = this.m_graph.getGraphModel().getDataAccess();
                qDR = new DataComponentInfo(this.m_row, this.m_column).getQDR(dataAccess, 1);
                int n = this.m_graph.getGraphType();
                if (n >= 55 && n <= 60 || n >= 93 || n >= 94) {
                    viewFormat = this.m_graph.getSliceLabel().getViewFormat();
                    return graphFormatManager.formatPieValue(d, viewFormat, bl, qDR, true);
                }
                viewFormat = this.getMarkerTextViewFormat(this.getSeries());
                return graphFormatManager.formatDataValue(d, viewFormat, this.m_valueType, this.m_column, this.m_row, bl, qDR, true);
            }
        }
        String string = "BadLabelType";
        String string2 = d > 1.0 || d == 0.0 ? new Double(d).toString() : String.valueOf(new Integer((int)(d * (double)100 + 0.5)).toString()) + "%";
        return string2;
    }

    private void calculateColumnAndRow() {
        int n = this.m_graph.getGraphType();
        int n2 = this.getGroup();
        try {
            switch (n) {
                case 61: 
                case 62: 
                case 65: 
                case 66: {
                    if (this.isX1AxisLabel()) {
                        n2 = this.getGroup() * 2;
                        this.m_valueType = 62;
                        break;
                    }
                    if (this.isY1AxisLabel()) {
                        n2 = this.getGroup() * 2 + 1;
                        this.m_valueType = 63;
                        break;
                    }
                    if (this.isY2AxisLabel()) {
                        n2 = this.getGroup() * 2 + 1;
                        this.m_valueType = 64;
                        break;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        n2 = this.getGroup() * 2;
                        this.m_valueType = 62;
                        break;
                    }
                    if (this.getValueType().equals("YVALUE")) {
                        n2 = this.getGroup() * 2 + 1;
                        this.m_valueType = 63;
                        if ((n == 62 || n == 66) && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                            this.m_valueType = 64;
                        }
                    }
                    break;
                }
                case 63: 
                case 64: {
                    if (this.isX1AxisLabel()) {
                        n2 = this.getGroup() * 3;
                        this.m_valueType = 62;
                        break;
                    }
                    if (this.isY1AxisLabel()) {
                        n2 = this.getGroup() * 3 + 1;
                        this.m_valueType = 63;
                        break;
                    }
                    if (this.isY2AxisLabel()) {
                        n2 = this.getGroup() * 3 + 1;
                        this.m_valueType = 64;
                        break;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        n2 = this.getGroup() * 3;
                        this.m_valueType = 62;
                        break;
                    }
                    if (this.getValueType().equals("YVALUE")) {
                        n2 = this.getGroup() * 3 + 1;
                        this.m_valueType = 63;
                        if (n == 64 && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                            this.m_valueType = 64;
                        }
                    }
                    break;
                }
                case 89: 
                case 91: {
                    if (this.isX1AxisLabel()) {
                        n2 = this.getGroup() * 3;
                        this.m_valueType = 62;
                        break;
                    }
                    if (this.isY1AxisLabel()) {
                        n2 = this.getGroup() * 3 + 1;
                        this.m_valueType = 63;
                        break;
                    }
                    if (this.isY2AxisLabel()) {
                        n2 = this.getGroup() * 3 + 1;
                        this.m_valueType = 64;
                        break;
                    }
                    if (this.isZ1AxisLabel()) {
                        n2 = this.getGroup() * 3 + 2;
                        this.m_valueType = 65;
                        break;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        n2 = this.getGroup() * 3;
                        this.m_valueType = 62;
                        break;
                    }
                    if (this.getValueType().equals("YVALUE")) {
                        n2 = this.getGroup() * 3 + 1;
                        this.m_valueType = 63;
                        if (n == 91 && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                            this.m_valueType = 64;
                        }
                    } else if (this.getValueType().equals("ZVALUE")) {
                        n2 = this.getGroup() * 3 + 2;
                        this.m_valueType = 65;
                    }
                    break;
                }
                case 90: 
                case 92: {
                    if (this.isX1AxisLabel()) {
                        n2 = this.getGroup() * 4;
                        this.m_valueType = 62;
                    } else if (this.isY1AxisLabel()) {
                        n2 = this.getGroup() * 4 + 1;
                        this.m_valueType = 63;
                    } else if (this.isY2AxisLabel()) {
                        n2 = this.getGroup() * 4 + 1;
                        this.m_valueType = 64;
                    } else if (this.isZ1AxisLabel()) {
                        n2 = this.getGroup() * 4 + 2;
                        this.m_valueType = 65;
                    }
                    if (this.getValueType().equals("XVALUE")) {
                        n2 = this.getGroup() * 4;
                        this.m_valueType = 62;
                    }
                    if (this.getValueType().equals("YVALUE")) {
                        n2 = this.getGroup() * 4 + 1;
                        this.m_valueType = 63;
                        if (n == 92 && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                            this.m_valueType = 64;
                        }
                    }
                    if (this.getValueType().equals("ZVALUE")) {
                        n2 = this.getGroup() * 4 + 2;
                        this.m_valueType = 65;
                    }
                    break;
                }
                case 71: 
                case 83: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("OPEN")) {
                        n2 = this.getGroup() * 5;
                        break;
                    }
                    if (this.getValueType().equals("HIGH")) {
                        n2 = this.getGroup() * 5 + 1;
                        break;
                    }
                    if (this.getValueType().equals("LOW")) {
                        n2 = this.getGroup() * 5 + 2;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        n2 = this.getGroup() * 5 + 3;
                        break;
                    }
                    if (this.getValueType().equals("VOLUME")) {
                        n2 = this.getGroup() * 5 + 4;
                        this.m_valueType = 64;
                    }
                    break;
                }
                case 70: 
                case 79: 
                case 80: 
                case 81: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("OPEN")) {
                        n2 = this.getGroup() * 4;
                    } else if (this.getValueType().equals("HIGH")) {
                        n2 = this.getGroup() * 4 + 1;
                    } else if (this.getValueType().equals("LOW")) {
                        n2 = this.getGroup() * 4 + 2;
                    } else if (this.getValueType().equals("CLOSE")) {
                        n2 = this.getGroup() * 4 + 3;
                    }
                    if ((n == 80 || n == 81) && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                        this.m_valueType = 64;
                    }
                    break;
                }
                case 82: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("HIGH")) {
                        n2 = this.getGroup() * 3;
                        break;
                    }
                    if (this.getValueType().equals("LOW")) {
                        n2 = this.getGroup() * 3 + 1;
                        break;
                    }
                    if (this.getValueType().equals("VOLUME")) {
                        n2 = this.getGroup() * 3 + 2;
                        this.m_valueType = 64;
                    }
                    break;
                }
                case 84: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("OPEN")) {
                        n2 = this.getGroup() * 3;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        n2 = this.getGroup() * 3 + 1;
                        break;
                    }
                    if (this.getValueType().equals("VOLUME")) {
                        n2 = this.getGroup() * 3 + 2;
                        this.m_valueType = 64;
                    }
                    break;
                }
                case 72: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("OPEN")) {
                        n2 = this.getGroup() * 2;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        n2 = this.getGroup() * 2 + 1;
                    }
                    break;
                }
                case 73: 
                case 74: 
                case 75: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("HIGH")) {
                        n2 = this.getGroup() * 2;
                    } else if (this.getValueType().equals("LOW")) {
                        n2 = this.getGroup() * 2 + 1;
                    }
                    if ((n == 74 || n == 75) && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                        this.m_valueType = 64;
                    }
                    break;
                }
                case 76: 
                case 77: 
                case 78: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("HIGH")) {
                        n2 = this.getGroup() * 3;
                    } else if (this.getValueType().equals("LOW")) {
                        n2 = this.getGroup() * 3 + 1;
                    } else if (this.getValueType().equals("CLOSE")) {
                        n2 = this.getGroup() * 3 + 2;
                    }
                    if ((n == 77 || n == 78) && this.m_graph.getSeries().isAssignedToY2(this.getSeries() % this.m_graph.getSeriesObjectCount())) {
                        this.m_valueType = 64;
                    }
                    break;
                }
                case 88: {
                    this.m_valueType = 63;
                    if (this.getValueType().equals("HIGH")) {
                        n2 = this.getGroup() * 4;
                        break;
                    }
                    if (this.getValueType().equals("LOW")) {
                        n2 = this.getGroup() * 4 + 1;
                        break;
                    }
                    if (this.getValueType().equals("CLOSE")) {
                        n2 = this.getGroup() * 4 + 2;
                        break;
                    }
                    if (!this.getValueType().equals("VOLUME")) break;
                    n2 = this.getGroup() * 4 + 3;
                    this.m_valueType = 64;
                }
            }
        }
        catch (SeriesOutOfRangeException seriesOutOfRangeException) {
            // empty catch block
        }
        int n3 = this.m_graph.isDataRowShownAsASeries() ? this.getSeries() : n2;
        int n4 = this.m_graph.isDataRowShownAsASeries() ? n2 : this.getSeries();
        this.m_column = ((DataCallback)this.m_graph.getDataFilter()).getDataAccessColumn(n3, n4);
        this.m_row = ((DataCallback)this.m_graph.getDataFilter()).getDataAccessRow(n3, n4);
    }
}

