/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.ModelAdapter;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.graph.GraphModel;
import oracle.dss.graph.GraphStyleManager;
import oracle.dss.graph.SampleDataSource;
import oracle.dss.graph.managers.GraphRuleFormatter;
import oracle.dss.graph.managers.GraphRuleStyles;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.TypeNotSupportedException;

public class GraphModelAdapter
extends ModelAdapter
implements GraphModel {
    protected Graph m_graphView;
    protected GraphFormatManager m_graphFormatManager;
    protected GraphStyleManager m_graphStyleManager;
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";

    public GraphModelAdapter(Graph graph) {
        this.m_graphView = graph;
        this.setGraphFormatManager(new GraphRuleFormatter());
        this.setGraphStyleManager(new GraphRuleStyles());
        this.initDefaults(new GraphDefaultValues());
    }

    public GraphModelAdapter(Graph graph, DataSource dataSource) {
        super.setDataSource(dataSource);
        this.m_graphView = graph;
        this.setGraphFormatManager(new GraphRuleFormatter());
        this.setGraphStyleManager(new GraphRuleStyles());
        this.initDefaults(new GraphDefaultValues());
    }

    protected void initDefaults(GraphDefaultValues graphDefaultValues) {
        super.initDefaults(graphDefaultValues);
    }

    public void setDataSource(DataSource dataSource) {
        if (dataSource == null) {
            super.setDataSource(new SampleDataSource(this.m_graphView));
        } else {
            super.setDataSource(dataSource);
        }
        if (this.dataDirectorFactory != null) {
            switch (this.m_graphView.getDataDirectorType()) {
                case 1: {
                    this.setDataDirector(this.dataDirectorFactory.createRelationalDataDirector());
                    break;
                }
                case 0: {
                    this.setDataDirector(this.dataDirectorFactory.createCubeDataDirector());
                    break;
                }
                default: {
                    this.getErrorHandler().log("Invalid DataDirectorType", this.getClass().getName(), "setDataSource");
                }
            }
        }
    }

    protected void setSupportedDataLayerFlags() {
        DataMap dataMap = this.getDataDirector().getSupportedDataMap();
        MetadataMap metadataMap = this.getDataDirector().getSupportedMetadataMap();
        LayerMetadataMap layerMetadataMap = this.getDataDirector().getSupportedLayerMetadataMap();
        boolean bl = false;
        if (dataMap == null) {
            this.m_graphView.getErrorHandler().trace("Current DataSource has a null DataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (metadataMap == null) {
            this.m_graphView.getErrorHandler().trace("Current DataSource has a null MetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (layerMetadataMap == null) {
            this.m_graphView.getErrorHandler().trace("Current DataSource has a null LayerMetadataMap", this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        if (!(bl = dataMap != null ? dataMap.contains("dataUnformatted") : false)) {
            this.m_graphView.getErrorHandler().error(new TypeNotSupportedException("DataMap", "DATA_UNFORMATTED"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.m_graphView.setDataUnformattedSupported(true);
        bl = metadataMap != null ? metadataMap.contains("longName") : false;
        if (!bl) {
            this.m_graphView.getErrorHandler().error(new TypeNotSupportedException("MetadataMap", "METADATA_LONGLABEL"), this.getClass().getName(), m_method_setsupporteddatalayerflags);
        }
        this.m_graphView.setMetadataLongLabelSupported(true);
        if (metadataMap != null) {
            bl = metadataMap.contains("drillState");
        }
        this.m_graphView.setMetadataDrillSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("mediumName") : false;
        this.m_graphView.setMetadataMediumLabelSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("shortName") : false;
        this.m_graphView.setMetadataShortLabelSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("viewStyle") : false;
        this.m_graphView.setMetadataViewStyleSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("date") : false;
        this.m_graphView.setMetadataDateSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("drillParentDate") : false;
        this.m_graphView.setMetadataDrillParentDateSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("drillParentDateSpan") : false;
        this.m_graphView.setMetadataDrillParentDateSpanSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("dateSpan") : false;
        this.m_graphView.setMetadataDateSpanSupported(bl);
        bl = metadataMap != null ? metadataMap.contains("value") : false;
        this.m_graphView.setMetadataValueSupported(bl);
        bl = layerMetadataMap != null ? layerMetadataMap.contains("dimShortName") : false;
        this.m_graphView.setLayerMetaShortLabelSupported(bl);
        bl = layerMetadataMap != null ? layerMetadataMap.contains("dimMediumName") : false;
        this.m_graphView.setLayerMetaMediumLabelSupported(bl);
        bl = layerMetadataMap != null ? layerMetadataMap.contains("dimLongName") : false;
        this.m_graphView.setLayerMetaLongLabelSupported(bl);
        bl = layerMetadataMap != null ? layerMetadataMap.contains("dimName") : false;
        this.m_graphView.setLayerMetaNameSupported(bl);
        bl = layerMetadataMap != null ? layerMetadataMap.contains("viewStyle") : false;
        this.m_graphView.setLayerMetaViewStyleSupported(bl);
    }

    public DataMap getDataMap() {
        return new DataMap("dataUnformatted");
    }

    public MetadataMap getMetadataMap(int n) {
        String[] stringArray = new String[]{"longName", "mediumName", "shortName", "viewStyle", "value"};
        return new MetadataMap(stringArray);
    }

    public LayerMetadataMap getLayerMetadataMap(int n) {
        String[] stringArray = new String[]{"dimLongName", "dimMediumName", "dimShortName", "dimName", "viewStyle"};
        return new LayerMetadataMap(stringArray);
    }

    public GraphFormatManager getGraphFormatManager() {
        return this.m_graphFormatManager;
    }

    public void setGraphFormatManager(GraphFormatManager graphFormatManager) {
        super.setFormatManager(graphFormatManager);
        this.m_graphFormatManager = graphFormatManager;
    }

    public GraphStyleManager getGraphStyleManager() {
        return this.m_graphStyleManager;
    }

    public void setGraphStyleManager(GraphStyleManager graphStyleManager) {
        this.m_graphStyleManager = graphStyleManager;
    }

    public Graph getGraphView() {
        return this.m_graphView;
    }
}

