/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.DataFilter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.ErrorHandler;

public abstract class DataFilterImpl
implements DataFilter {
    protected int m_graphType = 17;
    protected int m_scatterDataModel = 0;
    protected boolean m_seriesAreRows;
    protected boolean m_isDirtyFlag;
    protected boolean m_filterOn;
    protected boolean m_oneGrpLabel;
    protected int[][] m_measuresArrays = new int[12][];
    protected int m_totalMeasures = -1;
    protected int[] m_currentArray;
    protected int m_graphCategory = -1;
    protected int m_currentGroupSize = -1;
    protected static final int NON_FILTER_TYPE = -1;
    protected static final int SCATTER_TYPE = 0;
    protected static final int SCATTER_LABELS_TYPE = 1;
    protected static final int BUBBLE_TYPE = 2;
    protected static final int BUBBLE_LABELS_TYPE = 3;
    protected static final int OHLCV_TYPE = 4;
    protected static final int OHLC_TYPE = 5;
    protected static final int HLV_TYPE = 6;
    protected static final int OCV_TYPE = 7;
    protected static final int OC_TYPE = 8;
    protected static final int HL_TYPE = 9;
    protected static final int HLC_TYPE = 10;
    protected static final int HLCV_TYPE = 11;
    protected static final int TOTAL_CATEGORIES = 12;
    protected static final int GROUP_SIZE_TWO = 2;
    protected static final int GROUP_SIZE_THREE = 3;
    protected static final int GROUP_SIZE_FOUR = 4;
    protected static final int GROUP_SIZE_FIVE = 5;
    protected int d_totalMeasures;
    protected static final String m_method_setMeasures2 = "setMeasures(int measures[], int totalMeasures)";
    protected static final String m_method_setMeasures3 = "setMeasures(int graphType, int measures[], int totalMeasures)";
    protected static final String m_unequalLength = "measure array length is not equal to the group size";
    protected static final String m_nonFilterArray = "measure array set for graph type that does not need a filter";
    protected static final String m_lessTotalMeasures = "total number of measures are less than the group size";

    public void setGraphType(int n) {
        this.m_graphType = n;
        this.m_graphCategory = this.getGraphCategory(n);
        this.m_currentGroupSize = this.getGroupSize(this.m_graphCategory);
        if (this.m_graphCategory != -1) {
            if (this.m_measuresArrays[this.m_graphCategory] != null) {
                this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
                this.m_filterOn = true;
                this.needRec();
            } else {
                this.m_currentArray = null;
                this.m_filterOn = false;
            }
        } else {
            this.m_currentArray = null;
            this.m_filterOn = false;
        }
    }

    public void setDataRowShownAsASeries(boolean bl) {
        this.m_seriesAreRows = bl;
    }

    public int[] getMeasures() {
        return this.m_currentArray;
    }

    public int[] getMeasures(int n) {
        int n2 = this.getGraphCategory(n);
        return this.m_measuresArrays[n2];
    }

    public void setMeasures(int[] nArray, int n) {
        if (nArray.length != this.m_currentGroupSize) {
            this.getErrorHandler().log(m_unequalLength, this.getClass().getName(), m_method_setMeasures2);
        } else if (this.m_graphCategory == -1) {
            this.getErrorHandler().log(m_nonFilterArray, this.getClass().getName(), m_method_setMeasures2);
        } else if (n < this.m_currentGroupSize) {
            this.getErrorHandler().log(m_lessTotalMeasures, this.getClass().getName(), m_method_setMeasures2);
        } else {
            int n2 = 0;
            while (n2 < this.m_currentGroupSize) {
                if (nArray[n2] > n - 1) {
                    this.getErrorHandler().log(String.valueOf(String.valueOf("measure index in the specified array at index ")) + n2 + " is greater than (totalMeasures - 1)", this.getClass().getName(), m_method_setMeasures2);
                    return;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < this.m_currentGroupSize) {
                int n3 = n2 + 1;
                while (n3 < this.m_currentGroupSize) {
                    if (nArray[n2] == nArray[n3]) {
                        this.getErrorHandler().log(String.valueOf(String.valueOf("measure index in the specified array at index ")) + n2 + " is same as the one at the index " + n3 + ". Measure indexes should be unique.", this.getClass().getName(), m_method_setMeasures2);
                        return;
                    }
                    ++n3;
                }
                ++n2;
            }
            this.m_measuresArrays[this.m_graphCategory] = nArray;
            this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
            this.m_totalMeasures = n;
            this.m_filterOn = true;
            this.setDirty(true);
            this.needRec();
        }
    }

    public void setMeasures(int n, int[] nArray, int n2) {
        int n3 = this.getGraphCategory(n);
        int n4 = this.getGroupSize(n3);
        if (n3 == -1) {
            this.getErrorHandler().log(m_nonFilterArray, this.getClass().getName(), m_method_setMeasures3);
        } else if (nArray.length != n4) {
            this.getErrorHandler().log(m_unequalLength, this.getClass().getName(), m_method_setMeasures3);
        } else if (n2 < n4) {
            this.getErrorHandler().log(m_lessTotalMeasures, this.getClass().getName(), m_method_setMeasures3);
        } else {
            int n5 = 0;
            while (n5 < n4) {
                if (nArray[n5] > n2 - 1) {
                    this.getErrorHandler().log(String.valueOf(String.valueOf("measure index in the specified array at index ")) + n5 + " is greater than (totalMeasures - 1)", this.getClass().getName(), m_method_setMeasures3);
                    return;
                }
                ++n5;
            }
            n5 = 0;
            while (n5 < n4) {
                int n6 = n5 + 1;
                while (n6 < n4) {
                    if (nArray[n5] == nArray[n6]) {
                        this.getErrorHandler().log(String.valueOf(String.valueOf("measure index in the specified array at index ")) + n5 + " is same as the one at the index " + n6 + ". Measure indexes should be unique.", this.getClass().getName(), m_method_setMeasures3);
                        return;
                    }
                    ++n6;
                }
                ++n5;
            }
            this.m_measuresArrays[n3] = nArray;
            this.m_totalMeasures = n2;
            if (this.m_graphCategory == n3) {
                this.m_currentArray = this.m_measuresArrays[this.m_graphCategory];
                this.m_filterOn = true;
                this.setDirty(true);
                this.needRec();
            }
        }
    }

    public void refresh() {
        this.m_filterOn = false;
        this.m_totalMeasures = -1;
        int n = 0;
        while (n < 12) {
            this.m_measuresArrays[n] = null;
            ++n;
        }
        this.m_currentArray = null;
    }

    public int getColumns() {
        try {
            int n = this.getDataAccess().getEdgeExtent(0);
            if (this.m_seriesAreRows && this.m_filterOn) {
                this.m_oneGrpLabel = n / this.m_totalMeasures == 1;
                n = n / this.m_totalMeasures * this.m_currentGroupSize;
            } else if (this.m_seriesAreRows) {
                boolean bl = this.m_oneGrpLabel = n / this.m_currentGroupSize == 1;
            }
            if (this.isExcelOrDeskTop()) {
                n = this.m_scatterDataModel == 1 ? (!this.m_seriesAreRows ? --n : (n *= 2)) : (!this.m_seriesAreRows ? (n /= 2) : (n *= 2));
            }
            if (n < 0) {
                n = 0;
            }
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getRows() {
        try {
            int n = this.getDataAccess().getEdgeExtent(1);
            if (!this.m_seriesAreRows && this.m_filterOn) {
                this.m_oneGrpLabel = n / this.m_totalMeasures == 1;
                n = n / this.m_totalMeasures * this.m_currentGroupSize;
            } else if (!this.m_seriesAreRows) {
                boolean bl = this.m_oneGrpLabel = n / this.m_currentGroupSize == 1;
            }
            if (this.isExcelOrDeskTop()) {
                n = this.m_scatterDataModel == 1 ? (!this.m_seriesAreRows ? (n *= 2) : --n) : (!this.m_seriesAreRows ? (n *= 2) : (n /= 2));
            }
            if (n < 0) {
                n = 0;
            }
            int n2 = n;
            return n2;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean isDirty() {
        boolean bl = this.m_isDirtyFlag;
        this.m_isDirtyFlag = false;
        return bl;
    }

    public void setDirty(boolean bl) {
        this.m_isDirtyFlag = bl;
        this.m_oneGrpLabel = false;
    }

    public int getDataAccessColumn(int n) {
        if (this.m_seriesAreRows && this.m_filterOn) {
            return this.getDataAccessIndex(n);
        }
        return n;
    }

    public int getDataAccessRow(int n) {
        if (!this.m_seriesAreRows && this.m_filterOn) {
            return this.getDataAccessIndex(n);
        }
        return n;
    }

    public int getFilteredColumn(int n) {
        int n2 = 0;
        try {
            n2 = this.getDataAccess().getEdgeExtent(0);
        }
        catch (Exception exception) {
            int n3 = -1;
            return n3;
        }
        if (n > n2 - 1 || n < 0) {
            return -1;
        }
        if (this.m_seriesAreRows && this.m_filterOn) {
            int n4 = this.getFilteredIndex(n);
            if (n4 > this.getColumns() - 1) {
                return -1;
            }
            return n4;
        }
        return n;
    }

    public int getFilteredRow(int n) {
        int n2 = 0;
        try {
            n2 = this.getDataAccess().getEdgeExtent(1);
        }
        catch (Exception exception) {
            int n3 = -1;
            return n3;
        }
        if (n > n2 - 1 || n < 0) {
            return -1;
        }
        if (!this.m_seriesAreRows && this.m_filterOn) {
            int n4 = this.getFilteredIndex(n);
            if (n4 > this.getRows() - 1) {
                return -1;
            }
            return n4;
        }
        return n;
    }

    public int getTotalMeasures() {
        return this.m_totalMeasures;
    }

    public void setTotalMeasures(int n) {
        this.m_totalMeasures = n;
    }

    public int[][] getMArray() {
        return this.m_measuresArrays;
    }

    public void setMArray(int[][] nArray) {
        this.m_measuresArrays = nArray;
    }

    protected void setScatterDataModel(int n) {
        this.m_scatterDataModel = n;
    }

    public abstract Object getValue(int var1, int var2);

    protected abstract void needRec();

    protected abstract DataAccess getDataAccess();

    protected abstract ErrorHandler getErrorHandler();

    protected int getGroupSize(int n) {
        int n2 = -1;
        switch (n) {
            case 0: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 11: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 5;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    protected int getGraphCategory(int n) {
        int n2 = -1;
        switch (n) {
            case 61: 
            case 62: 
            case 65: 
            case 66: {
                n2 = 0;
                break;
            }
            case 63: 
            case 64: {
                n2 = 1;
                break;
            }
            case 89: 
            case 91: {
                n2 = 2;
                break;
            }
            case 90: 
            case 92: {
                n2 = 3;
                break;
            }
            case 71: 
            case 83: {
                n2 = 4;
                break;
            }
            case 70: 
            case 79: 
            case 80: 
            case 81: {
                n2 = 5;
                break;
            }
            case 82: {
                n2 = 6;
                break;
            }
            case 84: {
                n2 = 7;
                break;
            }
            case 72: {
                n2 = 8;
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                n2 = 9;
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                n2 = 10;
                break;
            }
            case 88: {
                n2 = 11;
                break;
            }
            default: {
                n2 = -1;
            }
        }
        return n2;
    }

    protected boolean isExcelOrDeskTop() {
        return this.m_scatterDataModel != 0 && (this.m_graphType == 61 || this.m_graphType == 62 || this.m_graphType == 65 || this.m_graphType == 66);
    }

    private int getFilteredIndex(int n) {
        if (n < 0) {
            return n;
        }
        int n2 = n / this.m_totalMeasures * this.m_currentGroupSize;
        int n3 = n % this.m_totalMeasures;
        int n4 = 0;
        while (n4 < this.m_currentGroupSize) {
            if (this.m_currentArray[n4] == n3) {
                return n2 + n4;
            }
            ++n4;
        }
        return -1;
    }

    private int getDataAccessIndex(int n) {
        if (n < 0) {
            return n;
        }
        int n2 = n / this.m_currentGroupSize * this.m_totalMeasures;
        int n3 = n % this.m_currentGroupSize;
        return n2 + this.m_currentArray[n3];
    }
}

