/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.ResourceBundle;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.UITitle;
import oracle.dss.graph.Visible;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseTitle
extends BaseText
implements UITitle,
Visible {
    protected static final int ATTR_TEXTROTATION = 1;
    protected static final int ATTR_HORIZONTALALIGNMENT = 2;
    protected static final int ATTR_BASETITLE_LASTID = 2;
    protected boolean visible;
    protected int textRotation;
    protected int horizontalAlignment;
    protected String text;
    protected String m_text;
    protected ResourceBundle rBundle;

    public BaseTitle(Graph graph) {
        super(graph);
        this.updateResourceBundle();
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    public int getHorizontalAlignment() {
        return this.convertPFJHAlignmentToSwing(this.m_pfj.getTextJustHoriz(this.m_identObj));
    }

    public void setHorizontalAlignment(int n) {
        int n2 = this.convertSwingHAlignmentToPFJ(n);
        if (n2 == -1) {
            this.m_graph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        } else {
            this.m_pfj.setTextJustHoriz(this.m_identObj, this.convertSwingHAlignmentToPFJ(n));
            this.setPropertyOverrideFlags(2);
        }
    }

    public String getText() {
        TokenSubstitution tokenSubstitution = this.m_graph.getTokenSubstitution();
        return tokenSubstitution.getParsedString(this.m_text);
    }

    public String getUnParseText() {
        return this.m_text;
    }

    public void setText(String string) {
        if (string == null) {
            this.m_graph.getErrorHandler().log("invalid text", this.getClass().toString(), "setText");
            return;
        }
        TokenSubstitution tokenSubstitution = this.m_graph.getTokenSubstitution();
        String[] stringArray = null;
        if (tokenSubstitution != null) {
            stringArray = tokenSubstitution.getListItems();
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = tokenSubstitution.getToken(stringArray[n]);
                ++n;
            }
        }
        string = this.truncateText(string, stringArray);
        this.setTitleString(tokenSubstitution.getParsedString(string));
        this.m_text = string;
    }

    public void setUnParseText(String string) {
        this.m_text = string;
    }

    protected abstract void setTitleString(String var1);

    public void resetToDefault() {
        this.m_text = "";
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int rotate)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, n);
            this.m_graph.autoSetAxisTitleVerticalAlignment(this.m_identObj.getObjectID());
            this.setPropertyOverrideFlags(1);
        }
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setDisplay(this.m_identObj, bl);
    }

    public void updateResourceBundle() {
        this.rBundle = this.m_graph != null ? ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle", this.m_graph.getLocale()) : ResourceBundle.getBundle("oracle.dss.graph.resource.GraphBundle");
    }

    protected String convertTextRotationToString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "TR_HORIZ";
                break;
            }
            case 1: {
                string = "TR_HORIZ_ROTATE_90";
                break;
            }
            case 2: {
                string = "TR_HORIZ_ROTATE_270";
            }
        }
        return string;
    }

    protected int convertTextRotationToInt(String string) {
        int n = 0;
        if (string.equals("TR_HORIZ")) {
            n = 0;
        } else if (string.equals("TR_HORIZ_ROTATE_90")) {
            n = 1;
        } else if (string.equals("TR_HORIZ_ROTATE_270")) {
            n = 2;
        }
        return n;
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        if (bl || !this.text.equals(this.getUnParseText())) {
            objectNode.addProperty("text", this.getUnParseText());
            bl2 = true;
        }
        if (bl || this.visible != this.isVisible()) {
            objectNode.addProperty("visible", this.isVisible());
            bl2 = true;
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString(this.getHorizontalAlignment()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("textRotation", this.convertTextRotationToString(this.getTextRotation()));
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
        super.setNonstyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("text");
        if (propertyNode != null) {
            this.setText(propertyNode.getValueAsString());
        }
        if ((propertyNode = objectNode.getProperty("visible")) != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        } else {
            this.setVisible(this.visible);
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("horizontalAlignment");
        if (propertyNode != null) {
            this.setHorizontalAlignment(this.convertHorizontalAlignmentToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("textRotation")) != null) {
            this.setTextRotation(this.convertTextRotationToInt(propertyNode.getValueAsString()));
        }
    }

    public void resetStyle() {
        this.setTextRotation(this.textRotation);
        this.setHorizontalAlignment(this.horizontalAlignment);
        super.resetStyle();
    }

    private String truncateText(String string, String[] stringArray) {
        if (string.length() <= 1024) {
            return string;
        }
        int n = 0;
        String string2 = string.substring(0, 1024);
        if (stringArray != null) {
            int n2 = -1;
            int n3 = 0;
            int n4 = 0;
            while (n4 < stringArray.length) {
                String string3 = stringArray[n4];
                n = string2.lastIndexOf(string3);
                if (n > n2) {
                    n2 = n;
                    n3 = string3.length();
                }
                ++n4;
            }
            if (n2 == -1) {
                if (string.charAt(1024) != ' ' && (n = string2.lastIndexOf(32)) != -1) {
                    string2 = string2.substring(0, n);
                }
            } else if (string.charAt(1024) != ' ') {
                n = string2.lastIndexOf(32);
                string2 = n != -1 ? (n > n2 ? string2.substring(0, n) : string2.substring(0, n2 + n3)) : string2.substring(0, n2 + n3);
            }
        } else if (string.charAt(1024) != ' ' && (n = string2.lastIndexOf(32)) != -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }
}

