/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.dataView.WordWrapEnabled;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UILegendText;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseLegendText
extends BaseText
implements WordWrapEnabled,
UILegendText {
    protected static final int ATTR_HORIZONTALALIGNMENT = 1;
    protected static final int ATTR_MAXAUTOFONTSIZE = 2;
    protected static final int ATTR_MINAUTOFONTSIZE = 3;
    protected static final int ATTR_WORDWRAPENABLED = 4;
    protected static final int ATTR_STYLE_MAXID = 5;
    protected boolean textFittingAutomatic;
    protected int horizontalAlignment;
    protected int d_maxAutoFontSize;
    protected int d_minAutoFontSize;
    protected boolean d_wordWrapEnabled;
    private static final String a_maxAutoFontSize = "maxAutoFontSize";
    private static final String a_minAutoFontSize = "minAutoFontSize";
    private static final String m_method_setMaxAutoFontSize = "void setMaxAutoFontSize(int size)";
    private static final String m_method_setMinAutoFontSize = "void setMinAutoFontSize(int size)";

    public BaseLegendText(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendText();
        this.initDefaultValues();
    }

    private void initDefaultValues() {
        this.fontTypeface = GraphDefaultValues.getLegendFontTypeface();
        this.fontColor = GraphDefaultValues.getLegendFontColor();
        this.fontStyle = GraphDefaultValues.getLegendFontStyle();
        this.fontSize = GraphDefaultValues.getLegendFontSize();
        this.horizontalAlignment = GraphDefaultValues.getLegendHorizontalAlignment();
        this.graphProportionalFontSize = GraphDefaultValues.getLegendGraphProportionalFontSize();
        this.textFittingAutomatic = GraphDefaultValues.isLegendTextFittingAutomatic();
        this.d_maxAutoFontSize = GraphDefaultValues.getLegendMaxAutoFontSize();
        this.d_minAutoFontSize = GraphDefaultValues.getLegendMinAutoFontSize();
        this.d_wordWrapEnabled = GraphDefaultValues.getLegendWordWrapEnabled();
    }

    public boolean isTextFittingAutomatic() {
        return this.m_pfj.getLegendTextAutofit();
    }

    public void setTextFittingAutomatic(boolean bl) {
        this.m_pfj.setLegendTextAutofit(bl);
    }

    public int getHorizontalAlignment() {
        return this.convertPFJHAlignmentToSwing(this.m_pfj.getTextJustHoriz(this.m_identObj));
    }

    public void setHorizontalAlignment(int n) {
        int n2 = this.convertSwingHAlignmentToPFJ(n);
        if (n2 == -1) {
            this.m_graph.getErrorHandler().log("invalid horizontal aligment", "oracle.dss.graph.LegendText", "setHorizontalAlignment(a)");
        } else {
            this.m_pfj.setTextJustHoriz(this.m_identObj, n2);
            this.m_graph.getLegendText().setPropertyOverrideFlags(1);
        }
    }

    public int getMaxAutoFontSize() {
        return this.m_pfj.getTextAutofitMax();
    }

    public void setMaxAutoFontSize(int n) {
        if (n < 1) {
            this.m_graph.getErrorHandler().log("invalid size", this.getClass().getName(), m_method_setMaxAutoFontSize);
            return;
        }
        this.m_pfj.setTextAutofitMax(n);
        this.m_graph.getLegendText().setPropertyOverrideFlags(2);
    }

    public int getMinAutoFontSize() {
        return this.m_pfj.getTextAutofitMin();
    }

    public void setMinAutoFontSize(int n) {
        if (n < 1) {
            this.m_graph.getErrorHandler().log("invalid size", this.getClass().getName(), m_method_setMinAutoFontSize);
            return;
        }
        this.m_pfj.setTextAutofitMin(n);
        this.m_graph.getLegendText().setPropertyOverrideFlags(3);
    }

    public boolean isWordWrapEnabled() {
        return this.m_pfj.getTextWrap(this.m_identObj);
    }

    public void setWordWrapEnabled(boolean bl) {
        this.m_pfj.setTextWrap(this.m_identObj, bl);
        this.m_graph.getLegendText().setPropertyOverrideFlags(4);
    }

    protected int convertHorizontalAlignmentToInt(String string) {
        int n = 0;
        if (string.equals("LEFT")) {
            n = 2;
        } else if (string.equals("CENTER")) {
            n = 0;
        } else if (string.equals("RIGHT")) {
            n = 4;
        } else if (string.equals("LEADING")) {
            n = 10;
        }
        return n;
    }

    protected String convertHorizontalAlignmentToString(int n) {
        String string = "";
        switch (n) {
            case 2: {
                string = "LEFT";
                break;
            }
            case 0: {
                string = "CENTER";
                break;
            }
            case 4: {
                string = "RIGHT";
                break;
            }
            case 10: {
                string = "LEADING";
            }
        }
        return string;
    }

    protected int getStylePropertyCount() {
        return 5;
    }

    protected void setXML(ObjectNode objectNode) {
        this.setStyleXML(objectNode);
        this.setNonstyleXML(objectNode);
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        if (bl || this.isTextFittingAutomatic() != this.textFittingAutomatic) {
            objectNode.addProperty("textFittingAutomatic", this.isTextFittingAutomatic());
            bl2 = true;
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString(this.getHorizontalAlignment()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty(a_maxAutoFontSize, this.getMaxAutoFontSize());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty(a_minAutoFontSize, this.getMinAutoFontSize());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("wordWrapEnabled", this.isWordWrapEnabled());
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode) {
        super.setNonstyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("textFittingAutomatic");
        if (propertyNode != null) {
            this.setTextFittingAutomatic(propertyNode.getValueAsBoolean());
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("horizontalAlignment");
        if (propertyNode != null) {
            this.setHorizontalAlignment(this.convertHorizontalAlignmentToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty(a_maxAutoFontSize)) != null) {
            this.setMaxAutoFontSize(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty(a_minAutoFontSize)) != null) {
            this.setMinAutoFontSize(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("wordWrapEnabled")) != null) {
            this.setWordWrapEnabled(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.m_pfj.setTextJustHoriz(this.m_identObj, this.convertSwingHAlignmentToPFJ(this.horizontalAlignment));
        this.m_pfj.setTextAutofitMax(this.d_maxAutoFontSize);
        this.m_pfj.setTextAutofitMin(this.d_minAutoFontSize);
        this.m_pfj.setTextWrap(this.m_identObj, this.d_wordWrapEnabled);
        super.resetStyle();
    }
}

