/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseLegendMarker
extends BaseGraphComponent {
    protected static final int ATTR_SIZE = 0;
    protected static final int ATTR_STYLE_MAXID = 1;
    protected int m_maxSize;
    protected int d_size;
    private static final String a_size = "size";
    private static final String m_method_setSize = "void setSize(int size)";

    public BaseLegendMarker(Graph graph) {
        super(graph);
        this.m_identObj = this.m_pfj.getLegendMarker();
        this.d_size = GraphDefaultValues.getLegendMarkerSize();
    }

    public void setSize(int n) {
        if (n < 1) {
            this.m_graph.getErrorHandler().log("size out of range", this.getClass().getName(), m_method_setSize);
            return;
        }
        this.m_pfj.setLegendMarkerSize(n);
        this.m_graph.getLegendMarker().setPropertyOverrideFlags(0);
    }

    public int getSize() {
        return this.m_pfj.getLegendMarkerSize();
    }

    protected int getStylePropertyCount() {
        return 1;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty(a_size, this.getSize());
            bl2 = true;
        }
        return bl2;
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty(a_size);
        if (propertyNode != null) {
            this.setSize(propertyNode.getValueAsInteger());
        }
    }

    protected void resetStyle() {
        this.setSize(this.d_size);
        super.resetStyle();
    }
}

