/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.Border;
import oracle.dss.graph.Fill;
import oracle.dss.graph.Graph;
import oracle.dss.graph.SFX;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseGraphFrame
extends BaseGraphComponent
implements Border,
Fill {
    protected static final int ATTR_FILLCOLOR = 0;
    protected static final int ATTR_FILLTRANSPARENT = 1;
    protected static final int ATTR_BORDERCOLOR = 2;
    protected static final int ATTR_BORDERTRANSPARENT = 3;
    protected static final int ATTR_BASEFRAME_LASTID = 3;
    protected static final int ATTR_STYLE_MAXID = 4;
    protected SFX m_sfx;
    protected int borderColor;
    protected boolean borderTransparent;
    protected int fillColor;
    protected boolean fillTransparent;

    public BaseGraphFrame(Graph graph) {
        super(graph);
    }

    public Color getBorderColor() {
        return this.m_pfj.getBorderColor(this.m_identObj);
    }

    public void setBorderColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setBorderColor( Color newColor)");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj, color);
        this.setPropertyOverrideFlags(2);
        if (this.getComponentName().equals("ThreeDFloor") && this.m_graph.isGroup3DPanels()) {
            this.m_pfj.setBorderColor(this.m_pfj.getCubeLeftWall(), color);
            this.m_graph.get3DLeftWall().setPropertyOverrideFlags(2);
            this.m_pfj.setBorderColor(this.m_pfj.getCubeRightWall(), color);
            this.m_graph.get3DRightWall().setPropertyOverrideFlags(2);
        }
    }

    public boolean isBorderTransparent() {
        return this.m_pfj.getTransparentBorderColor(this.m_identObj);
    }

    public void setBorderTransparent(boolean bl) {
        this.m_pfj.setTransparentBorderColor(this.m_identObj, bl);
        this.setPropertyOverrideFlags(3);
        if (this.getComponentName().equals("ThreeDFloor") && this.m_graph.isGroup3DPanels()) {
            this.m_pfj.setTransparentBorderColor(this.m_pfj.getCubeLeftWall(), bl);
            this.m_graph.get3DLeftWall().setPropertyOverrideFlags(3);
            this.m_pfj.setTransparentBorderColor(this.m_pfj.getCubeRightWall(), bl);
            this.m_graph.get3DRightWall().setPropertyOverrideFlags(3);
        }
    }

    public Color getFillColor() {
        return this.m_pfj.getFillColor(this.m_identObj);
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        if (this.m_graph.isGroup3DPanels()) {
            this.m_graph.getPlotArea().setGroupFillColor(color);
            this.m_pfj.setFillColor(this.m_pfj.getCubeLeftWall(), color);
            this.m_graph.get3DLeftWall().setPropertyOverrideFlags(0);
            this.m_pfj.setFillColor(this.m_pfj.getCubeRightWall(), color);
            this.m_graph.get3DRightWall().setPropertyOverrideFlags(0);
        } else if (this.getComponentName().equals("ThreeDLeftWall") || this.getComponentName().equals("ThreeDRightWall")) {
            this.m_pfj.setFillColor(this.m_identObj, color);
            this.setPropertyOverrideFlags(0);
        } else {
            this.m_graph.getPlotArea().setGroupFillColor(color);
        }
    }

    public boolean isFillTransparent() {
        return this.m_pfj.getTransparentFillColor(this.m_identObj);
    }

    public void setFillTransparent(boolean bl) {
        if (this.m_graph.isGroup3DPanels()) {
            this.m_graph.getPlotArea().setGroupFillTransparent(bl);
            this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeLeftWall(), bl);
            this.m_graph.get3DLeftWall().setPropertyOverrideFlags(1);
            this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeRightWall(), bl);
            this.m_graph.get3DRightWall().setPropertyOverrideFlags(1);
        } else if (this.getComponentName().equals("ThreeDLeftWall") || this.getComponentName().equals("ThreeDRightWall")) {
            this.m_pfj.setTransparentFillColor(this.m_identObj, bl);
            this.setPropertyOverrideFlags(1);
        } else {
            this.m_graph.getPlotArea().setGroupFillTransparent(bl);
        }
    }

    public SFX getSFX() {
        if (this.m_sfx == null) {
            this.m_sfx = new SFX(this.m_graph, this.m_identObj);
        }
        return this.m_sfx;
    }

    protected int getStylePropertyCount() {
        return 4;
    }

    protected ObjectNode getXML(boolean bl) {
        return this.getXML(bl, true);
    }

    protected ObjectNode getStyleXML(boolean bl) {
        return this.getXML(bl, false);
    }

    protected ObjectNode getXML(boolean bl, boolean bl2) {
        BaseObjectNode baseObjectNode;
        boolean bl3 = false;
        ObjectNode objectNode = new ObjectNode(this.getComponentName());
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty("borderColor", BaseGraphComponent.toHexString(this.getBorderColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty("borderTransparent", this.isBorderTransparent());
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("fillColor", BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
            bl3 = true;
        }
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("fillTransparent", this.isFillTransparent());
            bl3 = true;
        }
        if ((this.getComponentName().equals("ThreeDFloor") || this.getComponentName().equals("PieFrame")) && bl2) {
            if (!this.m_graph.getPlotArea().getFillColor().equals(this.getFillColor()) && !this.isUserOverrideFlag(0)) {
                objectNode.addProperty("fillColor", BaseGraphComponent.toHexString(this.getFillColor().getRGB()));
                bl3 = true;
            }
            if (this.m_graph.getPlotArea().isFillTransparent() != this.isFillTransparent() && !this.isUserOverrideFlag(1)) {
                objectNode.addProperty("fillTransparent", this.isFillTransparent());
                bl3 = true;
            }
        }
        if ((this.getComponentName().equals("PlotArea") || this.getComponentName().equals("PieFrame")) && (baseObjectNode = this.getRectXML(bl)) != null) {
            if (objectNode == null) {
                objectNode = new ObjectNode(this.getComponentName());
            }
            objectNode.addProperty((ObjectNode)baseObjectNode);
            bl3 = true;
        }
        if ((baseObjectNode = this.getSFX().getXML(bl, bl2)) != null) {
            objectNode.addContainer((ContainerNode)baseObjectNode);
            bl3 = true;
        }
        return bl3 ? objectNode : null;
    }

    protected void setXML(ObjectNode objectNode) {
        this.setXML(objectNode, true);
    }

    protected void setStyleXML(ObjectNode objectNode) {
        this.setXML(objectNode, false);
    }

    protected void setXML(ObjectNode objectNode, boolean bl) {
        ContainerNode containerNode;
        PropertyNode propertyNode = objectNode.getProperty("borderColor");
        if (propertyNode != null) {
            this.setBorderColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("borderTransparent")) != null) {
            this.setBorderTransparent(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("fillColor")) != null) {
            this.setFillColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((containerNode = objectNode.getContainer("SFX")) != null) {
            this.getSFX().setXML(containerNode, bl);
        }
        if ((propertyNode = objectNode.getProperty("fillTransparent")) != null) {
            this.setFillTransparent(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.m_pfj.setBorderColor(this.m_identObj, new Color(this.borderColor));
        this.m_pfj.setTransparentBorderColor(this.m_identObj, this.borderTransparent);
        this.m_pfj.setFillColor(this.m_identObj, new Color(this.fillColor));
        this.m_pfj.setTransparentFillColor(this.m_identObj, this.fillTransparent);
        super.resetStyle();
    }

    protected void createPropertyOverrideFlags() {
        if (this.m_sfx != null) {
            this.m_sfx.createPropertyOverrideFlags();
        }
        super.createPropertyOverrideFlags();
    }

    protected ObjectNode getRectXML(boolean bl) {
        return null;
    }
}

