/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.managers.Formattable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.graph.BaseGraphComponent;
import oracle.dss.graph.DataEndPoints;
import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.Graph;
import oracle.dss.graph.UIDataAxis;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.Visible;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.SeriesOutOfRangeException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseDataAxis
extends BaseGraphComponent
implements UIDataAxis,
Visible,
Formattable,
ViewFormatCallback {
    protected static final int ATTR_LINECOLOR = 0;
    protected static final int ATTR_LINEWIDTH = 1;
    protected static final int ATTR_AXISMAXLABELVISIBLE = 2;
    protected static final int ATTR_AXISMINLABELVISIBLE = 3;
    protected static final int ATTR_SCALEDLOGARITHMIC = 4;
    protected static final int ATTR_LOGARITHMICBASE = 5;
    protected static final int ATTR_ASCENDING = 6;
    protected static final int ATTR_AXISLOCATION = 7;
    protected static final int ATTR_VISIBLE = 8;
    protected static final int ATTR_STYLE_MAXID = 9;
    protected int lineWidth;
    protected Color lineColor;
    protected boolean axisMaxLabelVisible;
    protected boolean axisMinLabelVisible;
    protected boolean scaledLogarithmic;
    protected double logarithmicBase;
    protected boolean acsending;
    protected int axisLocation;
    protected boolean visible;
    protected double minAutoMajorTickStep;
    protected boolean axisMinAutoScaled;
    protected boolean axisMaxAutoScaled;
    protected boolean majorTickStepAutomatic;
    protected boolean axisAutoScaledFromZero;
    protected IdentObj m_identObj2;
    protected IdentObj m_majorGridIdentObj;
    protected IdentObj m_labelIdentObj;
    protected ViewFormat m_viewFormat = new ViewFormat();
    protected int m_id;
    protected static final String a_axisMaxLabelVisible = "axisMaxLabelVisible";
    protected static final String a_axisMinLabelVisible = "axisMinLabelVisible";
    protected static final String a_ascending = "ascending";
    protected static final String a_axisLocation = "axisLocation";
    protected static final String a_minAutoMajorTickStep = "minAutoMajorTickStep";
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat viewFormat)";

    public BaseDataAxis(Graph graph) {
        super(graph);
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_graph);
    }

    public boolean selectObject(int n, int n2) {
        this.m_pfj.setSelection(this.m_pfj.getGlobal());
        this.m_pfj.setNoSelection();
        this.m_pfj.setSelection(this.m_identObj2);
        return this.m_identObj2.equals(this.m_pfj.getSelectionID());
    }

    public void resetToDefault() {
        this.m_viewFormat = new ViewFormat();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_graph);
    }

    public void setAscending(boolean bl) {
        this.m_pfj.setAxisDescending(this.m_identObj, !bl);
        this.setPropertyOverrideFlags(6);
    }

    public boolean isAscending() {
        return !this.m_pfj.getAxisDescending(this.m_identObj);
    }

    public abstract boolean isAxisAutoScaledFromZero();

    public abstract void setAxisAutoScaledFromZero(boolean var1);

    public abstract boolean isAxisMaxAutoScaled();

    public abstract void setAxisMaxAutoScaled(boolean var1);

    public abstract boolean isAxisMinAutoScaled();

    public abstract void setAxisMinAutoScaled(boolean var1);

    public abstract double getAxisMaxAutoValue();

    public abstract double getAxisMaxValue();

    public abstract void setAxisMaxValue(double var1);

    public abstract double getAxisMinAutoValue();

    public abstract double getAxisMinValue();

    public abstract void setAxisMinValue(double var1);

    public int getAxisLocation() {
        return this.m_pfj.getAxisSide(this.m_identObj);
    }

    public void setAxisLocation(int n) {
        if (n < 0 || n > 2) {
            this.m_graph.getErrorHandler().log("invalid value for AxisLocation", this.getClass().getName(), "setAxisLocation( int location )");
        } else {
            this.m_pfj.setAxisSide(this.m_identObj, n);
            this.m_graph.autoSetAxisTitleVerticalAlignment(this.m_identObj.getObjectID());
            this.setPropertyOverrideFlags(7);
        }
    }

    public boolean isAxisMinLabelVisible() {
        return !this.m_pfj.getExcludeMinLabel(this.m_labelIdentObj);
    }

    public void setAxisMinLabelVisible(boolean bl) {
        this.m_pfj.setExcludeMinLabel(this.m_labelIdentObj, !bl);
        this.setPropertyOverrideFlags(3);
    }

    public boolean isAxisMaxLabelVisible() {
        return !this.m_pfj.getExcludeMaxLabel(this.m_labelIdentObj);
    }

    public void setAxisMaxLabelVisible(boolean bl) {
        this.m_pfj.setExcludeMaxLabel(this.m_labelIdentObj, !bl);
        this.setPropertyOverrideFlags(2);
    }

    public Color getLineColor() {
        return this.m_pfj.getBorderColor(this.m_identObj2);
    }

    public void setLineColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setLineColor( Color newColor )");
            return;
        }
        this.m_pfj.setBorderColor(this.m_identObj2, color);
        this.setPropertyOverrideFlags(0);
    }

    public int getLineWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj2);
    }

    public void setLineWidth(int n) {
        if (n < 0) {
            this.m_graph.getErrorHandler().log("invalid line width", this.getClass().getName(), "setLineWidth (int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj2, n);
            this.setPropertyOverrideFlags(1);
        }
    }

    public double getMajorTickStep() {
        return this.m_pfj.getGridStep(this.m_identObj);
    }

    public void setMajorTickStep(double d) {
        if (d < 0.0) {
            this.m_graph.getErrorHandler().log("invalid major tick step", this.getClass().getName(), "setMajorTickStep (double value)");
        } else {
            this.m_pfj.setGridStep(this.m_identObj, d);
        }
    }

    public double getMinAutoMajorTickStep() {
        return this.m_pfj.getMinAutoGridStep(this.m_majorGridIdentObj);
    }

    public void setMinAutoMajorTickStep(double d) {
        if (d < 0.0) {
            this.m_graph.getErrorHandler().log("invalid min auto major tick step", this.getClass().getName(), "setMinAutoMajorTickStep (double value)");
        } else {
            this.m_pfj.setMinAutoGridStep(this.m_majorGridIdentObj, d);
        }
    }

    public boolean isMajorTickStepAutomatic() {
        return this.m_pfj.getGridStepAuto(this.m_identObj);
    }

    public void setMajorTickStepAutomatic(boolean bl) {
        this.m_pfj.setGridStepAuto(this.m_identObj, bl);
    }

    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    public void setViewFormat(ViewFormat viewFormat) {
        if (viewFormat == null) {
            this.m_graph.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        this.m_viewFormat = (ViewFormat)viewFormat.clone();
        this.m_viewFormat.setViewFormatCallback(this);
        this.m_viewFormat.setView(this.m_graph);
        this.m_pfj.needRecalc();
    }

    public void formatChanged(int n, String string, Object object, Object object2) {
        this.m_pfj.needRecalc();
    }

    public double getLogarithmicBase() {
        return this.m_pfj.getLogScaleBase(this.m_identObj);
    }

    public void setLogarithmicBase(double d) {
        if (d <= 0.0) {
            this.m_graph.getErrorHandler().log("invalid logarithmicBase", this.getClass().getName(), "setLogarithmicBase (double value)");
        } else {
            this.m_pfj.setLogScaleBase(this.m_identObj, d);
            this.setPropertyOverrideFlags(5);
        }
    }

    public boolean isScaledLogarithmic() {
        return this.m_pfj.getLogScale(this.m_identObj);
    }

    public void setScaledLogarithmic(boolean bl) {
        this.m_pfj.setLogScale(this.m_identObj, bl);
        this.setPropertyOverrideFlags(4);
    }

    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj2);
    }

    public void setVisible(boolean bl) {
        this.m_pfj.setDisplay(this.m_identObj2, bl);
        this.setPropertyOverrideFlags(8);
    }

    public DataEndPoints getDataEndPoints() {
        return BaseDataAxis.getDataEndPoints(this.m_graph, this.m_id);
    }

    public static DataEndPoints getDataEndPoints(UIGraph uIGraph, int n) {
        int n2 = 0;
        int n3 = 0;
        double d = 0.0;
        try {
            if (uIGraph.isDataRowShownAsASeries()) {
                n2 = uIGraph.getColumnCount();
                n3 = uIGraph.getRowCount();
            } else {
                n2 = uIGraph.getRowCount();
                n3 = uIGraph.getColumnCount();
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            DataEndPoints dataEndPoints = null;
            return dataEndPoints;
        }
        int n4 = 0;
        int n5 = uIGraph.getGraphType();
        int n6 = 1;
        int n7 = 0;
        boolean bl = false;
        switch (n5) {
            case 61: 
            case 62: 
            case 65: 
            case 66: {
                if (n == 46 || n == 51) {
                    n7 = 1;
                }
                n6 = 2;
                break;
            }
            case 63: 
            case 64: 
            case 89: 
            case 91: {
                if (n == 46 || n == 51) {
                    n7 = 1;
                }
                n6 = 3;
                break;
            }
            case 82: 
            case 84: {
                if (n == 51) {
                    n6 = 3;
                    n7 = 2;
                }
                if (n == 46) {
                    n4 = 3;
                }
                bl = true;
                n3 = 1;
                break;
            }
            case 90: 
            case 92: {
                if (n == 46 || n == 51) {
                    n7 = 1;
                }
                n6 = 4;
                break;
            }
            case 88: {
                if (n == 51) {
                    n6 = 4;
                    n7 = 3;
                }
                if (n == 46) {
                    n4 = 4;
                }
                bl = true;
                n3 = 1;
                break;
            }
            case 71: 
            case 83: {
                if (n == 51) {
                    n6 = 5;
                    n7 = 4;
                }
                if (n == 46) {
                    n4 = 5;
                }
                bl = true;
                n3 = 1;
                break;
            }
            case 70: 
            case 72: {
                n3 = 1;
            }
        }
        if (n6 > n2 || n7 > n2 - 1) {
            return null;
        }
        n2 -= n2 % n6;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl2 = BaseDataAxis.isDual(n5);
        boolean bl3 = true;
        boolean bl4 = true;
        Object object = null;
        int n8 = 0;
        while (n8 < n3) {
            block45: {
                try {
                    if (!(!uIGraph.getUISeries().isAssignedToY2(n8 % uIGraph.getSeriesObjectCount()) && n == 46 && bl2 || uIGraph.getUISeries().isAssignedToY2(n8 % uIGraph.getSeriesObjectCount()) && n == 51 && bl2 || !bl2) && (!bl2 || n != 41)) break block45;
                    int n9 = 0;
                    int n10 = n7;
                    while (n10 < n2) {
                        if (n4 > 0 && ++n9 == n4) {
                            ++n10;
                            n9 = 1;
                        }
                        if (n10 <= n2 - 1) {
                            object = uIGraph.isDataRowShownAsASeries() ? ((DataFilterImpl)uIGraph.getDataFilter()).getValue(n8, n10) : ((DataFilterImpl)uIGraph.getDataFilter()).getValue(n10, n8);
                            if (object != null) {
                                bl4 = false;
                                if (object instanceof Number) {
                                    if (object instanceof Double) {
                                        d = (Double)object;
                                    } else if (object instanceof Integer) {
                                        d = ((Integer)object).doubleValue();
                                    } else if (object instanceof Long) {
                                        d = ((Long)object).doubleValue();
                                    } else if (object instanceof Float) {
                                        d = ((Float)object).doubleValue();
                                    } else if (object instanceof Short) {
                                        d = ((Short)object).doubleValue();
                                    }
                                    if (bl3) {
                                        d2 = d;
                                        d3 = d;
                                        bl3 = false;
                                    }
                                    if (d > d2) {
                                        d2 = d;
                                    } else if (d < d3) {
                                        d3 = d;
                                    }
                                }
                            }
                            n10 += n6;
                            continue;
                        }
                        break;
                    }
                }
                catch (SeriesOutOfRangeException seriesOutOfRangeException) {
                    DataEndPoints dataEndPoints = null;
                    return dataEndPoints;
                }
            }
            ++n8;
        }
        if (bl4) {
            return null;
        }
        return new DataEndPoints(d2, d3);
    }

    protected String convertAxisLocationToString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "AL_LEFT";
                break;
            }
            case 1: {
                string = "AL_RIGHT";
                break;
            }
            case 2: {
                string = "AL_BOTH";
            }
        }
        return string;
    }

    protected int convertAxisLocationToInt(String string) {
        int n = 0;
        if (string.equals("AL_RIGHT")) {
            n = 1;
        } else if (string.equals("AL_BOTH")) {
            n = 2;
        }
        return n;
    }

    private static boolean isDual(int n) {
        switch (n) {
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 62: 
            case 64: 
            case 66: 
            case 69: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 91: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    protected int getStylePropertyCount() {
        return 9;
    }

    protected boolean getNonstyleXML(boolean bl, ObjectNode objectNode) {
        ObjectNode objectNode2;
        boolean bl2 = super.getNonstyleXML(bl, objectNode);
        if (bl || this.axisMinAutoScaled != this.isAxisMinAutoScaled()) {
            objectNode.addProperty("axisMinAutoScaled", this.isAxisMinAutoScaled());
            bl2 = true;
        }
        if (bl || !this.isAxisMinAutoScaled()) {
            objectNode.addProperty("axisMinValue", this.getAxisMinValue());
            bl2 = true;
        }
        if (bl || this.axisMaxAutoScaled != this.isAxisMaxAutoScaled()) {
            objectNode.addProperty("axisMaxAutoScaled", this.isAxisMaxAutoScaled());
            bl2 = true;
        }
        if (bl || !this.isAxisMaxAutoScaled()) {
            objectNode.addProperty("axisMaxValue", this.getAxisMaxValue());
            bl2 = true;
        }
        if (bl || this.majorTickStepAutomatic != this.isMajorTickStepAutomatic()) {
            objectNode.addProperty("majorTickStepAutomatic", this.isMajorTickStepAutomatic());
            bl2 = true;
        }
        bl2 |= this.getMajorTickStepXML(bl, objectNode);
        if (bl || this.minAutoMajorTickStep != this.getMinAutoMajorTickStep()) {
            objectNode.addProperty(a_minAutoMajorTickStep, this.getMinAutoMajorTickStep());
            bl2 = true;
        }
        if (bl || this.axisAutoScaledFromZero != this.isAxisAutoScaledFromZero()) {
            objectNode.addProperty("axisAutoScaledFromZero", this.isAxisAutoScaledFromZero());
            bl2 = true;
        }
        if ((objectNode2 = this.getViewFormat().getXML(bl)) != null) {
            objectNode.addProperty(objectNode2);
            bl2 = true;
        }
        return bl2;
    }

    protected boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = super.getStyleXML(bl, objectNode);
        if (bl || this.isUserOverrideFlag(1)) {
            objectNode.addProperty("lineWidth", this.getLineWidth());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(0)) {
            objectNode.addProperty("lineColor", BaseGraphComponent.toHexString(this.getLineColor().getRGB()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(2)) {
            objectNode.addProperty(a_axisMaxLabelVisible, this.isAxisMaxLabelVisible());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(3)) {
            objectNode.addProperty(a_axisMinLabelVisible, this.isAxisMinLabelVisible());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(4)) {
            objectNode.addProperty("scaledLogarithmic", this.isScaledLogarithmic());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(5)) {
            objectNode.addProperty("logarithmicBase", this.getLogarithmicBase());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(6)) {
            objectNode.addProperty(a_ascending, this.isAscending());
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(7)) {
            objectNode.addProperty(a_axisLocation, this.convertAxisLocationToString(this.getAxisLocation()));
            bl2 = true;
        }
        if (bl || this.isUserOverrideFlag(8)) {
            objectNode.addProperty("visible", this.isVisible());
            bl2 = true;
        }
        return bl2;
    }

    protected void setNonstyleXML(ObjectNode objectNode, String string, int n) {
        PropertyNode propertyNode;
        super.setNonstyleXML(objectNode);
        ObjectNode objectNode2 = objectNode.getPropertyValueAsObjectNode("ViewFormat", true);
        if (objectNode2 != null) {
            this.getViewFormat().setXML(objectNode2, string, n);
        }
        if ((propertyNode = objectNode.getProperty("axisMinAutoScaled")) != null) {
            this.setAxisMinAutoScaled(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("axisMinValue")) != null) {
            this.setAxisMinValue(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("axisMaxAutoScaled")) != null) {
            this.setAxisMaxAutoScaled(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("axisMaxValue")) != null) {
            this.setAxisMaxValue(propertyNode.getValueAsDouble());
        }
        this.setMajorTickStepXML(objectNode);
        propertyNode = objectNode.getProperty("majorTickStepAutomatic");
        if (propertyNode != null) {
            this.setMajorTickStepAutomatic(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_minAutoMajorTickStep)) != null) {
            this.setMinAutoMajorTickStep(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty("axisAutoScaledFromZero")) != null) {
            this.setAxisAutoScaledFromZero(propertyNode.getValueAsBoolean());
        }
    }

    protected void setStyleXML(ObjectNode objectNode) {
        super.setStyleXML(objectNode);
        PropertyNode propertyNode = objectNode.getProperty("lineWidth");
        if (propertyNode != null) {
            this.setLineWidth(propertyNode.getValueAsInteger());
        }
        if ((propertyNode = objectNode.getProperty("lineColor")) != null) {
            this.setLineColor(new Color(BaseGraphComponent.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty(a_axisMaxLabelVisible)) != null) {
            this.setAxisMaxLabelVisible(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_axisMinLabelVisible)) != null) {
            this.setAxisMinLabelVisible(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("scaledLogarithmic")) != null) {
            this.setScaledLogarithmic(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty("logarithmicBase")) != null) {
            this.setLogarithmicBase(propertyNode.getValueAsDouble());
        }
        if ((propertyNode = objectNode.getProperty(a_ascending)) != null) {
            this.setAscending(propertyNode.getValueAsBoolean());
        }
        if ((propertyNode = objectNode.getProperty(a_axisLocation)) != null) {
            this.setAxisLocation(this.convertAxisLocationToInt(propertyNode.getValueAsString()));
        }
        if ((propertyNode = objectNode.getProperty("visible")) != null) {
            this.setVisible(propertyNode.getValueAsBoolean());
        }
    }

    protected void resetStyle() {
        this.setLineColor(this.lineColor);
        this.setLineWidth(this.lineWidth);
        this.setAscending(this.acsending);
        this.setAxisLocation(this.axisLocation);
        this.setAxisMinLabelVisible(this.axisMinLabelVisible);
        this.setAxisMaxLabelVisible(this.axisMaxLabelVisible);
        this.setLogarithmicBase(this.logarithmicBase);
        this.setScaledLogarithmic(this.scaledLogarithmic);
        this.setVisible(this.visible);
        super.resetStyle();
    }

    protected void setMajorTickStepXML(ObjectNode objectNode) {
        PropertyNode propertyNode = objectNode.getProperty("majorTickStep");
        if (propertyNode != null) {
            this.setMajorTickStep(propertyNode.getValueAsDouble());
        }
    }

    protected boolean getMajorTickStepXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || !this.isMajorTickStepAutomatic()) {
            objectNode.addProperty("majorTickStep", this.getMajorTickStep());
            bl2 = true;
        }
        return bl2;
    }

    public abstract double getAutoMajorTickStep();
}

