/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.dataView.UITransparentFillColor;
import oracle.dss.graph.BaseGraphFrame;
import oracle.dss.graph.Graph;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class Base3DPanel
extends BaseGraphFrame
implements UIFillColor,
UITransparentFillColor {
    protected static final int ATTR_SHARE_PANEL_PROPERTIES = 4;
    protected static final int ATTR_STYLE_MAXID = 5;

    public Base3DPanel(Graph graph) {
        super(graph);
    }

    public void setFillColor(Color color) {
        if (color == null) {
            this.m_graph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor( Color newColor)");
            return;
        }
        if (this.m_graph.m_settingXML) {
            if (this.m_graph.isGroup3DPanels()) {
                this.m_pfj.setFillColor(this.m_pfj.getCubeFloor(), color);
                this.m_pfj.setFillColor(this.m_pfj.getCubeLeftWall(), color);
                this.m_pfj.setFillColor(this.m_pfj.getCubeRightWall(), color);
            } else {
                this.m_pfj.setFillColor(this.m_identObj, color);
            }
        } else {
            super.setFillColor(color);
        }
    }

    public void setFillTransparent(boolean bl) {
        if (this.m_graph.m_settingXML) {
            if (this.m_graph.isGroup3DPanels()) {
                this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeFloor(), bl);
                this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeLeftWall(), bl);
                this.m_pfj.setTransparentFillColor(this.m_pfj.getCubeRightWall(), bl);
            } else {
                this.m_pfj.setTransparentFillColor(this.m_identObj, bl);
            }
        } else {
            super.setFillTransparent(bl);
        }
    }

    public boolean isSharePanelProperties() {
        return this.m_graph.isGroup3DPanels();
    }

    public void setSharePanelProperties(boolean bl) {
        this.m_graph.get3DFloor().setGroup3DPanels(bl);
    }

    protected ObjectNode getXML(boolean bl, boolean bl2) {
        boolean bl3 = false;
        if ((this.getComponentName().equals("ThreeDLeftWall") || this.getComponentName().equals("ThreeDRightWall")) && this.m_graph.isGroup3DPanels()) {
            return null;
        }
        ObjectNode objectNode = super.getXML(bl, bl2);
        if (objectNode != null) {
            bl3 = true;
        } else {
            objectNode = new ObjectNode(this.getComponentName());
        }
        if (this.getComponentName().equals("ThreeDFloor") && (bl || this.isUserOverrideFlag(4))) {
            objectNode.addProperty("sharePanelProperties", this.isSharePanelProperties());
            bl3 = true;
        }
        return bl3 ? objectNode : null;
    }

    protected void setXML(ObjectNode objectNode, boolean bl) {
        PropertyNode propertyNode = objectNode.getProperty("sharePanelProperties");
        if (propertyNode != null) {
            this.setSharePanelProperties(propertyNode.getValueAsBoolean());
        }
        super.setXML(objectNode, bl);
    }
}

