/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PaperSize;
import oracle.dss.util.ErrorHandler;

public class PageSetupGeneralPanel
extends JPanel
implements ActionListener {
    protected UIViewPrinter[] m_viewPrinter;
    protected PageFormat m_pageFormat;
    protected JPanel m_orientationPanel;
    protected JLabel m_orientationLabel;
    protected JLabel m_titleLabel;
    protected JLabel m_textLabel;
    protected JPanel m_paperSizePanel;
    protected JPanel m_mainPanel;
    protected JRadioButton m_potraitRadioButton;
    protected JLabel m_potraitLabel;
    protected JRadioButton m_landscapeRadioButton;
    protected JLabel m_landscapeLabel;
    protected JLabel m_pageSizeLabel;
    private boolean m_inD4O;
    private boolean m_D4OWksheetTitleVisible;
    private boolean m_D4OWksheetTextVisible;
    protected JLabel m_pageItemLabel;
    protected String m_papeSize = "";
    protected JPanel m_titlePanel;
    protected JPanel m_textPanel;
    protected JPanel m_pageItemsPanel;
    protected JRadioButton m_titleEveryPageButton;
    protected JRadioButton m_titleFirstPageButton;
    protected JRadioButton m_textEveryPageButton;
    protected JRadioButton m_textLastPageButton;
    protected JRadioButton m_pageCurrentButton;
    protected JRadioButton m_pageAllButton;
    protected int m_mask = -1;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh;
    protected String m_strHelpContextID;
    protected boolean m_isWorkSheet;
    private boolean isVersionSupportOrientation;
    private ResourceBundle rBundle;
    private boolean m_bSuperCalled;
    public static final int SHOW_ORITATION = 1;
    public static final int SHOW_PAPER_SIZE = 8;
    private JComboBox m_paperSizeComboBox;
    private CellRenderer m_paperSizeCellRenderer;
    private PaperSize m_currentPaperSize;
    private NumberFormat m_numberFormat;
    private static final Object[] PaperSizes = new Object[]{PaperSize.LETTER, PaperSize.LEGAL, PaperSize.TABLOID, PaperSize.EXECUTIVE, PaperSize.BROADSHEET, PaperSize.A1, PaperSize.A2, PaperSize.A3, PaperSize.A4, PaperSize.A5, PaperSize.A6, PaperSize.B3, PaperSize.B4, PaperSize.B5, PaperSize.B6, PaperSize.C1, PaperSize.C2, PaperSize.C3, PaperSize.C4, PaperSize.C5, PaperSize.C6};

    public PageSetupGeneralPanel(ViewPrinter[] viewPrinterArray) {
        this((UIViewPrinter[])viewPrinterArray);
    }

    public PageSetupGeneralPanel(UIViewPrinter[] uIViewPrinterArray, boolean bl, boolean bl2, boolean bl3) {
        this.m_inD4O = bl;
        this.m_D4OWksheetTitleVisible = bl2;
        this.m_D4OWksheetTextVisible = bl3;
        this.m_bSuperCalled = true;
        if (uIViewPrinterArray == null) {
            return;
        }
        this.m_numberFormat = NumberFormat.getInstance(uIViewPrinterArray[0].getLocale());
        this.m_pageFormat = uIViewPrinterArray[0].getPageFormat() != null ? (PageFormat)uIViewPrinterArray[0].getPageFormat().clone() : new PageFormat();
        this.m_viewPrinter = uIViewPrinterArray;
        if (this.m_viewPrinter[0].getViewPrinterType() == 4 || this.m_viewPrinter[0].getViewPrinterType() == 3 || this.m_viewPrinter[0].getViewPrinterType() == 5 || this.m_viewPrinter[0].getViewPrinterType() == 6 || this.m_viewPrinter[0].getViewPrinterType() == 7) {
            this.m_isWorkSheet = true;
        }
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    public PageSetupGeneralPanel(UIViewPrinter[] uIViewPrinterArray) {
        this.m_bSuperCalled = true;
        if (uIViewPrinterArray == null) {
            return;
        }
        this.m_numberFormat = NumberFormat.getInstance(uIViewPrinterArray[0].getLocale());
        this.m_pageFormat = uIViewPrinterArray[0].getPageFormat() != null ? (PageFormat)uIViewPrinterArray[0].getPageFormat().clone() : new PageFormat();
        this.m_viewPrinter = uIViewPrinterArray;
        if (this.m_viewPrinter[0].getViewPrinterType() == 4 || this.m_viewPrinter[0].getViewPrinterType() == 3 || this.m_viewPrinter[0].getViewPrinterType() == 5 || this.m_viewPrinter[0].getViewPrinterType() == 6 || this.m_viewPrinter[0].getViewPrinterType() == 7) {
            this.m_isWorkSheet = true;
        }
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_viewPrinter = null;
        this.m_pageFormat = null;
        this.m_numberFormat = null;
        this.m_currentPaperSize = null;
        this.m_paperSizeCellRenderer = null;
        this.m_paperSizeComboBox.removeActionListener(this);
        this.m_potraitRadioButton.removeActionListener(this);
        this.m_landscapeRadioButton.removeActionListener(this);
        this.m_orientationPanel.removeAll();
        this.m_orientationPanel = null;
        this.m_orientationLabel = null;
        this.m_titleLabel = null;
        this.m_textLabel = null;
        this.m_paperSizePanel.removeAll();
        this.m_paperSizePanel = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        this.m_potraitRadioButton = null;
        this.m_potraitLabel = null;
        this.m_landscapeRadioButton = null;
        this.m_landscapeLabel = null;
        this.m_pageSizeLabel = null;
        this.m_pageItemLabel = null;
        this.m_papeSize = null;
        if (this.m_isWorkSheet) {
            this.m_titlePanel.removeAll();
            this.m_titlePanel = null;
            this.m_textPanel.removeAll();
            this.m_textPanel = null;
            if (!this.m_inD4O) {
                this.m_pageItemsPanel.removeAll();
            }
            this.m_pageItemsPanel = null;
        }
        this.m_titleEveryPageButton = null;
        this.m_titleFirstPageButton = null;
        this.m_textEveryPageButton = null;
        this.m_textLastPageButton = null;
        this.m_pageCurrentButton = null;
        this.m_pageAllButton = null;
        this.m_eh = null;
        this.m_strHelpContextID = null;
        this.rBundle = null;
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        String string = this.rBundle.getString("Paper Size");
        this.m_pageSizeLabel = new JLabel(StringUtils.stripMnemonic((String)string));
        this.m_pageSizeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_pageSizeLabel.setAlignmentX(0.0f);
        this.m_paperSizeComboBox = new JComboBox();
        this.setPaperSizeList();
        this.m_paperSizeComboBox.addActionListener(this);
        this.m_paperSizeCellRenderer = new CellRenderer();
        this.m_paperSizeComboBox.setRenderer(this.m_paperSizeCellRenderer);
        this.m_paperSizeComboBox.setMinimumSize(this.m_paperSizeComboBox.getPreferredSize());
        this.m_paperSizeComboBox.setMaximumSize(this.m_paperSizeComboBox.getPreferredSize());
        this.m_paperSizeComboBox.setToolTipText(this.rBundle.getString("Paper Size"));
        this.m_paperSizeComboBox.setAlignmentX(0.0f);
        this.m_pageSizeLabel.setLabelFor(this.m_paperSizeComboBox);
        int n = 0;
        if ((this.m_mask & 8) != 0) {
            n = this.getToolkit().getFontMetrics(this.m_pageSizeLabel.getFont()).stringWidth(this.m_pageSizeLabel.getText());
        }
        string = this.rBundle.getString("Orientation");
        this.m_orientationLabel = new JLabel(string);
        this.m_orientationLabel.setAlignmentX(0.0f);
        n = Math.max(n, this.getToolkit().getFontMetrics(this.m_orientationLabel.getFont()).stringWidth(this.m_orientationLabel.getText()));
        if (this.m_isWorkSheet) {
            string = this.rBundle.getString("Title:");
            this.m_titleLabel = new JLabel(string);
            this.m_titleLabel.setAlignmentX(0.0f);
            n = Math.max(n, this.getToolkit().getFontMetrics(this.m_titleLabel.getFont()).stringWidth(this.m_titleLabel.getText()));
            string = this.rBundle.getString("Text:");
            this.m_textLabel = new JLabel(string);
            this.m_textLabel.setAlignmentX(0.0f);
            n = Math.max(n, this.getToolkit().getFontMetrics(this.m_textLabel.getFont()).stringWidth(this.m_textLabel.getText()));
        }
        if (!this.m_inD4O) {
            string = this.rBundle.getString("Page Items:");
            this.m_pageItemLabel = new JLabel(string);
            this.m_pageItemLabel.setAlignmentX(0.0f);
            n = Math.max(n, this.getToolkit().getFontMetrics(this.m_pageItemLabel.getFont()).stringWidth(this.m_pageItemLabel.getText()));
        }
        this.m_paperSizePanel = new JPanel();
        this.m_paperSizePanel.setLayout(new BoxLayout(this.m_paperSizePanel, 0));
        this.m_paperSizePanel.setAlignmentX(0.0f);
        this.m_pageSizeLabel.setPreferredSize(new Dimension(n + 5, this.m_pageSizeLabel.getPreferredSize().height));
        this.m_pageSizeLabel.setMinimumSize(this.m_pageSizeLabel.getPreferredSize());
        this.m_pageSizeLabel.setMaximumSize(this.m_pageSizeLabel.getPreferredSize());
        this.m_paperSizePanel.add(this.m_pageSizeLabel);
        this.m_paperSizePanel.add(this.m_paperSizeComboBox);
        this.m_paperSizePanel.setMinimumSize(this.m_paperSizePanel.getPreferredSize());
        this.m_paperSizePanel.setMaximumSize(this.m_paperSizePanel.getPreferredSize());
        if ((this.m_mask & 8) != 0) {
            this.m_mainPanel.add(this.m_paperSizePanel);
            this.m_mainPanel.add(Box.createVerticalStrut(5));
        }
        this.m_orientationPanel = new JPanel();
        this.m_orientationPanel.setLayout(new BoxLayout(this.m_orientationPanel, 1));
        this.m_orientationPanel.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(this.m_orientationLabel);
        jPanel.setPreferredSize(new Dimension(n + 5, jPanel.getPreferredSize().height));
        jPanel.setMinimumSize(jPanel.getPreferredSize());
        jPanel.setMaximumSize(jPanel.getPreferredSize());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        string = this.rBundle.getString("Portrait");
        this.m_potraitRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
        this.m_potraitRadioButton.addActionListener(this);
        this.m_potraitLabel = new JLabel();
        this.m_potraitRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_potraitRadioButton.setAlignmentX(0.0f);
        this.m_potraitLabel.setAlignmentX(0.0f);
        this.m_potraitLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.PageSetupGeneralPanel"), (String)"images/portrait.gif")));
        this.m_potraitRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("PortraitADA"));
        jPanel2.add(jPanel);
        jPanel2.add(this.m_potraitRadioButton);
        jPanel2.add(this.m_potraitLabel);
        jPanel2.setMinimumSize(jPanel2.getPreferredSize());
        jPanel2.setMaximumSize(jPanel2.getPreferredSize());
        JPanel jPanel3 = new JPanel();
        jPanel3.setAlignmentX(0.0f);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        string = this.rBundle.getString("Landscape");
        this.m_landscapeRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
        this.m_landscapeRadioButton.addActionListener(this);
        this.m_landscapeLabel = new JLabel();
        this.m_landscapeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        this.m_landscapeLabel.setAlignmentX(0.0f);
        this.m_landscapeLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.PageSetupGeneralPanel"), (String)"images/landscape.gif")));
        this.m_landscapeRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("LandscapeADA"));
        jPanel3.add(Box.createHorizontalStrut(n + 5));
        jPanel3.add(this.m_landscapeRadioButton);
        jPanel3.add(this.m_landscapeLabel);
        jPanel3.setMinimumSize(jPanel3.getPreferredSize());
        jPanel3.setMaximumSize(jPanel3.getPreferredSize());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_potraitRadioButton);
        buttonGroup.add(this.m_landscapeRadioButton);
        this.m_orientationPanel.add(jPanel2);
        this.m_orientationPanel.add(jPanel3);
        this.m_orientationPanel.add(Box.createVerticalStrut(5));
        if ((this.m_mask & 1) != 0) {
            this.m_mainPanel.add(this.m_orientationPanel);
        }
        if (this.m_isWorkSheet) {
            this.m_titlePanel = new JPanel();
            this.m_titlePanel.setLayout(new BoxLayout(this.m_titlePanel, 1));
            this.m_titlePanel.setAlignmentX(0.0f);
            JPanel jPanel4 = new JPanel();
            jPanel4.setLayout(new BoxLayout(jPanel4, 1));
            jPanel4.setAlignmentX(0.0f);
            jPanel4.add(this.m_titleLabel);
            jPanel4.setPreferredSize(new Dimension(n + 5, jPanel4.getPreferredSize().height));
            jPanel4.setMinimumSize(jPanel4.getPreferredSize());
            jPanel4.setMaximumSize(jPanel4.getPreferredSize());
            JPanel jPanel5 = new JPanel();
            jPanel5.setAlignmentX(0.0f);
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            string = this.rBundle.getString("TitleFirstPage");
            this.m_titleFirstPageButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_titleFirstPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_titleFirstPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TitleFirstPage"));
            jPanel5.add(jPanel4);
            jPanel5.add(this.m_titleFirstPageButton);
            jPanel5.setMinimumSize(jPanel5.getPreferredSize());
            jPanel5.setMaximumSize(jPanel5.getPreferredSize());
            this.m_titlePanel.add(jPanel5);
            jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setAlignmentX(0.0f);
            string = this.rBundle.getString("TitleEveryPage");
            this.m_titleEveryPageButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_titleEveryPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_titleEveryPageButton.setAlignmentX(0.0f);
            this.m_titleEveryPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TitleEveryPage"));
            jPanel5.add(Box.createHorizontalStrut(n + 5));
            jPanel5.add(this.m_titleEveryPageButton);
            jPanel5.setMinimumSize(jPanel5.getPreferredSize());
            jPanel5.setMaximumSize(jPanel5.getPreferredSize());
            this.m_titlePanel.add(jPanel5);
            this.m_titlePanel.add(Box.createVerticalStrut(5));
            ButtonGroup buttonGroup2 = new ButtonGroup();
            buttonGroup2.add(this.m_titleEveryPageButton);
            buttonGroup2.add(this.m_titleFirstPageButton);
            this.m_mainPanel.add(this.m_titlePanel);
            this.m_textPanel = new JPanel();
            this.m_textPanel.setLayout(new BoxLayout(this.m_textPanel, 1));
            this.m_textPanel.setAlignmentX(0.0f);
            JPanel jPanel6 = new JPanel();
            jPanel6.setLayout(new BoxLayout(jPanel6, 1));
            jPanel6.setAlignmentX(0.0f);
            jPanel6.add(this.m_textLabel);
            jPanel6.setPreferredSize(new Dimension(n + 5, jPanel6.getPreferredSize().height));
            jPanel6.setMinimumSize(jPanel6.getPreferredSize());
            jPanel6.setMaximumSize(jPanel6.getPreferredSize());
            jPanel5 = new JPanel();
            jPanel5.setAlignmentX(0.0f);
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            string = this.rBundle.getString("TextLastPage");
            this.m_textLastPageButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_textLastPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_textLastPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TextLastPage"));
            jPanel5.add(jPanel6);
            jPanel5.add(this.m_textLastPageButton);
            jPanel5.setMinimumSize(jPanel5.getPreferredSize());
            jPanel5.setMaximumSize(jPanel5.getPreferredSize());
            this.m_textPanel.add(jPanel5);
            jPanel5 = new JPanel();
            jPanel5.setLayout(new BoxLayout(jPanel5, 0));
            jPanel5.setAlignmentX(0.0f);
            string = this.rBundle.getString("TextEveryPage");
            this.m_textEveryPageButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
            this.m_textEveryPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
            this.m_textEveryPageButton.setAlignmentX(0.0f);
            this.m_textEveryPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TextEveryPage"));
            jPanel5.add(Box.createHorizontalStrut(n + 5));
            jPanel5.add(this.m_textEveryPageButton);
            jPanel5.setMinimumSize(jPanel5.getPreferredSize());
            jPanel5.setMaximumSize(jPanel5.getPreferredSize());
            this.m_textPanel.add(jPanel5);
            ButtonGroup buttonGroup3 = new ButtonGroup();
            buttonGroup3.add(this.m_textEveryPageButton);
            buttonGroup3.add(this.m_textLastPageButton);
            this.m_textPanel.add(Box.createVerticalStrut(5));
            this.m_mainPanel.add(this.m_textPanel);
            if (!this.m_inD4O) {
                this.m_pageItemsPanel = new JPanel();
                this.m_pageItemsPanel.setLayout(new BoxLayout(this.m_pageItemsPanel, 1));
                this.m_pageItemsPanel.setAlignmentX(0.0f);
                JPanel jPanel7 = new JPanel();
                jPanel7.setLayout(new BoxLayout(jPanel7, 1));
                jPanel7.setAlignmentX(0.0f);
                jPanel7.add(this.m_pageItemLabel);
                jPanel7.setPreferredSize(new Dimension(n + 5, jPanel7.getPreferredSize().height));
                jPanel7.setMinimumSize(jPanel7.getPreferredSize());
                jPanel7.setMaximumSize(jPanel7.getPreferredSize());
                jPanel5 = new JPanel();
                jPanel5.setLayout(new BoxLayout(jPanel5, 0));
                jPanel5.setAlignmentX(0.0f);
                string = this.rBundle.getString("PageItemsCurrent");
                this.m_pageCurrentButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
                this.m_pageCurrentButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
                this.m_pageCurrentButton.setAlignmentX(0.0f);
                this.m_pageCurrentButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("PageItemsCurrent"));
                jPanel5.add(jPanel7);
                jPanel5.add(this.m_pageCurrentButton);
                jPanel5.setMinimumSize(jPanel5.getPreferredSize());
                jPanel5.setMaximumSize(jPanel5.getPreferredSize());
                this.m_pageItemsPanel.add(jPanel5);
                jPanel5 = new JPanel();
                jPanel5.setAlignmentX(0.0f);
                jPanel5.setLayout(new BoxLayout(jPanel5, 0));
                string = this.rBundle.getString("PageItemsAll");
                this.m_pageAllButton = new JRadioButton(StringUtils.stripMnemonic((String)string));
                this.m_pageAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
                this.m_pageAllButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("PageItemsAll"));
                jPanel5.add(Box.createHorizontalStrut(n + 5));
                jPanel5.add(this.m_pageAllButton);
                jPanel5.setMinimumSize(jPanel5.getPreferredSize());
                jPanel5.setMaximumSize(jPanel5.getPreferredSize());
                ButtonGroup buttonGroup4 = new ButtonGroup();
                buttonGroup4.add(this.m_pageCurrentButton);
                buttonGroup4.add(this.m_pageAllButton);
                this.m_pageItemsPanel.add(jPanel5);
                this.m_pageItemsPanel.add(Box.createVerticalStrut(5));
                this.m_mainPanel.add(this.m_pageItemsPanel);
            }
        }
        if (this.m_inD4O) {
            if (this.m_D4OWksheetTitleVisible) {
                this.m_titleEveryPageButton.setEnabled(true);
                this.m_titleFirstPageButton.setEnabled(true);
            } else {
                this.m_titleEveryPageButton.setEnabled(false);
                this.m_titleFirstPageButton.setEnabled(false);
            }
            if (this.m_D4OWksheetTextVisible) {
                this.m_textEveryPageButton.setEnabled(true);
                this.m_textLastPageButton.setEnabled(true);
            } else {
                this.m_textEveryPageButton.setEnabled(false);
                this.m_textLastPageButton.setEnabled(false);
            }
        }
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
        this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
        this._initiate();
    }

    private void _initiate() {
        if (this.m_pageFormat.getOrientation() == 1) {
            this.m_potraitRadioButton.setSelected(true);
        } else {
            this.m_landscapeRadioButton.setSelected(true);
        }
        this.setSelectedPaperSize();
        if (this.m_isWorkSheet && this.m_viewPrinter != null) {
            this.m_titleEveryPageButton.setSelected(this.m_viewPrinter[0].isRepeatComponent(64));
            this.m_titleFirstPageButton.setSelected(!this.m_titleEveryPageButton.isSelected());
            this.m_textEveryPageButton.setSelected(this.m_viewPrinter[0].isRepeatComponent(128));
            this.m_textLastPageButton.setSelected(!this.m_textEveryPageButton.isSelected());
            if (!this.m_inD4O) {
                if (this.m_viewPrinter[0].getRangeType() == 1) {
                    this.m_pageAllButton.setSelected(true);
                } else {
                    this.m_pageCurrentButton.setSelected(true);
                }
            }
        }
    }

    public void setUIComponentMask(int n) {
        this.m_mask = n;
        this._init();
    }

    public int getUIComponentMask() {
        return this.m_mask;
    }

    public void apply() {
        int n = 0;
        while (n < this.m_viewPrinter.length) {
            this.m_viewPrinter[n].setPageFormat(this.m_pageFormat);
            if (this.m_isWorkSheet) {
                this.m_viewPrinter[n].setRepeatComponent(64, this.m_titleEveryPageButton.isSelected());
                this.m_viewPrinter[n].setRepeatComponent(128, this.m_textEveryPageButton.isSelected());
                if (!this.m_inD4O) {
                    if (this.m_pageAllButton.isSelected()) {
                        this.m_viewPrinter[n].setRangeType(1);
                    } else {
                        this.m_viewPrinter[n].setRangeType(0);
                    }
                }
            }
            ++n;
        }
    }

    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setViewPrinter(ViewPrinter[] viewPrinterArray) {
        if (viewPrinterArray != null) {
            this.m_viewPrinter = viewPrinterArray;
        }
        this._init();
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this._init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.m_paperSizeComboBox) {
            if (this.m_paperSizeComboBox.getSelectedItem() != null) {
                this.m_currentPaperSize = (PaperSize)this.m_paperSizeComboBox.getSelectedItem();
                this.setPaperSize();
            }
        } else if (actionEvent.getSource() == this.m_landscapeRadioButton) {
            if (this.m_landscapeRadioButton.isSelected()) {
                this.m_paperSizeComboBox.removeAllItems();
                this.setPaperSizeList();
                this.m_pageFormat.setOrientation(0);
                this.m_paperSizeComboBox.setSelectedItem(this.m_currentPaperSize);
            }
        } else if (actionEvent.getSource() == this.m_potraitRadioButton && this.m_potraitRadioButton.isSelected()) {
            this.m_paperSizeComboBox.removeAllItems();
            this.setPaperSizeList();
            this.m_pageFormat.setOrientation(1);
            this.m_paperSizeComboBox.setSelectedItem(this.m_currentPaperSize);
        }
    }

    private void setPaperSizeList() {
        this.m_paperSizeComboBox.setModel(new DefaultComboBoxModel<Object>(PaperSizes));
    }

    private void setPaperSize() {
        float f = this.m_viewPrinter[0].getTopMargin();
        float f2 = this.m_viewPrinter[0].getLeftMargin();
        float f3 = this.m_viewPrinter[0].getBottomMargin();
        float f4 = this.m_viewPrinter[0].getRightMargin();
        if (this.m_paperSizeComboBox.getSelectedItem() != null) {
            PaperSize paperSize = (PaperSize)this.m_paperSizeComboBox.getSelectedItem();
            float f5 = paperSize.getWidth(2);
            float f6 = paperSize.getHeight(2);
            Paper paper = new Paper();
            paper.setSize(f5, f6);
            paper.setImageableArea(f, f2, f5 - (f2 + f4), f6 - (f + f3));
            this.m_pageFormat.setPaper(paper);
        }
    }

    private void setSelectedPaperSize() {
        float f = (float)this.m_pageFormat.getPaper().getWidth();
        float f2 = (float)this.m_pageFormat.getPaper().getHeight();
        PaperSize paperSize = PaperSize.parse(f, f2);
        this.m_paperSizeComboBox.setSelectedItem(paperSize);
    }

    private String getSizeString(int n, String string) {
        String string2 = string;
        PaperSize paperSize = PaperSize.parse(n);
        float f = (float)Math.round(paperSize.getWidth(1) * 10.0f) / 10.0f;
        float f2 = (float)Math.round(paperSize.getHeight(1) * 10.0f) / 10.0f;
        String string3 = this.m_numberFormat.format(f);
        String string4 = this.m_numberFormat.format(f2);
        string2 = this.m_pageFormat.getOrientation() == 0 ? String.valueOf(string2) + " (" + string4 + " x " + string3 + ")" : String.valueOf(string2) + " (" + string3 + " x " + string4 + ")";
        return string2;
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            String string2 = null;
            if (object != null) {
                if (object.equals(PaperSize.LETTER)) {
                    string = "Letter";
                    string2 = PageSetupGeneralPanel.this.getSizeString(10, string);
                } else if (object.equals(PaperSize.LEGAL)) {
                    string = "Legal";
                    string2 = PageSetupGeneralPanel.this.getSizeString(11, string);
                } else if (object.equals(PaperSize.TABLOID)) {
                    string = "Tabloid";
                    string2 = PageSetupGeneralPanel.this.getSizeString(12, string);
                } else if (object.equals(PaperSize.EXECUTIVE)) {
                    string = "Executive";
                    string2 = PageSetupGeneralPanel.this.getSizeString(13, string);
                } else if (object.equals(PaperSize.BROADSHEET)) {
                    string = "Broadsheet";
                    string2 = PageSetupGeneralPanel.this.getSizeString(14, string);
                } else if (object.equals(PaperSize.A1)) {
                    string = "A1";
                    string2 = PageSetupGeneralPanel.this.getSizeString(15, string);
                } else if (object.equals(PaperSize.A2)) {
                    string = "A2";
                    string2 = PageSetupGeneralPanel.this.getSizeString(16, string);
                } else if (object.equals(PaperSize.A3)) {
                    string = "A3";
                    string2 = PageSetupGeneralPanel.this.getSizeString(17, string);
                } else if (object.equals(PaperSize.A4)) {
                    string = "A4";
                    string2 = PageSetupGeneralPanel.this.getSizeString(18, string);
                } else if (object.equals(PaperSize.A5)) {
                    string = "A5";
                    string2 = PageSetupGeneralPanel.this.getSizeString(19, string);
                } else if (object.equals(PaperSize.A6)) {
                    string = "A6";
                    string2 = PageSetupGeneralPanel.this.getSizeString(20, string);
                } else if (object.equals(PaperSize.B3)) {
                    string = "B3";
                    string2 = PageSetupGeneralPanel.this.getSizeString(21, string);
                } else if (object.equals(PaperSize.B4)) {
                    string = "B4";
                    string2 = PageSetupGeneralPanel.this.getSizeString(22, string);
                } else if (object.equals(PaperSize.B5)) {
                    string = "B5";
                    string2 = PageSetupGeneralPanel.this.getSizeString(23, string);
                } else if (object.equals(PaperSize.B6)) {
                    string = "B6";
                    string2 = PageSetupGeneralPanel.this.getSizeString(24, string);
                } else if (object.equals(PaperSize.C1)) {
                    string = "C1";
                    string2 = PageSetupGeneralPanel.this.getSizeString(25, string);
                } else if (object.equals(PaperSize.C2)) {
                    string = "C2";
                    string2 = PageSetupGeneralPanel.this.getSizeString(26, string);
                } else if (object.equals(PaperSize.C3)) {
                    string = "C3";
                    string2 = PageSetupGeneralPanel.this.getSizeString(27, string);
                } else if (object.equals(PaperSize.C4)) {
                    string = "C4";
                    string2 = PageSetupGeneralPanel.this.getSizeString(28, string);
                } else if (object.equals(PaperSize.C5)) {
                    string = "C5";
                    string2 = PageSetupGeneralPanel.this.getSizeString(29, string);
                } else if (object.equals(PaperSize.C6)) {
                    string = "C6";
                    string2 = PageSetupGeneralPanel.this.getSizeString(30, string);
                }
            }
            this.setText(string2);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.getAccessibleContext().setAccessibleName(string2);
            return this;
        }
    }
}

