/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataviewFont;
import oracle.dss.dataView.DataviewFontAttribute;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.UIDataview;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;

public class FontColorTool
extends JToolBar
implements DataviewToolbarRollover,
DataviewTool,
PropertyChangeListener {
    public static final String PROPERTY_FONT_COLOR = "FontColor";
    protected Object m_selectedObject;
    protected ComponentHandle m_selectedComponentHandle;
    protected UIDataview m_currentDataview;
    protected boolean m_colorPaletteSet;
    protected NewColorChoice m_fontColor = new NewColorChoice();
    private ResourceBundle rBundle;
    protected boolean m_enable = true;
    protected Color m_fnColor;
    protected boolean m_bPause;
    protected boolean m_bRolloverIconEnabled;
    private MouseListener m_mouseListener;
    private boolean m_bSuperCalled = true;

    public FontColorTool() {
        Icon icon = this.m_fontColor.getColorIcon();
        this.m_fontColor.setIcon(icon);
        this.m_fontColor.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.m_fontColor.getIcon()).getImage())));
        this.m_fontColor.setSelectedColor(new Color(153, 153, 153));
        this.m_fontColor.addPropertyChangeListener(this);
        this.m_fontColor.setEnabled(false);
        this.m_fontColor.setBorderPainted(false);
        this.add((Component)((Object)this.m_fontColor));
        this.setBorder(null);
        this.updateResourceBundle(Locale.getDefault());
        this.m_fontColor.setToolTipText(this.rBundle.getString(PROPERTY_FONT_COLOR));
        this.m_fontColor.getAccessibleContext().setAccessibleName(this.rBundle.getString("FontColorButton"));
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            if (this.m_fontColor.getBorder() != null && this.m_fontColor.getBorder() instanceof CompoundBorder) {
                this.m_fontColor.setBorder(new CompoundBorder(((CompoundBorder)this.m_fontColor.getBorder()).getOutsideBorder(), null));
            }
            this.m_fontColor.setPreferredSize(new Dimension(this.m_fontColor.getPreferredSize().width, 24));
            this.m_mouseListener = new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!FontColorTool.this.isRolloverIconEnabled()) {
                        FontColorTool.this.m_fontColor.setBorderPainted(true);
                    }
                    if (!FontColorTool.this.m_fontColor.isEnabled()) {
                        FontColorTool.this.m_fontColor.setBorderPainted(FontColorTool.this.m_fontColor.isSelected());
                    }
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    if (!FontColorTool.this.isRolloverIconEnabled() && FontColorTool.this.m_fontColor.isEnabled()) {
                        FontColorTool.this.m_fontColor.setBorderPainted(FontColorTool.this.m_fontColor.isSelected());
                    }
                }
            };
            this.m_fontColor.addMouseListener(this.m_mouseListener);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(locale);
        this.m_fontColor.setToolTipText(this.rBundle.getString(PROPERTY_FONT_COLOR));
        this.m_fontColor.getAccessibleContext().setAccessibleName(this.rBundle.getString("FontColorButton"));
    }

    public void selectedAction(ControllerEvent controllerEvent, UIDataview uIDataview, ToolBar toolBar) {
        Object object = null;
        boolean bl = false;
        this.m_currentDataview = uIDataview;
        if (controllerEvent == null) {
            return;
        }
        this.m_fontColor.setCustomColorsEnabled(uIDataview.isCustomColorsEnabled());
        ComponentHandle componentHandle = controllerEvent.getComponentHandle();
        if (componentHandle == null || this.m_currentDataview instanceof GraphAttribute && componentHandle.getComponent() == null) {
            this.m_selectedObject = null;
            this.m_fontColor.setEnabled(false);
            return;
        }
        object = componentHandle.getComponent();
        this.m_enable = false;
        if (this.isEnabled(controllerEvent.getComponentHandle())) {
            this.m_selectedObject = object;
            this.m_selectedComponentHandle = controllerEvent.getComponentHandle();
            this.m_fontColor.setEnabled(true);
            Color color = this.getFontColor();
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_fontColor.getColorPalette(), (Color)color)) {
                    this.m_fontColor.setColorPalette(FontButton.getNewColorPalette(this.m_fontColor.getColorPalette(), color, this.m_colorPaletteSet));
                }
                this.m_fontColor.setSelectedColor(color);
            } else {
                this.m_fontColor.setSelectedColor(this.m_fontColor.getClosestColor(color));
            }
            this.m_fnColor = color;
            this.m_fontColor.updateIconColor();
        } else {
            this.m_fontColor.setEnabled(false);
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
        }
        this.m_enable = true;
    }

    public void setColorPalette(TwoDModel twoDModel) {
        this.m_colorPaletteSet = twoDModel != null;
        this.m_bPause = true;
        if (this.m_fnColor == null) {
            this.m_fontColor.setSelectedColor((Color)this.m_fontColor.getColorPalette().getData(0, 0));
        }
        if (this.m_fnColor != null) {
            Color color = new Color(this.m_fnColor.getRGB());
            this.m_fontColor.setSelectedColor((Color)this.m_fontColor.getColorPalette().getData(0, 0));
            this.m_fontColor.setColorPalette(twoDModel);
            if (!this.m_colorPaletteSet) {
                if (!NewColorChoice.isColorInPalette((TwoDModel)this.m_fontColor.getColorPalette(), (Color)color)) {
                    this.m_fontColor.setColorPalette(FontButton.getNewColorPalette(this.m_fontColor.getColorPalette(), color, this.m_colorPaletteSet));
                }
                this.m_fontColor.setSelectedColor(color);
            } else {
                this.m_fontColor.setSelectedColor(this.m_fontColor.getClosestColor(color));
            }
        } else {
            this.m_fontColor.setColorPalette(twoDModel);
            this.m_fontColor.setSelectedColor(null);
        }
        this.m_bPause = false;
    }

    public TwoDModel getColorPalette() {
        return this.m_fontColor.getColorPalette();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.m_bPause) {
            return;
        }
        if (propertyChangeEvent == null || !this.m_enable) {
            return;
        }
        if (!propertyChangeEvent.getSource().equals((Object)this.m_fontColor) || !propertyChangeEvent.getPropertyName().equals("selectedColor")) {
            return;
        }
        if (this.m_selectedComponentHandle != null) {
            this.setFontColor(this.m_fontColor.getSelectedColor());
            this.firePropertyChange(PROPERTY_FONT_COLOR, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
        this.m_fontColor.updateIconColor();
    }

    public void update() {
        this.m_fontColor.setEnabled(this.isEnabled() && this.m_fontColor.isEnabled());
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    public void cleanUp() {
        this.m_fontColor.dispose();
        this.m_fontColor.removeMouseListener(this.m_mouseListener);
        this.m_fontColor.removePropertyChangeListener(this);
        this.remove((Component)((Object)this.m_fontColor));
        this.m_fontColor._filter = null;
        this.m_fontColor = null;
        this.rBundle = null;
    }

    public void setRolloverIconEnabled(boolean bl) {
        this.m_bRolloverIconEnabled = bl;
        if (bl) {
            this.m_fontColor.updateIconColor();
        } else {
            this.m_fontColor.setIcon(this.m_fontColor.getColorIcon());
            this.m_fontColor.setRolloverIcon(null);
            this.m_fontColor.setRolloverSelectedIcon(null);
        }
    }

    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    private ImageIcon makeImage(String string) {
        return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)string));
    }

    private boolean isEnabled(ComponentHandle componentHandle) {
        if (componentHandle == null) {
            return false;
        }
        if (componentHandle.getID() == 6 || componentHandle.getID() == 7 || componentHandle.getID() == 8) {
            return true;
        }
        if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        if (this.m_currentDataview instanceof GraphAttribute && componentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(componentHandle) != null) {
            return true;
        }
        return componentHandle.getComponent() instanceof DataviewFontAttribute;
    }

    private Color getFontColor() {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            return ((DataviewTitles)this.m_selectedObject).getForeground();
        }
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getForeground();
        }
        if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle);
            return viewStyle.getForeground();
        }
        if (this.m_selectedObject instanceof DataviewFontAttribute) {
            return ((DataviewFontAttribute)this.m_selectedObject).getDataviewFont().getGraphFontColor();
        }
        return Color.white;
    }

    private void setFontColor(Color color) {
        if (this.m_selectedComponentHandle.getID() == 6 || this.m_selectedComponentHandle.getID() == 7 || this.m_selectedComponentHandle.getID() == 8) {
            ((DataviewTitles)this.m_selectedObject).setForeground(color);
        } else if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setForeground(color);
            ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_currentDataview instanceof GraphAttribute && this.m_selectedComponentHandle instanceof PageItemComponentHandle && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewStyle(this.m_selectedComponentHandle) != null) {
            ViewStyle viewStyle = new ViewStyle();
            viewStyle.setForeground(color);
            ((GraphAttribute)((Object)this.m_currentDataview)).applyViewStyle(this.m_selectedComponentHandle, viewStyle);
        } else if (this.m_selectedObject instanceof DataviewFontAttribute) {
            DataviewFont dataviewFont = ((DataviewFontAttribute)this.m_selectedObject).getDataviewFont();
            dataviewFont.setGraphFontColor(color);
        }
    }

    class Filter_Font
    extends RGBImageFilter {
        private int _color;
        private int _sCOLOR = new Color(0, 153, 153).getRGB();

        public Filter_Font() {
            this.canFilterIndexColorModel = true;
        }

        public void setColor(Color color) {
            this._color = color == null ? 0 : color.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            if (n3 == this._sCOLOR) {
                return this._color;
            }
            return n3;
        }
    }

    class NewColorChoice
    extends BIColorChoice {
        Image image;
        protected Image m_fontColorImage;
        private Image m_fontColorImage1;
        private String imageName;
        protected Image newImage;
        protected Filter_Font _filter = null.new Filter_Font();
        protected Filter_Font _filter1 = null.new Filter_Font();

        NewColorChoice() {
        }

        protected void updateIconColor() {
            this.setIcon(this.getColorIcon());
            this.setDisabledIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())));
            this._filter1.setColor(this.getSelectedColor());
            Object var1_1 = null;
            this.m_fontColorImage1 = ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.ToolBar"), (String)"images/l_fontcolorwitharrow.gif");
            FilteredImageSource filteredImageSource = new FilteredImageSource(this.m_fontColorImage1.getSource(), this._filter1);
            this.newImage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            if (FontColorTool.this.isRolloverIconEnabled()) {
                this.setRolloverIcon(new ImageIcon(this.newImage));
                this.setRolloverSelectedIcon(new ImageIcon(this.newImage));
            }
        }

        protected Icon getColorIcon() {
            this._filter.setColor(this.getSelectedColor());
            Image image = null;
            String string = FontColorTool.this.isRolloverIconEnabled() ? "images/fontcolorwitharrow.gif" : "images/fontcolorwitharrow_18t.gif";
            if (string != this.imageName || this.m_fontColorImage == null) {
                this.m_fontColorImage = ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FontColorTool$NewColorChoice"), (String)string);
                this.imageName = string;
            }
            image = this.m_fontColorImage;
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this._filter);
            this.newImage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            return new ImageIcon(this.newImage);
        }

        public Icon getDisabledIcon() {
            this._filter.setColor(new Color(153, 153, 153));
            Image image = null;
            image = this.m_fontColorImage;
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this._filter);
            this.newImage = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            return new ImageIcon(this.newImage);
        }

        private ImageIcon makeImage(String string) {
            return new ImageIcon(ImageUtils.getImageResource(Class.forName("oracle.dss.dataView.gui.FontColorTool"), (String)string));
        }
    }
}

