/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.dss.dataView.datacache.CubeLayer;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class RowColumnEdge
implements Edge {
    private CubeLayer[] m_layers;
    private int m_nExtent;
    private int m_nLimit = -1;
    private boolean m_isOutline;
    private Cell[][] m_cells;
    private QDR[][] m_memberQDRs;
    private QDR[] m_sliceQDRs;
    public static final String EDGECELLS = "EdgeCells";
    public static final String EDGECELL = "EdgeCell";
    public static final String VAL = "val";
    public static final String DEPTH = "depth";
    public static final String OUTLINELAYER = "outlineLayer";
    public static final String MEMBERQDRS = "memberQdrs";
    public static final String SLICEQDRS = "sliceQdrs";

    RowColumnEdge(DataAccess dataAccess, boolean bl, int n, Map map, Map map2, int n2) {
        if (bl) {
            this.m_isOutline = bl;
            this._buildOutlineMode(dataAccess, n, map, map2, n2);
            return;
        }
        int n3 = 1;
        this.m_nExtent = 0;
        boolean bl2 = false;
        try {
            n3 = dataAccess.getLayerCount(n);
            this.m_nExtent = dataAccess.getEdgeExtent(n);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        if (n2 != -1 && this.m_nExtent > n2) {
            bl2 = true;
            this.m_nExtent = n2;
            this.m_nLimit = n2;
        }
        this.m_cells = new Cell[n3][this.m_nExtent];
        this.m_layers = new CubeLayer[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_layers[n4] = new CubeLayer(dataAccess, n, n4, map2);
            try {
                int n5 = 0;
                while (n5 < this.m_nExtent) {
                    block14: {
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        block16: {
                            block15: {
                                block13: {
                                    block12: {
                                        n9 = dataAccess.getMemberExtent(n, n4, n5);
                                        n8 = dataAccess.getMemberDepth(n, n4, n5);
                                        n7 = dataAccess.getMemberStartLayer(n, n4, n5);
                                        if (n8 <= 1) break block12;
                                        if (n7 == n4) break block13;
                                        break block14;
                                    }
                                    n7 = n4;
                                }
                                n6 = dataAccess.getMemberStartSlice(n, n4, n5);
                                if (bl2 && n9 + n6 > this.m_nExtent) {
                                    n9 = this.m_nExtent - n6;
                                }
                                if (n9 <= 1) break block15;
                                if (n6 == n5) break block16;
                                break block14;
                            }
                            n6 = n5;
                        }
                        Object object = null;
                        object = dataAccess.getMemberMetadata(n, n4, n5, "value");
                        Member member = this.m_layers[n4].getMember(object);
                        if (member == null) {
                            member = new Member(dataAccess, n, n4, n5, map);
                            this.m_layers[n4].putMember(object, member);
                        }
                        this.addCell(member, n7, n6, n8, n9);
                    }
                    ++n5;
                }
            }
            catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            }
            catch (LayerOutOfRangeException layerOutOfRangeException) {
            }
            catch (SliceOutOfRangeException sliceOutOfRangeException) {
                // empty catch block
            }
            ++n4;
        }
    }

    public RowColumnEdge(ObjectNode objectNode, boolean bl, Data data, Map map, Map map2) {
        ContainerNode containerNode;
        Object object;
        int n = 0;
        this.m_isOutline = bl;
        ContainerNode containerNode2 = null;
        if (objectNode != null) {
            try {
                n = objectNode.getPropertyValueAsInteger("layerCount");
                this.m_nExtent = objectNode.getPropertyValueAsInteger("extent");
                this.m_nLimit = objectNode.getPropertyValueAsInteger("limit");
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
            containerNode2 = objectNode.getContainer("Layers");
            if (containerNode2 == null) {
                n = 0;
            }
        }
        this.m_layers = new CubeLayer[n];
        if (n > 0) {
            this.m_cells = this.m_isOutline ? new Cell[1][this.m_nExtent] : new Cell[n][this.m_nExtent];
            object = containerNode2.getContainerNodes("Layer");
            int n2 = 0;
            while (object.hasMoreElements() && n2 < n) {
                ContainerNode containerNode3 = (ContainerNode)object.nextElement();
                this.m_layers[n2] = new CubeLayer(containerNode3, map2, map);
                ++n2;
            }
            containerNode = objectNode.getContainer(EDGECELLS);
            if (containerNode != null) {
                this.readEdgeCells(containerNode, 0, 0, data);
            }
        }
        if ((object = objectNode.getContainer(MEMBERQDRS)) != null) {
            this.readMemberQDRs((ContainerNode)object, n, this.m_nExtent);
        }
        if ((containerNode = objectNode.getContainer(SLICEQDRS)) != null) {
            this.readSliceQDRs(containerNode, this.m_nExtent);
        }
    }

    protected void _buildQDRStorage(DataAccess dataAccess, int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (n != 1) {
            return;
        }
        this.m_memberQDRs = new QDR[n2][n3];
        this.m_sliceQDRs = new QDR[n3];
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            while (n5 < n2) {
                this.m_memberQDRs[n5][n4] = dataAccess.getMemberQDR(n, n5, n4, 0);
                ++n5;
            }
            this.m_sliceQDRs[n4] = dataAccess.getSliceQDR(n, n4, 0);
            ++n4;
        }
    }

    protected void _buildOutlineMode(DataAccess dataAccess, int n, Map map, Map map2, int n2) {
        int n3 = 1;
        this.m_nExtent = 0;
        try {
            n3 = dataAccess.getLayerCount(n);
            this.m_nExtent = dataAccess.getEdgeExtent(n);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        boolean bl = false;
        if (n2 != -1 && this.m_nExtent > n2) {
            bl = true;
            this.m_nExtent = n2;
            this.m_nLimit = n2;
        }
        this.m_cells = new Cell[1][this.m_nExtent];
        this.m_layers = new CubeLayer[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.m_layers[n4] = new CubeLayer(dataAccess, n, n4, map2);
            ++n4;
        }
        try {
            n4 = 0;
            while (n4 < this.m_nExtent) {
                block13: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    block12: {
                        block11: {
                            n9 = dataAccess.getSliceOutlineLayer(n, n4);
                            n8 = dataAccess.getMemberExtent(n, n9, n4);
                            n7 = dataAccess.getMemberDepth(n, n9, n4);
                            n6 = dataAccess.getMemberStartLayer(n, 0, n4);
                            n5 = dataAccess.getMemberStartSlice(n, n9, n4);
                            if (n8 <= 1) break block11;
                            if (n5 == n4) break block12;
                            break block13;
                        }
                        n5 = n4;
                    }
                    if (bl && n8 + n5 > this.m_nExtent) {
                        n8 = this.m_nExtent - n5;
                    }
                    Object object = null;
                    object = dataAccess.getMemberMetadata(n, n9, n4, "value");
                    Member member = this.m_layers[n9].getMember(object);
                    if (member == null) {
                        member = new Member(dataAccess, n, n9, n4, map);
                        this.m_layers[n9].putMember(object, member);
                    }
                    this.addOutlineCell(member, n6, n5, n7, n8, n9);
                }
                ++n4;
            }
            this._buildQDRStorage(dataAccess, n, n3, this.m_nExtent);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
    }

    public Object getMemberMetadata(int n, int n2, String string) throws LayerOutOfRangeException, SliceOutOfRangeException {
        Cell cell = this.getCell(n, n2);
        return cell.getMember().getMetadata(string);
    }

    public Object getLayerMetadata(int n, String string) throws LayerOutOfRangeException {
        if (n >= this.m_layers.length) {
            throw new LayerOutOfRangeException(n, this.m_layers.length - 1);
        }
        if (n < 0) {
            throw new LayerOutOfRangeException(n, 0);
        }
        return this.m_layers[n].getMetadata(string);
    }

    public int getLayerCount() {
        return this.m_layers.length;
    }

    public int getExtent() {
        return this.m_nExtent;
    }

    public int getLimit() {
        return this.m_nLimit;
    }

    public Object getSliceLabel(int n) throws SliceOutOfRangeException {
        StringBuffer stringBuffer = new StringBuffer(50);
        try {
            int n2 = 0;
            while (n2 < this.getLayerCount()) {
                if (n2 != 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(this.getCell(n2, n).getMember().getMetadata("longName"));
                n2 += this.getCell(n2, n).getDepth();
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public int getSliceMemberCount(int n) throws SliceOutOfRangeException {
        int n2 = 0;
        try {
            int n3 = 0;
            while (n3 < this.getLayerCount()) {
                n3 += this.getCell(n3, n).getDepth();
                ++n2;
            }
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            // empty catch block
        }
        return n2;
    }

    public int getSliceOutlineLayer(int n) throws SliceOutOfRangeException {
        try {
            int n2 = this.getCell(0, n).getOutlineLayer();
            return n2;
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            throw new SliceOutOfRangeException(layerOutOfRangeException.getMessage(), layerOutOfRangeException);
        }
    }

    public int getMemberDepth(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getCell(n, n2).getDepth();
    }

    public int getMemberStartLayer(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        int n3 = n;
        Cell cell = this.getCell(n, n2);
        if (cell.hasDepth()) {
            n3 = ((BigCell)cell).getStartLayer();
        }
        return n3;
    }

    public int getMemberExtent(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getCell(n, n2).getSpan();
    }

    public int getMemberStartSlice(int n, int n2) throws LayerOutOfRangeException, SliceOutOfRangeException {
        int n3 = n2;
        Cell cell = this.getCell(n, n2);
        if (cell.hasSpan()) {
            n3 = ((BigCell)cell).getStartSlice();
        }
        return n3;
    }

    public int getMemberSiblingCount(int[] nArray, int n) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 0;
    }

    public Object getMemberMetadata(int[] nArray, int n, int n2, String string) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getMemberHPos(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getFirstHPos() {
        return null;
    }

    public int[] getLastHPos() {
        return null;
    }

    public int[] getPrevHPos(int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int[] getNextHPos(int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return null;
    }

    public int getCurrentSlice() {
        return 0;
    }

    public int[] getCurrentHPos() {
        return null;
    }

    public QDR getSliceQDR(int n) {
        if (this.m_sliceQDRs != null) {
            return this.m_sliceQDRs[n];
        }
        return null;
    }

    public QDR getMemberQDR(int n, int n2) {
        if (this.m_memberQDRs != null) {
            return this.m_memberQDRs[n][n2];
        }
        return null;
    }

    public Enumeration getMemberEnumeration(int n) {
        return new _MemberEnumeration(n);
    }

    public ObjectNode addEdgeToXML(String string, Data data, Map map, Map map2) {
        ContainerNode containerNode;
        ObjectNode objectNode = new ObjectNode(string);
        int n = this.getLayerCount();
        int n2 = this.getExtent();
        int n3 = this.getLimit();
        objectNode.addProperty("layerCount", n);
        objectNode.addProperty("extent", n2);
        objectNode.addProperty("limit", n3);
        ContainerNode containerNode2 = new ContainerNode("Layers");
        int n4 = 0;
        while (n4 < n) {
            containerNode = this.m_layers[n4].addLayerToXML(map, map2);
            containerNode2.addContainedObject(containerNode);
            ++n4;
        }
        objectNode.addContainer(containerNode2);
        ContainerNode containerNode3 = new ContainerNode(EDGECELLS);
        try {
            this.addCellsToXML(containerNode3, 0, n, 0, n2 - 1, data);
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        objectNode.addContainer(containerNode3);
        try {
            if (this.m_memberQDRs != null) {
                containerNode = new ContainerNode(MEMBERQDRS);
                this.addMemberQDRsToXML(containerNode, n, 0, n2 - 1);
                objectNode.addContainer(containerNode);
            }
            if (this.m_sliceQDRs != null) {
                containerNode = new ContainerNode(SLICEQDRS);
                this.addSliceQDRsToXML(containerNode, 0, n2 - 1);
                objectNode.addContainer(containerNode);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return objectNode;
    }

    private void readMemberQDRs(ContainerNode containerNode, int n, int n2) {
        this.m_memberQDRs = new QDR[n][n2];
        Enumeration enumeration = containerNode.getContainerNodes("QDR");
        int n3 = 0;
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            ContainerNode containerNode2 = (ContainerNode)enumeration.nextElement();
            if (containerNode2 != null) {
                QDR qDR = new QDR();
                qDR.setXML(null, containerNode2);
                this.m_memberQDRs[n4][n3] = qDR;
            }
            if (++n4 < n) continue;
            n4 = 0;
            ++n3;
        }
    }

    private void readSliceQDRs(ContainerNode containerNode, int n) {
        this.m_sliceQDRs = new QDR[n];
        Enumeration enumeration = containerNode.getContainerNodes("QDR");
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            ContainerNode containerNode2 = (ContainerNode)enumeration.nextElement();
            if (containerNode2 != null) {
                QDR qDR = new QDR();
                qDR.setXML(null, containerNode2);
                this.m_sliceQDRs[n2] = qDR;
            }
            ++n2;
        }
    }

    private int readEdgeCells(ContainerNode containerNode, int n, int n2, Data data) {
        int n3 = 0;
        int n4 = this.getLayerCount();
        if (this.m_layers[n] != null) {
            Enumeration enumeration = containerNode.getContainerNodes(EDGECELL);
            while (enumeration.hasMoreElements()) {
                BaseNode baseNode;
                Object object;
                ContainerNode containerNode2 = (ContainerNode)enumeration.nextElement();
                int n5 = 1;
                PropertyNode propertyNode = containerNode2.getProperty(DEPTH);
                if (propertyNode != null) {
                    n5 = propertyNode.getValueAsInteger();
                }
                int n6 = 0;
                PropertyNode propertyNode2 = containerNode2.getProperty(OUTLINELAYER);
                if (propertyNode2 != null) {
                    n6 = propertyNode2.getValueAsInteger();
                }
                int n7 = 1;
                int n8 = n2 + n3;
                if (n + n5 < n4) {
                    n7 = this.readEdgeCells(containerNode2, n + n5, n2 + n3, data);
                } else if (data != null && (object = containerNode2.getContainerNodes("Data")).hasMoreElements()) {
                    baseNode = (ContainerNode)object.nextElement();
                    data.readDataFromXML((ContainerNode)baseNode, n8);
                }
                object = null;
                baseNode = containerNode2.getProperty(VAL);
                if (baseNode != null) {
                    object = this.m_layers[this.m_isOutline ? n6 : n].getMember(((PropertyNode)baseNode).getValueAsString());
                }
                try {
                    if (object != null) {
                        if (this.m_isOutline) {
                            this.addOutlineCell((Member)object, n, n8, n5, n7, n6);
                        } else {
                            this.addCell((Member)object, n, n8, n5, n7);
                        }
                    }
                }
                catch (LayerOutOfRangeException layerOutOfRangeException) {
                }
                catch (SliceOutOfRangeException sliceOutOfRangeException) {
                    // empty catch block
                }
                n3 += n7;
            }
        }
        if (n3 < 1) {
            n3 = 1;
        }
        return n3;
    }

    private void addMemberQDRsToXML(ContainerNode containerNode, int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (this.m_memberQDRs == null) {
            return;
        }
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = 0;
            while (n5 < n) {
                containerNode.addContainedObject((ContainerNode)this.m_memberQDRs[n5][n4].getXML(null));
                ++n5;
            }
            ++n4;
        }
    }

    private void addSliceQDRsToXML(ContainerNode containerNode, int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        if (this.m_sliceQDRs == null) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            containerNode.addContainedObject((ContainerNode)this.m_sliceQDRs[n3].getXML(null));
            ++n3;
        }
    }

    private void addCellsToXML(ContainerNode containerNode, int n, int n2, int n3, int n4, Data data) throws SliceOutOfRangeException, LayerOutOfRangeException {
        int n5 = n3;
        while (n5 <= n4) {
            int n6 = this.getMemberExtent(n, n5);
            int n7 = this.getMemberDepth(n, n5);
            int n8 = this.getSliceOutlineLayer(n5);
            int n9 = n + n7;
            ContainerNode containerNode2 = new ContainerNode(EDGECELL);
            Object object = this.getMemberMetadata(n, n5, "value");
            containerNode2.addProperty(VAL, object == null ? null : object.toString());
            if (n7 > 1) {
                containerNode2.addProperty(DEPTH, n7);
            }
            if (n8 > 0) {
                containerNode2.addProperty(OUTLINELAYER, n8);
            }
            if (n9 < n2) {
                this.addCellsToXML(containerNode2, n9, n2, n5, n5 + n6 - 1, data);
            } else if (data != null) {
                ContainerNode containerNode3 = new ContainerNode("Data");
                data.addDataToXML(containerNode3, n5);
                containerNode2.addContainedObject(containerNode3);
            }
            containerNode.addContainedObject(containerNode2);
            n5 += n6;
        }
    }

    private void addOutlineCell(Member member, int n, int n2, int n3, int n4, int n5) throws SliceOutOfRangeException, LayerOutOfRangeException {
        if (n + n3 > this.m_layers.length) {
            throw new LayerOutOfRangeException(n + n3 - 1, this.m_layers.length - 1);
        }
        if (n2 + n4 > this.m_nExtent) {
            throw new SliceOutOfRangeException(n2 + n4 - 1, this.m_nExtent - 1);
        }
        if (n < 0) {
            throw new LayerOutOfRangeException(n, 0);
        }
        if (n2 < 0) {
            throw new SliceOutOfRangeException(n2, 0);
        }
        if (this.m_cells[n][n2] != null) {
            return;
        }
        if (n3 == 1 && n4 == 1) {
            this.m_cells[n][n2] = new Cell(member);
        } else {
            BigCell bigCell = new BigCell(member, n, n2, n3, n4, n5);
            int n6 = 0;
            while (n6 < n4) {
                this.m_cells[n][n2 + n6] = bigCell;
                ++n6;
            }
        }
    }

    private void addCell(Member member, int n, int n2, int n3, int n4) throws SliceOutOfRangeException, LayerOutOfRangeException {
        if (n + n3 > this.m_layers.length) {
            throw new LayerOutOfRangeException(n + n3 - 1, this.m_layers.length - 1);
        }
        if (n2 + n4 > this.m_nExtent) {
            throw new SliceOutOfRangeException(n2 + n4 - 1, this.m_nExtent - 1);
        }
        if (n < 0) {
            throw new LayerOutOfRangeException(n, 0);
        }
        if (n2 < 0) {
            throw new SliceOutOfRangeException(n2, 0);
        }
        if (this.m_cells[n][n2] != null) {
            return;
        }
        if (n3 == 1 && n4 == 1) {
            this.m_cells[n][n2] = new Cell(member);
        } else {
            BigCell bigCell = new BigCell(member, n, n2, n3, n4);
            int n5 = 0;
            while (n5 < n3) {
                int n6 = 0;
                while (n6 < n4) {
                    this.m_cells[n + n5][n2 + n6] = bigCell;
                    ++n6;
                }
                ++n5;
            }
        }
    }

    private Cell getCell(int n, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException {
        if (n >= this.m_layers.length) {
            throw new LayerOutOfRangeException(n, this.m_layers.length - 1);
        }
        if (n2 >= this.m_nExtent) {
            throw new SliceOutOfRangeException(n2, this.m_nExtent - 1);
        }
        if (n < 0) {
            throw new LayerOutOfRangeException(n, 0);
        }
        if (n2 < 0) {
            throw new SliceOutOfRangeException(n2, 0);
        }
        if (this.m_isOutline) {
            return this.m_cells[0][n2];
        }
        return this.m_cells[n][n2];
    }

    private class _MemberEnumeration
    implements Enumeration {
        private Enumeration keys;
        private Dictionary members;

        _MemberEnumeration(int n) {
            this.members = RowColumnEdge.this.m_layers[n].getMembers();
            this.keys = this.members.keys();
        }

        public boolean hasMoreElements() {
            return this.keys.hasMoreElements();
        }

        public Object nextElement() throws NoSuchElementException {
            return this.members.get(this.keys.nextElement());
        }
    }

    private static class BigCell
    extends Cell {
        private int startLayer;
        private int startSlice;
        private int span;
        private int depth;
        private int m_outlineLayer;

        protected BigCell(Member member, int n, int n2, int n3, int n4) {
            super(member);
            this.span = n4;
            this.depth = n3;
            this.startLayer = n;
            this.startSlice = n2;
        }

        protected BigCell(Member member, int n, int n2, int n3, int n4, int n5) {
            this(member, n, n2, n3, n4);
            this.m_outlineLayer = n5;
        }

        protected int getOutlineLayer() {
            return this.m_outlineLayer;
        }

        protected int getSpan() {
            return this.span;
        }

        protected int getDepth() {
            return this.depth;
        }

        protected int getStartSlice() {
            return this.startSlice;
        }

        protected int getStartLayer() {
            return this.startLayer;
        }

        protected boolean hasSpan() {
            return this.span > 1;
        }

        protected boolean hasDepth() {
            return this.depth > 1;
        }
    }

    private static class Cell {
        private Member m_member;

        protected Cell(Member member) {
            this.m_member = member;
        }

        protected Member getMember() {
            return this.m_member;
        }

        protected boolean hasSpan() {
            return false;
        }

        protected boolean hasDepth() {
            return false;
        }

        protected int getSpan() {
            return 1;
        }

        protected int getDepth() {
            return 1;
        }

        protected int getOutlineLayer() {
            return 0;
        }
    }
}

