/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Hashtable;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.PageEdge;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.CubeDataDirector;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAccessAdapter;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.QDR;
import oracle.dss.util.RelationalDataDirector;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.persistence.AggregateInfo;
import oracle.dss.util.persistence.BIPersistenceException;
import oracle.dss.util.persistence.Persistable;
import oracle.dss.util.persistence.PersistableAttributes;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;
import oracle.dss.util.xml.XMLObjectReader;
import oracle.dss.util.xml.XMLObjectWriter;

public abstract class BaseCachedDataSource
extends DataAccessAdapter
implements DataSource,
Persistable {
    protected Map m_dataMap;
    protected Map m_metadataMap;
    protected Map m_layerMetadataMap;
    protected Data m_data;
    protected Edge[] m_edges;
    protected PersistableAttributes m_attrs;
    protected boolean m_isOutline;
    protected static final String[] DEFAULT_SUPPORTED_DATAMAP = new String[]{"dataUnformatted", "dataFormatted", "dataIsTotal"};
    protected static final String[] DEFAULT_SUPPORTED_LAYERMETADATAMAP = new String[]{"dimName", "dimLongName", "dimMediumName", "dimShortName"};
    protected String m_measureDim;
    public static final String COLUMN_EDGE = "ColumnEdge";
    public static final String ROW_EDGE = "RowEdge";
    public static final String PAGE_EDGE = "PageEdge";
    public static final String DATAMAP = "DataMap";
    public static final String METADATAMAP = "MetadataMap";
    public static final String LAYERMETADATAMAP = "LayerMetadataMap";
    private static final String MEASURE_ATTR = "measure";
    public static final String IS_OUTLINE = "IsOutline";

    public BaseCachedDataSource() {
        this.init();
    }

    public void copyDataSource(DataAccess dataAccess, DataDirector dataDirector) {
        this.init();
        this.initializeDataSource(dataAccess, dataDirector, -1, -1);
    }

    public void copyDataSource(DataAccess dataAccess, DataDirector dataDirector, int n, int n2) {
        this.init();
        this.initializeDataSource(dataAccess, dataDirector, n, n2);
    }

    public int getEdgeCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.m_edges.length && this.m_edges[n2] != null) {
            ++n2;
            ++n;
        }
        return n;
    }

    public Object getLayerMetadata(int n, int n2, String string) throws LayerOutOfRangeException, EdgeOutOfRangeException {
        if (string.equals("dimIsMeasure")) {
            return new Boolean(this.m_measureDim != null && this.m_measureDim.equals(this.getEdge(n).getLayerMetadata(n2, "dimName")));
        }
        return this.getEdge(n).getLayerMetadata(n2, string);
    }

    public int getMemberSiblingCount(int n, int[] nArray, int n2) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberSiblingCount(nArray, n2);
    }

    public Object getMemberMetadata(int n, int[] nArray, int n2, int n3, String string) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberMetadata(nArray, n2, n3, string);
    }

    public int getLayerCount(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getLayerCount();
    }

    public int getEdgeExtent(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getExtent();
    }

    public int getLimit(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getLimit();
    }

    public int getSliceMemberCount(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getSliceMemberCount(n2);
    }

    public int getMemberDepth(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberDepth(n2, n3);
    }

    public int getMemberStartLayer(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberStartLayer(n2, n3);
    }

    public int getMemberExtent(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberExtent(n2, n3);
    }

    public int getMemberStartSlice(int n, int n2, int n3) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberStartSlice(n2, n3);
    }

    public Object getMemberMetadata(int n, int n2, int n3, String string) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberMetadata(n2, n3, string);
    }

    public int[] getMemberHPos(int n, int n2, int n3) throws LayerOutOfRangeException, SliceOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getMemberHPos(n2, n3);
    }

    public Object getSliceLabel(int n, int n2, String string) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getSliceLabel(n2);
    }

    public int[] getFirstHPos(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getFirstHPos();
    }

    public int[] getLastHPos(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getLastHPos();
    }

    public int[] getNextHPos(int n, int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getNextHPos(nArray);
    }

    public int[] getPrevHPos(int n, int[] nArray) throws SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException {
        return this.getEdge(n).getPrevHPos(nArray);
    }

    public int getEdgeCurrentSlice(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getCurrentSlice();
    }

    public int[] getEdgeCurrentHPos(int n) throws EdgeOutOfRangeException {
        return this.getEdge(n).getCurrentHPos();
    }

    public Object getValue(int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        return this.m_data.getValue(n, n2, string);
    }

    private Edge getEdge(int n) throws EdgeOutOfRangeException {
        if (n < 0) {
            throw new EdgeOutOfRangeException(n, 0);
        }
        int n2 = this.getEdgeCount();
        if (n >= n2) {
            throw new EdgeOutOfRangeException(n, n2 - 1);
        }
        return this.m_edges[n];
    }

    public boolean isOutline() {
        return this.m_isOutline;
    }

    public int getSliceOutlineLayer(int n, int n2) throws SliceOutOfRangeException, EdgeOutOfRangeException {
        if (!this.m_isOutline) {
            return super.getSliceOutlineLayer(n, n2);
        }
        return this.getEdge(n).getSliceOutlineLayer(n2);
    }

    public void setExpectedDataMap(DataMap dataMap) {
        this.m_dataMap.setExpectedMap(dataMap);
    }

    public DataMap getExpectedDataMap() {
        return (DataMap)this.m_dataMap.getExpectedMap();
    }

    public void setExpectedMetadataMap(MetadataMap metadataMap) {
        this.m_metadataMap.setExpectedMap(metadataMap);
    }

    public MetadataMap getExpectedMetadataMap() {
        return (MetadataMap)this.m_metadataMap.getExpectedMap();
    }

    public void setExpectedLayerMetadataMap(LayerMetadataMap layerMetadataMap) {
        this.m_layerMetadataMap.setExpectedMap(layerMetadataMap);
    }

    public LayerMetadataMap getExpectedLayerMetadataMap() {
        return (LayerMetadataMap)this.m_layerMetadataMap.getExpectedMap();
    }

    public MetadataMap getSupportedMetadataMap() {
        return (MetadataMap)this.m_metadataMap.getSupportedMap();
    }

    public LayerMetadataMap getSupportedLayerMetadataMap() {
        return (LayerMetadataMap)this.m_layerMetadataMap.getSupportedMap();
    }

    public DataMap getSupportedDataMap() {
        return (DataMap)this.m_dataMap.getSupportedMap();
    }

    public void addDataDirectorListener(DataDirectorListener dataDirectorListener) {
        dataDirectorListener.viewDataAvailable(new DataAvailableEvent(this, this));
    }

    public CubeDataDirector createCubeDataDirector() {
        return null;
    }

    public RelationalDataDirector createRelationalDataDirector() {
        return null;
    }

    public void initialize(Hashtable hashtable) {
    }

    public AggregateInfo[] getPersistableComponents() {
        return null;
    }

    public void setPersistableComponents(AggregateInfo[] aggregateInfoArray) {
    }

    public PersistableAttributes getPersistableAttributes(PersistableAttributes persistableAttributes) {
        PersistableAttributes persistableAttributes2 = null;
        persistableAttributes2 = this.m_attrs == null ? new PersistableAttributes() : (PersistableAttributes)this.m_attrs.clone();
        if (persistableAttributes != null) {
            persistableAttributes2.merge(persistableAttributes);
        }
        persistableAttributes2.setObjectType(this.getXMLObjectType());
        return persistableAttributes2;
    }

    public void setPersistableAttributes(PersistableAttributes persistableAttributes) {
        this.m_attrs = persistableAttributes;
    }

    public String getXMLAsString() throws BIPersistenceException {
        String string = null;
        try {
            string = this.getXML();
        }
        catch (BIIOException bIIOException) {
            throw new BIPersistenceException(bIIOException.getMessage(), bIIOException);
        }
        return string;
    }

    public boolean setXMLAsString(String string) throws BIPersistenceException {
        boolean bl = false;
        try {
            this.setXML(string);
            bl = true;
        }
        catch (BIParseException bIParseException) {
            throw new BIPersistenceException(bIParseException.getMessage(), bIParseException);
        }
        catch (BISAXException bISAXException) {
            throw new BIPersistenceException(bISAXException.getMessage(), bISAXException);
        }
        catch (BIIOException bIIOException) {
            throw new BIPersistenceException(bIIOException.getMessage(), bIIOException);
        }
        return bl;
    }

    protected abstract String getXMLObjectName();

    protected abstract String getXMLObjectType();

    public void writeXML(OutputStream outputStream) throws BIIOException {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF8");
            this._writeXML(outputStreamWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BIIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    protected void _writeXML(Writer writer) throws BIIOException {
        ObjectNode objectNode;
        XMLObjectWriter xMLObjectWriter = new XMLObjectWriter(writer);
        xMLObjectWriter.setIndentMode(1);
        ObjectNode objectNode2 = new ObjectNode(this.getXMLObjectName());
        if (this.m_measureDim != null) {
            objectNode2.addProperty(MEASURE_ATTR, this.m_measureDim);
        }
        this.m_dataMap.addMapToXML(objectNode2);
        this.m_metadataMap.addMapToXML(objectNode2);
        this.m_layerMetadataMap.addMapToXML(objectNode2);
        int n = this.getEdgeCount();
        Edge edge = null;
        if (n >= 1) {
            edge = this.m_edges[0];
            objectNode = edge.addEdgeToXML(COLUMN_EDGE, this.m_data, this.m_metadataMap, this.m_layerMetadataMap);
            objectNode2.addProperty(objectNode);
        }
        if (n >= 2) {
            edge = this.m_edges[1];
            objectNode = edge.addEdgeToXML(ROW_EDGE, null, this.m_metadataMap, this.m_layerMetadataMap);
            objectNode2.addProperty(objectNode);
        }
        if (n >= 3) {
            edge = this.m_edges[2];
            objectNode = edge.addEdgeToXML(PAGE_EDGE, null, this.m_metadataMap, this.m_layerMetadataMap);
            objectNode2.addProperty(objectNode);
        }
        objectNode2.addProperty(IS_OUTLINE, this.m_isOutline);
        xMLObjectWriter.writeObjectNode(objectNode2);
    }

    public String getXML() throws BIIOException {
        StringWriter stringWriter = new StringWriter(1024);
        this._writeXML(stringWriter);
        stringWriter.flush();
        return stringWriter.toString();
    }

    public void readXML(InputStream inputStream) throws BISAXException, BIParseException, BIIOException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
            this._readXML(inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BIIOException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    protected void _readXML(Reader reader) throws BISAXException, BIParseException, BIIOException {
        this.init();
        XMLObjectReader xMLObjectReader = new XMLObjectReader(reader);
        ObjectNode objectNode = xMLObjectReader.readObjectNode();
        PropertyNode propertyNode = objectNode.getProperty(MEASURE_ATTR);
        if (propertyNode != null) {
            this.m_measureDim = propertyNode.getValueAsString();
        }
        this.m_dataMap.readMapFromXML(objectNode);
        this.m_metadataMap.readMapFromXML(objectNode);
        this.m_layerMetadataMap.readMapFromXML(objectNode);
        int n = 0;
        int n2 = 0;
        ObjectNode objectNode2 = objectNode.getPropertyValueAsObjectNode(COLUMN_EDGE, true);
        if (objectNode2 == null) {
            return;
        }
        try {
            n2 = this.getEdgeExtent(objectNode2);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        ObjectNode objectNode3 = objectNode.getPropertyValueAsObjectNode(ROW_EDGE, true);
        if (objectNode3 != null) {
            try {
                n = this.getEdgeExtent(objectNode3);
            }
            catch (NoSuchPropertyException noSuchPropertyException) {
                // empty catch block
            }
        }
        this.m_data = new Data(this.m_dataMap, n, n2);
        try {
            this.m_isOutline = objectNode.getPropertyValueAsBoolean(IS_OUTLINE);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        this.m_edges[0] = this.createRowColumnEdge(objectNode2, false, this.m_data, this.m_metadataMap, this.m_layerMetadataMap);
        this.m_edges[1] = this.createRowColumnEdge(objectNode3, this.isOutline(), this.m_data, this.m_metadataMap, this.m_layerMetadataMap);
        ObjectNode objectNode4 = objectNode.getPropertyValueAsObjectNode(PAGE_EDGE, true);
        if (objectNode4 != null) {
            this.m_edges[2] = new PageEdge(objectNode4, this.m_metadataMap, this.m_layerMetadataMap);
        }
    }

    public void setXML(String string) throws BIIOException, BISAXException, BIParseException {
        StringReader stringReader = new StringReader(string);
        this._readXML(stringReader);
    }

    protected abstract Edge createRowColumnEdge(DataAccess var1, boolean var2, int var3, Map var4, Map var5, int var6);

    protected abstract Edge createRowColumnEdge(ObjectNode var1, boolean var2, Data var3, Map var4, Map var5);

    protected int getInitialRowCount() {
        return 0;
    }

    protected abstract int getEdgeExtent(ObjectNode var1) throws NoSuchPropertyException;

    protected abstract MetadataMap getDefaultSupportedMetadataMap();

    protected void init() {
        this.m_edges = new Edge[3];
        this.m_measureDim = null;
        this.m_dataMap = this.m_dataMap == null ? new Map(DATAMAP, new DataMap(DEFAULT_SUPPORTED_DATAMAP)) : new Map(DATAMAP, this.m_dataMap.getExpectedMap());
        this.m_metadataMap = this.m_metadataMap == null ? new Map(METADATAMAP, this.getDefaultSupportedMetadataMap()) : new Map(METADATAMAP, this.m_metadataMap.getExpectedMap());
        this.m_layerMetadataMap = this.m_layerMetadataMap == null ? new Map(LAYERMETADATAMAP, new LayerMetadataMap(DEFAULT_SUPPORTED_LAYERMETADATAMAP)) : new Map(LAYERMETADATAMAP, this.m_layerMetadataMap.getExpectedMap());
    }

    protected void initializeDataSource(DataAccess dataAccess, DataDirector dataDirector, int n, int n2) {
        this.m_dataMap.setSupportedMap(dataDirector.getSupportedDataMap());
        this.m_metadataMap.setSupportedMap(dataDirector.getSupportedMetadataMap());
        this.m_layerMetadataMap.setSupportedMap(dataDirector.getSupportedLayerMetadataMap());
        this.m_isOutline = dataDirector.isOutline();
        int n3 = dataAccess.getEdgeCount();
        if (n3 < 1) {
            return;
        }
        int n4 = this.getInitialRowCount();
        int n5 = 0;
        try {
            if (n3 >= 2) {
                n4 = dataAccess.getEdgeExtent(1);
            }
            if (n != -1 && n4 > n) {
                n4 = n;
            }
            n5 = dataAccess.getEdgeExtent(0);
            if (n2 != -1 && n5 > n2) {
                n5 = n2;
            }
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        this.m_data = new Data(this.m_dataMap, n4, n5);
        this.m_data.initializeDataSource(dataAccess);
        this.m_edges[0] = this.createRowColumnEdge(dataAccess, false, 0, this.m_metadataMap, this.m_layerMetadataMap, n2);
        if (n3 >= 2) {
            this.m_edges[1] = this.createRowColumnEdge(dataAccess, this.m_isOutline, 1, this.m_metadataMap, this.m_layerMetadataMap, n);
        }
        if (n3 >= 3) {
            this.m_edges[2] = new PageEdge(dataAccess, 2, this.m_metadataMap, this.m_layerMetadataMap);
        }
        try {
            QDR qDR = dataAccess.getValueQDR(0, 0, 0);
            if (qDR != null) {
                this.m_measureDim = qDR.getMeasureDim();
            }
        }
        catch (RowOutOfRangeException rowOutOfRangeException) {
        }
        catch (ColumnOutOfRangeException columnOutOfRangeException) {
            // empty catch block
        }
    }

    QDR createQDR() {
        return new QDR(this.m_measureDim);
    }
}

