/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.util.BitSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.event.EventListenerList;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewTitles;
import oracle.dss.dataView.FontList;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.SelectEvent;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.UIDataview;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.PagingControlAttributesAdapter;
import oracle.dss.util.WaitData;

public abstract class UIDataviewAdapter
extends PagingControlAttributesAdapter
implements UIDataview,
DataviewCommon {
    private boolean _userOverrideMode;
    private boolean _styleOverrideMode;
    protected DataviewTitles m_dataViewTitle;
    protected DataviewTitles m_dataViewSubtitle;
    protected DataviewTitles m_dataViewFootnote;
    protected Locale m_locale;
    protected ComponentHandle m_selectedObject;
    protected EventListenerList m_listenerList;
    protected TokenSubstitution m_token;
    protected ErrorHandler m_errorHandler = new DefaultErrorHandler();
    protected boolean m_customColorsEnabled;

    public UIDataviewAdapter() {
        this.m_dataViewTitle = null.new TitleAdapter(DataviewDefaultValues.getBaseTitleText(), null);
        this.m_dataViewSubtitle = null.new SubtitleAdapter(DataviewDefaultValues.getBaseTitleText(), null);
        this.m_dataViewFootnote = null.new FootnoteAdapter(DataviewDefaultValues.getBaseTitleText(), null);
    }

    public UIDataviewAdapter(UIDataview uIDataview) {
        this();
        this.initFromDataview(uIDataview);
    }

    public void initFromDataview(UIDataview uIDataview) {
        super.initFromPagingControlAttributes(uIDataview);
        this.m_locale = uIDataview.getLocale();
        this.setCustomColorsEnabled(uIDataview.isCustomColorsEnabled());
        this.m_selectedObject = uIDataview.getSelectedObject();
        this.initTitleAttributes(uIDataview);
    }

    public void applyToDataview(UIDataview uIDataview) {
        super.applyToPagingControlAttributes(uIDataview);
        this.applyTitleAttributes(uIDataview);
        uIDataview.setCustomColorsEnabled(this.isCustomColorsEnabled());
    }

    public Locale getLocale() {
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
        }
        return this.m_locale;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public ComponentHandle getSelectedObject() {
        return this.m_selectedObject;
    }

    public DataviewTitles getDataviewTitle() {
        return this.m_dataViewTitle;
    }

    public DataviewTitles getDataviewSubtitle() {
        return this.m_dataViewSubtitle;
    }

    public DataviewTitles getDataviewFootnote() {
        return this.m_dataViewFootnote;
    }

    public boolean selectObject(ComponentHandle componentHandle) {
        boolean bl = false;
        if (this.fireComponentSelecting(this, componentHandle)) {
            this.m_selectedObject = componentHandle;
            this.fireComponentSelected(this, componentHandle);
            bl = true;
        }
        return bl;
    }

    public void addControllerListener(ControllerListener controllerListener) {
        if (this.m_listenerList == null) {
            this.m_listenerList = new EventListenerList();
        }
        this.m_listenerList.add(Class.forName("oracle.dss.dataView.ControllerListener"), controllerListener);
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        if (this.m_listenerList != null) {
            this.m_listenerList.remove(Class.forName("oracle.dss.dataView.ControllerListener"), controllerListener);
        }
    }

    public abstract int getViewType();

    public void setTokenSubstitution(TokenSubstitution tokenSubstitution) {
        this.m_token = tokenSubstitution;
    }

    public TokenSubstitution getTokenSubstitution() {
        if (this.m_token == null) {
            this.m_token = new TokenSubstitutionAdapter(this);
        }
        return this.m_token;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    public FontList getFontList() {
        return null;
    }

    public int getZoomFactor() {
        return 0;
    }

    public Font scaleFont(Font font, int n) {
        return null;
    }

    public String getIntlString(String string) {
        return null;
    }

    public String getIntlString(String string, ResourceBundle resourceBundle) {
        String string2;
        if (resourceBundle == null) {
            return string;
        }
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            this.getErrorHandler().log(String.valueOf(String.valueOf("missing resource \"")) + string + "\" in " + resourceBundle.getClass().getName(), this.getClass().getName(), "getIntlString(String key, ResourceBundle rBundle)");
            String string3 = string;
            return string3;
        }
        return string2;
    }

    public boolean isLayerMetaShortLabelSupported() {
        return true;
    }

    public boolean isLayerMetaViewStyleSupported() {
        return true;
    }

    public boolean isMetadataViewStyleSupported() {
        return true;
    }

    public boolean isMetadataShortLabelSupported() {
        return true;
    }

    public boolean isDataUnformattedSupported() {
        return true;
    }

    public boolean isDataViewFormatSupported() {
        return true;
    }

    public boolean isMemberMetadataLabelTypeSupported(String string) {
        return true;
    }

    public boolean isLayerMetadataLabelTypeSupported(String string) {
        return true;
    }

    public String getLayerMetadataLabelType(int n) {
        return DataviewDefaultValues.getLayerMetadataLabelType(n);
    }

    public String getMemberMetadataLabelType(int n) {
        return DataviewDefaultValues.getMemberMetadataLabelType(n);
    }

    public void repaint() {
    }

    public void metadataStyleChanged() {
    }

    public void dataStyleChanged() {
    }

    public void dataFormatChanged() {
    }

    public WaitData getWaitDataForRow(int n) {
        return null;
    }

    public void setWaitDataForRow(int n, WaitData waitData) {
    }

    public Model getModel() {
        return null;
    }

    public int convertComponentTypeToInteger(String string) {
        return 0;
    }

    public String convertComponentTypeToString(int n) {
        return null;
    }

    public void setHTMLPagingControlAutosubmit(boolean bl) {
    }

    public boolean isHTMLPagingControlAutosubmit() {
        return true;
    }

    public void setHTMLPagingControlWidth(int n) {
    }

    public int getHTMLPagingControlWidth() {
        return -1;
    }

    protected void applyTitleAttributes(UIDataview uIDataview) {
        uIDataview.getDataviewTitle().setText(this.getDataviewTitle().getUnParseText());
        uIDataview.getDataviewSubtitle().setText(this.getDataviewSubtitle().getUnParseText());
        uIDataview.getDataviewFootnote().setText(this.getDataviewFootnote().getUnParseText());
        if (((TitleAdapter)this.getDataviewTitle()).isVisibleChanged()) {
            uIDataview.getDataviewTitle().setVisible(this.getDataviewTitle().isVisible());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isVisibleChanged()) {
            uIDataview.getDataviewSubtitle().setVisible(this.getDataviewSubtitle().isVisible());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isVisibleChanged()) {
            uIDataview.getDataviewFootnote().setVisible(this.getDataviewFootnote().isVisible());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isForegroundChanged()) {
            uIDataview.getDataviewTitle().setForeground(this.getDataviewTitle().getForeground());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isForegroundChanged()) {
            uIDataview.getDataviewSubtitle().setForeground(this.getDataviewSubtitle().getForeground());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isForegroundChanged()) {
            uIDataview.getDataviewFootnote().setForeground(this.getDataviewFootnote().getForeground());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isBackgroundChanged()) {
            uIDataview.getDataviewTitle().setBackground(this.getDataviewTitle().getBackground());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isBackgroundChanged()) {
            uIDataview.getDataviewSubtitle().setBackground(this.getDataviewSubtitle().getBackground());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isBackgroundChanged()) {
            uIDataview.getDataviewFootnote().setBackground(this.getDataviewFootnote().getBackground());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isHorizontalAlignmentChanged()) {
            uIDataview.getDataviewTitle().setHorizontalAlignment(this.getDataviewTitle().getHorizontalAlignment());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isHorizontalAlignmentChanged()) {
            uIDataview.getDataviewSubtitle().setHorizontalAlignment(this.getDataviewSubtitle().getHorizontalAlignment());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isHorizontalAlignmentChanged()) {
            uIDataview.getDataviewFootnote().setHorizontalAlignment(this.getDataviewFootnote().getHorizontalAlignment());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isFontChanged()) {
            uIDataview.getDataviewTitle().setFont(this.getDataviewTitle().getFont());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isFontChanged()) {
            uIDataview.getDataviewSubtitle().setFont(this.getDataviewSubtitle().getFont());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isFontChanged()) {
            uIDataview.getDataviewFootnote().setFont(this.getDataviewFootnote().getFont());
        }
        if (((TitleAdapter)this.getDataviewTitle()).isUnderlineChanged()) {
            uIDataview.getDataviewTitle().setUnderline(this.getDataviewTitle().isUnderline());
        }
        if (((SubtitleAdapter)this.getDataviewSubtitle()).isUnderlineChanged()) {
            uIDataview.getDataviewSubtitle().setUnderline(this.getDataviewSubtitle().isUnderline());
        }
        if (((FootnoteAdapter)this.getDataviewFootnote()).isUnderlineChanged()) {
            uIDataview.getDataviewFootnote().setUnderline(this.getDataviewFootnote().isUnderline());
        }
    }

    protected void initTitleAttributes(UIDataview uIDataview) {
        this.getDataviewTitle().setText(uIDataview.getDataviewTitle().getUnParseText());
        this.getDataviewSubtitle().setText(uIDataview.getDataviewSubtitle().getUnParseText());
        this.getDataviewFootnote().setText(uIDataview.getDataviewFootnote().getUnParseText());
        this.getDataviewTitle().setVisible(uIDataview.getDataviewTitle().isVisible());
        ((TitleAdapter)this.getDataviewTitle()).setVisibleChanged(false);
        this.getDataviewSubtitle().setVisible(uIDataview.getDataviewSubtitle().isVisible());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setVisibleChanged(false);
        this.getDataviewFootnote().setVisible(uIDataview.getDataviewFootnote().isVisible());
        ((FootnoteAdapter)this.getDataviewFootnote()).setVisibleChanged(false);
        this.getDataviewTitle().setForeground(uIDataview.getDataviewTitle().getForeground());
        ((TitleAdapter)this.getDataviewTitle()).setForegroundChanged(false);
        this.getDataviewSubtitle().setForeground(uIDataview.getDataviewSubtitle().getForeground());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setForegroundChanged(false);
        this.getDataviewFootnote().setForeground(uIDataview.getDataviewFootnote().getForeground());
        ((FootnoteAdapter)this.getDataviewFootnote()).setForegroundChanged(false);
        this.getDataviewTitle().setBackground(uIDataview.getDataviewTitle().getBackground());
        ((TitleAdapter)this.getDataviewTitle()).setBackgroundChanged(false);
        this.getDataviewSubtitle().setBackground(uIDataview.getDataviewSubtitle().getBackground());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setBackgroundChanged(false);
        this.getDataviewFootnote().setBackground(uIDataview.getDataviewFootnote().getBackground());
        ((FootnoteAdapter)this.getDataviewFootnote()).setBackgroundChanged(false);
        this.getDataviewTitle().setHorizontalAlignment(uIDataview.getDataviewTitle().getHorizontalAlignment());
        ((TitleAdapter)this.getDataviewTitle()).setHorizontalAlignmentChanged(false);
        this.getDataviewSubtitle().setHorizontalAlignment(uIDataview.getDataviewSubtitle().getHorizontalAlignment());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setHorizontalAlignmentChanged(false);
        this.getDataviewFootnote().setHorizontalAlignment(uIDataview.getDataviewFootnote().getHorizontalAlignment());
        ((FootnoteAdapter)this.getDataviewFootnote()).setHorizontalAlignmentChanged(false);
        this.getDataviewTitle().setFont(uIDataview.getDataviewTitle().getFont());
        ((TitleAdapter)this.getDataviewTitle()).setFontChanged(false);
        this.getDataviewSubtitle().setFont(uIDataview.getDataviewSubtitle().getFont());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setFontChanged(false);
        this.getDataviewFootnote().setFont(uIDataview.getDataviewFootnote().getFont());
        ((FootnoteAdapter)this.getDataviewFootnote()).setFontChanged(false);
        this.getDataviewTitle().setUnderline(uIDataview.getDataviewTitle().isUnderline());
        ((TitleAdapter)this.getDataviewTitle()).setUnderlineChanged(false);
        this.getDataviewSubtitle().setUnderline(uIDataview.getDataviewSubtitle().isUnderline());
        ((SubtitleAdapter)this.getDataviewSubtitle()).setUnderlineChanged(false);
        this.getDataviewFootnote().setUnderline(uIDataview.getDataviewFootnote().isUnderline());
        ((FootnoteAdapter)this.getDataviewFootnote()).setUnderlineChanged(false);
    }

    protected boolean fireComponentSelecting(Object object, ComponentHandle componentHandle) {
        boolean bl = true;
        if (this.m_listenerList != null) {
            SelectEvent selectEvent = new SelectEvent(object, 0, componentHandle);
            Object[] objectArray = this.m_listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                    ((ControllerListener)objectArray[n + 1]).componentSelecting(selectEvent);
                    if (selectEvent.isConsumed()) {
                        bl = false;
                    }
                }
                n -= 2;
            }
        }
        return bl;
    }

    protected void fireComponentSelected(Object object, ComponentHandle componentHandle) {
        if (this.m_listenerList != null) {
            SelectEvent selectEvent = new SelectEvent(object, 1, componentHandle);
            Object[] objectArray = this.m_listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                    ((ControllerListener)objectArray[n + 1]).componentSelected(selectEvent);
                }
                n -= 2;
            }
        }
    }

    public void setDataSource(DataSource dataSource) {
    }

    public DataSource getDataSource() {
        return null;
    }

    protected void cleanUp() {
        this.m_dataViewTitle = null;
        this.m_dataViewSubtitle = null;
        this.m_dataViewFootnote = null;
        this.m_locale = null;
        this.m_selectedObject = null;
        this.m_token = null;
        this.m_errorHandler = null;
        if (this.m_listenerList != null) {
            Object[] objectArray = this.m_listenerList.getListenerList();
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = null;
                ++n;
            }
        }
        this.m_listenerList = null;
    }

    public BitSet createPropertyOverrideFlags(int n) {
        return new BitSet(n);
    }

    public void setPropertyOverrideFlags(int n, BitSet bitSet, BitSet bitSet2) {
        if (bitSet != null && n >= 0 && n < bitSet.size()) {
            if (this.isUserOverrideMode()) {
                bitSet.set(n);
            }
            if (this.isStyleOverrideMode()) {
                bitSet2.set(n);
            }
        }
    }

    public boolean isPropertyOverrideFlag(int n, BitSet bitSet) {
        if (n >= 0 && n < bitSet.size()) {
            return bitSet.get(n);
        }
        return false;
    }

    public static void clearPropertyOverrideFlag(int n, BitSet bitSet) {
        if (n >= 0 && n < bitSet.size()) {
            bitSet.clear(n);
        }
    }

    public void setCustomColorsEnabled(boolean bl) {
        this.m_customColorsEnabled = bl;
    }

    public boolean isCustomColorsEnabled() {
        return this.m_customColorsEnabled;
    }

    protected void setStyleOverrideMode(boolean bl) {
        this._styleOverrideMode = bl;
    }

    protected boolean isStyleOverrideMode() {
        return this._styleOverrideMode;
    }

    protected void setUserOverrideMode(boolean bl) {
        this._userOverrideMode = bl;
    }

    protected boolean isUserOverrideMode() {
        return this._userOverrideMode;
    }

    private class FootnoteAdapter
    extends Footnote {
        private boolean m_bBackgroundChanged;
        private boolean m_bForegroundChanged;
        private boolean m_bVisibleChanged;
        private boolean m_bUnderlineChanged;
        private boolean m_bFontChanged;
        private boolean m_bHorizontalAlignmentChanged;

        public FootnoteAdapter(String string, Dataview dataview) {
            super(string, dataview);
        }

        public int getID() {
            return 8;
        }

        public String getComponentName() {
            return "DataviewFootnote";
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.setVisibleChanged(true);
        }

        public void setVisibleChanged(boolean bl) {
            this.m_bVisibleChanged = bl;
        }

        public boolean isVisibleChanged() {
            return this.m_bVisibleChanged;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.setBackgroundChanged(true);
        }

        public void setBackgroundChanged(boolean bl) {
            this.m_bBackgroundChanged = bl;
        }

        public boolean isBackgroundChanged() {
            return this.m_bBackgroundChanged;
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.setForegroundChanged(true);
        }

        public void setForegroundChanged(boolean bl) {
            this.m_bForegroundChanged = bl;
        }

        public boolean isForegroundChanged() {
            return this.m_bForegroundChanged;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.setFontChanged(true);
        }

        public void setFontChanged(boolean bl) {
            this.m_bFontChanged = bl;
        }

        public boolean isFontChanged() {
            return this.m_bFontChanged;
        }

        public void setHorizontalAlignment(int n) {
            super.setHorizontalAlignment(n);
            this.setHorizontalAlignmentChanged(true);
        }

        public void setHorizontalAlignmentChanged(boolean bl) {
            this.m_bHorizontalAlignmentChanged = bl;
        }

        public boolean isHorizontalAlignmentChanged() {
            return this.m_bHorizontalAlignmentChanged;
        }

        public void setUnderline(boolean bl) {
            super.setUnderline(bl);
            this.setUnderlineChanged(true);
        }

        public void setUnderlineChanged(boolean bl) {
            this.m_bUnderlineChanged = bl;
        }

        public boolean isUnderlineChanged() {
            return this.m_bUnderlineChanged;
        }
    }

    private class SubtitleAdapter
    extends Subtitle {
        private boolean m_bBackgroundChanged;
        private boolean m_bForegroundChanged;
        private boolean m_bVisibleChanged;
        private boolean m_bUnderlineChanged;
        private boolean m_bFontChanged;
        private boolean m_bHorizontalAlignmentChanged;

        public SubtitleAdapter(String string, Dataview dataview) {
            super(string, dataview);
        }

        public int getID() {
            return 7;
        }

        public String getComponentName() {
            return "DataviewSubtitle";
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.setVisibleChanged(true);
        }

        public void setVisibleChanged(boolean bl) {
            this.m_bVisibleChanged = bl;
        }

        public boolean isVisibleChanged() {
            return this.m_bVisibleChanged;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.setBackgroundChanged(true);
        }

        public void setBackgroundChanged(boolean bl) {
            this.m_bBackgroundChanged = bl;
        }

        public boolean isBackgroundChanged() {
            return this.m_bBackgroundChanged;
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.setForegroundChanged(true);
        }

        public void setForegroundChanged(boolean bl) {
            this.m_bForegroundChanged = bl;
        }

        public boolean isForegroundChanged() {
            return this.m_bForegroundChanged;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.setFontChanged(true);
        }

        public void setFontChanged(boolean bl) {
            this.m_bFontChanged = bl;
        }

        public boolean isFontChanged() {
            return this.m_bFontChanged;
        }

        public void setHorizontalAlignment(int n) {
            super.setHorizontalAlignment(n);
            this.setHorizontalAlignmentChanged(true);
        }

        public void setHorizontalAlignmentChanged(boolean bl) {
            this.m_bHorizontalAlignmentChanged = bl;
        }

        public boolean isHorizontalAlignmentChanged() {
            return this.m_bHorizontalAlignmentChanged;
        }

        public void setUnderline(boolean bl) {
            super.setUnderline(bl);
            this.setUnderlineChanged(true);
        }

        public void setUnderlineChanged(boolean bl) {
            this.m_bUnderlineChanged = bl;
        }

        public boolean isUnderlineChanged() {
            return this.m_bUnderlineChanged;
        }
    }

    private class TitleAdapter
    extends Title {
        private boolean m_bBackgroundChanged;
        private boolean m_bForegroundChanged;
        private boolean m_bVisibleChanged;
        private boolean m_bUnderlineChanged;
        private boolean m_bFontChanged;
        private boolean m_bHorizontalAlignmentChanged;

        public TitleAdapter(String string, Dataview dataview) {
            super(string, dataview);
        }

        public int getID() {
            return 6;
        }

        public String getComponentName() {
            return "DataviewTitle";
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.setVisibleChanged(true);
        }

        public void setVisibleChanged(boolean bl) {
            this.m_bVisibleChanged = bl;
        }

        public boolean isVisibleChanged() {
            return this.m_bVisibleChanged;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
            this.setBackgroundChanged(true);
        }

        public void setBackgroundChanged(boolean bl) {
            this.m_bBackgroundChanged = bl;
        }

        public boolean isBackgroundChanged() {
            return this.m_bBackgroundChanged;
        }

        public void setForeground(Color color) {
            super.setForeground(color);
            this.setForegroundChanged(true);
        }

        public void setForegroundChanged(boolean bl) {
            this.m_bForegroundChanged = bl;
        }

        public boolean isForegroundChanged() {
            return this.m_bForegroundChanged;
        }

        public void setFont(Font font) {
            super.setFont(font);
            this.setFontChanged(true);
        }

        public void setFontChanged(boolean bl) {
            this.m_bFontChanged = bl;
        }

        public boolean isFontChanged() {
            return this.m_bFontChanged;
        }

        public void setHorizontalAlignment(int n) {
            super.setHorizontalAlignment(n);
            this.setHorizontalAlignmentChanged(true);
        }

        public void setHorizontalAlignmentChanged(boolean bl) {
            this.m_bHorizontalAlignmentChanged = bl;
        }

        public boolean isHorizontalAlignmentChanged() {
            return this.m_bHorizontalAlignmentChanged;
        }

        public void setUnderline(boolean bl) {
            super.setUnderline(bl);
            this.setUnderlineChanged(true);
        }

        public void setUnderlineChanged(boolean bl) {
            this.m_bUnderlineChanged = bl;
        }

        public boolean isUnderlineChanged() {
            return this.m_bUnderlineChanged;
        }
    }
}

