/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.BeanInfo;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.scrolling.ArrowBox;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewPagingComponent;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.PagingControlAttributes;
import oracle.dss.dataView.PagingControlXML;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.util.xml.ObjectNode;

public class PagingControl
extends JPanel
implements ViewComponent,
MouseListener,
MouseMotionListener,
FocusListener,
PagingControlAttributes,
Styleable {
    protected DataviewPagingComponent m_pc;
    protected ArrowBox m_arrowBox;
    protected JLabel m_label;
    protected int m_zoomFactor = Dataview.DEFAULT_ZOOM_FACTOR;
    protected boolean m_fIsJavaPaging;
    private ResourceBundle rBundle;
    private Dataview m_view;
    private Model m_model;
    private Font m_defaultLabelFont;
    private PagingControlXML _pagingControlXML;
    private ViewStyle m_viewStyle;
    private boolean m_bSwapAllowed = true;
    private boolean m_bAllocatePC = true;
    private int m_previousItemCount;
    private int m_previousPageItemIndex = -1;

    public PagingControl(Dataview dataview, Model model) {
        this(dataview, model, null, true);
    }

    public PagingControl(Dataview dataview, Model model, DataviewPagingComponent dataviewPagingComponent) {
        this(dataview, model, dataviewPagingComponent, false);
    }

    private PagingControl(Dataview dataview, Model model, DataviewPagingComponent dataviewPagingComponent, boolean bl) {
        this.m_bAllocatePC = bl;
        this.m_pc = dataviewPagingComponent;
        if (dataview != null) {
            this.setLocale(dataview.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this.m_model = model;
        this.m_view = dataview;
        if (dataview != null) {
            this.m_fIsJavaPaging = dataview.isJavaComponent();
        }
        this._pagingControlXML = new PagingControlXML(this);
        this.init();
    }

    protected void init() {
        this.initUI();
    }

    protected void initUI() {
        this.setLayout(new BoxLayout(this, 0));
        String string = this.rBundle.getString("Page Items");
        this.m_label = new JLabel(string);
        this.add(this.m_label);
        this.m_defaultLabelFont = this.m_label.getFont();
        if (this.m_bAllocatePC) {
            this.m_pc = new DataviewPagingComponent(this.m_view, this.m_model);
        }
        if (this.m_pc != null) {
            this.m_pc.setPagingControl(this);
            if (this.m_viewStyle != null) {
                this.m_pc.setViewStyle(this.m_viewStyle);
            }
            this.m_pc.setZoomFactor(this.m_zoomFactor);
            this.m_pc.setEnabled(this.isEnabled());
            this.m_pc.setSwapAllowed(this.m_bSwapAllowed);
            this.m_pc.addMouseListener(this);
            this.m_pc.addMouseMotionListener(this);
        }
        this.m_arrowBox = this.getArrowBox((JComponent)((Object)this.m_pc));
        this.add((Component)this.m_arrowBox);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_label.addMouseListener(this);
        this.m_label.addMouseMotionListener(this);
        this.m_arrowBox.addMouseListener((MouseListener)this);
        this.m_arrowBox.addMouseMotionListener((MouseMotionListener)this);
    }

    public JLabel getLabel() {
        return this.m_label;
    }

    public DataviewPagingComponent getPagingComponent() {
        return this.m_pc;
    }

    public void updateCurrentPage() {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.updateCurrentPage();
        }
    }

    public void updatePageItems() {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            this.m_previousItemCount = dataviewPagingComponent.getComponentCount();
            this.getPagingComponent().newPageItems();
            int n = 0;
            while (n < dataviewPagingComponent.getComponentCount()) {
                this.addPIM((PageItem)dataviewPagingComponent.getComponent(n));
                ++n;
            }
        }
    }

    public int getPreviousPageItemIndex() {
        return this.m_previousPageItemIndex;
    }

    public void addPIM(PageItem pageItem) {
        pageItem.addMouseListener((MouseListener)this);
        pageItem.addMouseMotionListener((MouseMotionListener)this);
        pageItem.addFocusListener((FocusListener)this);
        pageItem.getComponent(0).addMouseListener(this);
        pageItem.getComponent(0).addMouseMotionListener(this);
        pageItem.getComponent(1).addMouseListener(this);
        pageItem.getComponent(1).addMouseMotionListener(this);
    }

    public int getID() {
        return 3;
    }

    public String getComponentName() {
        return "PageHeader";
    }

    public BeanInfo getBeanInfo() {
        return null;
    }

    public int getEdge() {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            return dataviewPagingComponent.getEdge();
        }
        return 2;
    }

    public Dataview getView() {
        return this.m_view;
    }

    public ViewStyle getViewStyle() {
        ViewStyle viewStyle = null;
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            viewStyle = dataviewPagingComponent.getViewStyle();
        } else {
            if (this.m_viewStyle == null) {
                this.m_viewStyle = new ViewStyle();
                this.m_viewStyle.setView(this.m_view);
            }
            viewStyle = this.m_viewStyle;
        }
        return viewStyle;
    }

    public void setViewStyle(ViewStyle viewStyle) {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.setViewStyle(viewStyle);
        } else {
            this.m_viewStyle = (ViewStyle)viewStyle.clone();
            this.m_viewStyle.setView(this.m_view);
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.updateResourceBundle(locale);
    }

    private void updateResourceBundle(Locale locale) {
        this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle", locale) : ResourceBundle.getBundle("oracle.dss.dataView.resource.DataviewBundle");
        if (this.m_label != null) {
            this.m_label.setText(this.rBundle.getString("Page Items"));
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(this.convertMouseEvent(mouseEvent));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.processMouseMotionEvent(this.convertMouseEvent(mouseEvent));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.processMouseEvent(this.convertMouseEvent(mouseEvent));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.processMouseEvent(this.convertMouseEvent(mouseEvent));
        if (mouseEvent.getSource() instanceof JComponent && ((JComponent)mouseEvent.getSource()).getParent() instanceof PageItem && SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.getPagingComponent().setSelectedItem((PageItem)((JComponent)mouseEvent.getSource()).getParent());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.processMouseEvent(this.convertMouseEvent(mouseEvent));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.processMouseEvent(this.convertMouseEvent(mouseEvent));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.processMouseEvent(this.convertMouseEvent(mouseEvent));
    }

    public void focusGained(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            int n = this.getPagingComponent().getIndex((PageItem)focusEvent.getSource());
            int n2 = this.getPagingComponent().getComponentCount();
            if (n == -1) {
                if (n2 > 0) {
                    PageItem pageItem;
                    if (this.m_previousPageItemIndex > n2 - 1) {
                        this.m_previousPageItemIndex = n2 - 1;
                        pageItem = this.getPagingComponent().getItem(this.m_previousPageItemIndex);
                    } else if (n2 == this.m_previousItemCount) {
                        pageItem = this.getPagingComponent().getItem(this.m_previousPageItemIndex);
                    } else {
                        --this.m_previousPageItemIndex;
                        if (this.m_previousPageItemIndex < 0) {
                            this.m_previousPageItemIndex = 0;
                        }
                        pageItem = this.getPagingComponent().getItem(this.m_previousPageItemIndex);
                    }
                    pageItem.requestFocus();
                    return;
                }
            } else {
                this.m_previousPageItemIndex = n;
            }
        }
        this.processFocusEvent(focusEvent);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.processFocusEvent(focusEvent);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.m_pc != null) {
            this.m_pc.setEnabled(bl);
        }
    }

    public void setZoomFactor(int n) {
        this.m_zoomFactor = n;
        if (this.m_pc != null) {
            this.m_pc.setZoomFactor(n);
            if (n != Dataview.DEFAULT_ZOOM_FACTOR) {
                this.m_label.setFont(this.m_view.scaleFont(this.m_defaultLabelFont, n));
            } else {
                this.m_label.setFont(this.m_defaultLabelFont);
            }
            this.updatePageItemStyles();
        }
    }

    protected void updatePageItemStyles() {
    }

    public void setXML(ObjectNode objectNode, String string, int n) {
        this._pagingControlXML.setXML(objectNode, string, n);
    }

    public ObjectNode getXML(boolean bl) {
        return this._pagingControlXML.getXML(bl);
    }

    protected void resetToDefault(int n) {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.resetToDefault(n);
        } else {
            this.getViewStyle().resetToDefault(n);
        }
    }

    protected ArrowBox getArrowBox(JComponent jComponent) {
        return new ArrowBox((Component)jComponent);
    }

    protected MouseEvent convertMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JComponent && ((JComponent)mouseEvent.getSource()).getParent() instanceof PageItem) {
            return this.createPageItemMouseEvent(mouseEvent);
        }
        return this.createPageControlMouseEvent(mouseEvent);
    }

    protected MouseEvent createPageItemMouseEvent(MouseEvent mouseEvent) {
        return new MouseEvent(((JComponent)mouseEvent.getSource()).getParent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    protected MouseEvent createPageControlMouseEvent(MouseEvent mouseEvent) {
        return new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
    }

    public void setSwapAllowed(boolean bl) {
        this.m_bSwapAllowed = bl;
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            dataviewPagingComponent.setSwapAllowed(bl);
        }
    }

    public boolean isSwapAllowed() {
        DataviewPagingComponent dataviewPagingComponent = this.getPagingComponent();
        if (dataviewPagingComponent != null) {
            return dataviewPagingComponent.isSwapAllowed();
        }
        return this.m_bSwapAllowed;
    }
}

