/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.Model;
import oracle.dss.util.DataException;

public class PageItemData
implements OneDModel {
    protected int[] m_depthIndex;
    protected int m_depth;
    protected Model m_model;
    protected Dataview m_view;
    private int m_itemCount;
    private Object[] m_members;
    private boolean[] m_membersCached;

    public PageItemData(Dataview dataview, int[] nArray, int n) {
        this.m_view = dataview;
        this.m_model = dataview.getModel();
        this.m_depthIndex = nArray;
        this.m_depth = n;
        if (this.m_depthIndex[this.m_depth] != -1) {
            try {
                this.m_itemCount = this.m_model.getDataAccess().getMemberSiblingCount(2, this.m_depthIndex, this.m_depth);
            }
            catch (DataException dataException) {
                this.m_model.getErrorHandler().log(String.valueOf(String.valueOf("could not get MemberSiblingCount for page layer ")) + this.m_depth, this.getClass().getName(), "public PageItemData(Dataview v, int[] depthIndex, int depth)");
            }
        }
        if (this.m_itemCount < 0) {
            this.m_itemCount = 0;
        }
        this.m_members = new Object[this.m_itemCount];
        this.m_membersCached = new boolean[this.m_itemCount];
        int n2 = 0;
        while (n2 < this.m_itemCount) {
            this.m_members[n2] = null;
            this.m_membersCached[n2] = false;
            ++n2;
        }
    }

    public int getItemCount() {
        return this.m_itemCount;
    }

    public Object getData(int n) {
        Object object = null;
        if (this.m_depthIndex[this.m_depth] != -1 && this.m_membersCached != null && this.m_membersCached.length > 0) {
            if (n >= 0 && n < this.m_membersCached.length && this.m_membersCached[n]) {
                object = this.m_members[n];
            } else {
                try {
                    String string = this.m_view.getMemberMetadataLabelType(2);
                    if (this.m_view.isMemberMetadataLabelTypeSupported(string)) {
                        object = this.m_model.getDataAccess().getMemberMetadata(2, this.m_depthIndex, this.m_depth, n, string);
                    }
                }
                catch (DataException dataException) {
                    this.m_model.getErrorHandler().error(dataException, this.getClass().getName(), "getData");
                }
                if (n >= 0 && n < this.m_membersCached.length) {
                    this.m_members[n] = object;
                    this.m_membersCached[n] = true;
                }
            }
        }
        return object;
    }

    public void setData(int n, Object object) {
    }

    public void addModelListener(OneDModelListener oneDModelListener) {
    }

    public void removeModelListener(OneDModelListener oneDModelListener) {
    }
}

