/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import oracle.dss.dataView.CustomHeaderAndFooterCallback;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.TokenSubstitution;

public class HeaderAndFooterPainter {
    public static final int NONE = 0;
    public static final int DATE = 1;
    public static final int PAGE_NUMBER = 2;
    public static final int STRINGS = 4;
    private Dataview _view;
    private int _headerOrFooterID;
    private int _hAlignment;
    private int _contentType;
    private String[] _string;
    private String[] _callbackString;
    private int _pageNum;
    private int _maximumHeight;
    private TokenSubstitution m_tokenSubstitution;
    private int _margin = 18;
    private static final String m_constructor = "HeaderAndFooterPainter(Dataview view, int headerOrFooterID, Font font, Object[] content, int contentType)";
    private static final String m_method_setcontenttype = "setContentType(int contentType)";
    private static final String m_method_sethorizontalalignment = "setHorizontalAlignment(int hAlignment)";
    private static final String m_method_paint = "paint(Graphics g, int x, int y, int width, int height, CustomHeaderAndFooterCallback callback, int physPageNum)";
    private static final String m_method_calcmaximumheight = "calcMaximumHeight (Graphics g, CustomHeaderAndFooterCallback callback)";
    private String currentDate;
    private Font defaultFont;

    public HeaderAndFooterPainter(Dataview dataview, int n, Font font, Object[] objectArray, int n2) {
        this.initialize(dataview, n, font, objectArray, n2);
    }

    public HeaderAndFooterPainter(boolean bl, Font font, String string, boolean bl2, boolean bl3, boolean bl4) {
        int n = bl ? 2 : 32;
        Object[] objectArray = new String[]{string};
        int n2 = bl2 ? 4 : (bl3 ? 1 : (bl4 ? 2 : 0));
        this.initialize(null, n, font, objectArray, n2);
    }

    private void initialize(Dataview dataview, int n, Font font, Object[] objectArray, int n2) {
        this._view = dataview;
        this._headerOrFooterID = n;
        switch (n) {
            case 2: 
            case 32: {
                this._hAlignment = 0;
                break;
            }
            case 4: 
            case 64: {
                this._hAlignment = 4;
                break;
            }
            case 1: 
            case 16: {
                this._hAlignment = 2;
                break;
            }
            default: {
                this._hAlignment = 2;
                this._headerOrFooterID = 1;
                if (this._view == null) break;
                this._view.getErrorHandler().log("invalid headerOrFooterID", this.getClass().getName(), m_constructor);
            }
        }
        this._string = this.verifyObjArray(objectArray) ? this.fastcopy(objectArray) : this.convertObjToStringArray(objectArray, m_constructor);
        this.defaultFont = font == null ? new Font("SansSerif", 0, 10) : font;
        this._contentType = n2;
        switch (n2) {
            case 1: {
                this.initDate();
            }
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                this._contentType = 0;
                if (this._view == null) break;
                this._view.getErrorHandler().log("invalid contentType", this.getClass().getName(), m_constructor);
            }
        }
    }

    public void setString(String string) {
        this._string = new String[1];
        this._string[0] = string;
    }

    public String getString() {
        if (this._string == null) {
            return null;
        }
        return this._string[0];
    }

    public void setShowString(boolean bl) {
        this._contentType = bl ? 4 : 0;
    }

    public boolean isShowString() {
        return (this._contentType & 4) > 0;
    }

    public void setShowDate(boolean bl) {
        if (bl) {
            this.initDate();
            this._contentType = 1;
        } else {
            this.currentDate = null;
            this._contentType = 0;
        }
    }

    public boolean isShowDate() {
        return (this._contentType & 1) > 0;
    }

    public void setShowPageNumber(boolean bl) {
        this._contentType = bl ? 2 : 0;
    }

    public boolean isShowPageNumber() {
        return (this._contentType & 2) > 0;
    }

    public void setStrings(String[] stringArray) {
        this._string = stringArray;
    }

    public String[] getStrings() {
        return this._string;
    }

    private String[] getParsedStrings(String[] stringArray) {
        if (this.m_tokenSubstitution == null || stringArray == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = stringArray[n] != null ? this.m_tokenSubstitution.getParsedString(stringArray[n]) : null;
            ++n;
        }
        return stringArray2;
    }

    public void setContentType(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 0) {
            if (this._view != null) {
                this._view.getErrorHandler().log("invalid content type", this.getClass().getName(), m_method_setcontenttype);
            }
            return;
        }
        this._contentType = n;
        if (this._contentType == 1) {
            this.initDate();
        }
    }

    public int getContentType() {
        return this._contentType;
    }

    public void setHorizontalAlignment(int n) {
        if (n == 2 || n == 0 || n == 4) {
            this._hAlignment = n;
        } else if (this._view != null) {
            this._view.getErrorHandler().log("invalid horizontal alignment", this.getClass().getName(), m_method_sethorizontalalignment);
        }
    }

    public int getHorizontalAlignment() {
        return this._hAlignment;
    }

    public void setPageNumber(int n) {
        this._pageNum = n;
    }

    public int getPageNumber() {
        return this._pageNum;
    }

    public void setFont(Font font) {
        this.defaultFont = font;
    }

    public Font getFont() {
        return this.defaultFont;
    }

    private void initDate() {
        Locale locale = null;
        if (this._view != null) {
            locale = this._view.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Calendar calendar = null;
        boolean bl = locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0;
        calendar = bl ? new GregorianCalendar(locale) : Calendar.getInstance(locale);
        DateFormat dateFormat = (DateFormat)DateFormat.getDateInstance(3, locale).clone();
        if (bl) {
            dateFormat.setCalendar(calendar);
        }
        dateFormat.setTimeZone(TimeZone.getDefault());
        this.currentDate = dateFormat.format(calendar.getTime());
    }

    private String[] fastcopy(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray instanceof String[]) {
            return (String[])objectArray;
        }
        String[] stringArray = new String[objectArray.length];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        return stringArray;
    }

    private String[] getText(int n) {
        String[] stringArray = null;
        if (this._contentType == 4) {
            stringArray = this.getParsedStrings(this._string);
        } else {
            stringArray = new String[1];
            if (this._contentType == 1) {
                stringArray[0] = this.currentDate;
            } else if (this._contentType == 2) {
                stringArray[0] = String.valueOf(n);
            } else {
                stringArray = null;
            }
        }
        return stringArray;
    }

    private boolean verifyObjArray(Object[] objectArray) {
        if (objectArray instanceof String[] || objectArray == null) {
            return true;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (!(objectArray[n] instanceof String)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private String[] convertObjToStringArray(Object[] objectArray, String string) {
        Vector<Object> vector = new Vector<Object>();
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] instanceof String) {
                vector.addElement(objectArray[n2]);
                ++n;
            } else if (this._view != null) {
                this._view.getErrorHandler().log("Object array contains non-string element", this.getClass().getName(), string);
            }
            ++n2;
        }
        if (n > 0) {
            Object[] objectArray2 = new String[n];
            vector.copyInto(objectArray2);
            return objectArray2;
        }
        return null;
    }

    protected int calcMaximumHeight(Graphics graphics, CustomHeaderAndFooterCallback customHeaderAndFooterCallback, int n, int[] nArray) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.defaultFont);
        Object[] objectArray = this.getText(n);
        this._pageNum = n;
        if (customHeaderAndFooterCallback != null) {
            if (!this.verifyObjArray(objectArray = customHeaderAndFooterCallback.getDynamicContent(this._headerOrFooterID, objectArray, n, nArray))) {
                objectArray = this.convertObjToStringArray(objectArray, m_method_calcmaximumheight);
            }
            this._callbackString = this.fastcopy(objectArray);
        } else {
            this._callbackString = null;
        }
        this._maximumHeight = objectArray == null ? 0 : fontMetrics.getHeight() * objectArray.length - fontMetrics.getLeading() * 2 + this._margin;
        return this._maximumHeight;
    }

    public int getMaximumHeight() {
        return this._maximumHeight;
    }

    public int getMinimumHeight(Graphics graphics) {
        if (this._contentType == 0) {
            return 0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.defaultFont);
        int n = fontMetrics.getHeight() - fontMetrics.getLeading() + this._margin;
        return n;
    }

    protected void setMargin(int n) {
        this._margin = n;
    }

    protected int getMargin() {
        return this._margin;
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4) {
        this.paint(graphics, n, n2, n3, n4, null, this._pageNum, null);
    }

    public void paint(Graphics graphics, int n, int n2, int n3, int n4, CustomHeaderAndFooterCallback customHeaderAndFooterCallback, int n5, int[] nArray) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.defaultFont);
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        graphics.setFont(this.defaultFont);
        graphics.setColor(Color.black);
        Shape shape = graphics.getClip();
        graphics.setClip(0, n2, n3, n4);
        n2 += fontMetrics.getAscent();
        int n6 = fontMetrics.getHeight();
        n2 = this._headerOrFooterID == 1 || this._headerOrFooterID == 2 || this._headerOrFooterID == 4 ? (n2 += this._margin - 2 * fontMetrics.getLeading()) : (n2 += 2 * fontMetrics.getLeading());
        Object[] objectArray = this.getText(n5);
        if (customHeaderAndFooterCallback != null) {
            if (this._callbackString == null) {
                Object[] objectArray2 = customHeaderAndFooterCallback.getDynamicContent(this._headerOrFooterID, objectArray, n5, nArray);
                objectArray = this.verifyObjArray(objectArray2) ? this.fastcopy(objectArray2) : this.convertObjToStringArray(objectArray2, m_method_paint);
            } else {
                objectArray = this._callbackString;
                this._callbackString = null;
            }
        }
        n3 /= 3;
        if (objectArray != null) {
            int n7 = n;
            int n8 = n2;
            int n9 = 0;
            while (n9 < objectArray.length) {
                if (objectArray[n9] == null) {
                    n8 += n6;
                } else {
                    if (this._hAlignment != 2) {
                        int n10 = 0;
                        int n11 = fontMetrics.stringWidth((String)objectArray[n9]);
                        if (this._hAlignment == 0) {
                            n10 = (n3 - n11) / 2;
                        } else if (this._hAlignment == 4) {
                            n10 = n3 - n11;
                        }
                        n7 = n + n10;
                    }
                    graphics.drawString((String)objectArray[n9], n7, n8);
                    n8 += n6;
                }
                ++n9;
            }
        }
        graphics.setClip(shape);
        graphics.setFont(font);
        graphics.setColor(color);
    }

    public void setTokenSubstitution(TokenSubstitution tokenSubstitution) {
        this.m_tokenSubstitution = tokenSubstitution;
    }

    public TokenSubstitution getTokenSubstitution() {
        return this.m_tokenSubstitution;
    }
}

