/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import javax.swing.JPopupMenu;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.util.MenuUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.Controller;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.ControllerListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewPagingComponent;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.ManagerAdapter;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.PopupManager;
import oracle.dss.dataView.RolloverTextManager;
import oracle.dss.dataView.SelectEvent;
import oracle.dss.dataView.SelectionManager;
import oracle.dss.dataView.SizeEvent;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.dataView.ViewFocusEvent;
import oracle.dss.dataView.ViewFocusListener;
import oracle.dss.dataView.ViewKeyEvent;
import oracle.dss.dataView.ViewKeyListener;
import oracle.dss.dataView.ViewMouseEvent;
import oracle.dss.dataView.ViewMouseListener;
import oracle.dss.dataView.ViewMouseMotionListener;

public abstract class ControllerAdapter
implements Controller,
Serializable,
FocusListener,
MouseMotionListener,
MouseListener,
KeyListener {
    public static final boolean DEBUG = false;
    protected MouseEvent mouseEvent;
    private Dataview view;
    protected EventListenerList listenerList = new EventListenerList();
    private SelectionManager selectionManager = ManagerAdapter.getInstance();
    private PopupManager popupManager = ManagerAdapter.getInstance();
    private RolloverTextManager rolloverManager = ManagerAdapter.getInstance();
    protected Cursor m_defaultCursor;
    protected Cursor m_moveCursor;
    protected Cursor m_waitCursor;
    protected Cursor m_nResizeCursor;
    protected Cursor m_sResizeCursor;
    protected Cursor m_eResizeCursor;
    protected Cursor m_wResizeCursor;
    protected Cursor m_neResizeCursor;
    protected Cursor m_swResizeCursor;
    protected Cursor m_nwResizeCursor;
    protected Cursor m_seResizeCursor;
    protected Cursor m_selectCursor;
    protected Cursor m_textCursor;
    protected Cursor m_drillCursor;
    protected Cursor m_noDropCursor;
    protected Cursor m_vertSplitCursor;
    protected Cursor m_horzSplitCursor;
    protected boolean m_isWaitCursor;
    protected int m_viewPositionX;
    protected int m_viewPositionY;
    protected int m_viewSizeWidth;
    protected int m_viewSizeHeight;
    protected boolean m_viewSizeSet;

    public ControllerAdapter(Dataview dataview) {
        this.view = dataview;
        ((BaseTitle)dataview.getDataviewTitle()).addFocusListener(this);
        ((BaseTitle)dataview.getDataviewTitle()).addMouseMotionListener(this);
        ((BaseTitle)dataview.getDataviewTitle()).addMouseListener(this);
        ((BaseTitle)dataview.getDataviewTitle()).addKeyListener(this);
        ((BaseTitle)dataview.getDataviewSubtitle()).addFocusListener(this);
        ((BaseTitle)dataview.getDataviewSubtitle()).addMouseMotionListener(this);
        ((BaseTitle)dataview.getDataviewSubtitle()).addMouseListener(this);
        ((BaseTitle)dataview.getDataviewSubtitle()).addKeyListener(this);
        ((BaseTitle)dataview.getDataviewFootnote()).addFocusListener(this);
        ((BaseTitle)dataview.getDataviewFootnote()).addMouseMotionListener(this);
        ((BaseTitle)dataview.getDataviewFootnote()).addMouseListener(this);
        ((BaseTitle)dataview.getDataviewFootnote()).addKeyListener(this);
        this.m_isWaitCursor = false;
        this.m_defaultCursor = Cursor.getPredefinedCursor(0);
        this.m_moveCursor = Cursor.getPredefinedCursor(13);
        this.m_waitCursor = Cursor.getPredefinedCursor(3);
        this.m_nResizeCursor = Cursor.getPredefinedCursor(8);
        this.m_sResizeCursor = Cursor.getPredefinedCursor(9);
        this.m_eResizeCursor = Cursor.getPredefinedCursor(11);
        this.m_wResizeCursor = Cursor.getPredefinedCursor(10);
        this.m_neResizeCursor = Cursor.getPredefinedCursor(7);
        this.m_swResizeCursor = Cursor.getPredefinedCursor(4);
        this.m_nwResizeCursor = Cursor.getPredefinedCursor(6);
        this.m_seResizeCursor = Cursor.getPredefinedCursor(5);
        this.m_selectCursor = Cursor.getPredefinedCursor(1);
        this.m_textCursor = Cursor.getPredefinedCursor(2);
        this.m_drillCursor = Cursor.getPredefinedCursor(12);
        this.m_noDropCursor = Cursor.getPredefinedCursor(0);
        this.m_vertSplitCursor = Cursor.getPredefinedCursor(0);
        this.m_horzSplitCursor = Cursor.getPredefinedCursor(0);
    }

    public void addControllerListener(ControllerListener controllerListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ControllerListener"), controllerListener);
    }

    public void removeControllerListener(ControllerListener controllerListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ControllerListener"), controllerListener);
    }

    public void addViewMouseListener(ViewMouseListener viewMouseListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ViewMouseListener"), viewMouseListener);
    }

    public void removeViewMouseListener(ViewMouseListener viewMouseListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ViewMouseListener"), viewMouseListener);
    }

    public void addViewMouseMotionListener(ViewMouseMotionListener viewMouseMotionListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ViewMouseMotionListener"), viewMouseMotionListener);
    }

    public void removeViewMouseMotionListener(ViewMouseMotionListener viewMouseMotionListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ViewMouseMotionListener"), viewMouseMotionListener);
    }

    public void addViewKeyListener(ViewKeyListener viewKeyListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ViewKeyListener"), viewKeyListener);
    }

    public void removeViewKeyListener(ViewKeyListener viewKeyListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ViewKeyListener"), viewKeyListener);
    }

    public void addViewFocusListener(ViewFocusListener viewFocusListener) {
        this.listenerList.add(Class.forName("oracle.dss.dataView.ViewFocusListener"), viewFocusListener);
    }

    public void removeViewFocusListener(ViewFocusListener viewFocusListener) {
        this.listenerList.remove(Class.forName("oracle.dss.dataView.ViewFocusListener"), viewFocusListener);
    }

    public void setPopupManager(PopupManager popupManager) {
        this.popupManager = popupManager;
    }

    public PopupManager getPopupManager() {
        return this.popupManager;
    }

    public void setRolloverTextManager(RolloverTextManager rolloverTextManager) {
        this.rolloverManager = rolloverTextManager;
    }

    public RolloverTextManager getRolloverTextManager() {
        return this.rolloverManager;
    }

    public void focusGained(FocusEvent focusEvent) {
        NonDataComponentHandle nonDataComponentHandle = this.getNonDataComponent((ViewComponent)focusEvent.getSource());
        this.processViewFocusEvent(focusEvent, nonDataComponentHandle);
    }

    public void focusLost(FocusEvent focusEvent) {
        NonDataComponentHandle nonDataComponentHandle = this.getNonDataComponent((ViewComponent)focusEvent.getSource());
        if (!focusEvent.isTemporary()) {
            this.changeTitleSelectedState(false);
        }
        this.processViewFocusEvent(focusEvent, nonDataComponentHandle);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseMotionEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseMotionEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        this.processViewMouseEvent(mouseEvent, this.getNonDataComponent((ViewComponent)mouseEvent.getSource()));
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.processViewKeyEvent(keyEvent, this.getNonDataComponent((ViewComponent)keyEvent.getSource()));
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.processViewKeyEvent(keyEvent, this.getNonDataComponent((ViewComponent)keyEvent.getSource()));
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.processViewKeyEvent(keyEvent, this.getNonDataComponent((ViewComponent)keyEvent.getSource()));
    }

    public void cleanUp() {
        ((Title)this.view.getDataviewTitle()).removeFocusListener(this);
        ((Title)this.view.getDataviewTitle()).removeMouseMotionListener(this);
        ((Title)this.view.getDataviewTitle()).removeMouseListener(this);
        ((Title)this.view.getDataviewTitle()).removeKeyListener(this);
        ((Subtitle)this.view.getDataviewSubtitle()).removeFocusListener(this);
        ((Subtitle)this.view.getDataviewSubtitle()).removeMouseMotionListener(this);
        ((Subtitle)this.view.getDataviewSubtitle()).removeMouseListener(this);
        ((Subtitle)this.view.getDataviewSubtitle()).removeKeyListener(this);
        ((Footnote)this.view.getDataviewFootnote()).removeFocusListener(this);
        ((Footnote)this.view.getDataviewFootnote()).removeMouseMotionListener(this);
        ((Footnote)this.view.getDataviewFootnote()).removeMouseListener(this);
        ((Footnote)this.view.getDataviewFootnote()).removeKeyListener(this);
    }

    protected void setSelectionManager(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    protected SelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    protected void processViewMouseEvent(MouseEvent mouseEvent, ComponentHandle componentHandle) {
        ViewMouseEvent viewMouseEvent = new ViewMouseEvent(mouseEvent, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ViewMouseListener")) {
                ViewMouseListener viewMouseListener = (ViewMouseListener)objectArray[n + 1];
                switch (viewMouseEvent.getID()) {
                    case 500: {
                        viewMouseListener.mouseClicked(viewMouseEvent);
                        break;
                    }
                    case 501: {
                        viewMouseListener.mousePressed(viewMouseEvent);
                        break;
                    }
                    case 502: {
                        viewMouseListener.mouseReleased(viewMouseEvent);
                        break;
                    }
                    case 504: {
                        viewMouseListener.mouseEntered(viewMouseEvent);
                        break;
                    }
                    case 505: {
                        viewMouseListener.mouseExited(viewMouseEvent);
                    }
                }
                if (viewMouseEvent.isConsumed()) {
                    mouseEvent.consume();
                }
            }
            n -= 2;
        }
        if (this.view.isEnabled() && mouseEvent.isPopupTrigger()) {
            this.processPopup(mouseEvent, componentHandle);
        }
    }

    protected void processPopup(MouseEvent mouseEvent, ComponentHandle componentHandle) {
        ControllerEvent controllerEvent = new ControllerEvent(mouseEvent.getSource(), componentHandle);
        if (this.firePopupTriggering(controllerEvent)) {
            return;
        }
        JPopupMenu jPopupMenu = this.getPopupManager().getPopupMenu(this.view, componentHandle);
        if (jPopupMenu != null) {
            MenuUtils.showPopupMenu((JPopupMenu)jPopupMenu, (Component)((Component)mouseEvent.getSource()), (int)mouseEvent.getX(), (int)mouseEvent.getY());
        }
        this.firePopupTriggered(controllerEvent);
    }

    protected void processViewMouseMotionEvent(MouseEvent mouseEvent, ComponentHandle componentHandle) {
        ViewMouseEvent viewMouseEvent = new ViewMouseEvent(mouseEvent, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ViewMouseMotionListener")) {
                ViewMouseMotionListener viewMouseMotionListener = (ViewMouseMotionListener)objectArray[n + 1];
                switch (viewMouseEvent.getID()) {
                    case 506: {
                        viewMouseMotionListener.mouseDragged(viewMouseEvent);
                        break;
                    }
                    case 503: {
                        viewMouseMotionListener.mouseMoved(viewMouseEvent);
                    }
                }
                if (viewMouseEvent.isConsumed()) {
                    mouseEvent.consume();
                }
            }
            n -= 2;
        }
    }

    protected void processViewKeyEvent(KeyEvent keyEvent, ComponentHandle componentHandle) {
        ViewKeyEvent viewKeyEvent = new ViewKeyEvent(keyEvent, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ViewKeyListener")) {
                ViewKeyListener viewKeyListener = (ViewKeyListener)objectArray[n + 1];
                switch (viewKeyEvent.getID()) {
                    case 401: {
                        viewKeyListener.keyPressed(viewKeyEvent);
                        break;
                    }
                    case 402: {
                        viewKeyListener.keyReleased(viewKeyEvent);
                        break;
                    }
                    case 400: {
                        viewKeyListener.keyTyped(viewKeyEvent);
                    }
                }
                keyEvent.setKeyCode(viewKeyEvent.getKeyCode());
                keyEvent.setKeyChar(viewKeyEvent.getKeyChar());
                if (viewKeyEvent.isConsumed()) {
                    keyEvent.consume();
                }
            }
            n -= 2;
        }
    }

    protected void processViewFocusEvent(FocusEvent focusEvent, ComponentHandle componentHandle) {
        ViewFocusEvent viewFocusEvent = new ViewFocusEvent(focusEvent, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ViewFocusListener")) {
                ViewFocusListener viewFocusListener = (ViewFocusListener)objectArray[n + 1];
                switch (viewFocusEvent.getID()) {
                    case 1004: {
                        viewFocusListener.focusGained(viewFocusEvent);
                        break;
                    }
                    case 1005: {
                        viewFocusListener.focusLost(viewFocusEvent);
                    }
                }
            }
            n -= 2;
        }
    }

    protected boolean fireComponentSizing(Object object, ComponentHandle componentHandle) {
        SizeEvent sizeEvent = new SizeEvent(object, 0, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        boolean bl = true;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                ((ControllerListener)objectArray[n + 1]).componentSizing(sizeEvent);
                if (sizeEvent.isConsumed()) {
                    bl = false;
                }
            }
            n -= 2;
        }
        return bl;
    }

    protected void fireComponentSized(Object object, ComponentHandle componentHandle) {
        SizeEvent sizeEvent = new SizeEvent(object, 1, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                ((ControllerListener)objectArray[n + 1]).componentSized(sizeEvent);
            }
            n -= 2;
        }
    }

    protected boolean fireComponentSelecting(Object object, ComponentHandle componentHandle) {
        SelectEvent selectEvent = new SelectEvent(object, 0, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        boolean bl = true;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                ((ControllerListener)objectArray[n + 1]).componentSelecting(selectEvent);
                if (selectEvent.isConsumed()) {
                    bl = false;
                }
            }
            n -= 2;
        }
        return bl;
    }

    protected void fireComponentSelected(Object object, ComponentHandle componentHandle) {
        SelectEvent selectEvent = new SelectEvent(object, 1, componentHandle);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                ((ControllerListener)objectArray[n + 1]).componentSelected(selectEvent);
            }
            n -= 2;
        }
    }

    protected boolean firePopupTriggering(ControllerEvent controllerEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        boolean bl = false;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                ((ControllerListener)objectArray[n + 1]).popupTriggering(controllerEvent);
                if (controllerEvent.isConsumed()) {
                    bl = true;
                }
            }
            n -= 2;
        }
        return bl;
    }

    protected void firePopupTriggered(ControllerEvent controllerEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == Class.forName("oracle.dss.dataView.ControllerListener")) {
                ((ControllerListener)objectArray[n + 1]).popupTriggered(controllerEvent);
            }
            n -= 2;
        }
    }

    protected NonDataComponentHandle getNonDataComponent(ViewComponent viewComponent) {
        return new NonDataComponentHandle(viewComponent.getID(), viewComponent.getComponentName(), viewComponent);
    }

    protected MouseEvent getMouseEvent() {
        return this.mouseEvent;
    }

    public Cursor getCursorType(int n) {
        Cursor cursor = Cursor.getPredefinedCursor(0);
        switch (n) {
            case 0: {
                cursor = this.m_defaultCursor;
                break;
            }
            case 1: {
                cursor = this.m_moveCursor;
                break;
            }
            case 2: {
                cursor = this.m_waitCursor;
                break;
            }
            case 3: {
                cursor = this.m_nResizeCursor;
                break;
            }
            case 4: {
                cursor = this.m_sResizeCursor;
                break;
            }
            case 5: {
                cursor = this.m_eResizeCursor;
                break;
            }
            case 6: {
                cursor = this.m_wResizeCursor;
                break;
            }
            case 7: {
                cursor = this.m_neResizeCursor;
                break;
            }
            case 8: {
                cursor = this.m_swResizeCursor;
                break;
            }
            case 9: {
                cursor = this.m_nwResizeCursor;
                break;
            }
            case 10: {
                cursor = this.m_seResizeCursor;
                break;
            }
            case 11: {
                cursor = this.m_selectCursor;
                break;
            }
            case 12: {
                cursor = this.m_textCursor;
                break;
            }
            case 13: {
                cursor = this.m_drillCursor;
                break;
            }
            case 14: {
                cursor = this.m_noDropCursor;
                break;
            }
            case 16: {
                cursor = this.m_nResizeCursor;
                break;
            }
            case 15: {
                cursor = this.m_nResizeCursor;
                break;
            }
        }
        return cursor;
    }

    public void setCursorType(Cursor cursor, int n) {
        switch (n) {
            case 0: {
                this.m_defaultCursor = cursor;
                break;
            }
            case 1: {
                this.m_moveCursor = cursor;
                break;
            }
            case 2: {
                this.m_waitCursor = cursor;
                break;
            }
            case 3: {
                this.m_nResizeCursor = cursor;
                break;
            }
            case 4: {
                this.m_sResizeCursor = cursor;
                break;
            }
            case 5: {
                this.m_eResizeCursor = cursor;
                break;
            }
            case 6: {
                this.m_wResizeCursor = cursor;
                break;
            }
            case 7: {
                this.m_neResizeCursor = cursor;
                break;
            }
            case 8: {
                this.m_swResizeCursor = cursor;
                break;
            }
            case 9: {
                this.m_nwResizeCursor = cursor;
                break;
            }
            case 10: {
                this.m_seResizeCursor = cursor;
                break;
            }
            case 11: {
                this.m_selectCursor = cursor;
                break;
            }
            case 12: {
                this.m_textCursor = cursor;
                break;
            }
            case 13: {
                this.m_drillCursor = cursor;
                break;
            }
            case 14: {
                this.m_drillCursor = cursor;
                break;
            }
            case 16: {
                this.m_nResizeCursor = cursor;
                break;
            }
            case 15: {
                this.m_nResizeCursor = cursor;
                break;
            }
        }
    }

    public boolean isWaitCursorForced() {
        return this.m_isWaitCursor;
    }

    public void setWaitCursorForced(boolean bl) {
        this.m_isWaitCursor = bl;
    }

    protected void changeTitleSelectedState(boolean bl) {
        ((Title)this.view.getDataviewTitle()).setSelected(bl);
        ((Subtitle)this.view.getDataviewSubtitle()).setSelected(bl);
        ((Footnote)this.view.getDataviewFootnote()).setSelected(bl);
    }

    protected ComponentHandle createComponentFromPageItem(Object object) {
        PageItem pageItem = (PageItem)object;
        DataviewPagingComponent dataviewPagingComponent = this.view.getPagingControl().getPagingComponent();
        return new PageItemComponentHandle(4, this.view.getNameFromID(4), object, dataviewPagingComponent.getIndex(pageItem));
    }
}

