/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.xml;

import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.jbo.AttributeDef;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ViewObject;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlRowSetRenderer {
    private Hashtable _sParams;
    private final String DEFAULT_ROWSET_TAG;
    private final String DEFAULT_ROW_TAG;
    private String rowSetTag;
    private String rowTag;
    private XSLStylesheet xslt;
    private URL xsltBaseURL;
    private int maxRows;
    private boolean useRowTagInsteadOfVOName;
    private RowSet root;
    private XMLDocument source;

    public XmlRowSetRenderer() {
        this.$init$();
        this.source = new XMLDocument();
    }

    public XmlRowSetRenderer(RowSet rowSet) {
        this.$init$();
        this.root = rowSet;
        this.source = new XMLDocument();
    }

    public void setRowSetTag(String string) {
        if (string != null) {
            this.rowSetTag = string;
        }
    }

    public void setRowTag(String string) {
        if (string != null) {
            this.rowTag = string;
            this.useRowTagInsteadOfVOName = true;
        }
    }

    public void setRowSet(RowSet rowSet) {
        this.root = rowSet;
    }

    public Document getXMLDocument() {
        try {
            this.printXmlForRowSet(this.root, (Node)this.source, this.rowSetTag, true);
            if (this.xslt != null) {
                XSLProcessor xSLProcessor = new XSLProcessor();
                this.setStylesheetParameters(xSLProcessor);
                if (this.xsltBaseURL != null) {
                    xSLProcessor.setBaseURL(this.xsltBaseURL);
                }
                XMLDocumentFragment xMLDocumentFragment = xSLProcessor.processXSL(this.xslt, this.source);
                XMLDocument xMLDocument = new XMLDocument();
                xMLDocument.appendChild((Node)xMLDocumentFragment);
                Document document = (Document)xMLDocument;
                return document;
            }
            Document document = (Document)this.source;
            return document;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return (Document)this.source;
        }
    }

    public void setStylesheetParam(String string, String string2) {
        this.setStylesheetParameter(string, "'" + string2 + "'");
    }

    public void setStylesheetParamXPath(String string, String string2) {
        this.setStylesheetParameter(string, string2);
    }

    public void setStylesheet(XSLStylesheet xSLStylesheet) {
        this.setStylesheet(xSLStylesheet, null);
    }

    public void setStylesheet(XSLStylesheet xSLStylesheet, URL uRL) {
        this.xslt = xSLStylesheet;
        this.xsltBaseURL = uRL;
    }

    public void setMaxRows(int n) {
        this.maxRows = n < 0 ? -1 : n;
    }

    public void print(PrintWriter printWriter) throws Exception {
        this.printXmlForRowSet(this.root, (Node)this.source, this.rowSetTag, true);
        if (this.xslt != null) {
            XSLProcessor xSLProcessor = new XSLProcessor();
            this.setStylesheetParameters(xSLProcessor);
            if (this.xsltBaseURL != null) {
                xSLProcessor.setBaseURL(this.xsltBaseURL);
            }
            xSLProcessor.processXSL(this.xslt, this.source, printWriter);
        } else {
            this.source.print(printWriter);
        }
    }

    private void setStylesheetParameter(String string, String string2) {
        if (this._sParams == null) {
            this._sParams = new Hashtable(10);
        }
        this._sParams.put(string, string2);
    }

    private void printXmlForRowSet(RowSet rowSet, Node node, String string, boolean bl) throws Exception {
        RowSetIterator rowSetIterator = bl && !rowSet.isForwardOnly() ? rowSet.createRowSetIterator(null) : (RowSetIterator)rowSet;
        ViewObject viewObject = rowSetIterator.getRowSet().getViewObject();
        AttributeDef[] attributeDefArray = viewObject.getAttributeDefs();
        int n = viewObject.getAttributeCount();
        Row row = null;
        AttributeDef attributeDef = null;
        String string2 = this.xmlElementNameFor(rowSetIterator.getRowSet());
        int n2 = 0;
        node = this.append(node, string);
        while ((bl && (n2 < this.maxRows || this.maxRows == -1) || !bl) && rowSetIterator.hasNext()) {
            row = rowSetIterator.next();
            ++n2;
            Node node2 = this.append(node, string2);
            int n3 = 0;
            while (n3 < n) {
                attributeDef = attributeDefArray[n3];
                String string3 = this.xmlElementNameFor(attributeDef);
                if (this.isRowSet(attributeDef)) {
                    RowSet rowSet2 = (RowSet)row.getAttribute(n3);
                    rowSet2.executeQuery();
                    rowSet2.setForwardOnly(true);
                    this.printXmlForRowSet(rowSet2, node2, string3, false);
                } else if (!string3.equals("#hide")) {
                    this.append(node2, string3, this.valueOf(row, attributeDef, node2.getOwnerDocument()));
                }
                ++n3;
            }
        }
    }

    private String xmlElementNameFor(RowSet rowSet) {
        if (this.useRowTagInsteadOfVOName) {
            return this.rowTag;
        }
        ViewObject viewObject = rowSet.getViewObject();
        String string = (String)viewObject.getProperty("XML_ELEMENT");
        return string != null ? string : viewObject.getDefName();
    }

    private String xmlElementNameFor(AttributeDef attributeDef) {
        String string = (String)attributeDef.getProperty("XML_ELEMENT");
        return string != null ? string : attributeDef.getName();
    }

    private Node valueOf(Row row, AttributeDef attributeDef, Document document) {
        String string = "";
        if (row.getAttribute(attributeDef.getIndex()) != null) {
            string = row.getAttribute(attributeDef.getIndex()).toString();
        }
        if (this.treatAsCDATA(attributeDef)) {
            return document.createCDATASection(string);
        }
        return document.createTextNode(this.normalize(string));
    }

    private String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '\r': {
                    stringBuffer.append('\n');
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private boolean treatAsCDATA(AttributeDef attributeDef) {
        String string = (String)attributeDef.getProperty("CDATA");
        return string != null;
    }

    private boolean isRowSet(AttributeDef attributeDef) {
        byte by = attributeDef.getAttributeKind();
        return by == 2 || by == 6;
    }

    private Node append(Node node, String string) {
        Element element = null;
        try {
            element = this.source.createElement(string);
            node.appendChild(element);
        }
        catch (DOMException dOMException) {
            throw new RuntimeException(dOMException.getMessage());
        }
        return element;
    }

    private void append(Node node, String string, Node node2) {
        Element element = this.source.createElement(string);
        element.appendChild(node2);
        node.appendChild(element);
    }

    private void setStylesheetParameters(XSLProcessor xSLProcessor) {
        if (this._sParams == null || this.xslt == null) {
            return;
        }
        try {
            xSLProcessor.resetParams();
            Enumeration enumeration = this._sParams.keys();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = (String)this._sParams.get(string);
                    xSLProcessor.setParam("", string, (Object)string2);
                }
            }
        }
        catch (XSLException xSLException) {
            throw new RuntimeException(xSLException.getMessage());
        }
    }

    private /* synthetic */ void $init$() {
        this._sParams = null;
        this.DEFAULT_ROWSET_TAG = "RowSet";
        this.DEFAULT_ROW_TAG = "Row";
        this.rowSetTag = "RowSet";
        this.rowTag = null;
        this.xslt = null;
        this.xsltBaseURL = null;
        this.maxRows = -1;
        this.useRowTagInsteadOfVOName = false;
        this.root = null;
        this.source = null;
    }
}

