/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.jbo.ApplicationModule;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.mom.xml.DefXMLParser;
import oracle.jbo.server.MetaObjectManager;

public class JboXMLUtil {
    public void createSerFile(DefElement defElement, String string) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(defElement);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public DefElement createXMLFromSerFile(String string) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        DefElement defElement = (DefElement)objectInputStream.readObject();
        return defElement;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.out.println("Error: Invalid Syntax");
            System.out.println("JboXMLUtil InputFileName OutputFileName");
            return;
        }
        try {
            String string = "/" + stringArray[0].replace('.', '/') + ".xml";
            InputStream inputStream = string.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                System.out.println("Error:  Input File " + string + " Could not be loacted in the classpath");
                return;
            }
            JboXMLUtil jboXMLUtil = new JboXMLUtil();
            DefXMLParser defXMLParser = new DefXMLParser(MetaObjectManager.getSingleton());
            defXMLParser.parse(inputStream);
            jboXMLUtil.createSerFile((DefElement)((Object)defXMLParser.getDocument().getDocumentElement()), stringArray[1]);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public static String getBC4JTempDir(ApplicationModule applicationModule) {
        String string = null;
        if (applicationModule != null) {
            string = (String)applicationModule.getSession().getEnvironment().get("jbo.tmpdir");
        }
        if (!(string != null && string.length() != 0 || (string = PropertyMetadata.TEMPORARY_FILES_HOME.getProperty()) != null && string.length() != 0 || (string = System.getProperty("user.dir")) != null && string.length() != 0)) {
            string = String.valueOf(File.separatorChar);
        }
        if (string.charAt(string.length() - 1) != File.separatorChar) {
            string = string + File.separatorChar;
        }
        MOMProperties.setProperty("jbo.tmpdir", string);
        return string;
    }
}

