/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import oracle.jbo.server.util.Tok;

public class GenClausesRuntime {
    public static final int TOK_IDENT = 1;
    public static final int TOK_SPECIAL_CHAR = 2;
    public static final int TOK_SINGLE_QUOTE_STR = 3;
    public static final int TOK_DOUBLE_QUOTE_STR = 4;
    public static final int TOK_NUMBER = 5;
    public static final int TOK_WHITE_SPACE = 6;
    String fileType;
    boolean inSingleQuote;
    boolean inDoubleQuote;
    int processingSpecialTok;
    Tok specialTok;
    PrintStream fwr;
    int bracketLevel;

    private /* synthetic */ void $init$() {
        this.fileType = null;
        this.inSingleQuote = false;
        this.inDoubleQuote = false;
        this.processingSpecialTok = 0;
        this.specialTok = null;
        this.fwr = null;
        this.bracketLevel = 0;
    }

    public static void main(String[] stringArray) {
        try {
            GenClausesRuntime genClausesRuntime = new GenClausesRuntime();
            genClausesRuntime.doWork(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
    }

    public GenClausesRuntime() {
        this.$init$();
    }

    public void procError(String string) {
        System.out.println(string);
        System.exit(2);
    }

    public void doWork(String[] stringArray) throws Exception {
        FileOutputStream fileOutputStream;
        FileReader fileReader;
        if (stringArray.length < 2) {
            this.procError("Usage: java oracle.jbo.server.util.GenClausesRuntime <ViewObject-XML-file-name> <output-file-name>");
        }
        int n = 0;
        String string = stringArray[n++];
        String string2 = stringArray[n++];
        String string3 = new File(string).getCanonicalPath();
        String string4 = new File(string2).getCanonicalPath();
        if (string3 != null && string3.equals(string4)) {
            this.procError("Error: In and out file cannot be the same file");
        }
        if ((fileReader = new FileReader(string)) == null) {
            this.procError("Error: Could not open in file " + string);
        }
        if ((fileOutputStream = new FileOutputStream(string2)) == null) {
            this.procError("Error: Could not open out file " + string2);
        }
        this.fwr = new PrintStream(fileOutputStream);
        if (this.fwr == null) {
            this.procError("Error: Could not open out file " + string2);
        }
        LineNumberReader lineNumberReader = new LineNumberReader(fileReader);
        this.doProc(lineNumberReader);
        lineNumberReader.close();
        fileReader.close();
        fileOutputStream.close();
        this.fwr.close();
        if (this.fileType == null || !this.fileType.equals("ViewObject")) {
            System.out.println("File " + string + " is not an XML file for a ViewObject");
            System.exit(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Tok[] getTokens(String var1_1) {
        var2_2 = new ArrayList<Tok>();
        var3_3 = 0;
        block0: while (var3_3 < var1_1.length()) {
            block20: {
                block19: {
                    var4_4 = var1_1.charAt(var3_3);
                    var5_5 = var3_3++;
                    if (!this.inSingleQuote && var4_4 != '\'') break block19;
                    var6_6 = new char[var1_1.length() + 1];
                    var7_7 = 0;
                    if (!this.inSingleQuote) {
                        ++var3_3;
                    }
                    this.inSingleQuote = true;
                    while (var3_3 < var1_1.length()) {
                        var4_4 = var1_1.charAt(var3_3);
                        if (var4_4 == '\'') {
                            ++var3_3;
                            this.inSingleQuote = false;
                            break;
                        }
                        if (var4_4 != '\\') ** GOTO lbl26
                        if (++var3_3 < var1_1.length()) {
                            var4_4 = var1_1.charAt(var3_3++);
                        } else {
                            var6_6[var7_7++] = 10;
                            var2_2.add(new Tok(3, var5_5, var3_3, new String(var6_6), var1_1.substring(var5_5, var3_3)));
                            return var2_2.toArray(new Tok[var2_2.size()]);
lbl26:
                            // 1 sources

                            ++var3_3;
                        }
                        var6_6[var7_7++] = var4_4;
                    }
                    if (this.inSingleQuote) {
                        var6_6[var7_7++] = 10;
                    }
                    var2_2.add(new Tok(3, var5_5, var3_3, new String(var6_6, 0, var7_7), var1_1.substring(var5_5, var3_3)));
                    continue;
                }
                if (!this.inDoubleQuote && var4_4 != '\"') break block20;
                var8_8 = new char[var1_1.length() + 1];
                var9_9 = 0;
                if (!this.inDoubleQuote) {
                    ++var3_3;
                }
                this.inDoubleQuote = true;
                while (var3_3 < var1_1.length()) {
                    var4_4 = var1_1.charAt(var3_3);
                    if (var4_4 == '\"') {
                        ++var3_3;
                        this.inDoubleQuote = false;
                        break;
                    }
                    if (var4_4 != '\\') ** GOTO lbl55
                    if (++var3_3 < var1_1.length()) {
                        var4_4 = var1_1.charAt(var3_3++);
                    } else {
                        var8_8[var9_9++] = 10;
                        var2_2.add(new Tok(4, var5_5, var3_3, new String(var8_8), var1_1.substring(var5_5, var3_3)));
                        return var2_2.toArray(new Tok[var2_2.size()]);
lbl55:
                        // 1 sources

                        ++var3_3;
                    }
                    var8_8[var9_9++] = var4_4;
                }
                if (this.inDoubleQuote) {
                    var8_8[var9_9++] = 10;
                }
                var2_2.add(new Tok(4, var5_5, var3_3, new String(var8_8, 0, var9_9), var1_1.substring(var5_5, var3_3)));
                continue;
            }
            if (Character.isJavaIdentifierStart(var4_4)) {
                while (var3_3 < var1_1.length()) {
                    var4_4 = var1_1.charAt(var3_3);
                    if (!Character.isJavaIdentifierPart(var4_4)) break;
                    ++var3_3;
                }
                var2_2.add(new Tok(1, var5_5, var3_3, var1_1.substring(var5_5, var3_3), var1_1.substring(var5_5, var3_3)));
                continue;
            }
            if (Character.isDigit(var4_4)) {
                ++var3_3;
                while (var3_3 < var1_1.length()) {
                    var4_4 = var1_1.charAt(var3_3);
                    if (!Character.isDigit(var4_4) && var4_4 != '.') break;
                    ++var3_3;
                }
                var2_2.add(new Tok(5, var5_5, var3_3, var1_1.substring(var5_5, var3_3), var1_1.substring(var5_5, var3_3)));
                continue;
            }
            if (Character.isWhitespace(var4_4)) {
                ++var3_3;
                while (var3_3 < var1_1.length()) {
                    var4_4 = var1_1.charAt(var3_3);
                    if (!Character.isWhitespace(var4_4)) continue block0;
                    ++var3_3;
                }
                continue;
            }
            var2_2.add(new Tok(2, var5_5, ++var3_3, new String(new char[]{var4_4}), var1_1.substring(var5_5, var3_3)));
        }
        return var2_2.toArray(new Tok[var2_2.size()]);
    }

    public void reportException(String string, int n, Tok tok) throws Exception {
        throw new Exception("GenClausesRuntime (" + n + "," + tok.mBegPos + "): " + string);
    }

    public void doProc(LineNumberReader lineNumberReader) throws Exception {
        String string;
        while ((string = lineNumberReader.readLine()) != null) {
            int n = lineNumberReader.getLineNumber();
            Tok[] tokArray = this.getTokens(string);
            int n2 = 0;
            while (n2 < tokArray.length) {
                if (tokArray[n2].mStr.equals("<")) {
                    ++this.bracketLevel;
                } else if (tokArray[n2].mStr.equals(">")) {
                    --this.bracketLevel;
                    if (this.bracketLevel < 0) {
                        this.reportException("Integrity problem, unmatching >", n, tokArray[n2]);
                    }
                }
                if (!(this.fileType != null || this.bracketLevel != 1 || n2 + 1 >= tokArray.length || tokArray[n2].mStr.equals("<") && tokArray[n2 + 1].mStr.equals("?") || tokArray[n2].mStr.equals("<") && tokArray[n2 + 1].mStr.equals("!") || !tokArray[n2].mStr.equals("<") || tokArray[n2 + 1].mKind != 1)) {
                    this.fileType = tokArray[1].mStr;
                }
                if (this.bracketLevel == 1 && this.fileType != null && this.fileType.equals("ViewObject")) {
                    if (this.processingSpecialTok == 1) {
                        if (tokArray[n2].mKind != 2 || !tokArray[n2].mStr.equals("=")) {
                            this.reportException("Expecting '=' but didn't find one", n, tokArray[n2]);
                        }
                        this.processingSpecialTok = 2;
                    } else if (this.processingSpecialTok == 2 && tokArray[n2].mKind != 4) {
                        if (this.specialTok.mStr.equals("SelectList")) {
                            this.println("SelectListFlags=\"1\"");
                        } else if (this.specialTok.mStr.equals("FromList")) {
                            this.println("FromListFlags=\"1\"");
                        } else if (this.specialTok.mStr.equals("Where")) {
                            this.println("WhereFlags=\"1\"");
                        }
                        this.processingSpecialTok = 0;
                    }
                    if (this.processingSpecialTok == 0 && tokArray[n2].mKind == 1 && (tokArray[n2].mStr.equals("SelectList") || tokArray[n2].mStr.equals("FromList") || tokArray[n2].mStr.equals("Where"))) {
                        this.print(string.substring(0, tokArray[n2].mBegPos));
                        this.processingSpecialTok = 1;
                        this.specialTok = tokArray[n2];
                    }
                }
                ++n2;
            }
            if (this.processingSpecialTok != 0) continue;
            this.println(string);
        }
    }

    public void println(String string) {
        this.fwr.println(string);
    }

    public void print(String string) {
        this.fwr.print(string);
    }

    public void dumpTokens(int n, Tok[] tokArray) {
        int n2 = 0;
        while (n2 < tokArray.length) {
            System.out.println("#" + n + ") " + tokArray[n2]);
            ++n2;
        }
    }
}

