/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import oracle.jbo.common.JBOClass;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.SQLBuilderFactory;
import oracle.jbo.server.util.MatchedHashtable;

public class Canonizer {
    public static final String CANONIZED = "$CANON";
    public static final int JDBC_TIMESTAMP = 42;
    public static final int ORACLE_DDMONYY = 56;
    private static MatchedHashtable s_messageTransforms = new MatchedHashtable(10);
    private static MatchedHashtable s_classNameTransforms = new MatchedHashtable(10);
    private static MatchedHashtable s_typeNameTransforms = new MatchedHashtable(10);
    private static SQLBuilder s_ttSQLBuilder = SQLBuilderFactory.create();
    private static String s_dbType = s_ttSQLBuilder.getDbType();
    private static int s_dateFormat = 56;

    private Canonizer() {
    }

    public static void setDateFormat(int n) {
        if (n != 56 && n != 42) {
            throw new RuntimeException("unknown date format code: " + n);
        }
        s_dateFormat = n;
    }

    public static int getDateFormat() {
        return s_dateFormat;
    }

    public static void addMessageTransform(int n, String string, String[][] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].length != 2) {
                throw new IllegalArgumentException();
            }
            if (s_dbType.equals(stringArray[n2][0])) {
                s_messageTransforms.put(stringArray[n2][1], "$CANON-" + n + ": " + string);
            }
            ++n2;
        }
    }

    public static void addClassNameTransform(String string, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length != 2) {
                throw new IllegalArgumentException();
            }
            if (s_dbType.equals(stringArray[n][0])) {
                s_classNameTransforms.put(stringArray[n][1], string);
            }
            ++n;
        }
    }

    public static void addTypeNameTransform(String string, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].length != 2) {
                throw new IllegalArgumentException();
            }
            if (s_dbType.equals(stringArray[n][0])) {
                s_typeNameTransforms.put(string, stringArray[n][1]);
            }
            ++n;
        }
    }

    public static void removeMessageTransforms() {
        s_messageTransforms.clear();
    }

    public static void removeClassNameTransforms() {
        s_classNameTransforms.clear();
    }

    public static void removeTypeNameTransforms() {
        s_typeNameTransforms.clear();
    }

    public static String canonizeMessage(String string, boolean bl, boolean bl2) {
        if (string == null) {
            return "null";
        }
        String string2 = Canonizer.massageExceptionMsg(string);
        String string3 = s_messageTransforms.getMatching(string2.trim(), bl2);
        if (string3 != null) {
            return string3;
        }
        if (bl) {
            return string2;
        }
        return string;
    }

    public static String productTypeName(String string) {
        String string2 = (String)s_typeNameTransforms.get(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String canonizeExceptionClassName(Exception exception) {
        String string = exception.getClass().getName();
        String string2 = (String)s_classNameTransforms.get(string);
        if (string2 == null) {
            return string;
        }
        try {
            if (JBOClass.forName(string2).isInstance(exception)) {
                String string3 = string2;
                return string3;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return string;
    }

    public static String canonizeWhereClause(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = string;
        String string4 = ":";
        int n = string4.length();
        int n2 = string3.indexOf(string4);
        while (n2 >= 0) {
            string2 = string2 + string3.substring(0, n2);
            int n3 = (string3 = string3.substring(n2)).length();
            if (n3 > n) {
                int n4 = n;
                while (n4 <= n3) {
                    if (n4 >= n3 || !Character.isDigit(string3.charAt(n4))) {
                        string3 = string3.substring(n4);
                        string2 = n4 > n ? string2 + "?" : string2 + string4;
                        break;
                    }
                    ++n4;
                }
            } else {
                string2 = string2 + string4;
                string3 = string3.substring(n);
            }
            n2 = string3.indexOf(58);
        }
        string2 = string2 + string3;
        return string2;
    }

    public static String canonizeString(Object object) {
        StringTokenizer stringTokenizer;
        if (object == null) {
            return "null";
        }
        if (object instanceof BigDecimal) {
            String string;
            BigDecimal bigDecimal = (BigDecimal)object;
            try {
                BigDecimal bigDecimal2 = bigDecimal.setScale(0);
                string = bigDecimal2.toString();
            }
            catch (ArithmeticException arithmeticException) {
                try {
                    BigDecimal bigDecimal3 = bigDecimal.setScale(2);
                    string = bigDecimal3.toString();
                }
                catch (ArithmeticException arithmeticException2) {
                    string = bigDecimal.toString();
                }
            }
            return string;
        }
        if (object instanceof Timestamp) {
            String string;
            if (s_dateFormat == 56) {
                Date date = new Date(((Timestamp)object).getTime());
                string = new SimpleDateFormat("dd-MMM-yy").format(date).toUpperCase();
            } else {
                string = object.toString();
            }
            return string;
        }
        if (object instanceof Date) {
            String string = s_dateFormat == 56 ? new SimpleDateFormat("dd-MMM-yy").format((Date)object).toUpperCase() : (s_dateFormat == 42 ? new Timestamp(((Date)object).getTime()).toString() : object.toString());
            return string;
        }
        if (object.getClass().getName().equals("oracle.sql.REF")) {
            return "oracle.sql.REF";
        }
        if (object instanceof String && ((String)object).length() >= 7 && Character.isDigit(((String)object).charAt(0)) && Character.isDigit(((String)object).charAt(((String)object).length() - 1)) && (stringTokenizer = new StringTokenizer((String)object, "-")).countTokens() == 3) {
            boolean bl = false;
            String string = stringTokenizer.nextToken();
            if (string.length() == 3) {
                int n = 0;
                while (n < 3) {
                    if (!Character.isDigit(string.charAt(n))) {
                        bl = true;
                        break;
                    }
                    ++n;
                }
            } else {
                bl = true;
            }
            if (!bl) {
                string = stringTokenizer.nextToken();
                if (string.length() == 3) {
                    int n = 0;
                    while (n < 3) {
                        if (!Character.isDigit(string.charAt(n))) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
            } else {
                bl = true;
            }
            if (!bl) {
                string = stringTokenizer.nextToken();
                if (string.length() == 3) {
                    int n = 0;
                    while (n < 4) {
                        if (!Character.isDigit(string.charAt(n))) {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    return (String)object;
                }
            } else {
                bl = true;
            }
        }
        try {
            String string;
            Timestamp timestamp = Timestamp.valueOf(object.toString());
            if (s_dateFormat == 56) {
                Date date = new Date(timestamp.getTime());
                string = new SimpleDateFormat("dd-MMM-yy").format(date).toUpperCase();
            } else {
                string = timestamp.toString();
            }
            String string2 = string;
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                Date date = Date.valueOf(object.toString());
                String string = s_dateFormat == 56 ? new SimpleDateFormat("dd-MMM-yy").format(date).toUpperCase() : (s_dateFormat == 42 ? new SimpleDateFormat("yyyy-MM-dd").format(date).toUpperCase() : date.toString());
                String string3 = string;
                return string3;
            }
            catch (IllegalArgumentException illegalArgumentException2) {
                return object.toString();
            }
        }
    }

    public static String massageExceptionMsg(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        String string2 = "";
        if (n > 0 && string.charAt(n - 1) == '\n') {
            --n;
        }
        if (n > 0 && string.charAt(n - 1) == '\r') {
            --n;
        }
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\n') {
                string2 = string2 + "\r\n";
            } else if (c != '\r') {
                string2 = string2 + c;
            }
            ++n2;
        }
        return string2 + "\r\n";
    }

    public static void addStandardCanonizers() {
        Canonizer.addMessageTransform(100, "JBO-27120 or 27122 error during statement preparation or execution. ", new String[][]{{"Oracle", "JBO-27120: SQL error during query execution."}, {"OLite", "JBO-27120: SQL error during query execution."}, {"OLite", "JBO-27122: SQL error during statement preparation."}, {"DB2", "JBO-27120: SQL error during query execution."}});
        Canonizer.addMessageTransform(200, "SQLParser missing expression or syntax error", new String[][]{{"Oracle", "ORA-00900: invalid SQL statement"}, {"Oracle", "Invalid SQL type"}, {"Oracle", "ORA-00903: invalid table name"}, {"Oracle", "ORA-00923: FROM keyword not found where expected"}, {"Oracle", "ORA-00936: missing expression"}, {"Oracle", "ORA-00920: invalid relational operator"}, {"Oracle", "ORA-00933: SQL command not properly ended"}, {"OLite", "[POL-5228] syntax error"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0104N  An unexpected token"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0198N  The statement string of the PREPARE or EXECUTE IMMEDIATE statement is blank or empty"}});
        Canonizer.addMessageTransform(300, "SQLParser column problem", new String[][]{{"Oracle", "ORA-00904: "}, {"OLite", "[POL-5205] column not found"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0206N"}});
        Canonizer.addMessageTransform(400, "SQLParser table or view not found", new String[][]{{"Oracle", "ORA-00942: table or view does not exist"}, {"OLite", "[POL-5130] table or view not found"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0204N"}});
        Canonizer.addMessageTransform(500, "Constraint violation -- Cannot delete parent or update parent's PK because of parent/child constraint", new String[][]{{"Oracle", "ORA-02292: integrity constraint"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0532N  A parent row cannot be deleted because the relationship"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0531N  The parent key in a parent row of relationship"}});
        Canonizer.addMessageTransform(600, "NOT NULL violation", new String[][]{{"Oracle", "ORA-01400: cannot insert NULL into"}, {"DB2", "[IBM][CLI Driver][DB2/NT] SQL0407N  Assignment of a NULL value to a NOT NULL column"}});
        Canonizer.addMessageTransform(700, "insufficient privileges", new String[][]{{"Oracle", "ORA-01031: insufficient privileges"}, {"Oracle", "ORA-01779: cannot modify a column which maps to a non key-preserved table"}, {"Oracle", "ORA-02030: can only select from fixed tables/views"}});
        Canonizer.addMessageTransform(800, "value too large", new String[][]{{"Oracle", "ORA-01401: inserted value too large for column"}, {"Oracle", "ORA-12899: value too large for column"}});
        Canonizer.addClassNameTransform("java.sql.SQLException", new String[][]{{"Oracle", "oracle.jdbc.driver.OracleSQLException"}, {"DB2", "COM.ibm.db2.jdbc.DB2Exception"}});
        Canonizer.addTypeNameTransform("VARCHAR2", new String[][]{{"DB2", "VARCHAR"}});
    }
}

