/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.sql.SQLException;
import java.sql.Statement;
import oracle.jbo.JboException;

public class WaitThread
extends Thread {
    private Statement mStmt;
    private boolean mMarkForStop;
    private boolean mMarkForCancel;
    private int mTimeOut;
    private static int mThreadCounter = 0;
    private static final int CHECK_TIME_DURATION = 100;

    private /* synthetic */ void $init$() {
        this.mMarkForStop = false;
        this.mMarkForCancel = false;
        this.mTimeOut = -1;
    }

    public WaitThread(int n) {
        super("BC4J_WaitThread" + mThreadCounter++);
        this.$init$();
        this.mTimeOut = n;
    }

    public synchronized boolean doCancel() {
        if (this.mStmt != null) {
            try {
                this.mStmt.cancel();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw new JboException(sQLException);
            }
            this.mStmt = null;
            return true;
        }
        return false;
    }

    public synchronized void markForCancel() {
        this.mMarkForCancel = true;
    }

    public synchronized void markForStop() {
        this.mMarkForStop = true;
    }

    public synchronized void setStatement(Statement statement) {
        this.mStmt = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int n = 0;
        try {
            while (this.mTimeOut < 0 || n < this.mTimeOut) {
                int n2 = this.mTimeOut >= 0 ? this.mTimeOut - n : 100;
                Thread.sleep(n2);
                WaitThread waitThread = this;
                synchronized (waitThread) {
                    if (this.mMarkForCancel) {
                        this.doCancel();
                        return;
                    }
                    if (this.mMarkForStop) {
                        this.mStmt = null;
                        return;
                    }
                }
                n += n2;
            }
            WaitThread waitThread = this;
            synchronized (waitThread) {
                if (!this.mMarkForStop) {
                    this.doCancel();
                }
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JboException(exception);
        }
    }
}

