/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeadEntityAccessException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.PCollException;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.Row;
import oracle.jbo.RowAlreadyDeletedException;
import oracle.jbo.RowCreateException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.WeakVector;
import oracle.jbo.pcoll.PCollInputStream;
import oracle.jbo.pcoll.PCollKeyInfo;
import oracle.jbo.pcoll.PCollOutputStream;
import oracle.jbo.pcoll.PCollPersistable;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.AttributeListImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.EntityAssociationReference;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityReference;
import oracle.jbo.server.EntityRowSetImpl;
import oracle.jbo.server.MapInfo;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.RetainAccessorDomain;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;

class ViewRowStorage
implements Serializable,
PCollPersistable {
    static final long serialVersionUID = 1153742097612164205L;
    static final byte STATUS_INITIALIZED = -1;
    static final byte STATUS_NEW = 0;
    static final byte STATUS_UNMODIFIED = 1;
    static final byte STATUS_MODIFIED = 2;
    static final byte STATUS_DELETED = 3;
    static final byte STATUS_DEAD = 4;
    private ViewRowImpl mOuter;
    private Class mViewRowClass;
    private WeakVector mSecViewRows;
    private Object[] mCalcs;
    private ArrayList mDynAttrs;
    private byte mState;
    private Object mHandle;
    EntityImpl[] mRows;
    ViewObjectImpl mVO;
    ViewDefImpl mViewDef;
    ViewAttributeDefImpl[] mAttrs;
    private QueryCollection mQC;
    private int mUseCount;
    private long mPersistId;
    private long mPCollParentId;
    private boolean mHasBeenPersisted;
    private boolean mPCollChanged;
    private ArrayList mChangedPK;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$server$RetainAccessorDomain;

    private /* synthetic */ void $init$() {
        this.mOuter = null;
        this.mViewRowClass = null;
        this.mSecViewRows = null;
        this.mState = 1;
        this.mHandle = null;
        this.mUseCount = 0;
        this.mPersistId = 0L;
        this.mPCollParentId = 0L;
        this.mHasBeenPersisted = false;
        this.mPCollChanged = false;
        this.mChangedPK = null;
    }

    ViewRowStorage(ViewRowImpl viewRowImpl) {
        this.$init$();
        this.mOuter = viewRowImpl;
        this.mPCollChanged = true;
    }

    final synchronized void addUse() {
        ++this.mUseCount;
    }

    final synchronized void releaseUse() {
        --this.mUseCount;
        if (this.mUseCount < 0 && (Diagnostic.isOn() || Diagnostic.isStopOnAssert())) {
            String string = this.mVO == null ? "null" : this.mVO.getName();
            Diagnostic.ASSERT(false, "Object use count is negative on VR of VO " + string);
        }
    }

    final MapInfo[] getMapInfo() {
        return this.getViewDef().getMapInfo();
    }

    final ViewDefImpl getViewDefInternal() {
        return this.mViewDef;
    }

    final ViewDefImpl getViewDef() {
        if (this.mViewDef == null) {
            return this.mVO.getViewDef();
        }
        return this.mViewDef;
    }

    public boolean canBePersisted() {
        if (this.mUseCount != 0 || !this.getViewDef().mHasAllEOPKs) {
            return false;
        }
        int n = this.getEntityCount();
        int n2 = 0;
        while (n2 < n) {
            EntityImpl entityImpl = this.getEntity(n2);
            if (entityImpl != null && !entityImpl.isInRowList()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean getHasBeenPersisted() {
        return this.mHasBeenPersisted;
    }

    public void setHasBeenPersisted(boolean bl) {
        this.mHasBeenPersisted = bl;
    }

    public boolean getPCollChanged() {
        return this.mPCollChanged;
    }

    public void setPCollChanged(boolean bl) {
        this.mPCollChanged = bl;
    }

    public long getPersistentId() {
        if (this.mPersistId == 0L) {
            this.mPersistId = this.mQC.getNextObjId();
        }
        return this.mPersistId;
    }

    void usePersistentId(long l) {
        this.mQC.getPCollManager().useObjIdUpto(l);
        this.mPersistId = l;
        if (this.mSecViewRows != null) {
            int n = 0;
            while (n < this.mSecViewRows.size()) {
                ViewRowImpl viewRowImpl = (ViewRowImpl)this.mSecViewRows.elementAt(n);
                if (viewRowImpl != null) {
                    viewRowImpl.setPersistentId(l);
                }
                ++n;
            }
        }
    }

    public void setPersistentId(long l) {
        this.mPersistId = l;
    }

    public long getPCollParentId() {
        return this.mPCollParentId;
    }

    public void setPCollParentId(long l) {
        this.mPCollParentId = l;
    }

    private PCollKeyInfo[] getPCollKeys(boolean bl) {
        int n = this.getEntityCount();
        Object object = null;
        if (n == 0) {
            Key key = this.getRowImpl().getKey();
            object = key == null || key.getAttributeCount() == 0 ? null : new PCollKeyInfo[]{new PCollKeyInfo(-1, key)};
        } else {
            object = new PCollKeyInfo[n];
            int n2 = 0;
            while (n2 < n) {
                EntityImpl entityImpl = this.getEntity(n2);
                if (entityImpl != null) {
                    Key key = null;
                    if (this.mChangedPK != null && n2 < this.mChangedPK.size()) {
                        key = (Key)this.mChangedPK.get(n2);
                    }
                    if (key == null) {
                        key = entityImpl.getPrimaryKey();
                    }
                    object[n2] = new PCollKeyInfo(entityImpl.getEntityDef().getEntityDefId(), key);
                    if (bl) {
                        this.mQC.viewRowPassivated(this, entityImpl, key);
                    }
                } else {
                    object[n2] = new PCollKeyInfo(-1, null);
                }
                ++n2;
            }
        }
        return object;
    }

    void setChangedPK(Row row, Key key) {
        if (key == null) {
            return;
        }
        int n = this.getEntityCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getEntity(n2) == row) {
                if (this.mChangedPK == null) {
                    this.mChangedPK = new ArrayList(4);
                    JboEnvUtil.setSizeInArrayList(this.mChangedPK, n);
                }
                this.mChangedPK.set(n2, (Object)key);
                break;
            }
            ++n2;
        }
    }

    private static void readArray(Object[] objectArray, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = objectInputStream.readObject();
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        EntityReference[] entityReferenceArray;
        if (!(objectInputStream instanceof PCollInputStream)) {
            Diagnostic.ASSERT(false, "ObjectInputStream " + objectInputStream + " is not a PCollInputStream");
        }
        PCollInputStream pCollInputStream = (PCollInputStream)objectInputStream;
        this.setQueryCollection((QueryCollection)pCollInputStream.getListener());
        if (!objectInputStream.readBoolean()) {
            String string = objectInputStream.readUTF();
            this.mViewDef = ViewDefImpl.findDefObjectNoSub(string);
        }
        PCollKeyInfo[] pCollKeyInfoArray = pCollInputStream.getKeyArr();
        this.mAttrs = null;
        int n = objectInputStream.readInt();
        if (n > 0 && (entityReferenceArray = this.getViewDef().getEntityReferences()) != null) {
            EntityImpl[] entityImplArray = new EntityImpl[entityReferenceArray.length];
            ArrayList arrayList = (ArrayList)objectInputStream.readObject();
            int n2 = 0;
            while (n2 < n) {
                EntityImpl entityImpl = null;
                Key key = (Key)pCollKeyInfoArray[n2].mKey;
                if (key != null) {
                    EntityDefImpl entityDefImpl = null;
                    if (arrayList != null) {
                        entityDefImpl = EntityDefImpl.findDefObjectNoSub((String)arrayList.get(n2));
                    }
                    if (entityDefImpl == null) {
                        entityDefImpl = entityReferenceArray[n2].getEntityDef();
                    }
                    if ((entityImpl = entityDefImpl.findByPrimaryKey(this.mVO.getDBTransactionImpl(), key)) == null) {
                        throw new RowAlreadyDeletedException(true, entityDefImpl.getName(), key);
                    }
                    this.mQC.viewRowActivated(this, pCollInputStream.getCollection(), entityImpl, key);
                }
                entityImplArray[n2] = entityImpl;
                ++n2;
            }
            this.setEntities(entityImplArray);
        }
        this.mViewRowClass = JBOClass.forName(objectInputStream.readUTF());
        this.mPersistId = objectInputStream.readLong();
        int n3 = objectInputStream.readInt();
        if (n3 < 0) {
            this.mCalcs = null;
        } else {
            this.mCalcs = new Object[n3];
            ViewRowStorage.readArray(this.mCalcs, objectInputStream);
        }
        boolean bl = objectInputStream.readBoolean();
        this.mDynAttrs = bl ? null : (ArrayList)objectInputStream.readObject();
        this.mState = objectInputStream.readByte();
    }

    private static void writeArray(Object[] objectArray, ObjectOutputStream objectOutputStream) throws IOException {
        if (objectArray == null) {
            objectOutputStream.writeInt(-1);
        } else {
            objectOutputStream.writeInt(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                objectOutputStream.writeObject(objectArray[n]);
                ++n;
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        EntityReference[] entityReferenceArray;
        if (!(objectOutputStream instanceof PCollOutputStream)) {
            Diagnostic.ASSERT(false, "ObjectInputStream " + objectOutputStream + " is not a PCollOutputStream");
        }
        PCollOutputStream pCollOutputStream = (PCollOutputStream)objectOutputStream;
        pCollOutputStream.setKeyArr(this.getPCollKeys(true));
        if (this.mViewDef == null) {
            objectOutputStream.writeBoolean(true);
        } else {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeUTF(this.getViewDef().getFullName());
        }
        int n = this.getEntityCount();
        objectOutputStream.writeInt(n);
        if (n > 0 && (entityReferenceArray = this.getViewDef().getEntityReferences()) != null) {
            ArrayList arrayList = null;
            int n2 = 0;
            while (n2 < n) {
                EntityImpl entityImpl = this.getEntity(n2);
                if (entityImpl != null && entityImpl.getEntityDef() != entityReferenceArray[n2].getEntityDef() && arrayList == null) {
                    arrayList = new ArrayList(n);
                    int n3 = 0;
                    while (n3 < n) {
                        arrayList.add(null);
                        ++n3;
                    }
                    arrayList.set(n2, (Object)entityImpl.getEntityDef().getFullName());
                }
                ++n2;
            }
            objectOutputStream.writeObject(arrayList);
        }
        this.mChangedPK = null;
        objectOutputStream.writeUTF(this.mOuter.getClass().getName());
        objectOutputStream.writeLong(this.mPersistId);
        ViewRowStorage.writeArray(this.mCalcs, objectOutputStream);
        objectOutputStream.writeBoolean(this.mDynAttrs == null);
        if (this.mDynAttrs != null) {
            objectOutputStream.writeObject(this.mDynAttrs);
        }
        objectOutputStream.writeByte(this.mState);
        this.mOuter.setPersistentId(this.getPersistentId());
        this.mOuter.setInner(null);
        if (this.mSecViewRows != null) {
            int n4 = 0;
            while (n4 < this.mSecViewRows.size()) {
                ViewRowImpl viewRowImpl = (ViewRowImpl)this.mSecViewRows.elementAt(n4);
                if (viewRowImpl != null) {
                    viewRowImpl.setPersistentId(this.getPersistentId());
                    viewRowImpl.setInner(null);
                }
                ++n4;
            }
        }
    }

    final ViewRowImpl getRowImpl() {
        if (this.mOuter == null) {
            try {
                this.mOuter = (ViewRowImpl)this.mViewRowClass.newInstance();
            }
            catch (Exception exception) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowStorage.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28021", new Object[]{this.mQC.getName(), new Long(this.getPersistentId())}, null);
            }
            this.mOuter.setPersistentId(this.getPersistentId());
            this.mOuter.setInner(this);
            this.mOuter.initQueryCollection(this.mQC);
        }
        return this.mOuter;
    }

    final void setRowImpl(ViewRowImpl viewRowImpl) {
        if (this.mOuter == viewRowImpl) {
            return;
        }
        if (viewRowImpl != null) {
            if (this.mSecViewRows == null) {
                this.mSecViewRows = new WeakVector(2);
            }
            if (!this.mSecViewRows.contains(viewRowImpl)) {
                this.mSecViewRows.addElement(viewRowImpl);
            }
        }
    }

    final void init(ViewDefImpl viewDefImpl, QueryCollection queryCollection, boolean bl) {
        if (viewDefImpl != queryCollection.getViewObjectImpl().getViewDef()) {
            this.mViewDef = viewDefImpl;
        }
        this.mQC = queryCollection;
        this.mVO = this.mQC.getViewObjectImpl();
        this.mAttrs = null;
        this.mPCollChanged = true;
        int n = this.getViewDef().getCalculatedAttributeCount();
        this.mCalcs = n > 0 ? new Object[n] : null;
        this.mDynAttrs = null;
        if (bl) {
            this.mState = (byte)(this.mVO.getDBTransactionImpl().isTrackNewAndModifiedRowsOnly() ? -1 : 0);
        }
    }

    protected void initDefaults() {
        ViewAttributeDefImpl[] viewAttributeDefImplArray = this.getViewAttributeDefs();
        int n = 0;
        while (n < viewAttributeDefImplArray.length) {
            ViewAttributeDefImpl viewAttributeDefImpl = viewAttributeDefImplArray[n];
            Object object = viewAttributeDefImpl.getDefaultValue();
            if (object != null && this.getAttributeInternal(n) == null) {
                this.populateAttributeAsChanged(n, object);
            }
            ++n;
        }
    }

    void create(AttributeList attributeList) {
        this.mState = (byte)(this.mVO.getDBTransactionImpl().isTrackNewAndModifiedRowsOnly() ? -1 : 0);
        int n = attributeList != null ? attributeList.getAttributeCount() : 0;
        int n2 = this.getEntityCount();
        if (n == 0 && n2 == 0) {
            return;
        }
        String[] stringArray = n > 0 ? attributeList.getAttributeNames() : null;
        MapInfo[] mapInfoArray = this.getMapInfo();
        AttributeListImpl attributeListImpl = MetaObjectManager.getSingleton().is903Compatible() ? new AttributeListImpl(n) : null;
        ViewDefImpl viewDefImpl = this.getViewDef();
        viewDefImpl.processEntityAssociations();
        int n3 = 0;
        while (n3 < n2) {
            EntityImpl entityImpl = this.getEntity(n3);
            if (n3 > 0 && attributeListImpl != null) {
                attributeListImpl.clear();
            }
            if (entityImpl != null && (entityImpl.getPostState() == 0 || entityImpl.getPostState() == -1) && entityImpl.isNotCreated()) {
                try {
                    EntityReference entityReference = viewDefImpl.getEntityReference(n3);
                    EntityAssociationReference[] entityAssociationReferenceArray = entityReference.getAssociationReferences();
                    int n4 = 0;
                    while (n4 < entityAssociationReferenceArray.length) {
                        if (entityAssociationReferenceArray[n4].getOtherEntityReference() == entityReference) {
                            String string = entityAssociationReferenceArray[n4].getEntityAssociation().getName() + '.' + entityAssociationReferenceArray[n4].getEndName();
                            EntityImpl entityImpl2 = this.getEntity(viewDefImpl.getEntityIndex(entityAssociationReferenceArray[n4].getEntityReference()));
                            if (entityImpl2 != null) {
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("Passing to detail entity.create:+" + string + " = " + entityImpl2.getAttribute(0));
                                }
                                if (attributeListImpl == null) {
                                    attributeListImpl = new AttributeListImpl(n);
                                }
                                attributeListImpl.setAttribute(string, (Object)entityImpl2);
                            }
                        }
                        ++n4;
                    }
                    if (n > 0) {
                        int n5 = 0;
                        while (n5 < n) {
                            ViewAttributeDefImpl viewAttributeDefImpl = (ViewAttributeDefImpl)this.mVO.lookupAttributeDef(stringArray[n5]);
                            if (viewAttributeDefImpl != null && viewAttributeDefImpl.getIndex() < mapInfoArray.length && mapInfoArray[viewAttributeDefImpl.getIndex()].getSourceIndex() == n3) {
                                AttributeDefImpl attributeDefImpl = viewAttributeDefImpl.getAttributeDefImpl();
                                Object object = attributeList.getAttribute(n5);
                                if (attributeListImpl == null) {
                                    attributeListImpl = new AttributeListImpl(n);
                                }
                                attributeListImpl.setAttribute(attributeDefImpl.getName(), object);
                                entityImpl.populateAttributeAsChanged(mapInfoArray[viewAttributeDefImpl.getIndex()].getIndex(), attributeDefImpl.convertToJava(object));
                            }
                            ++n5;
                        }
                    }
                    entityImpl.callCreate(attributeListImpl);
                }
                catch (Exception exception) {
                    entityImpl.removeFromValidationManager();
                    entityImpl.removeFromTransactionPostManager();
                    entityImpl.removeFromTransactionManager();
                    if (exception instanceof JboException) {
                        throw (JboException)exception;
                    }
                    throw new RowCreateException(true, entityImpl.getEntityDef().getName(), exception);
                }
            }
            ++n3;
        }
    }

    final QueryCollection getQueryCollection() {
        return this.mQC;
    }

    final void setQueryCollection(QueryCollection queryCollection) {
        if (queryCollection == this.mQC) {
            return;
        }
        this.mQC = queryCollection;
        ViewObjectImpl viewObjectImpl = this.mVO = queryCollection != null ? this.mQC.getViewObjectImpl() : null;
        if (this.mOuter != null && this.mOuter.getQueryCollection() != queryCollection) {
            this.mOuter.initQueryCollection(queryCollection);
        }
        if (this.mSecViewRows != null) {
            int n = 0;
            while (n < this.mSecViewRows.size()) {
                ViewRowImpl viewRowImpl = (ViewRowImpl)this.mSecViewRows.elementAt(n);
                if (viewRowImpl != null) {
                    viewRowImpl.initQueryCollection(queryCollection);
                }
                ++n;
            }
        }
    }

    final ViewAttributeDefImpl getViewAttributeDef(int n) {
        if (this.mViewDef == null) {
            return this.getViewAttributeDefs()[n];
        }
        int n2 = this.mViewDef.getAttributeCount();
        if (n < n2) {
            return (ViewAttributeDefImpl)this.mViewDef.getAttributeDefs()[n];
        }
        n = this.mVO.getDynamicAttributeOffset() + (n - n2);
        return this.getViewAttributeDefs()[n];
    }

    final ViewAttributeDefImpl[] getViewAttributeDefs() {
        return this.mVO.getViewAttributeDefImpls();
    }

    Object getViewLinkAccessorResult(ViewAttributeDefImpl viewAttributeDefImpl) {
        String string;
        AttributeDef attributeDef;
        RetainAccessorDomain retainAccessorDomain;
        Object object = null;
        int n = -1;
        if (this.mVO.isViewLinkAccessorRetained() && (retainAccessorDomain = (RetainAccessorDomain)this.getDynamicAttribute(this.getDynamicAttributeIndex(n = (attributeDef = this.mVO.findAttributeDef(string = ViewObjectImpl.vlAccResultAttrName(viewAttributeDefImpl))).getIndex()))) != null && (object = retainAccessorDomain.getRowSet()) == null) {
            ViewDefImpl viewDefImpl = viewAttributeDefImpl.getOtherViewDef();
            String string2 = viewAttributeDefImpl.getViewLinkAccessorVOName(viewDefImpl);
            ApplicationModuleImpl applicationModuleImpl = this.getDBTransactionImpl().getTxnApplicationModuleImpl();
            ViewObjectImpl viewObjectImpl = (ViewObjectImpl)applicationModuleImpl.findViewObject(string2);
            if (viewObjectImpl == null) {
                viewObjectImpl = (ViewObjectImpl)applicationModuleImpl.createViewObject(string2, viewDefImpl);
            }
            object = retainAccessorDomain.getRowSet(viewObjectImpl);
        }
        if (object == null) {
            object = viewAttributeDefImpl.get(this.mOuter);
            if (this.mVO.isViewLinkAccessorRetained() && n >= 0) {
                if (object instanceof ViewRowSetImpl) {
                    ApplicationModuleImpl applicationModuleImpl = this.getDBTransactionImpl().getTxnApplicationModuleImpl();
                    applicationModuleImpl.addPassivatableRowSet((ViewRowSetImpl)object);
                }
                this.setDynamicAttribute(this.getDynamicAttributeIndex(n), new RetainAccessorDomain((ViewRowSetImpl)object));
                ViewAttributeDefImpl viewAttributeDefImpl2 = (ViewAttributeDefImpl)this.mVO.getAttributeDef(n);
                Class clazz = viewAttributeDefImpl2.mJavaType;
                Class clazz2 = class$oracle$jbo$server$RetainAccessorDomain;
                if (clazz2 == null) {
                    clazz2 = class$oracle$jbo$server$RetainAccessorDomain = ViewRowStorage.class$("oracle.jbo.server.RetainAccessorDomain");
                }
                if (clazz != clazz2) {
                    Class clazz3 = class$oracle$jbo$server$RetainAccessorDomain;
                    if (clazz3 == null) {
                        clazz3 = class$oracle$jbo$server$RetainAccessorDomain = ViewRowStorage.class$("oracle.jbo.server.RetainAccessorDomain");
                    }
                    viewAttributeDefImpl2.mJavaType = clazz3;
                    this.mVO.setPassivatableTransientAttribute(viewAttributeDefImpl2, true);
                }
            }
        }
        return object;
    }

    Object getAttributeInternal(int n) {
        if (n == -1) {
            return null;
        }
        Object object = null;
        MapInfo[] mapInfoArray = this.getMapInfo();
        if (n < mapInfoArray.length) {
            ViewAttributeDefImpl viewAttributeDefImpl;
            byte by;
            EntityImpl entityImpl;
            MapInfo mapInfo = mapInfoArray[n];
            int n2 = mapInfo.getSourceIndex();
            int n3 = mapInfo.getIndex();
            object = n2 != -1 ? ((entityImpl = this.mRows[n2]) == null ? null : entityImpl.getAttribute(n3)) : ((by = (viewAttributeDefImpl = this.getViewAttributeDef(n)).getAttributeKind()) == 2 || by == 6 ? this.getViewLinkAccessorResult(viewAttributeDefImpl) : this.mCalcs[n3]);
        } else {
            ViewAttributeDefImpl viewAttributeDefImpl = this.getViewAttributeDef(n);
            byte by = viewAttributeDefImpl.getAttributeKind();
            object = by == 2 || by == 6 ? this.getViewLinkAccessorResult(viewAttributeDefImpl) : this.getDynamicAttribute(this.getDynamicAttributeIndex(n));
        }
        if (object instanceof EntityRowSetImpl) {
            EntityRowSetImpl entityRowSetImpl = (EntityRowSetImpl)object;
            QueryCollection queryCollection = entityRowSetImpl.getQueryCollection();
            ViewRowSetImpl viewRowSetImpl = entityRowSetImpl.getViewObjectImpl().findRowSetForQueryCollection(queryCollection, true);
            if (viewRowSetImpl == null) {
                viewRowSetImpl = queryCollection.createViewRowSet();
            }
            object = viewRowSetImpl;
        }
        return object;
    }

    void setAttributeInternal(int n, Object object) {
        if (this.mState == -1) {
            this.mOuter.setNewRowState((byte)0);
        }
        if (!((ApplicationModuleImpl)this.mVO.getApplicationModule()).isDeferredMode()) {
            this.setAttributeValue(n, object);
        } else {
            this.mPCollChanged = true;
        }
        if (this.mQC == null) {
            return;
        }
        if (this.mState == 0) {
            ViewAttributeDefImpl viewAttributeDefImpl = this.getViewAttributeDef(n);
            if (viewAttributeDefImpl.isJoinFK() && this.mQC.indexOf(this.mOuter) == -1) {
                EntityImpl entityImpl = (EntityImpl)this.getEntity(viewAttributeDefImpl.getEntityReference());
                ViewAttributeDefImpl[] viewAttributeDefImplArray = new ViewAttributeDefImpl[this.mVO.getAttributeCount()];
                viewAttributeDefImplArray[0] = viewAttributeDefImpl;
                int n2 = this.mVO.updateReferenceEntities(this.mQC, entityImpl, 1, null, viewAttributeDefImplArray, new Row[]{this.mOuter}, true);
            }
        } else {
            this.mState = (byte)2;
        }
    }

    void setAttributeValue(int n, Object object) {
        MapInfo[] mapInfoArray = this.getMapInfo();
        if (!this.isAttributeUpdateable(n)) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ViewRowStorage.class$("oracle.jbo.CSMessageBundle");
            }
            throw new ReadOnlyAttrException(111, clazz, "27008", this.mVO.getName(), this.getViewAttributeDef(n).getName());
        }
        if (n < mapInfoArray.length) {
            MapInfo mapInfo = mapInfoArray[n];
            if (mapInfo.getSourceIndex() != -1) {
                EntityImpl entityImpl = this.getEntity(mapInfo.getSourceIndex());
                if (entityImpl == null) {
                    throw new RowAlreadyDeletedException(this.mVO.getName(), this.getViewAttributeDef(n).getEntityReference().getName());
                }
                entityImpl.setAttribute(mapInfo.getIndex(), object);
                return;
            }
            this.mPCollChanged = true;
            this.mCalcs[mapInfo.getIndex()] = object;
        } else {
            this.setDynamicAttribute(this.getDynamicAttributeIndex(n), object);
        }
        this.mVO.notifyRowUpdated(this.mQC, (Row)this.mOuter, new int[]{n}, true);
    }

    Row getEntity(EntityReference entityReference) {
        if (this.mViewDef != null) {
            entityReference = this.getViewDef().getEntityReference(entityReference.getName());
        }
        int n = entityReference != null ? entityReference.getOrderIndex() : -1;
        return n >= 0 ? this.getEntity(n) : null;
    }

    int getEntityIndex(Row row) {
        int n = this.getEntityCount();
        int n2 = n - 1;
        while (n2 >= 0) {
            if (this.getEntity(n2) == row) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    int getEntityCount() {
        return this.mRows == null ? 0 : this.mRows.length;
    }

    final EntityImpl getEntity(int n) {
        return this.mRows[n];
    }

    final EntityImpl getEntity(String string) {
        int n = this.getViewDef().getEntityIndex(this.getViewDef().getEntityReference(string));
        if (n == -1) {
            return null;
        }
        return this.getEntity(n);
    }

    EntityImpl[] getEntities() {
        if (this.mRows == null) {
            return null;
        }
        EntityImpl[] entityImplArray = new EntityImpl[this.mRows.length];
        System.arraycopy(this.mRows, 0, entityImplArray, 0, this.mRows.length);
        return entityImplArray;
    }

    final void setEntities(EntityImpl[] entityImplArray) {
        this.mPCollChanged = true;
        this.mRows = entityImplArray;
    }

    void setEntity(int n, EntityImpl entityImpl) {
        if (this.mQC != null) {
            this.mQC.updateReference(this.getRowImpl(), entityImpl, n);
        } else {
            this.updateReference(n, entityImpl);
        }
    }

    boolean isAttributeUpdateable(int n) {
        ViewAttributeDefImpl viewAttributeDefImpl = this.getViewAttributeDef(n);
        EntityReference entityReference = viewAttributeDefImpl.getEntityReference();
        if (viewAttributeDefImpl.mKind == 0 && entityReference != null && (!entityReference.isLockParticipant() || entityReference.isReadOnly())) {
            return false;
        }
        if (entityReference != null) {
            int n2 = this.getViewAttributeDef(n).getAttributeDefImpl().getIndex();
            EntityImpl entityImpl = (EntityImpl)this.getEntity(entityReference);
            if (entityImpl != null && !entityImpl.hasUpdatePrivilege(n2)) {
                return false;
            }
        }
        boolean bl = true;
        switch (viewAttributeDefImpl.mUpdateable) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                MapInfo[] mapInfoArray = this.getMapInfo();
                if (n < mapInfoArray.length && mapInfoArray[n].getSourceIndex() != -1) {
                    EntityImpl entityImpl = this.mRows[mapInfoArray[n].getSourceIndex()];
                    if (entityImpl == null) {
                        bl = false;
                        break;
                    }
                    bl = entityImpl.getEntityState() == 0 ? entityImpl.isAttributeUpdateable(viewAttributeDefImpl.getAttributeDefImpl().getIndex()) : false;
                    break;
                }
                bl = this.getPostState() == 0 || this.getPostState() == -1;
                break;
            }
            case 2: {
                MapInfo[] mapInfoArray = this.getMapInfo();
                if (n >= mapInfoArray.length || mapInfoArray[n].getSourceIndex() == -1) break;
                EntityImpl entityImpl = this.mRows[mapInfoArray[n].getSourceIndex()];
                bl = entityImpl == null ? false : entityImpl.isAttributeUpdateable(viewAttributeDefImpl.getAttributeDefImpl().getIndex());
            }
        }
        return bl;
    }

    void entityCacheAdd() {
        if (this.mRows == null) {
            return;
        }
        EntityReference[] entityReferenceArray = this.getViewDef().getEntityReferences();
        int n = 0;
        while (n < this.mRows.length) {
            EntityImpl entityImpl = this.mRows[n];
            if (entityImpl != null) {
                Object var6_5;
                try {
                    block8: {
                        try {
                            this.mPCollChanged = true;
                            if (entityImpl.getPostState() == -1) break block8;
                            this.mQC.setEntityCacheAdd(entityImpl);
                            this.mRows[n] = entityImpl.getEntityCache().add(entityImpl);
                        }
                        catch (DeadEntityAccessException deadEntityAccessException) {
                            if (!this.getViewDef().getEntityReference(n).isReference()) {
                                throw deadEntityAccessException;
                            }
                            this.mPCollChanged = true;
                            this.mRows[n] = null;
                            var6_5 = null;
                            this.mQC.setEntityCacheAdd(null);
                        }
                    }
                    var6_5 = null;
                    this.mQC.setEntityCacheAdd(null);
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    this.mQC.setEntityCacheAdd(null);
                    throw throwable;
                }
            }
            ++n;
        }
    }

    protected void populateAttribute(int n, Object object) {
        MapInfo[] mapInfoArray = this.getMapInfo();
        if (n < mapInfoArray.length) {
            MapInfo mapInfo = mapInfoArray[n];
            if (mapInfo.getSourceIndex() == -1) {
                this.mPCollChanged = true;
                this.mCalcs[mapInfo.getIndex()] = object;
            } else {
                this.getEntity(mapInfo.getSourceIndex()).populateAttribute(mapInfo.getIndex(), object);
            }
        } else {
            this.setDynamicAttribute(this.getDynamicAttributeIndex(n), object);
        }
    }

    protected void populateAttributeAsChanged(int n, Object object) {
        MapInfo[] mapInfoArray = this.getMapInfo();
        if (n < mapInfoArray.length) {
            MapInfo mapInfo = mapInfoArray[n];
            if (mapInfo.getSourceIndex() == -1) {
                this.mPCollChanged = true;
                this.mCalcs[mapInfo.getIndex()] = object;
            } else {
                this.getEntity(mapInfo.getSourceIndex()).populateAttributeAsChanged(mapInfo.getIndex(), object);
            }
        } else {
            this.setDynamicAttribute(this.getDynamicAttributeIndex(n), object);
        }
    }

    private int getDynamicAttributeIndex(int n) {
        if (this.mViewDef == null) {
            return n - this.mVO.getDynamicAttributeOffset();
        }
        return n - this.mViewDef.getAttributeCount();
    }

    Object getDynamicAttribute(int n) {
        return this.mDynAttrs != null && n < this.mDynAttrs.size() ? this.mDynAttrs.get(n) : null;
    }

    void setDynamicAttribute(int n, Object object) {
        int n2 = this.mVO.getDynamicAttributeCount();
        this.mPCollChanged = true;
        if (this.mDynAttrs == null) {
            this.mDynAttrs = new ArrayList();
            JboEnvUtil.setSizeInArrayList(this.mDynAttrs, n2);
        } else if (n2 >= this.mDynAttrs.size()) {
            JboEnvUtil.setSizeInArrayList(this.mDynAttrs, n2);
        }
        this.mDynAttrs.set(n, object);
    }

    void setPostState(byte by) {
        this.mPCollChanged = true;
        this.mState = this.mState == 0 && by == 2 ? (byte)0 : by;
    }

    byte getNewRowState() {
        if (this.mState == -1 || this.mState == 0) {
            return this.mState;
        }
        return 127;
    }

    byte getPostState() {
        return this.mState;
    }

    void removeReference(EntityImpl entityImpl) {
        int n = 0;
        while (n < this.mRows.length) {
            if (this.mRows[n] == entityImpl) {
                this.mPCollChanged = true;
                this.mRows[n] = null;
            }
            ++n;
        }
    }

    void updateReference(int n, EntityImpl entityImpl) {
        this.mPCollChanged = true;
        this.mRows[n] = entityImpl;
    }

    Object[] getCalcAttrs() {
        return this.mCalcs;
    }

    void setCalcAttrs(Object[] objectArray) {
        this.mCalcs = objectArray;
    }

    final DBTransactionImpl getDBTransactionImpl() {
        return this.mVO.getDBTransactionImpl();
    }

    Object getAttributeInternal(int n, byte by) {
        if (by == 0) {
            return this.getAttributeInternal(n);
        }
        if (n == -1) {
            return null;
        }
        Object object = null;
        MapInfo[] mapInfoArray = this.getMapInfo();
        if (n < mapInfoArray.length) {
            MapInfo mapInfo = mapInfoArray[n];
            int n2 = mapInfo.getSourceIndex();
            int n3 = mapInfo.getIndex();
            if (n2 != -1) {
                EntityImpl entityImpl = this.mRows[n2];
                object = entityImpl == null ? null : entityImpl.getAttribute(n3, by);
                return object;
            }
        }
        throw new UnsupportedOperationException("Non-entity/Non-scalar attributes are not versioned");
    }

    byte getViewRowState() {
        if (!this.mVO.hasSingleUpdateParticipant()) {
            throw new JboException("Can't determine view row state with multiple entities");
        }
        int[] nArray = this.mVO.getInsertParticipants();
        if (nArray.length == 0) {
            return 1;
        }
        return this.getEntity(nArray[0]).getPostState();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PersKeyInfo {
        int mKeyId;
        Key mKey;

        PersKeyInfo(int n, Key key) {
            this.mKeyId = n;
            this.mKey = key;
        }
    }
}

