/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Hashtable;
import oracle.jbo.AttributeDef;
import oracle.jbo.InvalidOperException;
import oracle.jbo.Key;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.WeakKeyHashtable;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityReference;
import oracle.jbo.server.QueryCollection;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowStorage;

class ViewRowCache {
    private QueryCollection mQC;
    private HashMap mViewRowMap;
    static final String CACHE_DOTS = "*-*-*-*";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    public ViewRowCache(QueryCollection queryCollection) {
        this.mQC = queryCollection;
        this.mViewRowMap = new HashMap(2);
    }

    private Object getMapKey(Object object) {
        return object instanceof EntityImpl ? (Object)((EntityImpl)object).getEntityDef() : "NOENTITY";
    }

    void viewRowPassivated(ViewRowStorage viewRowStorage, EntityImpl entityImpl, Key key) {
        ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get(this.getMapKey(entityImpl));
        if (eRToVRInfo != null) {
            eRToVRInfo.viewRowPassivated(viewRowStorage, entityImpl, key);
        }
    }

    void viewRowActivated(ViewRowStorage viewRowStorage, EntityImpl entityImpl, Key key) {
        ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get(this.getMapKey(entityImpl));
        if (eRToVRInfo != null) {
            eRToVRInfo.viewRowActivated(viewRowStorage, entityImpl, key);
        }
    }

    void putRowsIntoRowCache(Object object, ArrayList arrayList) {
        Object object2 = this.getMapKey(object);
        ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get(object2);
        if (eRToVRInfo == null) {
            eRToVRInfo = new ERToVRInfo(object2);
            this.mViewRowMap.put(object2, (Object)eRToVRInfo);
        }
        eRToVRInfo.put(object, arrayList);
    }

    private ArrayList getRowsFromRowCache(Object object) {
        ArrayList arrayList = null;
        ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get(this.getMapKey(object));
        if (eRToVRInfo != null) {
            arrayList = eRToVRInfo.get(object);
            if (eRToVRInfo.mRowsInPStore > 0L) {
                eRToVRInfo.restoreViewRowCache(this.mQC, object, arrayList);
                arrayList = eRToVRInfo.get(object);
            }
        }
        return arrayList;
    }

    private void removeRowsFromRowCache(Object object) {
        ((ERToVRInfo)this.mViewRowMap.get(this.getMapKey(object))).remove(object);
    }

    void addToRowIds(ArrayList arrayList, long l, boolean bl) {
        int n = 0;
        while (n < arrayList.size()) {
            long l2 = (Long)arrayList.get(n);
            if (l2 == l) {
                return;
            }
            if (l2 > l) {
                arrayList.add(n, (Object)new Long(l));
                break;
            }
            ++n;
        }
        if (n >= arrayList.size()) {
            arrayList.add((Object)new Long(l));
        }
    }

    protected void addWithCheck(ViewRowStorage viewRowStorage, boolean bl) {
        if (!this.mQC.getViewObjectImpl().isManageRowsByKey()) {
            return;
        }
        int n = viewRowStorage.getEntityCount();
        if (n > 0) {
            ArrayList arrayList = new ArrayList();
            int n2 = 0;
            while (n2 < n) {
                EntityImpl entityImpl = viewRowStorage.getEntity(n2);
                if (entityImpl != null && !arrayList.contains((Object)entityImpl)) {
                    ArrayList arrayList2 = null;
                    ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get((Object)entityImpl.getEntityDef());
                    if (eRToVRInfo != null) {
                        arrayList2 = eRToVRInfo.get(entityImpl);
                    }
                    if (arrayList2 == null) {
                        arrayList2 = new ArrayList();
                        this.putRowsIntoRowCache(entityImpl, arrayList2);
                    }
                    this.addToRowIds(arrayList2, viewRowStorage.getPersistentId(), bl);
                    arrayList.add((Object)entityImpl);
                }
                ++n2;
            }
        } else {
            AttributeDef[] attributeDefArray = this.mQC.getViewObjectImpl().getKeyAttributeDefs();
            if (attributeDefArray == null || attributeDefArray.length == 0) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = ViewRowCache.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25059", new Object[]{this.mQC.getViewObjectImpl().getName()});
            }
            Key key = viewRowStorage.getRowImpl().getKey();
            ArrayList arrayList = null;
            ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get(this.getMapKey(key));
            if (eRToVRInfo != null) {
                arrayList = eRToVRInfo.get(key);
            }
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.putRowsIntoRowCache(key, arrayList);
            }
            this.addToRowIds(arrayList, viewRowStorage.getPersistentId(), bl);
        }
    }

    protected void add(ViewRowImpl viewRowImpl) {
        this.addWithCheck(viewRowImpl.getRowStorage(), false);
    }

    protected boolean remove(ViewRowImpl viewRowImpl, EntityImpl entityImpl) {
        if (this.isDeleteCandidate(viewRowImpl, entityImpl)) {
            this.removeReferenceRows(entityImpl);
            this.removeReferenceFromOthers(viewRowImpl, entityImpl);
            this.removeReference(viewRowImpl, entityImpl);
            return true;
        }
        return false;
    }

    protected int[] getViewRowIndexes(Object object) {
        ArrayList arrayList = this.getRows(object);
        if (arrayList == null) {
            return null;
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            nArray[n] = this.mQC.indexOf(arrayList.get(n));
            ++n;
        }
        return nArray;
    }

    protected void removeReferenceRows(EntityImpl entityImpl) {
        EntityReference[] entityReferenceArray = this.mQC.getViewObjectImpl().getViewDef().getEntityReferences();
        ArrayList arrayList = this.getRows(entityImpl);
        int n = arrayList.size() - 1;
        while (n >= 0) {
            ViewRowImpl viewRowImpl = (ViewRowImpl)arrayList.get(n);
            int n2 = 0;
            while (n2 < entityReferenceArray.length) {
                if (entityImpl == viewRowImpl.getEntity(n2) && entityReferenceArray[n2].isReference()) {
                    this.mQC.removeReference(viewRowImpl, entityImpl);
                    break;
                }
                ++n2;
            }
            --n;
        }
    }

    void removeReference(ViewRowImpl viewRowImpl) {
        int n = viewRowImpl.getEntityCount();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                EntityImpl entityImpl = viewRowImpl.getEntity(n2);
                this.removeReference(viewRowImpl, entityImpl);
                ++n2;
            }
        } else {
            this.removeReference(viewRowImpl, null);
        }
    }

    protected void removeReference(ViewRowImpl viewRowImpl, EntityImpl entityImpl) {
        Object object = entityImpl == null ? (Object)viewRowImpl.getKey() : entityImpl;
        ArrayList arrayList = this.getRowsFromRowCache(object);
        if (arrayList != null) {
            long l = viewRowImpl.getPersistentId();
            if (Diagnostic.isOn()) {
                Diagnostic.println("ViewRowCache: removeReference, vr id = " + l);
            }
            arrayList.remove((Object)new Long(l));
            if (arrayList.size() == 0) {
                this.removeRowsFromRowCache(object);
            }
        }
    }

    ViewRowImpl getRowFromId(long l) {
        return this.mQC.getRowStorageFromId(l).getRowImpl();
    }

    ArrayList getRowIds(Object object) {
        return this.getRowsFromRowCache(object);
    }

    protected ArrayList getRows(Object object) {
        if (object == null) {
            return null;
        }
        ArrayList arrayList = this.getRowIds(object);
        if (arrayList == null) {
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        int n = 0;
        while (n < arrayList.size()) {
            ViewRowImpl viewRowImpl = this.getRowFromId((Long)arrayList.get(n));
            arrayList2.add((Object)viewRowImpl);
            ++n;
        }
        return arrayList2;
    }

    protected void updateReference(ViewRowImpl viewRowImpl, EntityImpl entityImpl, EntityImpl entityImpl2) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("ViewRowCache: updateReference");
        }
        if (entityImpl2 != null) {
            int n = 0;
            EntityImpl[] entityImplArray = viewRowImpl.getEntities();
            if (entityImplArray.length > 1) {
                int n2 = 0;
                while (n2 < entityImplArray.length) {
                    if (entityImpl2 == entityImplArray[n2] && ++n > 1) break;
                    ++n2;
                }
            }
            if (n <= 1) {
                this.removeReference(viewRowImpl, entityImpl2);
            }
        }
        if (entityImpl == null) {
            return;
        }
        ArrayList arrayList = this.getRowIds(entityImpl);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.putRowsIntoRowCache(entityImpl, arrayList);
        }
        this.addToRowIds(arrayList, viewRowImpl.getPersistentId(), true);
    }

    public void dump(Writer writer) {
        int n = 0;
        PrintWriter printWriter = new PrintWriter(writer, true);
        printWriter.println("*-*-*-* " + this.mQC.getViewObjectImpl().getName() + " ViewRow cache listing " + CACHE_DOTS);
        EntityDefImpl[] entityDefImplArray = this.mQC.getViewObjectImpl().getViewDef().getEntityDefs();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < entityDefImplArray.length) {
            if (!arrayList.contains((Object)entityDefImplArray[n2])) {
                arrayList.add((Object)entityDefImplArray[n2]);
                printWriter.println(" EntityDefImpl: " + entityDefImplArray[n2].getName());
                ERToVRInfo eRToVRInfo = (ERToVRInfo)this.mViewRowMap.get((Object)entityDefImplArray[n2]);
                Dictionary dictionary = eRToVRInfo != null ? eRToVRInfo.getERToVRMap() : null;
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = new ArrayList();
                int n3 = n2;
                while (n3 < entityDefImplArray.length) {
                    if (entityDefImplArray[n3] == entityDefImplArray[n2]) {
                        int n4 = 0;
                        while (n4 < this.mQC.getCollectionSize()) {
                            EntityImpl entityImpl = ((ViewRowImpl)this.mQC.get(n4)).getEntity(n3);
                            if (entityImpl != null && !arrayList2.contains((Object)entityImpl) && !arrayList3.contains((Object)entityImpl)) {
                                Key key = entityImpl.getKey();
                                if (key == null) {
                                    arrayList3.add((Object)entityImpl);
                                } else {
                                    arrayList2.add((Object)entityImpl);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n3;
                }
                int n5 = this.dumpEntities(arrayList2, dictionary, printWriter, false);
                if (arrayList3.size() > 0) {
                    printWriter.println(" Entities with NULL key...");
                    n5 += this.dumpEntities(arrayList3, dictionary, printWriter, true);
                }
                printWriter.println(" (" + n5 + ") entries");
                n += n5;
                printWriter.println();
            }
            ++n2;
        }
        printWriter.println("*-*-*-* (" + n + ") total entries " + CACHE_DOTS);
    }

    private int dumpEntities(ArrayList arrayList, Object object, PrintWriter printWriter, boolean bl) {
        String string = bl ? "  ViewRow key: " : "  Entity key: ";
        int n = 0;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            EntityImpl entityImpl = (EntityImpl)arrayList.get(n2);
            ArrayList arrayList2 = null;
            if (object != null) {
                arrayList2 = this.getRowIds(entityImpl);
            }
            if (arrayList2 != null) {
                Key key;
                if (bl) {
                    ViewRowImpl viewRowImpl = this.getRowFromId((Long)arrayList2.get(0));
                    Object object2 = viewRowImpl.getHandle();
                    key = new Key(new Object[]{object2});
                    printWriter.println(string + key.toString());
                } else {
                    key = entityImpl.getKey();
                    printWriter.println(string + key.toString());
                }
                String string2 = new String("[ ");
                int n3 = 0;
                while (n3 < arrayList2.size()) {
                    ViewRowImpl viewRowImpl = this.getRowFromId((Long)arrayList2.get(n3));
                    string2 = string2.concat(this.mQC.indexOf(viewRowImpl) + " ");
                    ++n3;
                }
                string2 = string2.concat("]");
                printWriter.println("   Row indexes: " + string2);
                if (arrayList2.size() > 0) {
                    ++n;
                }
            }
            ++n2;
        }
        return n;
    }

    private boolean isDeleteCandidate(ViewRowImpl viewRowImpl, EntityImpl entityImpl) {
        int n = viewRowImpl.getEntityCount();
        int n2 = 0;
        while (n2 < n) {
            if (entityImpl == viewRowImpl.getEntity(n2) && this.mQC.getViewObjectImpl().getViewDef().getEntityReference(n2).isDeleteParticipant()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void removeReferenceFromOthers(ViewRowImpl viewRowImpl, EntityImpl entityImpl) {
        int n = viewRowImpl.getEntityCount();
        int n2 = 0;
        while (n2 < n) {
            EntityImpl entityImpl2 = viewRowImpl.getEntity(n2);
            if (entityImpl != entityImpl2 && entityImpl2 != null) {
                this.removeReference(viewRowImpl, entityImpl2);
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ERToVRInfo {
        private static final int PSTORE_COUNT_SIZE = 31;
        private static final byte PSTORE_TOO_MANY = -1;
        private byte[] mPStoreCount;
        private long mRowsInPStore;
        private boolean mIsKeyEntity;
        private Dictionary mERToVRMap;

        private /* synthetic */ void $init$() {
            this.mPStoreCount = null;
            this.mRowsInPStore = 0L;
            this.mIsKeyEntity = false;
            this.mERToVRMap = null;
        }

        ERToVRInfo(Object object) {
            this.$init$();
            this.mIsKeyEntity = object instanceof EntityDefImpl;
        }

        final ArrayList get(Object object) {
            return this.mERToVRMap != null ? (ArrayList)this.mERToVRMap.get(object) : null;
        }

        final void put(Object object, ArrayList arrayList) {
            if (this.mERToVRMap == null) {
                this.mERToVRMap = this.mIsKeyEntity ? (Dictionary)new WeakKeyHashtable(4) : new Hashtable(4);
            }
            this.mERToVRMap.put(object, arrayList);
        }

        final void remove(Object object) {
            if (this.mERToVRMap != null) {
                this.mERToVRMap.remove(object);
            }
        }

        final void clear() {
            if (this.mERToVRMap != null) {
                if (this.mIsKeyEntity) {
                    ((WeakKeyHashtable)this.mERToVRMap).clear();
                } else {
                    ((Hashtable)this.mERToVRMap).clear();
                }
            }
        }

        final long getRowsInPStore() {
            return this.mRowsInPStore;
        }

        final Dictionary getERToVRMap() {
            return this.mERToVRMap;
        }

        final int getIndex(Key key) {
            int n = key.hashCode();
            if (n < 0) {
                n = -n;
            }
            return n % 31;
        }

        final Key getRowKey(Object object) {
            return object instanceof EntityImpl ? ((EntityImpl)object).getPrimaryKey() : (Key)object;
        }

        final void restoreViewRowCache(QueryCollection queryCollection, Object object, ArrayList arrayList) {
            int n;
            Key key = this.getRowKey(object);
            if (key != null && this.mPStoreCount[n = this.getIndex(key)] != 0) {
                queryCollection.restoreViewRowCache(object, key, arrayList, true);
            }
        }

        final void viewRowPassivated(ViewRowStorage viewRowStorage, EntityImpl entityImpl, Key key) {
            int n;
            ++this.mRowsInPStore;
            if (this.mPStoreCount == null) {
                this.mPStoreCount = new byte[31];
            }
            if (this.mPStoreCount[n = this.getIndex(key)] != -1) {
                int n2 = n;
                this.mPStoreCount[n2] = (byte)(this.mPStoreCount[n2] + 1);
                if (Diagnostic.isOn() && this.mPStoreCount[n] == -1) {
                    Diagnostic.println("###$$$ PSTORE_TOO_MANY reached!!! ###$$$");
                }
            }
        }

        final void viewRowActivated(ViewRowStorage viewRowStorage, EntityImpl entityImpl, Key key) {
            --this.mRowsInPStore;
            if (this.mRowsInPStore < 0L) {
                Diagnostic.ASSERT(false, "mRowsInPStore is < 0 for " + entityImpl.getEntityDef().getName() + ", key=" + key);
            } else if (this.mRowsInPStore == 0L) {
                this.mPStoreCount = null;
            } else {
                int n = this.getIndex(key);
                if (this.mPStoreCount[n] != -1) {
                    int n2 = n;
                    this.mPStoreCount[n2] = (byte)(this.mPStoreCount[n2] - 1);
                }
            }
        }
    }
}

