/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import oracle.jbo.server.SparseArrayInterface;

public class SparseArray
implements SparseArrayInterface {
    private Object[] mStorage;
    private byte[] mSlots;
    private static final int STORAGE_INCR = 5;
    private static final int SLOT_INCR = 1;
    private static final byte[] BIT_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};

    SparseArray(int n) {
        this.mStorage = new Object[n];
        this.mSlots = new byte[n / 8 + 1];
    }

    public Object get(int n) {
        return this.mStorage[n];
    }

    public void set(int n, Object object) {
        this.mStorage[n] = object;
        int n2 = n / 8;
        this.mSlots[n2] = (byte)(this.mSlots[n2] | 1 << n % 8);
    }

    public boolean isPopulated(int n) {
        return (this.mSlots[n / 8] & 1 << n % 8) != 0;
    }

    public void clear(int n) {
        this.mStorage[n] = null;
        int n2 = n / 8;
        this.mSlots[n2] = (byte)(this.mSlots[n2] & ~(1 << n % 8));
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        stringBuffer.append("[" + this.mStorage.length + "]");
        stringBuffer.append('{');
        int n3 = 0;
        while (n3 < this.mStorage.length) {
            if (this.isPopulated(n3)) {
                if (++n2 != 1) {
                    stringBuffer.append(", ");
                }
                if (n2 > n && n != 0) {
                    n3 = this.mStorage.length;
                    stringBuffer.append("...");
                } else {
                    if (this.get(n3) != null) {
                        stringBuffer.append(this.get(n3).toString());
                    } else {
                        stringBuffer.append("<null>");
                    }
                    stringBuffer.append('[');
                    stringBuffer.append(n3);
                    stringBuffer.append(']');
                }
            }
            ++n3;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean isEmpty() {
        int n = 0;
        while (n < this.mStorage.length) {
            if (this.isPopulated(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public SparseArray toSparseArray() {
        return this;
    }
}

