/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import oracle.jbo.server.QueryDump;
import oracle.jbo.server.util.Canonizer;

class QueryDumpCSV
implements QueryDump {
    static final int TYP_VARCHAR2 = 12;
    static final int TYP_DATE = 93;
    private ResultSet mRslt;
    private StringWriter mSW;
    private PrintWriter mOut;
    private int[] mDataTypes;
    private int[] mPrecisions;
    private int[] mScales;

    private /* synthetic */ void $init$() {
        this.mRslt = null;
        this.mSW = null;
        this.mOut = null;
        this.mDataTypes = null;
        this.mPrecisions = null;
        this.mScales = null;
    }

    QueryDumpCSV() {
        this.$init$();
    }

    public String initialize(String string, String[] stringArray) {
        return null;
    }

    private void processHeader() throws SQLException, IOException {
        ResultSetMetaData resultSetMetaData = this.mRslt.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.mDataTypes = new int[n];
        this.mPrecisions = new int[n];
        this.mScales = new int[n];
        int n2 = 1;
        while (n2 <= n) {
            String string = resultSetMetaData.getColumnLabel(n2);
            if (n2 > 1) {
                this.mOut.print(",");
            }
            this.mOut.print("\"" + string + "\"");
            this.mDataTypes[n2 - 1] = resultSetMetaData.getColumnType(n2);
            this.mPrecisions[n2 - 1] = resultSetMetaData.getPrecision(n2);
            this.mScales[n2 - 1] = resultSetMetaData.getScale(n2);
            ++n2;
        }
        this.mOut.print("\r\n");
    }

    private void processData() throws SQLException, IOException {
        while (this.mRslt.next()) {
            int n = 1;
            while (n <= this.mDataTypes.length) {
                if (n > 1) {
                    this.mOut.print(",");
                }
                switch (this.mDataTypes[n - 1]) {
                    case 2: 
                    case 3: 
                    case 4: {
                        Object object = this.mRslt.getObject(n);
                        if (object == null) {
                            object = new Integer(0);
                        }
                        this.mOut.print(Canonizer.canonizeString(object));
                        break;
                    }
                    default: {
                        Object object = this.mRslt.getObject(n);
                        if (object == null) {
                            object = "";
                        }
                        this.mOut.print("\"" + Canonizer.canonizeString(object) + "\"");
                    }
                }
                ++n;
            }
            this.mOut.print("\r\n");
        }
    }

    public String dumpQueryResult(ResultSet resultSet, String[] stringArray) throws SQLException, IOException {
        this.mRslt = resultSet;
        this.mSW = new StringWriter();
        this.mOut = new PrintWriter(this.mSW);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n] != null && stringArray[n].length() > 0) {
                    if (stringArray[n].startsWith("$dateformat$=")) {
                        String string = stringArray[n].substring("$dateformat$=".length());
                        int n2 = new Integer(string);
                        Canonizer.setDateFormat(n2);
                    } else {
                        this.mOut.print("User data #" + n + ": " + Canonizer.canonizeString(stringArray[n]) + "\r\n");
                    }
                }
                ++n;
            }
        }
        this.processHeader();
        this.processData();
        this.mOut.flush();
        this.mSW.flush();
        this.mOut.close();
        this.mSW.flush();
        return this.mSW.toString();
    }
}

