/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.AbstractList;
import com.sun.java.util.collections.ArrayList;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeadEntityAccessException;
import oracle.jbo.InvalidObjAccessException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.SQLStmtException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.EventGroup;
import oracle.jbo.common.InstrumentedEvent;
import oracle.jbo.domain.NullValue;
import oracle.jbo.mom.LongRunningStatementHandle;
import oracle.jbo.pcoll.PCollListener;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollPersistable;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.server.ApplicationModuleImpl;
import oracle.jbo.server.AssociationDefImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.AttributeListImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.EntityAssociationReference;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.EntityReference;
import oracle.jbo.server.MapInfo;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.RowFilter;
import oracle.jbo.server.RowFilterKeyForwardOnly;
import oracle.jbo.server.RowImpl;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowCache;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.ViewRowStorage;

public class QueryCollection
extends AbstractList
implements PCollListener {
    private ArrayList mUnpostedRows;
    private PCollection mPCollRows;
    private PCollection mPCollNewRows;
    private com.sun.java.util.collections.Iterator mEntityCacheRows;
    private boolean mFetchComplete;
    PreparedStatement mStatement;
    boolean mBoundNullParams;
    private ResultSet mResultSet;
    private boolean mExecuted;
    private MapInfo[] mMap;
    private int mColumnCount;
    private long mEstimatedRowCount;
    private long mEarlyRowCount;
    private long mChangedRowCount;
    private ViewRowCache mViewRowCache;
    private ViewObjectImpl mVO;
    private RowFilter mRowFilter;
    private int mNumUserParams;
    private int mRowsFetched;
    private byte mAccessMode;
    private String mName;
    private boolean mIsDirty;
    private int mPinned;
    private boolean mIsPinnedTemporarily;
    private boolean mIsSkipQuery;
    private boolean mIsScanBase;
    private byte mViewLinkMode;
    private int mQueryTS;
    private Object mUserData;
    private static int mQueryTSCounter = 0;
    ArrayList mNewRowTracker;
    private boolean mMaxRowExceeded;
    private boolean mResetCollection;
    private EntityImpl mEntityCacheAdd;
    int mPageSize;
    int mPageStart;
    boolean mPageRowCountDirty;
    private ResultSetStateHolder mResultSetStateHolder;
    private boolean mSkipDuplicateRows;
    private Object[] mParams;
    private int mNoUserParams;
    private static final int BUILD_RESULT_SET_RESTORE_STATE = 1;
    private LongRunningStatementHandle mLongRunningStatementHandle;
    private ViewRowImpl _mBackupRow;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mUnpostedRows = null;
        this.mPCollRows = null;
        this.mPCollNewRows = null;
        this.mEntityCacheRows = null;
        this.mFetchComplete = false;
        this.mStatement = null;
        this.mBoundNullParams = false;
        this.mExecuted = false;
        this.mColumnCount = -1;
        this.mEstimatedRowCount = -1;
        this.mEarlyRowCount = 0L;
        this.mChangedRowCount = 0L;
        this.mNumUserParams = 0;
        this.mRowsFetched = 0;
        this.mAccessMode = 0;
        this.mName = null;
        this.mIsDirty = false;
        this.mPinned = 0;
        this.mIsPinnedTemporarily = false;
        this.mIsSkipQuery = false;
        this.mIsScanBase = false;
        this.mViewLinkMode = (byte)-1;
        this.mQueryTS = -1;
        this.mUserData = null;
        this.mMaxRowExceeded = false;
        this.mResetCollection = false;
        this.mEntityCacheAdd = null;
        this.mPageRowCountDirty = false;
        this.mResultSetStateHolder = null;
        this.mSkipDuplicateRows = false;
        this.mParams = null;
        this.mNoUserParams = -1;
        this.mLongRunningStatementHandle = null;
        this._mBackupRow = null;
    }

    QueryCollection(ViewRowSetImpl viewRowSetImpl) {
        this.$init$();
        this.initQC(viewRowSetImpl.getViewObjectImpl(), viewRowSetImpl, viewRowSetImpl.getName());
    }

    QueryCollection(ViewObjectImpl viewObjectImpl) {
        this.$init$();
        this.initQC(viewObjectImpl, viewObjectImpl.getDefaultRowSet(), viewObjectImpl.getName());
    }

    final Object getSyncLock() {
        return ((ApplicationModuleImpl)this.mVO.getApplicationModule()).getSyncLock();
    }

    final boolean isRangePaging() {
        return this.mAccessMode == 2 || this.mAccessMode == 3;
    }

    final boolean isForwardOnly() {
        return this.mAccessMode == 1;
    }

    void setAccessMode(byte by) {
        this.mAccessMode = by;
    }

    void setRangeSize(int n) {
        this.mPageSize = n;
    }

    private void initPCollRows() {
        int n = this.mVO.getViewDef().getMaxRowsPerNode();
        int n2 = this.mVO.getViewDef().getMaxActiveNodes();
        this.mPCollRows = this.getPCollManager().createCollection(this.mName, n, n2);
        this.mPCollRows.setCommitThreshhold(50);
        this.mPCollRows.enableIdAccess();
        this.mPCollRows.setListener(this);
    }

    private void initQC(ViewObjectImpl viewObjectImpl, ViewRowSetImpl viewRowSetImpl, String string) {
        this.mVO = viewObjectImpl;
        this.mName = string;
        this.mAccessMode = viewRowSetImpl.getAccessMode();
        this.mPageSize = viewRowSetImpl.getRangeSize();
        this.mViewLinkMode = viewRowSetImpl.isAssociationConsistent() ? (byte)1 : 0;
        this.mPageStart = 0;
        this.initPCollRows();
    }

    Object getUserData() {
        return this.mUserData;
    }

    void setUserData(Object object) {
        this.mUserData = object;
    }

    void setNewRowTracker(ArrayList arrayList) {
        this.mNewRowTracker = arrayList;
    }

    byte getViewLinkMode() {
        return this.mViewLinkMode;
    }

    void setViewLinkMode(byte by) {
        this.mViewLinkMode = by;
    }

    boolean isAssociationConsistent() {
        return this.mViewLinkMode == 1;
    }

    void setAssociationConsistent(boolean bl) {
        this.mViewLinkMode = bl ? (byte)1 : 0;
    }

    public void beforePassivateElement(PCollection pCollection, PCollPersistable pCollPersistable) {
    }

    public void afterActivateElement(PCollection pCollection, PCollPersistable pCollPersistable) {
        if (pCollection == this.mPCollRows && pCollPersistable instanceof ViewRowStorage) {
            this.mViewRowCache.addWithCheck((ViewRowStorage)pCollPersistable, true);
        }
    }

    void restoreViewRowCache(Object object, Key key, ArrayList arrayList, boolean bl) {
        int n = object instanceof EntityImpl ? ((EntityImpl)object).getEntityDef().getEntityDefId() : 0;
        int n2 = 0;
        long[] lArray = null;
        if (this.mPCollRows != null) {
            lArray = this.mPCollRows.idsWithKey(n, key);
            n2 = lArray.length;
        }
        if (n2 > 0) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.mViewRowCache.putRowsIntoRowCache(object, arrayList);
            }
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    this.mViewRowCache.addToRowIds(arrayList, lArray[n3], bl);
                    ++n3;
                }
            }
        }
    }

    public long getNextObjId() {
        return this.getPCollManager().getNextObjId();
    }

    PCollManager getPCollManager() {
        PCollManager pCollManager = this.mVO.getDBTransactionImpl().getPCollManager();
        if (pCollManager == null || !pCollManager.isOpen()) {
            throw new InvalidObjAccessException(111, this.mVO.getName());
        }
        return pCollManager;
    }

    int[] getCollMgmtInfo() {
        return new int[]{this.mPCollRows.getNumActiveLeafNodes(), this.mPCollRows.getMaxActiveLeafNodes()};
    }

    private void clearParameters(PreparedStatement preparedStatement) throws SQLException {
        block2: {
            try {
                preparedStatement.clearParameters();
            }
            catch (NullPointerException nullPointerException) {
                if (!Diagnostic.isOn()) break block2;
                Diagnostic.println("clearParameters failed; probably no parameters in the statement");
                Diagnostic.printStackTrace(nullPointerException);
            }
        }
    }

    void closeCollection() {
        if (this.mVO != null) {
            this.mVO.releaseUserDataForCollection(this, this.mUserData);
            this.mUserData = null;
            this.mVO.removeQueryCollectionFromCache(this, this.mRowFilter);
        }
        this.emptyCollection();
        if (this.mPCollRows != null) {
            this.mPCollRows.close();
            this.mPCollRows = null;
        }
        if (this.mPCollNewRows != null) {
            this.mPCollNewRows.close();
            this.mPCollNewRows = null;
        }
        this.mEntityCacheRows = null;
        this.setNewRowTracker(null);
        this.mColumnCount = -1;
        this.mRowsFetched = 0;
        this.mFetchComplete = false;
        if (this.mResultSet != null) {
            try {
                this.mResultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.mResultSet = null;
        this.mResultSetStateHolder = null;
        this.mSkipDuplicateRows = false;
        this.mExecuted = false;
        this.mMap = null;
        this.mViewRowCache = null;
        this.mEstimatedRowCount = -1;
        this.mEarlyRowCount = 0L;
        this.mChangedRowCount = 0L;
        this.mIsDirty = false;
        this.mPinned = 0;
        this.mIsPinnedTemporarily = false;
        this.mIsSkipQuery = false;
        this.mPageRowCountDirty = false;
        this.mMaxRowExceeded = false;
        if (this.mVO != null) {
            this.mVO.freeStatement(this.mStatement, this.mBoundNullParams, false);
        }
        this.mVO = null;
        this.mRowFilter = null;
        this.mNumUserParams = 0;
        this.mStatement = null;
        this.mUnpostedRows = null;
    }

    final ViewObjectImpl getViewObjectImpl() {
        return this.mVO;
    }

    final SQLBuilder getSQLBuilder() {
        if (this.mVO != null) {
            return this.mVO.getSQLBuilder();
        }
        return null;
    }

    static int getNewQueryTS() {
        return mQueryTSCounter++;
    }

    int getQueryTS() {
        return this.mQueryTS;
    }

    void setResultSet(ResultSet resultSet) {
        this.mResultSet = resultSet;
        this.mResultSetStateHolder = null;
        this.mSkipDuplicateRows = false;
    }

    private ResultSet getResultSet() {
        if (this.mResultSet == null && this.mResultSetStateHolder != null) {
            this.buildResultSet(this.mVO, 1);
        }
        return this.mResultSet;
    }

    void removeUnqualifiedRows() {
        int n = (int)this.mPCollRows.size();
        int n2 = 0;
        this.mEarlyRowCount = 0L;
        int n3 = 0;
        while (n3 < n) {
            ViewRowImpl viewRowImpl = ((ViewRowStorage)this.mPCollRows.elementAt(n2)).getRowImpl();
            if (!this.rowQualifies(viewRowImpl)) {
                this.removeRow(viewRowImpl, n2, true, 3);
            } else {
                ++n2;
            }
            ++n3;
        }
        this.mEarlyRowCount = this.mPCollRows.size();
    }

    void prepForQuery(boolean bl) {
        if (this.mResetCollection || (this.getViewObjectImpl().getQueryMode() & 1) != 0) {
            this.resetCollection(true);
        }
        if (this.mUnpostedRows == null && this.isAssociationConsistent()) {
            if (!this.mExecuted) {
                this.setNewRowTracker(null);
            }
            this.findUnpostedRows(false, false);
            if (bl) {
                this.fetch(this.mUnpostedRows.size() - 1);
            }
        }
    }

    boolean fetchUnpostedRows() {
        int n;
        if (this.mUnpostedRows != null && (n = this.mUnpostedRows.size()) > 0) {
            this.fetch(this.getFetchedRowCount() + n - 1);
            return true;
        }
        return false;
    }

    void setExecuted(boolean bl) {
        this.mExecuted = bl;
    }

    void executeQuery(Object[] objectArray, int n) {
        ArrayList arrayList = this.mNewRowTracker;
        ViewObjectImpl viewObjectImpl = this.getViewObjectImpl();
        viewObjectImpl.processCacheFilters();
        this.prepForQuery(false);
        if (this.mExecuted) {
            return;
        }
        this.mParams = objectArray;
        this.mNoUserParams = n;
        if (viewObjectImpl == null) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = QueryCollection.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25015", new Object[]{this.getName()});
        }
        try {
            if (this.mResultSet != null) {
                this.mResultSet.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (arrayList == this.mNewRowTracker && arrayList != null) {
            this.setNewRowTracker(null);
        }
        this.buildResultSet(viewObjectImpl, 0);
        if (viewObjectImpl.getSortCriteria() != null) {
            this.fetch(-1);
            int n2 = (int)this.mPCollRows.size();
            if (n2 > 0) {
                Row[] rowArray = new Row[n2];
                int n3 = 0;
                while (n3 < n2) {
                    rowArray[n3] = (Row)this.get(n3);
                    ++n3;
                }
                viewObjectImpl.sortRows(rowArray);
                this.mPCollRows.close();
                this.initPCollRows();
                int n4 = 0;
                while (n4 < n2) {
                    this.mPCollRows.addElement(((ViewRowImpl)rowArray[n4]).getRowStorage());
                    ++n4;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildResultSet(ViewObjectImpl viewObjectImpl, int n) {
        ResultSetStateHolder resultSetStateHolder = this.mResultSetStateHolder;
        this.mResultSetStateHolder = null;
        int n2 = viewObjectImpl.getMaxFetchSize();
        int n3 = viewObjectImpl.getQueryMode();
        this._mBackupRow = null;
        if (this.mIsSkipQuery || !viewObjectImpl.hasQuery() || n2 == 0 || (n3 & 4) == 0) {
            this.mExecuted = true;
            if (viewObjectImpl.isQueryChanged()) {
                viewObjectImpl.processCacheFilters();
                viewObjectImpl.setQueryChanged(false);
            }
            this.removeUnqualifiedRows();
            if (n2 != 0) {
                if (n3 != 1) return;
            }
            this.mFetchComplete = true;
            return;
        }
        boolean bl = false;
        try {
            AttributeDefImpl[] attributeDefImplArray;
            if (this.mStatement == null) {
                boolean[] blArray = new boolean[]{false};
                this.mStatement = viewObjectImpl.getPreparedStatement(this.mNoUserParams, blArray);
                bl = blArray[0];
            } else {
                this.clearParameters(this.mStatement);
                this.getSQLBuilder().doStatementSetRowPrefetch(this.mStatement, viewObjectImpl.getFetchSize());
                bl = this.mBoundNullParams;
            }
            if (n2 > 0) {
                this.mStatement.setMaxRows(n2);
            } else {
                this.mStatement.setMaxRows(0);
            }
            this.mVO.bindParametersForCollection(this, this.mParams, this.mStatement);
            if (bl && (attributeDefImplArray = viewObjectImpl.getViewAttributeDefImpls()) != null) {
                this.getSQLBuilder().doPreparedStatementDefines(this.mStatement, attributeDefImplArray);
            }
        }
        catch (SQLException sQLException) {
            this.mVO.freeStatement(this.mStatement, true, true);
            this.mStatement = null;
            if (Diagnostic.isOn()) {
                Diagnostic.println("QueryCollection.executeQuery failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            Class clazz = class$oracle$jbo$CSMessageBundle;
            Class clazz2 = clazz;
            if (clazz != null) throw new SQLStmtException(clazz2, "27122", viewObjectImpl.buildQuery(this.mNoUserParams, false), sQLException);
            clazz2 = class$oracle$jbo$CSMessageBundle = QueryCollection.class$("oracle.jbo.CSMessageBundle");
            throw new SQLStmtException(clazz2, "27122", viewObjectImpl.buildQuery(this.mNoUserParams, false), sQLException);
        }
        boolean bl2 = (n & 1) > 0;
        try {
            block32: {
                int n4 = 0;
                if (InstrumentedEvent.isActive) {
                    n4 = InstrumentedEvent.startEvent(EventGroup.JDBC_EXECUTE, "QueryCollection jdbc executeQuery " + this.mVO.getName());
                }
                this.createHandleForCancellableStatements(this.mStatement);
                try {
                    this.mVO.setResultSetForCollection(this, this.mStatement.executeQuery());
                    Object var15_12 = null;
                    if (this.mLongRunningStatementHandle != null) {
                        if (this.mLongRunningStatementHandle.getState() != 2) {
                            this.mLongRunningStatementHandle.setState(0);
                        }
                        this.mLongRunningStatementHandle = null;
                    }
                    if (!InstrumentedEvent.isActive) break block32;
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    if (this.mLongRunningStatementHandle != null) {
                        if (this.mLongRunningStatementHandle.getState() != 2) {
                            this.mLongRunningStatementHandle.setState(0);
                        }
                        this.mLongRunningStatementHandle = null;
                    }
                    if (!InstrumentedEvent.isActive) throw throwable;
                    InstrumentedEvent.endEvent(n4);
                    throw throwable;
                }
                InstrumentedEvent.endEvent(n4);
            }
            if (bl2) {
                this.restoreResultSetState(resultSetStateHolder);
                return;
            }
            this.mExecuted = true;
            this.mMaxRowExceeded = false;
            this.mQueryTS = QueryCollection.getNewQueryTS();
            if (this.mColumnCount < 0) {
                this.createColumnList();
            }
            if (this.mVO.getViewDef().isFetchAhead()) {
                this.hasNext();
            } else if (this.mVO.getViewDef().hasLongData()) {
                this.hasNext();
                this.saveNextRowInResultSet();
            }
            if (viewObjectImpl.getFetchMode() == 1 && this.mAccessMode == 0) {
                this.fetch(-1);
                return;
            }
            if (this.isRangePaging() && this.fetch(this.mPageSize + 1)) {
                this.mFetchComplete = false;
            }
            if (this.mStatement == null) return;
            this.clearParameters(this.mStatement);
            return;
        }
        catch (SQLException sQLException) {
            try {
                if (this.mResultSet != null) {
                    this.mResultSet.close();
                    this.mResultSet = null;
                }
                if (this.mStatement != null) {
                    this.mVO.freeStatement(this.mStatement, true, true);
                    this.mStatement = null;
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("QueryCollection.executeQuery failed...");
                Diagnostic.printStackTrace(sQLException);
            }
            this.getSQLBuilder().processException("27122", sQLException, new Object[]{viewObjectImpl.buildQuery(this.mNoUserParams, false)});
        }
    }

    private void restoreResultSetState(ResultSetStateHolder resultSetStateHolder) throws SQLException {
        this.mSkipDuplicateRows = true;
        ViewRowImpl viewRowImpl = null;
        PCollPersistable pCollPersistable = this.mPCollRows != null && this.mPCollRows.size() > 0L ? this.mPCollRows.elementAt(this.mPCollRows.size() - 1L) : null;
        ArrayList arrayList = null;
        ViewObjectImpl viewObjectImpl = this.mVO;
        if (this.mResultSet.getType() != 1003) {
            if (resultSetStateHolder.mRow > 1) {
                this.mResultSet.absolute(resultSetStateHolder.mRow - 1);
            }
            if ((viewRowImpl = viewObjectImpl.createInstanceFromResultSet(this, this.mResultSet)) == null) {
                return;
            }
            arrayList = this.findByKey(viewRowImpl.getKey(), 1);
            if (arrayList.size() > 0 && (this.isForwardOnly() || ((ViewRowImpl)arrayList.get(0)).getRowStorage().equals(pCollPersistable))) {
                return;
            }
            this.mResultSet.beforeFirst();
        }
        ArrayList arrayList2 = new ArrayList(resultSetStateHolder.mRow);
        int n = -1;
        if (!this.mVO.isManageRowsByKey() && resultSetStateHolder.mRow > 1) {
            int n2 = 0;
            while (n2 < resultSetStateHolder.mRow) {
                this.hasNext();
                ++n2;
            }
        } else if (resultSetStateHolder != null && resultSetStateHolder.mRow > 1) {
            while (this.hasNext()) {
                viewRowImpl = viewObjectImpl.createInstanceFromResultSet(this, this.mResultSet);
                if (viewRowImpl != null) {
                    arrayList = this.findByKey(viewRowImpl.getKey(), 1);
                    if (arrayList.size() > 0) {
                        if (((ViewRowImpl)arrayList.get(0)).getRowStorage().equals(pCollPersistable)) {
                            this.hasNext();
                            return;
                        }
                        if (this.mPCollRows.indexOf(((ViewRowImpl)arrayList.get(0)).getRowStorage()) < 0L) continue;
                        n = arrayList2.size();
                        continue;
                    }
                    arrayList2.add((Object)viewRowImpl);
                    continue;
                }
                break;
            }
        } else {
            this.hasNext();
        }
        if (arrayList2.size() == 0) {
            return;
        }
        if (n <= 0) {
            ViewRowImpl viewRowImpl2 = null;
            int n3 = 0;
            while (n3 < arrayList2.size()) {
                viewRowImpl2 = (ViewRowImpl)arrayList2.get(n3);
                if (this.rowQualifies(viewRowImpl2)) {
                    // empty if block
                }
                this.addRowToColl(viewRowImpl2);
                ++n3;
            }
        } else {
            int n4 = arrayList2.size() - n;
            ViewRowImpl viewRowImpl3 = null;
            int n5 = 0;
            while (n5 < n4) {
                viewRowImpl3 = (ViewRowImpl)arrayList2.get(n5 + n);
                if (this.rowQualifies(viewRowImpl3)) {
                    this.addRowToColl(viewRowImpl3);
                }
                ++n5;
            }
        }
    }

    public boolean cancelQuery() {
        if (this.mLongRunningStatementHandle != null) {
            return this.mLongRunningStatementHandle.cancel();
        }
        return false;
    }

    private void createHandleForCancellableStatements(Statement statement) {
        int n = this.mVO.getQueryTimeOut();
        if (n > 0) {
            this.mLongRunningStatementHandle = new LongRunningStatementHandle(System.currentTimeMillis() + (long)n, statement);
            MetaObjectManager.getSingleton().getStatementMonitor().monitor(this.mLongRunningStatementHandle);
        } else {
            this.mLongRunningStatementHandle = new LongRunningStatementHandle(-1, statement);
        }
    }

    int getAttributeCount() {
        if (this.mColumnCount < 0) {
            return 0;
        }
        return this.mColumnCount;
    }

    int getCalculatedAttributeCount() {
        return this.mVO.getCalculatedAttributeCount();
    }

    private MapInfo[] getMapInfo() {
        if (this.mColumnCount < 0) {
            this.createColumnList();
        }
        return this.mMap;
    }

    ViewRowSetImpl createViewRowSet() {
        ViewRowSetImpl viewRowSetImpl = this.mVO.createViewRowSet(null, false);
        viewRowSetImpl.setRangeSize(-1);
        RowFilter rowFilter = this.getRowFilter();
        if (rowFilter != null) {
            viewRowSetImpl.setParamValues(rowFilter.getWhereClauseParams());
        }
        viewRowSetImpl.setQueryCollection(this);
        viewRowSetImpl.setOwnedByQC(true);
        return viewRowSetImpl;
    }

    AttributeList getRowInitValues() {
        AttributeListImpl attributeListImpl;
        ArrayList arrayList = this.mVO.getViewLinkDestinationAttributes();
        RowFilter rowFilter = this.getRowFilter();
        if (rowFilter == null) {
            return null;
        }
        Object[] objectArray = rowFilter.getRowInitValues();
        if (objectArray != null && arrayList != null) {
            attributeListImpl = new AttributeListImpl(objectArray.length);
            int n = 0;
            int n2 = this.mNumUserParams;
            while (n2 < objectArray.length) {
                attributeListImpl.setAttribute(((AttributeDefImpl)arrayList.get(n)).getName(), objectArray[n2]);
                ++n;
                ++n2;
            }
        } else {
            attributeListImpl = new AttributeListImpl(0);
        }
        return attributeListImpl;
    }

    void addNewRow(ViewRowImpl viewRowImpl) {
        if (this.mPCollNewRows == null) {
            if (!this.isExecuted() && this.mVO.getMaxFetchSize() == 0) {
                ViewRowSetImpl viewRowSetImpl = this.mVO.findRowSetForQueryCollection(this, true);
                viewRowSetImpl.executeQuery();
            }
            this.mPCollNewRows = this.getPCollManager().createCollection(this.mName, this.mVO.getViewDef().getMaxRowsPerNode(), this.mVO.getViewDef().getMaxActiveNodes());
            this.mPCollNewRows.setCommitThreshhold(50);
            this.mPCollNewRows.enableIdAccess();
            this.mPCollNewRows.setListener(this);
        }
        this.mPCollNewRows.addElement(viewRowImpl.getRowStorage());
    }

    RowImpl createRowWithEntities(int[] nArray, EntityImpl[] entityImplArray, ViewRowSetImpl viewRowSetImpl, AttributeList attributeList) {
        ViewRowImpl viewRowImpl;
        try {
            this.setPinned(true);
            if (entityImplArray == null || entityImplArray.length == 0) {
                viewRowImpl = this.mVO.createInstance(viewRowSetImpl, attributeList);
            } else {
                viewRowImpl = this.mVO.createInstanceWithEntities(nArray, entityImplArray, viewRowSetImpl, attributeList);
                if (entityImplArray != null && this.mVO.getDBTransactionImpl().isDirty() && this.mVO.getViewDef().isManageRowsByKey()) {
                    this.updateReferencedEntities(viewRowImpl, true);
                }
            }
            if (viewRowImpl.getQueryCollection() != this) {
                viewRowImpl = this.getRowSetImpl().makeRowCopy(viewRowImpl);
            }
            this.addNewRow(viewRowImpl);
            Object var7_6 = null;
            this.setPinned(false);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setPinned(false);
            throw throwable;
        }
        return viewRowImpl;
    }

    Object convertStringToHandle(String string) {
        try {
            Integer n = Integer.valueOf(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            Object var4_4 = null;
            return var4_4;
        }
    }

    public int size() {
        return this.getFetchedRowCount();
    }

    public Object get(int n) {
        if (n < 0) {
            return null;
        }
        boolean bl = true;
        ArrayList arrayList = null;
        int n2 = n;
        if (this.isRangePaging() && (n != 0 || this.mPageStart != 0)) {
            boolean bl2;
            int n3 = n - this.mPageStart;
            int n4 = (int)this.mPCollRows.size();
            if (n4 < this.mPageSize) {
                n4 = this.mPageSize;
            }
            boolean bl3 = bl2 = n3 >= 0 && n3 <= n4;
            if (bl2 && this.mFetchComplete && n >= this.getFetchedRowCount()) {
                return null;
            }
            if (bl2) {
                bl = n4 >= (int)this.mPCollRows.size();
                n2 = n3;
            } else {
                if (this.mPageRowCountDirty) {
                    if (this.mAccessMode == 3) {
                        this.mVO.getDBTransactionImpl().postChanges();
                    } else {
                        Class clazz = class$oracle$jbo$CSMessageBundle;
                        if (clazz == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = QueryCollection.class$("oracle.jbo.CSMessageBundle");
                        }
                        throw new InvalidOperException(clazz, "25053", null);
                    }
                }
                this.mPageStart = n;
                arrayList = this.mNewRowTracker;
                ViewRowSetImpl viewRowSetImpl = this.mVO.findRowSetForQueryCollection(this, true);
                this.mFetchComplete = false;
                this.mExecuted = false;
                this.resetCollection(false);
                this.mVO.executeQueryForCollection(this, viewRowSetImpl.getParametersAsStorageTypes(), viewRowSetImpl.mUserParams.size());
                viewRowSetImpl.setExecuted();
                n2 = 0;
            }
        }
        if (bl && !this.fetch(n)) {
            return null;
        }
        n = n2;
        if (arrayList != null) {
            this.setNewRowTracker(arrayList);
        }
        PCollPersistable pCollPersistable = this.isForwardOnly() ? this.mPCollRows.elementAt(0L) : this.mPCollRows.elementAt(n);
        return ((ViewRowStorage)pCollPersistable).getRowImpl();
    }

    public ViewRowStorage getRowStorageFromId(long l) {
        if (this.mVO == null) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = QueryCollection.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25015", new Object[]{this.getName()});
        }
        ViewRowStorage viewRowStorage = (ViewRowStorage)this.mPCollRows.elementWithId(l);
        if (viewRowStorage == null && this.mPCollNewRows != null) {
            viewRowStorage = (ViewRowStorage)this.mPCollNewRows.elementWithId(l);
        }
        return viewRowStorage;
    }

    public Object set(int n, Object object) {
        Object object2 = this.remove(n);
        this.add(n, object);
        return object2;
    }

    private void replaceRow(ViewRowImpl viewRowImpl) {
        if (this.mPCollRows.size() == 0L) {
            this.mPCollRows.addElement(viewRowImpl.getRowStorage());
        } else {
            ViewRowStorage viewRowStorage = (ViewRowStorage)this.mPCollRows.elementAt(0L);
            if (viewRowStorage != null) {
                this.mViewRowCache.removeReference(viewRowStorage.getRowImpl());
            }
            this.mPCollRows.setElementAt(viewRowImpl.getRowStorage(), 0L);
        }
    }

    public void add(int n, Object object) {
        this.add(n, object, true, true);
    }

    void add(int n, Object object, boolean bl, boolean bl2) {
        long l;
        ViewRowImpl viewRowImpl = (ViewRowImpl)object;
        boolean bl3 = false;
        QueryCollection queryCollection = viewRowImpl.getQueryCollection();
        viewRowImpl.initQueryCollection(this);
        viewRowImpl.setQueryCollection(this);
        byte by = viewRowImpl.getPostState();
        if (n < 0) {
            bl3 = true;
        } else if (n > this.getFetchedRowCount() && !this.fetch(n) && n != this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (viewRowImpl.getPostState() == 0) {
            viewRowImpl.entityCacheAdd();
        }
        if (queryCollection != null && queryCollection.mPCollNewRows != null && (by == 0 || by == 3) && (l = queryCollection.mPCollNewRows.indexOf(viewRowImpl.getRowStorage())) >= 0L) {
            ViewRowStorage viewRowStorage = viewRowImpl.getRowStorage();
            viewRowStorage.addUse();
            try {
                queryCollection.mPCollNewRows.removeElementAt(l);
                Object var13_11 = null;
                viewRowStorage.releaseUse();
            }
            catch (Throwable throwable) {
                Object var13_12 = null;
                viewRowStorage.releaseUse();
                throw throwable;
            }
            viewRowStorage.setHasBeenPersisted(false);
        }
        if (by == 3) {
            viewRowImpl.setPostState((byte)1);
        }
        if (this.isForwardOnly()) {
            this.replaceRow(viewRowImpl);
            ++this.mRowsFetched;
        } else if (bl3) {
            this.mPCollRows.addElement(viewRowImpl.getRowStorage());
        } else {
            this.mPCollRows.insertElementAt(viewRowImpl.getRowStorage(), n);
        }
        this.mViewRowCache.add(viewRowImpl);
        if (bl2) {
            this.changedRowCount(1, true);
        }
        if (bl) {
            this.mVO.notifyRowInserted(this, (Row)viewRowImpl, n == -1 ? this.getFetchedRowCount() - 1 : n);
        }
    }

    Object doRemove(int n, int n2) {
        if (n < 0 || !this.fetch(n)) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.isRangePaging()) {
            this.fetchRangeAt(n);
            n -= this.mPageStart;
        }
        ViewRowImpl viewRowImpl = ((ViewRowStorage)this.mPCollRows.elementAt(n)).getRowImpl();
        if (n2 == 0) {
            viewRowImpl.remove();
        } else if (n2 == 1) {
            viewRowImpl.removeFromCollection();
        } else {
            viewRowImpl.removeAndRetain();
        }
        return viewRowImpl;
    }

    public Object remove(int n) {
        return this.doRemove(n, 0);
    }

    public Object removeFromCollection(int n) {
        return this.doRemove(n, 1);
    }

    public Object removeAndRetain(int n) {
        return this.doRemove(n, 2);
    }

    int getFetchedRowCount() {
        switch (this.mAccessMode) {
            case 1: {
                return this.mRowsFetched;
            }
            case 2: 
            case 3: {
                return this.mPageStart + (int)this.mPCollRows.size();
            }
        }
        return (int)this.mPCollRows.size();
    }

    int getCollectionSize() {
        return (int)this.mPCollRows.size();
    }

    boolean hasResultSet() {
        return this.mResultSet != null;
    }

    boolean hasMoreRow() {
        boolean bl;
        if (this.isForwardOnly()) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = QueryCollection.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25011", new Object[]{this.getName()});
        }
        ViewRowImpl viewRowImpl = this.populateRow();
        boolean bl2 = bl = viewRowImpl != null;
        if (bl) {
            this.mPCollRows.addElement(viewRowImpl.getRowStorage());
            this.mViewRowCache.add(viewRowImpl);
        }
        return bl;
    }

    int getRowCount() {
        if (!this.mFetchComplete) {
            this.fetch(-1);
        }
        return this.size();
    }

    boolean isFetchComplete() {
        return this.mFetchComplete;
    }

    protected int[] getIndexes(EntityImpl entityImpl) {
        return this.mViewRowCache.getViewRowIndexes(entityImpl);
    }

    ViewRowSetImpl getRowSetImpl() {
        ViewRowSetImpl viewRowSetImpl = this.mVO.findRowSetForQueryCollection(this, false);
        if (viewRowSetImpl == null) {
            viewRowSetImpl = this.createViewRowSet();
        }
        return viewRowSetImpl;
    }

    int getUnpostedRowCount() {
        return this.mUnpostedRows == null ? 0 : this.mUnpostedRows.size();
    }

    ViewRowImpl nextRowFromEntityCache() {
        EntityDefImpl entityDefImpl = this.mVO.getViewDef().getEntityDef(0);
        if (this.mEntityCacheRows == null) {
            this.mEntityCacheRows = entityDefImpl.getAllEntityInstancesIterator(this.mVO.getDBTransaction());
        }
        List list = this.getAttributeMappingForAssociations();
        ViewRowImpl viewRowImpl = null;
        while (this.mEntityCacheRows.hasNext()) {
            ViewRowSetImpl viewRowSetImpl;
            ViewRowImpl viewRowImpl2;
            EntityImpl entityImpl = (EntityImpl)this.mEntityCacheRows.next();
            java.util.ArrayList<EntityImpl> arrayList = new java.util.ArrayList<EntityImpl>();
            arrayList.add(entityImpl);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    EntityImpl entityImpl2 = this.findAssociatedRow(entityImpl, (Map)iterator.next());
                    if (entityImpl2 == null) continue;
                    arrayList.add(entityImpl2);
                }
            }
            if (!this.rowQualifies(viewRowImpl2 = (ViewRowImpl)(viewRowSetImpl = this.getRowSetImpl()).createRowWithEntities(null, arrayList.toArray(new EntityImpl[arrayList.size()]), this.getRowInitValues()))) continue;
            viewRowImpl = viewRowImpl2;
            this.earlyRowCount(1);
            break;
        }
        return viewRowImpl;
    }

    protected List getAttributeMappingForAssociations() {
        java.util.ArrayList arrayList = null;
        EntityAssociationReference[] entityAssociationReferenceArray = this.mVO.getViewDef().getEntityAssociationReferences();
        if (entityAssociationReferenceArray != null) {
            arrayList = new java.util.ArrayList();
            int n = 0;
            while (n < entityAssociationReferenceArray.length) {
                AssociationDefImpl associationDefImpl = entityAssociationReferenceArray[n].getAccessor();
                AttributeDefImpl[] attributeDefImplArray = associationDefImpl.getAttributeDefImpls();
                AttributeDefImpl[] attributeDefImplArray2 = associationDefImpl.getOtherAttributeDefImpls();
                if (attributeDefImplArray != null && attributeDefImplArray2 != null) {
                    HashMap<String, AttributeDefImpl> hashMap = new HashMap<String, AttributeDefImpl>();
                    int n2 = 0;
                    while (n2 < attributeDefImplArray.length) {
                        hashMap.put(attributeDefImplArray[n2].getName(), attributeDefImplArray2[n2]);
                        ++n2;
                    }
                    arrayList.add(hashMap);
                }
                ++n;
            }
        }
        return arrayList;
    }

    protected EntityImpl findAssociatedRow(EntityImpl entityImpl, Map map) {
        Iterator iterator = map.keySet().iterator();
        EntityDefImpl entityDefImpl = null;
        Object[] objectArray = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)map.get(string);
            if (entityDefImpl == null) {
                entityDefImpl = attributeDefImpl.getEntityDef();
                objectArray = new Object[entityDefImpl.getAttributeCount()];
            }
            int n = entityDefImpl.getAttributeIndexOf(attributeDefImpl.getName());
            objectArray[n] = entityImpl.getAttribute(string);
        }
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getPrimaryKeys();
        boolean bl = true;
        int n = 0;
        while (n < attributeDefImplArray.length && bl) {
            Object object = objectArray[attributeDefImplArray[n].getIndex()];
            bl = object != null;
            ++n;
        }
        if (bl) {
            Object[] objectArray2 = new Object[attributeDefImplArray.length];
            int n2 = 0;
            while (n2 < objectArray2.length) {
                objectArray2[n2] = objectArray[attributeDefImplArray[n2].getIndex()];
                ++n2;
            }
            Key key = new Key(objectArray2);
            return entityDefImpl.findByPrimaryKey(this.mVO.getDBTransaction(), key);
        }
        com.sun.java.util.collections.Iterator iterator2 = entityDefImpl.getAllEntityInstancesIterator(this.mVO.getDBTransaction());
        while (iterator2.hasNext()) {
            EntityImpl entityImpl2 = (EntityImpl)iterator2.next();
            boolean bl2 = true;
            int n3 = 0;
            while (n3 < objectArray.length && bl2) {
                if (objectArray[n3] != null && bl2) {
                    bl2 = entityImpl2.getAttribute(n3).equals(objectArray[n3]);
                }
                ++n3;
            }
            if (!bl2) continue;
            return entityImpl2;
        }
        return null;
    }

    int addUnpostedRowsFromECache(EntityCache entityCache, int[] nArray, RowFilter rowFilter, int n, ArrayList arrayList, boolean bl) {
        ArrayList arrayList2 = entityCache.findUnpostedRows(nArray, rowFilter, bl);
        ViewRowSetImpl viewRowSetImpl = this.getRowSetImpl();
        int n2 = 0;
        while (n2 < arrayList2.size()) {
            EntityImpl entityImpl = (EntityImpl)arrayList2.get(n2);
            Row[] rowArray = this.getRows(entityImpl);
            if (rowArray == null || rowArray.length == 0) {
                ViewRowImpl viewRowImpl = (ViewRowImpl)viewRowSetImpl.createRowWithEntities(null, new EntityImpl[]{entityImpl}, this.getRowInitValues());
                if (this.mVO.rowQualifies(viewRowImpl)) {
                    arrayList.add((Object)viewRowImpl);
                }
            } else {
                int n3 = 0;
                while (n3 < rowArray.length) {
                    this.mVO.addNewRowTracker(this, (ViewRowImpl)rowArray[n3], n++, true);
                    ++n3;
                }
            }
            ++n2;
        }
        return n;
    }

    void findUnpostedRows(boolean bl, boolean bl2) {
        if (this.mUnpostedRows == null) {
            ArrayList arrayList;
            this.mUnpostedRows = arrayList = new ArrayList();
            RowFilter rowFilter = this.getRowFilter();
            DBTransactionImpl dBTransactionImpl = (DBTransactionImpl)this.mVO.getDBTransaction();
            ViewDefImpl viewDefImpl = this.mVO.getViewDef();
            int n = 0;
            if (viewDefImpl.getEntityDefCount() > 0) {
                EntityDefImpl entityDefImpl = viewDefImpl.getEntityDef(0);
                EntityCache entityCache = dBTransactionImpl.findEntityCache(entityDefImpl);
                int[] nArray = this.mVO.getFKeyMap();
                int[] nArray2 = null;
                if (nArray != null) {
                    nArray2 = new int[nArray.length];
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        int n3 = nArray[n2];
                        if (n3 < 0) {
                            return;
                        }
                        nArray2[n2] = this.getMapInfo()[n3].getIndex();
                        if (nArray2[n2] < 0) {
                            return;
                        }
                        ++n2;
                    }
                }
                n = this.addUnpostedRowsFromECache(entityCache, nArray2, rowFilter, n, arrayList, bl2);
                ArrayList arrayList2 = entityDefImpl.getExtendedDefObjects();
                int n4 = 0;
                while (arrayList2 != null && n4 < arrayList2.size()) {
                    EntityDefImpl entityDefImpl2 = (EntityDefImpl)arrayList2.get(n4);
                    n = this.addUnpostedRowsFromECache(dBTransactionImpl.findEntityCache(entityDefImpl2), nArray2, rowFilter, n, arrayList, bl2);
                    ++n4;
                }
            }
        }
    }

    void addRowToColl(ViewRowImpl viewRowImpl) {
        if (this.isForwardOnly()) {
            this.replaceRow(viewRowImpl);
            ++this.mRowsFetched;
        } else {
            this.mPCollRows.addElement(viewRowImpl.getRowStorage());
        }
        this.mViewRowCache.add(viewRowImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fetch(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            while (n >= this.getFetchedRowCount() || n < 0 && !this.mFetchComplete) {
                ViewRowImpl viewRowImpl = this.populateRow();
                if (viewRowImpl == null) {
                    boolean bl = n < 0;
                    return bl;
                }
                this.addRowToColl(viewRowImpl);
            }
            boolean bl = true;
            return bl;
        }
    }

    private ViewRowImpl populateRow() {
        ViewRowImpl viewRowImpl = null;
        ViewObjectImpl viewObjectImpl = this.mVO;
        ViewDefImpl viewDefImpl = viewObjectImpl.getViewDef();
        int n = this.getViewObjectImpl().getQueryMode();
        if ((n & 2) != 0) {
            viewRowImpl = this.nextRowFromEntityCache();
            if (viewRowImpl != null) {
                return viewRowImpl;
            }
            if ((n & 4) == 0) {
                this.mFetchComplete = true;
            }
        }
        if (this.mUnpostedRows != null && this.mUnpostedRows.size() > 0) {
            viewRowImpl = (ViewRowImpl)this.mUnpostedRows.get(0);
            this.mUnpostedRows.remove(0);
            ++this.mChangedRowCount;
            long l = this.mPCollNewRows.indexOf(viewRowImpl.getRowStorage());
            if (l >= 0L) {
                ViewRowStorage viewRowStorage = viewRowImpl.getRowStorage();
                viewRowStorage.addUse();
                try {
                    this.mPCollNewRows.removeElementAt(l);
                    Object var11_7 = null;
                    viewRowStorage.releaseUse();
                }
                catch (Throwable throwable) {
                    Object var11_8 = null;
                    viewRowStorage.releaseUse();
                    throw throwable;
                }
                viewRowStorage.setHasBeenPersisted(false);
            }
            return viewRowImpl;
        }
        while (this.mExecuted && !this.mFetchComplete) {
            if (this._mBackupRow == null && !viewDefImpl.isFetchAhead() && !this.hasNext()) {
                viewRowImpl = null;
                break;
            }
            int n2 = (int)this.mPCollRows.size();
            if (!viewObjectImpl.isForScan() || this.mIsScanBase) {
                if (this._mBackupRow != null) {
                    viewRowImpl = this._mBackupRow;
                    try {
                        viewRowImpl.entityCacheAdd();
                        this._mBackupRow = null;
                    }
                    catch (DeadEntityAccessException deadEntityAccessException) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("*** Ignore deleted row error  ***");
                        }
                        this._mBackupRow = null;
                        viewRowImpl = null;
                    }
                } else {
                    viewRowImpl = viewObjectImpl.createInstanceFromResultSet(this, this.getResultSet());
                }
                if (viewDefImpl.isFetchAhead()) {
                    this.hasNext();
                }
                if (viewRowImpl == null && !this.mFetchComplete) {
                    --this.mChangedRowCount;
                    continue;
                }
                if (viewRowImpl != null && this.mSkipDuplicateRows && this.findByKey(viewRowImpl.getKey(), 1).size() > 0) {
                    continue;
                }
            } else {
                viewRowImpl = (ViewRowImpl)viewObjectImpl.getDefaultRowSet().next();
            }
            if (viewRowImpl == null || this.rowQualifies(viewRowImpl)) break;
            viewRowImpl = null;
        }
        return viewRowImpl;
    }

    private boolean rowQualifies(ViewRowImpl viewRowImpl) {
        int n;
        AttributeDef[] attributeDefArray;
        Key key;
        ArrayList arrayList;
        Object[] objectArray;
        ViewObjectImpl viewObjectImpl = this.mVO;
        ViewDefImpl viewDefImpl = viewObjectImpl.getViewDef();
        int n2 = viewObjectImpl.getQueryMode();
        if (!viewObjectImpl.rowQualifies(viewRowImpl)) {
            this.changedRowCount(-1, false);
            return false;
        }
        if (viewObjectImpl.getDBTransactionImpl().isDirty() && viewDefImpl.isManageRowsByKey()) {
            this.updateReferencedEntities(viewRowImpl, false);
        }
        if (viewObjectImpl.getFKeyMap() != null && this.isForeignKeyChanged(viewRowImpl) && !this.mRowFilter.whereClauseParamQualifies(objectArray = this.getFilterParamValues(viewRowImpl, null, null))) {
            viewObjectImpl.moveRow(viewRowImpl, objectArray);
            this.changedRowCount(-1, false);
            return false;
        }
        if (this.mEarlyRowCount > 0L && n2 != 2 && (arrayList = this.findByKey(key = viewRowImpl.getKey(), 1)).size() > 0) {
            --this.mEarlyRowCount;
            return false;
        }
        if (viewObjectImpl.isForScan() && !this.mIsScanBase && (attributeDefArray = viewObjectImpl.getScanRowFilterAttributeDefs()) != null && (n = attributeDefArray.length) > 0) {
            Object[] objectArray2 = new Object[n];
            int n3 = 0;
            while (n3 < n) {
                objectArray2[n3] = viewRowImpl.getAttribute(attributeDefArray[n3].getIndex());
                ++n3;
            }
            RowFilter rowFilter = viewObjectImpl.buildRowFilter(objectArray2);
            if (!rowFilter.equals(this.getRowFilter())) {
                QueryCollection queryCollection = viewObjectImpl.getCachedQueryCollection(rowFilter);
                if (queryCollection == null) {
                    queryCollection = new QueryCollection(viewObjectImpl);
                    queryCollection.createColumnList();
                    queryCollection.setAssociationConsistent(viewObjectImpl.isAssociationConsistent());
                    queryCollection.setRowFilter(rowFilter, this.mNumUserParams);
                    queryCollection.setPinned(true);
                    viewObjectImpl.updateQueryCollectionCache(queryCollection, rowFilter, false);
                    queryCollection.setExecuted(true);
                    queryCollection.prepForQuery(false);
                }
                queryCollection.addRowToColl(viewRowImpl);
                return false;
            }
        }
        return true;
    }

    void updateReferencedEntities(ViewRowImpl viewRowImpl, boolean bl) {
        boolean bl2 = false;
        EntityImpl[] entityImplArray = viewRowImpl.getEntities();
        ViewDefImpl viewDefImpl = this.mVO.getViewDef();
        int n = 0;
        while (n < entityImplArray.length) {
            EntityReference entityReference;
            byte by;
            if (entityImplArray[n] != null && ((by = entityImplArray[n].getPostState()) == 2 || bl && by == 0) && (entityReference = viewDefImpl.getEntityReference(n)) != null && entityReference.isInsertParticipant()) {
                bl2 = true;
                break;
            }
            ++n;
        }
        if (!bl2) {
            return;
        }
        ViewAttributeDefImpl[] viewAttributeDefImplArray = viewDefImpl.getEntityReferenceAttributes();
        ViewAttributeDefImpl[] viewAttributeDefImplArray2 = null;
        int n2 = 0;
        if (viewAttributeDefImplArray != null) {
            int n3 = 0;
            while (n3 < viewAttributeDefImplArray.length) {
                EntityImpl entityImpl;
                ViewAttributeDefImpl viewAttributeDefImpl = viewAttributeDefImplArray[n3];
                EntityReference entityReference = viewAttributeDefImpl.getEntityReference();
                if (entityReference != null && (entityImpl = (EntityImpl)viewRowImpl.getEntity(entityReference)) != null && entityImpl.isAttributeChanged(viewAttributeDefImpl.getAttributeDefImpl().getIndex())) {
                    if (viewAttributeDefImplArray2 == null) {
                        viewAttributeDefImplArray2 = new ViewAttributeDefImpl[this.mVO.getAttributeCount()];
                    }
                    viewAttributeDefImplArray2[n2++] = viewAttributeDefImpl;
                }
                ++n3;
            }
            if (n2 > 0) {
                this.mVO.updateReferenceEntities(this, null, n2, null, viewAttributeDefImplArray2, new Row[]{viewRowImpl}, true);
            }
        }
    }

    void createColumnList() {
        if (this.mColumnCount >= 0) {
            return;
        }
        this.mColumnCount = this.mVO.getViewDef().getAttributeCount();
        if (Diagnostic.isOn()) {
            Diagnostic.println("Column count: " + this.mColumnCount);
        }
        this.createMap();
    }

    boolean isExecuted() {
        return this.mExecuted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEstimatedRowCount(ViewRowSetImpl viewRowSetImpl, Row[] rowArray) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isExecuted() && this.isFetchComplete()) {
                long l = this.getRowCount();
                return l;
            }
            long l = 0L;
            if (this.mEstimatedRowCount == (long)-1) {
                this.mEstimatedRowCount = rowArray == null ? this.mVO.getQueryHitCount(viewRowSetImpl) : this.mVO.getQueryHitCount(viewRowSetImpl, rowArray);
            }
            if (this.isAssociationConsistent()) {
                if (this.mUnpostedRows == null) {
                    this.findUnpostedRows(false, false);
                }
                l = this.mUnpostedRows.size();
            }
            long l2 = this.mEstimatedRowCount + this.mChangedRowCount + l;
            return l2;
        }
    }

    EntityImpl getEntityCacheAdd() {
        return this.mEntityCacheAdd;
    }

    void setEntityCacheAdd(EntityImpl entityImpl) {
        this.mEntityCacheAdd = entityImpl;
    }

    private void emptyCollection() {
        ViewObjectImpl viewObjectImpl = this.getViewObjectImpl();
        if (viewObjectImpl != null && (viewObjectImpl.getQueryMode() & 1) == 0 && this.mPCollRows != null && this.mPCollRows.getManager().isOpen()) {
            this.mPCollRows.removeAllElements();
            if (this.mPCollNewRows != null) {
                this.mPCollNewRows.removeAllElements();
            }
        }
        this.mEntityCacheRows = null;
        this.setNewRowTracker(null);
        this.mEarlyRowCount = 0L;
    }

    void markForReset() {
        if (!this.isExecuted()) {
            this.mResetCollection = true;
        }
        this.mEstimatedRowCount = -1;
        this.mChangedRowCount = 0L;
        this.mIsDirty = false;
        this.mPageRowCountDirty = false;
    }

    void resetCollection(boolean bl) {
        int n = (int)this.mPCollRows.size();
        this.emptyCollection();
        if ((this.getViewObjectImpl().getQueryMode() & 1) == 0) {
            this.mViewRowCache = new ViewRowCache(this);
        }
        if (bl) {
            this.mPageStart = 0;
            if (n > 0) {
                this.mVO.resetIterators(this);
            }
        }
        this.mResetCollection = false;
    }

    private void createMap() {
        this.mMap = this.mVO.getViewDef().getMapInfo();
        if (this.mMap == null) {
            int n = this.getAttributeCount();
            this.mMap = new MapInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.mMap[n2] = new MapInfo(n2, -1);
                ++n2;
            }
        }
        this.mViewRowCache = new ViewRowCache(this);
    }

    void dumpViewRowCache(Writer writer) {
        this.mViewRowCache.dump(writer);
    }

    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        return (int)this.mPCollRows.indexOf(((ViewRowImpl)object).getRowStorage());
    }

    protected void afterRemove(EntityImpl entityImpl) {
        Row[] rowArray = this.getRows(entityImpl);
        if (rowArray == null) {
            return;
        }
        int n = 0;
        while (n < rowArray.length) {
            ViewRowImpl viewRowImpl = (ViewRowImpl)rowArray[n];
            int n2 = this.indexOf(viewRowImpl);
            if (n2 != -1) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("QueryCollection: afterRemove(" + n2 + ")");
                }
                if (this.mViewRowCache.remove(viewRowImpl, entityImpl)) {
                    this.removeRow(viewRowImpl, n2, false, 0);
                } else {
                    this.removeReference(viewRowImpl, entityImpl);
                }
            } else {
                this.removeReference(viewRowImpl, entityImpl);
            }
            ++n;
        }
    }

    void removeRow(ViewRowImpl viewRowImpl, int n, boolean bl, int n2) {
        if (bl) {
            this.mViewRowCache.removeReference(viewRowImpl);
        }
        this.mPCollRows.removeElementAt(n);
        viewRowImpl.getRowStorage().setHasBeenPersisted(false);
        if (n2 != 3) {
            if (this.isForwardOnly()) {
                --this.mRowsFetched;
            }
            this.changedRowCount(-1, true);
            this.mVO.notifyRowDeleted(this, viewRowImpl, n, n2 == 0);
        }
        if (viewRowImpl != null && viewRowImpl.getQueryCollection() == this) {
            if (n2 != 2) {
                viewRowImpl.setQueryCollection(null);
            } else {
                this.addNewRow(viewRowImpl);
            }
        }
    }

    int removeNewViewRow(ViewRowImpl viewRowImpl) {
        ArrayList arrayList;
        EntityImpl[] entityImplArray = viewRowImpl.getEntities();
        if (entityImplArray != null && entityImplArray.length > 0 && (arrayList = this.mViewRowCache.getRows(entityImplArray[0])) != null) {
            int n = arrayList.size();
            int n2 = entityImplArray.length;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                ViewRowImpl viewRowImpl2 = (ViewRowImpl)arrayList.get(n4);
                EntityImpl[] entityImplArray2 = viewRowImpl2.getEntities();
                n3 = 0;
                while (n3 < n2) {
                    if (entityImplArray2[n3] != entityImplArray[n3]) break;
                    ++n3;
                }
                if (n3 == n2) {
                    int n5 = -1;
                    if (this.mPCollRows != null) {
                        n5 = (int)this.mPCollRows.indexOf(viewRowImpl2.getRowStorage());
                    }
                    if (n5 > -1) {
                        this.removeRow(viewRowImpl2, n5, true, 0);
                        return n5;
                    }
                }
                ++n4;
            }
        }
        return -1;
    }

    protected Row[] getRows(EntityImpl entityImpl) {
        return this.doGetRows(entityImpl);
    }

    protected Row[] getRows(Key key) {
        return this.doGetRows(key);
    }

    Row[] doGetRows(Object object) {
        ArrayList arrayList = null;
        if (this.mViewRowCache == null || (arrayList = this.mViewRowCache.getRows(object)) == null) {
            return null;
        }
        return (Row[])arrayList.toArray((Object[])new Row[arrayList.size()]);
    }

    protected void removeReference(ViewRowImpl viewRowImpl, EntityImpl entityImpl) {
        viewRowImpl.removeReference(entityImpl);
        this.mViewRowCache.removeReference(viewRowImpl, entityImpl);
        this.mVO.notifyRowUpdated(this, (Row)viewRowImpl, entityImpl, false);
    }

    protected void updateReference(ViewRowImpl viewRowImpl, EntityImpl entityImpl, int n) {
        EntityImpl entityImpl2 = viewRowImpl.getEntity(n);
        this.mViewRowCache.updateReference(viewRowImpl, entityImpl, entityImpl2);
        viewRowImpl.updateReference(n, entityImpl);
    }

    boolean isDirty() {
        return this.mIsDirty;
    }

    boolean isPinnedTemporarily() {
        return this.mIsPinnedTemporarily;
    }

    void setPinnedTemporarily(boolean bl) {
        this.mIsPinnedTemporarily = bl;
    }

    boolean isPinned() {
        return this.mPinned > 0;
    }

    void setPinned(boolean bl) {
        if (!bl) {
            if (this.mPinned > 0) {
                --this.mPinned;
                if (this.mPinned == 0 && !this.mIsDirty) {
                    this.getViewObjectImpl().unpinQC(this);
                }
            }
        } else {
            this.setPinnedTemporarily(false);
            if (this.mPinned == 0) {
                this.getViewObjectImpl().pinQC(this);
            }
            ++this.mPinned;
        }
    }

    boolean isSkipQuery() {
        return this.mIsSkipQuery;
    }

    void setSkipQuery(boolean bl) {
        this.mIsSkipQuery = bl;
    }

    void setScanBase(boolean bl) {
        if (this.mIsScanBase != bl) {
            this.mIsScanBase = bl;
            if (this.mIsScanBase) {
                this.setPinned(true);
            }
        }
    }

    void setRowFilter(RowFilter rowFilter, int n) {
        if (this.isForwardOnly()) {
            rowFilter = new RowFilterKeyForwardOnly(this.mVO, rowFilter.getWhereClauseParams());
        }
        this.mRowFilter = rowFilter;
        if (n >= 0) {
            this.mNumUserParams = n;
        }
    }

    public RowFilter getRowFilter() {
        return this.mRowFilter;
    }

    public int getNumUserParams() {
        return this.mNumUserParams;
    }

    private boolean hasNext() {
        return this.mVO.hasNextForCollection(this);
    }

    void setFetchComplete(boolean bl) {
        this.mFetchComplete = bl;
    }

    final boolean isMaxFetchSizeExceeded() {
        return this.getResultSet() != null ? false : this.mMaxRowExceeded;
    }

    boolean hasNextInResultSet() {
        try {
            if (this.getResultSet() == null || !this.mResultSet.next()) {
                this.mFetchComplete = true;
                if (this.mResultSet != null) {
                    try {
                        int n = this.mVO.getMaxFetchSize();
                        if (n > 0) {
                            if (this.mVO.getViewDef().isFetchAhead()) {
                                if (this.getFetchedRowCount() >= n - 1) {
                                    this.mMaxRowExceeded = true;
                                }
                            } else if (this.getFetchedRowCount() >= n) {
                                this.mMaxRowExceeded = true;
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.mResultSet.close();
                    this.mResultSet = null;
                }
                if (this.mStatement != null) {
                    this.mVO.freeStatement(this.mStatement, this.mBoundNullParams, false);
                    this.mStatement = null;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Class clazz;
            if (this.mResultSet != null) {
                try {
                    this.mResultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.mResultSet = null;
            }
            if (this.mStatement != null) {
                this.mVO.freeStatement(this.mStatement, this.mBoundNullParams, true);
                this.mStatement = null;
                this.mFetchComplete = true;
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = QueryCollection.class$("oracle.jbo.CSMessageBundle");
            }
            RowNotFoundException rowNotFoundException = new RowNotFoundException(clazz, "25060", new Object[]{this.getName()});
            rowNotFoundException.addToDetails(exception);
            if (Diagnostic.isOn()) {
                Diagnostic.printStackTrace(rowNotFoundException);
            }
            throw rowNotFoundException;
        }
    }

    String getName() {
        return this.mName;
    }

    public String getName(Object object) {
        return this.getName();
    }

    void earlyRowCount(int n) {
        this.mEarlyRowCount += (long)n;
    }

    void changedRowCount(int n, boolean bl) {
        if (bl) {
            this.mIsDirty = true;
            if (this.isRangePaging()) {
                this.mPageRowCountDirty = true;
            }
        }
        this.mChangedRowCount += (long)n;
    }

    void setDirty(boolean bl) {
        if (!this.isForwardOnly()) {
            this.mIsDirty = bl;
        }
    }

    boolean isPageRowCountDirty() {
        return this.mPageRowCountDirty;
    }

    public Object[] getFilterParamValues(ViewRowImpl viewRowImpl, Object[] objectArray, int[] nArray) {
        int[] nArray2 = this.mVO.getFKeyMap();
        if (nArray2 == null) {
            return null;
        }
        Object[] objectArray2 = this.mRowFilter.getWhereClauseParams();
        Object[] objectArray3 = new Object[objectArray2.length];
        int n = this.mVO.getBindingStyle();
        System.arraycopy(objectArray2, 0, objectArray3, 0, objectArray2.length);
        int n2 = 0;
        while (n2 < nArray2.length) {
            int n3 = nArray2[n2];
            if (n3 != -1) {
                if (objectArray != null) {
                    ViewAttributeDefImpl[] viewAttributeDefImplArray = this.mVO.getViewAttributeDefImpls();
                    if (nArray != null) {
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            if (nArray[n4] == n3) {
                                objectArray[n4] = viewAttributeDefImplArray[n3].convertToJava(objectArray[n4]);
                                if (n == 2) {
                                    objectArray3[n2] = new Object[]{((Object[])objectArray3[n2])[0], objectArray[n4]};
                                    break;
                                }
                                objectArray3[n2] = objectArray[n4];
                                break;
                            }
                            ++n4;
                        }
                        if (n4 >= nArray.length) {
                            objectArray3[n2] = n == 2 ? new Object[]{((Object[])objectArray3[n2])[0], viewRowImpl.getAttributeInternal(n3)} : viewRowImpl.getAttributeInternal(n3);
                        }
                    } else {
                        objectArray[n3] = viewAttributeDefImplArray[n3].convertToJava(objectArray[n3]);
                        objectArray3[n2] = n == 2 ? new Object[]{((Object[])objectArray3[n2])[0], objectArray[n3]} : objectArray[n3];
                    }
                } else {
                    objectArray3[n2] = n == 2 ? new Object[]{((Object[])objectArray3[n2])[0], viewRowImpl.getAttributeInternal(n3)} : viewRowImpl.getAttributeInternal(n3);
                }
            }
            ++n2;
        }
        return objectArray3;
    }

    boolean isForeignKeyChanged(ViewRowImpl viewRowImpl) {
        ViewAttributeDefImpl[] viewAttributeDefImplArray = this.mVO.getViewAttributeDefImpls();
        int[] nArray = this.mVO.getFKeyMap();
        int n = 0;
        while (n < nArray.length) {
            ViewAttributeDefImpl viewAttributeDefImpl;
            EntityReference entityReference;
            if (nArray[n] != -1 && (entityReference = (viewAttributeDefImpl = viewAttributeDefImplArray[nArray[n]]).getEntityReference()) != null && ((EntityImpl)viewRowImpl.getEntity(entityReference)).isAttributeChanged(viewAttributeDefImpl.getAttributeDefImpl().getIndex())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    ArrayList findByKey(Key key, int n) {
        ArrayList arrayList;
        block16: {
            block17: {
                arrayList = new ArrayList(n > -1 ? n : 2);
                if (n == 0 || !this.mVO.isManageRowsByKey()) {
                    return arrayList;
                }
                if (this.isForwardOnly()) {
                    Row row;
                    if (n == 1 && (row = (Row)this.get(0)) != null && row.getKey().equals(key)) {
                        arrayList.add((Object)row);
                    }
                    return arrayList;
                }
                EntityReference[] entityReferenceArray = this.mVO.getViewDef().getEntityReferences();
                if (entityReferenceArray == null || entityReferenceArray.length <= 0) break block17;
                int n2 = 0;
                while (n2 < entityReferenceArray.length) {
                    block18: {
                        Key key2 = ViewRowImpl.getEntityKeyFromViewRowKey(key, n2, this.mVO);
                        EntityImpl entityImpl = null;
                        try {
                            entityImpl = key2 == null ? null : entityReferenceArray[n2].getEntityDef().findInCacheByPKExtended(this.mVO.getDBTransactionImpl(), key2, true);
                        }
                        catch (DeadEntityAccessException deadEntityAccessException) {
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("findByKey: WARNING - ignoring PK-modified and removed row.");
                            }
                            entityImpl = null;
                        }
                        if (entityImpl == null || entityImpl.isPKChanged() && !key2.equals(entityImpl.getPrimaryKey())) break block18;
                        Row[] rowArray = this.getRows(entityImpl);
                        if (rowArray == null || rowArray.length <= 0) break block16;
                        int n3 = 0;
                        while (n3 < rowArray.length) {
                            block19: {
                                boolean bl = true;
                                ViewRowImpl viewRowImpl = (ViewRowImpl)rowArray[n3];
                                if (viewRowImpl.getEntity(n2) != entityImpl) break block19;
                                int n4 = n2 + 1;
                                while (n4 < entityReferenceArray.length) {
                                    block20: {
                                        block22: {
                                            Key key3;
                                            block21: {
                                                key2 = ViewRowImpl.getEntityKeyFromViewRowKey(key, n4, this.mVO);
                                                EntityImpl entityImpl2 = viewRowImpl.getEntity(n4);
                                                Key key4 = key3 = entityImpl2 != null ? entityImpl2.getKey() : null;
                                                if (key2 == null) break block20;
                                                if (key3 != null) break block21;
                                                Object[] objectArray = key2.getKeyValues();
                                                int n5 = 0;
                                                while (n5 < objectArray.length) {
                                                    if (!(objectArray[n5] instanceof NullValue)) break;
                                                    ++n5;
                                                }
                                                if (n5 < objectArray.length) break block22;
                                                break block20;
                                            }
                                            if (key2.equals(key3)) break block20;
                                        }
                                        bl = false;
                                        break;
                                    }
                                    ++n4;
                                }
                                if (bl) {
                                    arrayList.add((Object)viewRowImpl);
                                }
                                if (n != -1 && arrayList.size() == n) break block16;
                            }
                            ++n3;
                        }
                        break block16;
                    }
                    ++n2;
                }
                break block16;
            }
            Row[] rowArray = this.getRows(key);
            if (rowArray == null) break block16;
            int n6 = 0;
            while (n6 < rowArray.length) {
                arrayList.add((Object)rowArray[n6]);
                ++n6;
            }
        }
        return arrayList;
    }

    public void printActiveObjsTab(PrintWriter printWriter) {
        this.mPCollRows.printActiveObjsTab(printWriter);
    }

    public void printRUChain(PrintWriter printWriter) {
        this.mPCollRows.printRUChain(printWriter);
    }

    public void printColl(PrintWriter printWriter, int n) {
        this.mPCollRows.printColl(printWriter, n);
    }

    protected void finalize() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("##### QueryCollection.finl " + (this.getRowFilter() == null ? "no RowFilter" : this.getRowFilter().toString()));
        }
        this.closeCollection();
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    void viewRowPassivated(ViewRowStorage viewRowStorage, EntityImpl entityImpl, Key key) {
        this.mViewRowCache.viewRowPassivated(viewRowStorage, entityImpl, key);
    }

    void viewRowActivated(ViewRowStorage viewRowStorage, PCollection pCollection, EntityImpl entityImpl, Key key) {
        if (pCollection == this.mPCollRows) {
            this.mViewRowCache.viewRowActivated(viewRowStorage, entityImpl, key);
        }
    }

    public boolean equals(Object object) {
        return object == this;
    }

    void fetchRangeAt(int n) {
        if (this.isRangePaging()) {
            boolean bl = false;
            int n2 = this.mPageStart + this.mPageSize;
            if (this.mPageStart < n && n2 >= n) {
                this.mPageStart = n + this.mPageSize;
            }
            int n3 = 0;
            while (n3 < this.mPageSize) {
                this.get(n + n3);
                ++n3;
            }
        }
    }

    void disconnect() {
        if (this.mResultSet != null) {
            try {
                this.mResultSetStateHolder = new ResultSetStateHolder(this.mResultSet.getRow());
            }
            catch (SQLException sQLException) {
                throw new JboException(sQLException);
            }
            try {
                this.mResultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.mResultSet = null;
        }
        if (this.mStatement != null) {
            if (this.mVO != null) {
                this.mVO.freeStatement(this.mStatement, this.mBoundNullParams, false);
            }
            this.mStatement = null;
        }
    }

    void saveNextRowInResultSet() {
        ViewRowImpl viewRowImpl;
        this._mBackupRow = viewRowImpl = this.mVO.createInstanceFromResultSet(this, this.mResultSet, true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class ResultSetStateHolder {
        final int mRow;

        ResultSetStateHolder(int n) {
            this.mRow = n;
        }
    }
}

