/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import oracle.jbo.InvalidDefNameException;
import oracle.jbo.JboException;
import oracle.jbo.NoXMLFileException;
import oracle.jbo.SharedHandle;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.mom.ContainerDefImpl;
import oracle.jbo.mom.DefinitionManager;
import oracle.jbo.mom.DefinitionObject;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.mom.xml.DefXMLParser;
import oracle.jbo.server.ApplicationModuleDefImpl;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.ComponentDefImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.DomainDefImpl;
import oracle.jbo.server.EntityAssociation;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.JDBCInteract;
import oracle.jbo.server.PackageDefImpl;
import oracle.jbo.server.ViewAttributeDefImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewLinkDefImpl;

public class MetaObjectManager
extends DefinitionManager {
    static final String[] XML_VERSIONS = new String[]{"jbo.dtd", "jbo_01_01.dtd", "jbo_02_01.dtd", "jbo_03_01.dtd"};
    private boolean mSharedHandleStat;
    private String mSharedHandleName;
    private SharedHandle mSharedHandle;
    private String m8iProjectSubName;
    private Long mTimestamp;
    private static MetaObjectManager mom = null;
    static boolean mInit = false;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$server$MetaObjectManager;

    private /* synthetic */ void $init$() {
        this.mSharedHandleStat = false;
        this.mSharedHandleName = null;
        this.mSharedHandle = null;
        this.m8iProjectSubName = null;
        this.mTimestamp = new Long(0L);
    }

    MetaObjectManager() {
        this.$init$();
    }

    static boolean isInitialized() {
        return mInit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetaObjectManager getSingleton() {
        if (mInit) {
            return mom;
        }
        Class clazz = class$oracle$jbo$server$MetaObjectManager;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$MetaObjectManager = MetaObjectManager.class$("oracle.jbo.server.MetaObjectManager");
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            if (mom == null) {
                JDBCInteract.init();
                mom = new MetaObjectManager();
                mom.initManager();
                mInit = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mom;
        }
    }

    public static DefXMLParser getParser() {
        return MetaObjectManager.getSingleton().getJboXMLDoc();
    }

    protected void initManager() {
        super.initManager();
        this.setSharedHandleProp();
    }

    public static void setSharedHandleName(String string) {
        MetaObjectManager.getSingleton().mSharedHandleName = string;
    }

    public static void set8iProjectSub(String string) {
        MetaObjectManager.getSingleton().m8iProjectSubName = string;
    }

    public static String getSharedHandleName() {
        return MetaObjectManager.getSingleton().mSharedHandleName;
    }

    public static boolean getSharedHandleStatus() {
        return MetaObjectManager.getSingleton().mSharedHandleStat;
    }

    public static SharedHandle getSharedHandle() {
        return MetaObjectManager.getSingleton().mSharedHandle;
    }

    public static boolean isLazyLoading() {
        return MetaObjectManager.getSingleton().mLazyLoading;
    }

    public static void setLazyLoading(boolean bl) {
        MetaObjectManager.getSingleton().mLazyLoading = bl;
    }

    public static void insertMetaObject(String string, Object object) {
        MetaObjectManager.getSingleton().insertDefinition(string, object, false);
    }

    public static Object removeMetaObject(String string) {
        return MetaObjectManager.getSingleton().removeDefinition(string);
    }

    static PackageDefImpl findPackage(String string) {
        Object object = MetaObjectManager.getSingleton().findLoadedObject(string);
        if (object == null) {
            if (MetaObjectManager.getSingleton().mbValidateName && !JboNameUtil.isFullNameValid(string)) {
                throw new InvalidDefNameException(151, string);
            }
            object = MetaObjectManager.getSingleton().loadLazyDefinitionObject(string, null, false, true);
        }
        if (object instanceof PackageDefImpl) {
            return (PackageDefImpl)object;
        }
        return null;
    }

    static AttributeDefImpl findEntityAttribute(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        EntityDefImpl entityDefImpl = EntityDefImpl.findDefObject(string2);
        String string3 = string.substring(n + 1);
        return entityDefImpl.getAttributeDefImpl(string3);
    }

    static ViewAttributeDefImpl findViewAttribute(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        ViewDefImpl viewDefImpl = ViewDefImpl.findDefObject(string2);
        String string3 = string.substring(n + 1);
        return (ViewAttributeDefImpl)viewDefImpl.findAttributeDef(string3);
    }

    protected synchronized Object loadLazyFromSharedObject(String string, ContainerDefImpl containerDefImpl, boolean bl, boolean bl2) {
        if (containerDefImpl == null && bl) {
            containerDefImpl = MetaObjectManager.getSingleton().loadSharedParent(string);
        }
        try {
            DefElement defElement = (DefElement)MetaObjectManager.loadXMLFromSharedDataHandle(string);
            DefObject defObject = null;
            String string2 = defElement.getNodeName();
            defObject = (DefObject)MetaObjectManager.getSingleton().loadFromXML(string, defElement, string2);
            if (string2.equalsIgnoreCase("JboPackage") || string2.equalsIgnoreCase("JboEjbPackage")) {
                PackageDefImpl packageDefImpl = new PackageDefImpl();
                MetaObjectManager.insertMetaObject(string, packageDefImpl);
                packageDefImpl.loadFromXMLFile(defElement);
                packageDefImpl.setIsProject(false);
                PackageDefImpl packageDefImpl2 = packageDefImpl;
                return packageDefImpl2;
            }
            if (defObject != null) {
                String string3 = null;
                string3 = containerDefImpl != null ? JboNameUtil.getContainerPartOfName(containerDefImpl.getFullName()) + "." + defObject.getName() : defObject.getName();
                if (!MetaObjectManager.getSingleton().mSubstituteStat && !string3.equals(string)) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println(" Object name in xml file " + string3 + " does not match metaobj name " + string);
                    }
                    throw new NoXMLFileException(string);
                }
                if (containerDefImpl != null) {
                    defObject.setFullName(string);
                    containerDefImpl.addChild(defObject);
                } else {
                    defObject.setFullName(string);
                }
                if (!MetaObjectManager.getSingleton().isLazyLoadingMode()) {
                    defObject.resolveReferences();
                }
                defObject.finishedLoading();
            }
            defElement = null;
            DefObject defObject2 = defObject;
            return defObject2;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Error trying to lookup XML metaObjectName'" + string + ".xml'");
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = MetaObjectManager.class$("oracle.jbo.CSMessageBundle");
            }
            JboException jboException = new JboException(clazz, "26049", new Object[]{string});
            jboException.addToDetails(exception);
            throw jboException;
        }
    }

    public DefinitionObject loadFromXML(String string, DefElement defElement, String string2) {
        DefObject defObject = null;
        try {
            if (string2.equalsIgnoreCase("Entity") || string2.equalsIgnoreCase("CmpEntity")) {
                defObject = EntityDefImpl.loadFromXML(defElement);
            } else if (string2.equalsIgnoreCase("ViewObject")) {
                defObject = ViewDefImpl.loadFromXML(defElement);
            } else if (string2.equalsIgnoreCase("Association")) {
                defObject = EntityAssociation.loadFromXML(defElement);
            } else if (string2.equalsIgnoreCase("AppModule")) {
                defObject = ApplicationModuleDefImpl.loadFromXML(defElement);
            } else if (string2.equalsIgnoreCase("ViewLink")) {
                defObject = ViewLinkDefImpl.loadFromXML(defElement);
            } else if (string2.equalsIgnoreCase("ComponentObject")) {
                defObject = ComponentDefImpl.loadFromXML(defElement);
            } else if (string2.equalsIgnoreCase("Domain")) {
                defObject = DomainDefImpl.loadFromXML(defElement);
            }
            long l = defElement.readLong("TimeStamp");
            if (l > this.mTimestamp) {
                this.mTimestamp = new Long(l);
            }
        }
        catch (JboException jboException) {
            throw jboException;
        }
        catch (Exception exception) {
            Class clazz;
            if (Diagnostic.isOn()) {
                String string3 = JboNameUtil.getDocumentName(string);
                Diagnostic.println("Generic exception trying to load XML File " + string3);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = MetaObjectManager.class$("oracle.jbo.CSMessageBundle");
            }
            JboException jboException = new JboException(clazz, "26049", new Object[]{string});
            jboException.addToDetails(exception);
            throw jboException;
        }
        return defObject;
    }

    private PackageDefImpl loadSharedParent(String string) {
        String string2 = JboNameUtil.getContainerPartOfName(string);
        if (string2 == null) {
            return MetaObjectManager.getDynamicObjectsPackage();
        }
        String string3 = JboNameUtil.getLastPartOfName(string2);
        String string4 = string2 + "." + string3;
        Object object = this.findLoadedObject(string4);
        if (object != null && object instanceof PackageDefImpl) {
            return (PackageDefImpl)object;
        }
        try {
            PackageDefImpl packageDefImpl = (PackageDefImpl)this.loadLazyFromSharedObject(string4, null, false, true);
            return packageDefImpl;
        }
        catch (NoXMLFileException noXMLFileException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Cannot Load parent Package : " + string4);
                Diagnostic.println("Business Object Browsing may be unavailable");
            }
            PackageDefImpl packageDefImpl = MetaObjectManager.getDynamicObjectsPackage();
            return packageDefImpl;
        }
    }

    public static PackageDefImpl loadProject(String string) {
        return (PackageDefImpl)MetaObjectManager.getSingleton().loadProjectDefinition(string);
    }

    static synchronized PackageDefImpl getDynamicObjectsPackage() {
        PackageDefImpl packageDefImpl = (PackageDefImpl)MetaObjectManager.getSingleton().getDynamicObjectsContainer();
        return packageDefImpl;
    }

    public static Object loadFromSharedDataHandle(String string) {
        Hashtable hashtable = MetaObjectManager.getSingleton().mSharedHandle.access(MetaObjectManager.getSingleton().mSharedHandleName);
        return hashtable.get(string);
    }

    public static Object loadXMLFromSharedDataHandle(String string) {
        Hashtable hashtable = MetaObjectManager.getSingleton().mSharedHandle.access(MetaObjectManager.getSingleton().mSharedHandleName);
        return hashtable.get(string);
    }

    public static Object findMetaObject(String string, int n, Class clazz, boolean bl) {
        if (n == 41 && (string.startsWith("oracle.jbo.") || string.startsWith("oracle.ord."))) {
            Object object;
            if (bl) {
                string = MetaObjectManager.getSingleton().findSubstituteName(string);
            }
            if ((object = MetaObjectManager.getSingleton().findLoadedObject(string)) == null) {
                object = new DomainDefImpl();
                ((DomainDefImpl)object).setName(JboNameUtil.getLastPartOfName(string));
                ((DomainDefImpl)object).setFullName(string);
                MetaObjectManager.insertMetaObject(string, object);
            }
            return object;
        }
        return MetaObjectManager.getSingleton().findDefinitionObject(string, n, clazz, bl);
    }

    public static DefElement loadBaseElement(String string) {
        return MetaObjectManager.getSingleton().loadBaseXMLElement(string);
    }

    protected void initSubExtendsPropForProject() {
        if (JboEnvUtil.inJServer()) {
            this.initSubExtendsFor8iProp();
        } else {
            super.initSubExtendsPropForProject();
        }
    }

    private void initSubExtendsFor8iProp() {
        block5: {
            try {
                if (this.m8iProjectSubName != null) {
                    this.mSubstituteStat = true;
                    MetaObjectManager.loadProject(this.m8iProjectSubName.trim());
                } else {
                    String string = PropertyMetadata.GLOBAL_SUBSTITUTION.getProperty();
                    if (!JboEnvUtil.isEmptyString(string)) {
                        String string2 = string.trim();
                        this.mSubstituteStat = true;
                        MetaObjectManager.loadProject(string2);
                    }
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block5;
                Diagnostic.println("MetaObjectManager: Error loading project with Sub-Extends in 8i");
                Diagnostic.printStackTrace(exception);
            }
        }
    }

    private void setSharedHandleProp() {
        block4: {
            try {
                this.mSharedHandleStat = PropertyMetadata.SHARED_DATA_HANDLE.getPropertyAsBoolean();
                String string = PropertyMetadata.HANDLE_NAME.getProperty();
                if (!JboEnvUtil.isEmptyString(string)) {
                    this.mSharedHandleName = string.trim();
                }
                if (this.mSharedHandleStat) {
                    MetaObjectManager.createSharedDataHandle();
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block4;
                Diagnostic.println("MetaObjectManager: Error Creating Shared Handle");
                Diagnostic.printStackTrace(exception);
            }
        }
    }

    public static Properties getServerProperties() {
        return MetaObjectManager.getSingleton().getMOMProperties();
    }

    public static void createSharedDataHandle() throws NamingException {
        try {
            Class clazz = JBOClass.forName("oracle.jbo.mom.xml.aurora.SharedDataHandleImpl");
            MetaObjectManager.getSingleton().mSharedHandle = (SharedHandle)clazz.newInstance();
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException(exception.getMessage());
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    protected String getDynamicPackageName() {
        return "JBODynamicObjectsPackage";
    }

    protected String getProjectFileExtension() {
        return ".jpx";
    }

    protected Object loadSpecialObjects(DefElement defElement, String string, String string2) {
        if (string2.equalsIgnoreCase("JboPackage") || string2.equalsIgnoreCase("JboEjbPackage")) {
            PackageDefImpl packageDefImpl = new PackageDefImpl();
            this.insertDefinition(string, packageDefImpl);
            packageDefImpl.loadFromXMLFile(defElement);
            packageDefImpl.setIsProject(false);
            return packageDefImpl;
        }
        return null;
    }

    protected ContainerDefImpl createContainerDefObject(boolean bl) {
        return new PackageDefImpl(this);
    }

    public String[] getXMLVersionArray() {
        return XML_VERSIONS;
    }

    public static String getLatestXMLVersion() {
        return MetaObjectManager.getSingleton().getLatestDTDVersion();
    }

    public ArrayList getCustomMessageBundlesList() {
        return (ArrayList)this.findLoadedObject("oracle.jbo.CustomMessageBundles");
    }

    void setCustomMessageBundlesList(ArrayList arrayList) {
        this.insertDefinition("oracle.jbo.CustomMessageBundles", arrayList, false);
    }

    public final Long getVersionTimestamp() {
        return this.mTimestamp;
    }

    protected String getDefaultMOMCacheScope() {
        return System.getProperty("oracle.jbo.mom.cache.scope");
    }

    protected boolean usesMDSByDefault() {
        return this.getBooleanFlag(PropertyMetadata.JBO_MOM_USES_MDS, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

