/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.util.Iterator;
import oracle.jbo.RowSetIterator;
import oracle.jbo.common.DataDocument;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.xml.Criteria;
import oracle.jbo.server.RowImpl;
import oracle.jbo.server.RowSetImpl;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewObjectImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.ViewRowSetImpl;
import oracle.jbo.server.ViewRowSetIteratorImpl;
import oracle.jbo.server.XmlDataDocumentWriter;
import oracle.svcmsg.DataRow;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DotNetXmlDocumentWriter
extends XmlDataDocumentWriter {
    private static final String DIFFGRAM_PREFIX = "diffgr:";
    private static final String MSDATA_PREFIX = "msdata:";
    private static final String ID = "id";
    private static final String ROWORDER = "rowOrder";
    private static final String HASCHANGES = "hasChanges";
    private static final String MODIFIED = "modified";
    private static final String INSERTED = "inserted";
    private DocumentFragment mSchemaDoc;
    private DocumentFragment mCurrrentFragment;
    private DocumentFragment mBeforeFragment;
    private DataDocument mDataDocument;

    public DotNetXmlDocumentWriter() {
        this((Document)new XMLDocument());
    }

    public DotNetXmlDocumentWriter(Document document) {
        super(document);
        this.initDocument();
    }

    public Document writeDataDocument(DataDocument dataDocument) {
        this.mDataDocument = dataDocument;
        Iterator iterator = dataDocument.getAllRowSetIterators().iterator();
        Criteria criteria = dataDocument.getCriteria();
        while (iterator.hasNext()) {
            RowSetIterator rowSetIterator = (RowSetIterator)iterator.next();
            ViewRowSetIteratorImpl viewRowSetIteratorImpl = ViewObjectImpl.getImplObject(rowSetIterator);
            Node node = this.writeObject(viewRowSetIteratorImpl.getRowSetImpl(), dataDocument.getCriteria());
            Diagnostic.println("Appending node to current fragment.." + node);
        }
        this.writeDeletedRowDiffgram(dataDocument);
        Element element = this.getXMLDocument().createElement(dataDocument.getName());
        element.appendChild(this.mCurrrentFragment);
        this.getXMLDocument().getDocumentElement().appendChild(element);
        if (this.mBeforeFragment.hasChildNodes()) {
            element = this.getXMLDocument().createElement("diffgr:before");
            element.appendChild(this.mBeforeFragment);
            this.getXMLDocument().getDocumentElement().appendChild(element);
        }
        return this.getXMLDocument();
    }

    protected Node createRowSetNode(RowSetImpl rowSetImpl) {
        ViewDefImpl viewDefImpl = ((ViewRowSetImpl)rowSetImpl).getViewObjectImpl().getViewDef();
        if (viewDefImpl.getProperty("XML_ROW_ELEMENT") == null) {
            viewDefImpl.setProperty("XML_ROW_ELEMENT", viewDefImpl.getName());
        }
        return this.mCurrrentFragment;
    }

    protected Node createViewObjectNode(ViewObjectImpl viewObjectImpl) {
        return this.createRowSetNode(viewObjectImpl.getDefaultRowSet());
    }

    protected Node createRowNode(RowImpl rowImpl) {
        ViewRowImpl viewRowImpl = (ViewRowImpl)rowImpl;
        String string = null;
        Element element = this.getXMLDocument().createElement(viewRowImpl.getElementTagName());
        Integer n = (Integer)viewRowImpl.getHandle();
        boolean bl = false;
        switch (viewRowImpl.getViewRowState()) {
            case 2: {
                string = MODIFIED;
                bl = true;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 0: {
                string = INSERTED;
            }
        }
        element.setAttribute("diffgr:id", viewRowImpl.getViewDef().getName() + n);
        element.setAttribute("msdata:rowOrder", n.toString());
        if (string != null) {
            element.setAttribute("msdata:hasChanges", string);
        }
        if (bl) {
            this.writeBeforeElement(viewRowImpl);
        }
        return element;
    }

    public DocumentFragment getBeforeDataFragment() {
        return this.mBeforeFragment;
    }

    public DocumentFragment getCurrentDataFragment() {
        return this.mCurrrentFragment;
    }

    protected void writeDeletedRowDiffgram(DataDocument dataDocument) {
        String[] stringArray = dataDocument.getChangedRowSetNames();
        int n = 0;
        while (n < stringArray.length) {
            String string = dataDocument.getElementTagNameForRowSet(stringArray[n]);
            Iterator iterator = dataDocument.getChangedRowsForRowSet(stringArray[n]).iterator();
            while (iterator.hasNext()) {
                Element element = this.getXMLDocument().createElement(string);
                DataRow dataRow = (DataRow)iterator.next();
                Object object = dataDocument.getDataRowId(dataRow);
                element.setAttribute("diffgr:id", string + object.toString());
                element.setAttribute("msdata:rowOrder", object.toString());
                dataDocument.writeDataRowToXmlNode(this, element, dataRow);
                this.mBeforeFragment.appendChild(element);
            }
            ++n;
        }
    }

    private void writeBeforeElement(ViewRowImpl viewRowImpl) {
        Element element = this.getXMLDocument().createElement(viewRowImpl.getElementTagName());
        Integer n = (Integer)viewRowImpl.getHandle();
        element.setAttribute("diffgr:id", viewRowImpl.getViewDef().getName() + n);
        element.setAttribute("msdata:rowOrder", n.toString());
        viewRowImpl.writeAsXml(this, element, this.mDataDocument.getCriteria(), (byte)1);
        this.mBeforeFragment.appendChild(element);
    }

    private void initDocument() {
        Element element = this.getXMLDocument().createElement("diffgr:diffgram");
        element.setAttribute("xmlns:msdata", "urn:schemas-microsoft-com:xml-msdata");
        element.setAttribute("xmlns:diffgr", "urn:schemas-microsoft-com:xml-diffgram-v1");
        this.getXMLDocument().appendChild(element);
        this.mCurrrentFragment = this.getXMLDocument().createDocumentFragment();
        this.mBeforeFragment = this.getXMLDocument().createDocumentFragment();
    }
}

