/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.sql.DataSource;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeLoadException;
import oracle.jbo.DMLException;
import oracle.jbo.InvalidOperException;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.RowAlreadyDeletedException;
import oracle.jbo.RowInconsistentException;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSet;
import oracle.jbo.SQLStmtException;
import oracle.jbo.TooManyObjectsException;
import oracle.jbo.Transaction;
import oracle.jbo.ViewCriteria;
import oracle.jbo.ViewObject;
import oracle.jbo.common.CommonCriteriaAdapter;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboTypeMap;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.domain.BlobDomainInterface;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.NullValue;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.format.Formatter;
import oracle.jbo.mom.LongRunningStatementHandle;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.EntityCache;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.JDBCInteract;
import oracle.jbo.server.MetaObjectManager;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.SparseArray;
import oracle.jbo.server.TransactionEvent;
import oracle.jbo.server.ViewCriteriaAdapter;
import oracle.jbo.server.ViewObjectImpl;

public abstract class BaseSQLBuilderImpl
extends CommonCriteriaAdapter
implements ViewCriteriaAdapter,
SQLBuilder {
    static final String ORACLE_ROWID_COLUMN = "ROWID";
    static final char QOT = '\'';
    static final String QOTSTR = "'";
    static final String LIKE_QOT = "LIKE '";
    static final String LIKE = "LIKE";
    static final String IS = "IS";
    static final String IN = "IN";
    static final String NOT = "NOT";
    static final String NULL = "NULL";
    static final String BETWEEN = "BETWEEN";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$common$CommonMessageBundle;

    public abstract String getVersion();

    public abstract String getDbType();

    public ArrayList getNestedTables(Connection connection) throws SQLException {
        return null;
    }

    public abstract String getTypeMapName();

    public abstract String getPersistManagerClassName();

    public abstract String getDbTimeQuery();

    public abstract String getDropTableSQL(String var1);

    public abstract String getCreateSequenceInsertTriggerSQL(String var1, String var2, String var3, String var4);

    public abstract String getCreateSequenceSQL(String var1, int var2);

    public abstract String getDropSequenceSQL(String var1);

    public abstract boolean isDisplayBindValueUI();

    public BaseSQLBuilderImpl() {
        this.populateJboTypeMapEntries();
    }

    public int getDefaultBindingStyle() {
        return 0;
    }

    public void doRegisterDefaultDriver(String string) throws SQLException {
        block4: {
            try {
                JBOClass.forName(this.getJDBCDriverClassName(string));
                if (Diagnostic.isOn()) {
                    Diagnostic.println(this.getDbType() + " SQLBuilder: Registered driver: " + this.getJDBCDriverClassName(string));
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!Diagnostic.isOn()) break block4;
                Diagnostic.println(this.getDbType() + " SQLBuilder: Failed to load driver: " + this.getJDBCDriverClassName(string));
            }
        }
        if (JDBCInteract.mDoTrace) {
            JDBCInteract.header();
        }
    }

    public void executeBatch(PreparedStatement preparedStatement) throws SQLException {
        throw new JboException("SendBatch Not Implemented");
    }

    protected boolean shouldSkipDML(EntityImpl entityImpl, int n, TransactionEvent transactionEvent) {
        return entityImpl.isPostedToDB();
    }

    protected LongRunningStatementHandle createHandleForCancellableStatements(DBTransactionImpl dBTransactionImpl, Statement statement) {
        LongRunningStatementHandle longRunningStatementHandle = null;
        int n = dBTransactionImpl.getDMLOperationTimeOut();
        if (n > 0) {
            longRunningStatementHandle = new LongRunningStatementHandle(System.currentTimeMillis() + (long)n, statement);
            MetaObjectManager.getSingleton().getStatementMonitor().monitor(longRunningStatementHandle);
        } else {
            longRunningStatementHandle = new LongRunningStatementHandle(-1, statement);
        }
        dBTransactionImpl.addLongRunningDMLOperationHandle(longRunningStatementHandle);
        return longRunningStatementHandle;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doEntityDML(EntityImpl var1_1, int var2_2, TransactionEvent var3_3) {
        block39: {
            if (this.shouldSkipDML(var1_1, var2_2, var3_3)) {
                if (Diagnostic.isOn() == false) return;
                Diagnostic.println("Skip posting ... (" + DMLException.getOperationString(var2_2) + ")");
                return;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("BaseSQLBuilder Executing DML ... (" + DMLException.getOperationString(var2_2) + ")");
            }
            var4_4 = null;
            var5_5 = var1_1.getEntityDef();
            var6_6 = null;
            var7_7 = new HashMap(10);
            var8_8 = null;
            var9_9 = null;
            var10_10 = null;
            var11_11 = var1_1.getDBTransactionImpl();
            var11_11.mUseCallableStmt = false;
            if (Diagnostic.isOn()) {
                Diagnostic.println("Executing DML...");
            }
            var12_12 = var1_1.getEntityCache().isBatchable(var2_2);
            try {
                block40: {
                    try {
                        block42: {
                            block41: {
                                switch (var2_2) {
                                    case 1: {
                                        var8_8 = var5_5.getRetrievedOnInsertAttributes();
                                        var9_9 = var5_5.getRetrievedOnInsertPrimaryKeys();
                                        break;
                                    }
                                    case 2: {
                                        var8_8 = var5_5.getRetrievedOnUpdateAttributes();
                                        var9_9 = var5_5.getRetrievedOnUpdatePrimaryKeys();
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("");
                                    }
                                }
                                var6_6 = var1_1.buildDMLStatement(var2_2, var5_5.getAttributeDefImpls(), var8_8, var9_9, var12_12);
                                if (var6_6 == null) break block41;
                                if (var6_6.length() != 0) break block42;
                            }
                            var32_13 = null;
                            if (var10_10 != null) {
                                if (var10_10.getState() != 2) {
                                    var10_10.setState(0);
                                }
                                var11_11.removeLongRunningDMLOperationHandle(var10_10);
                            }
                            if (var4_4 == null) return;
                            break block39;
                        }
                        if (Diagnostic.isOn()) {
                            Diagnostic.println(var6_6.toString());
                        }
                        v0 = var13_19 = var11_11.getLockingMode() == 3;
                        if (var11_11.mUseCallableStmt) {
                            var6_6.insert(0, "BEGIN ");
                            var6_6.append(" END;");
                            var4_4 = var11_11.createCallableStatement(var6_6.toString(), 1);
                        } else {
                            var4_4 = var11_11.createPreparedStatement(var6_6.toString(), 1);
                        }
                        var1_1.bindDMLStatement(var2_2, (PreparedStatement)var4_4, var5_5.getAttributeDefImpls(), var8_8, var9_9, var7_7, var12_12);
                        var10_10 = this.createHandleForCancellableStatements(var11_11, var4_4);
                        var14_20 = var4_4.executeUpdate();
                        if (!var12_12 && var13_19 && var14_20 == 0) {
                            v1 = BaseSQLBuilderImpl.class$oracle$jbo$CSMessageBundle;
                            if (v1 == null) {
                                v1 = BaseSQLBuilderImpl.class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                            }
                            throw new RowNotFoundException(v1, "25057", new Object[]{var5_5.getName(), var1_1.getPrimaryKey()});
                        }
                        var1_1.setPostedToDB(true);
                        if (JDBCInteract.mDoTrace) {
                            JDBCInteract.execute(var4_4);
                        }
                        var17_21 = var7_7.size();
                        var18_22 = 0;
                        var19_23 = new int[var17_21];
                        var20_24 = new Object[var17_21];
                        var22_25 = null;
                        v2 = var24_26 = var9_9 != null && var9_9.length > 0;
                        if (var24_26) {
                            var22_25 = var1_1.getPrimaryKey();
                            var23_27 = true;
                        } else {
                            v3 = var23_27 = var8_8 != null && var8_8.length > 0;
                        }
                        if (var7_7.size() > 0) {
                            var26_28 = var7_7.keySet().iterator();
                            while (true) {
                                if (!var26_28.hasNext()) {
                                    if (var24_26 && (var22_25 == null || var22_25 != null && !var22_25.equals(var1_1.getPrimaryKey()))) {
                                        var1_1.getEntityCache().replace(var1_1, var22_25);
                                        if (var2_2 == 1) {
                                            var1_1.refreshFKInNewContainees();
                                        }
                                    }
                                    if (var18_22 != var17_21) break;
                                    var1_1.notifyAttributesChanged(var19_23, var20_24, false);
                                    break block40;
                                }
                                var15_29 = (Integer)var26_28.next();
                                var16_30 = (AttributeDefImpl)var7_7.get((Object)var15_29);
                                var25_32 = var16_30.getIndex();
                                var21_31 = var1_1.mData.get(var25_32);
                                if (!(var1_1.mOrigData.isPopulated(var25_32) || var2_2 == 1 && var16_30.isRetrievedOnInsert() || var2_2 == 2 && var16_30.isRetrievedOnUpdate())) {
                                    var1_1.mOrigData.set(var25_32, var21_31);
                                }
                                var1_1.populateAttribute(var25_32, var16_30.loadFromStatement((PreparedStatement)var4_4, var15_29, var1_1.getDBTransaction()));
                                if (!var1_1.isAttributePopulated(var25_32)) continue;
                                var19_23[var18_22] = var25_32;
                                var20_24[var18_22++] = var21_31;
                            }
                            var27_33 = new int[var18_22];
                            var28_34 = new Object[var18_22];
                            System.arraycopy(var19_23, 0, var27_33, 0, var18_22);
                            System.arraycopy(var20_24, 0, var28_34, 0, var18_22);
                            var1_1.notifyAttributesChanged(var27_33, var28_34, false);
                            break block40;
                        }
                        if (!var23_27) break block40;
                        var1_1.internalRefreshSQL(var2_2, var22_25, var9_9, var8_8);
                    }
                    catch (SQLException var29_35) {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("SQL92SQLBuilderImpl.doEntityDML failed...");
                            Diagnostic.println("X/Open SQL State is: " + var29_35.getSQLState());
                            Diagnostic.printStackTrace(var29_35);
                        }
                        if (var29_35.getNextException() == null) throw new DMLException(var2_2, var1_1, var1_1.getTransPostHandle(), var6_6.toString(), var29_35);
                        if (Diagnostic.isOn() == false) throw new DMLException(var2_2, var1_1, var1_1.getTransPostHandle(), var6_6.toString(), var29_35);
                        Diagnostic.println("more sqlerrors on stack");
                        throw new DMLException(var2_2, var1_1, var1_1.getTransPostHandle(), var6_6.toString(), var29_35);
                    }
                }
                var32_14 = null;
                if (var10_10 != null) {
                    if (var10_10.getState() != 2) {
                        var10_10.setState(0);
                    }
                    var11_11.removeLongRunningDMLOperationHandle(var10_10);
                }
                if (var4_4 == null) return;
                try {
                    var4_4.close();
                    if (JDBCInteract.mDoTrace == false) return;
                    JDBCInteract.closeStmt(var4_4);
                    return;
                }
                catch (SQLException var30_17) {
                    return;
                }
            }
            catch (Throwable var31_36) {
                var32_15 = null;
                if (var10_10 != null) {
                    if (var10_10.getState() != 2) {
                        var10_10.setState(0);
                    }
                    var11_11.removeLongRunningDMLOperationHandle(var10_10);
                }
                if (var4_4 == null) throw var31_36;
                ** try [egrp 2[TRYBLOCK] [2 : 987->1008)] { 
lbl143:
                // 1 sources

                var4_4.close();
                if (JDBCInteract.mDoTrace == false) throw var31_36;
                JDBCInteract.closeStmt(var4_4);
                throw var31_36;
lbl147:
                // 1 sources

                catch (SQLException var30_18) {
                    // empty catch block
                }
                throw var31_36;
            }
        }
        ** try [egrp 2[TRYBLOCK] [2 : 987->1008)] { 
lbl152:
        // 1 sources

        var4_4.close();
        if (JDBCInteract.mDoTrace == false) return;
        JDBCInteract.closeStmt(var4_4);
        return;
lbl156:
        // 1 sources

        catch (SQLException var30_16) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doEntitySelect(EntityImpl entityImpl, boolean bl) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("BaseSQLBuilderImpl Executing doSelect ... (" + bl + ")");
        }
        PreparedStatement preparedStatement = null;
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.getSource();
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getAttributeDefImpls();
        AttributeDefImpl[] attributeDefImplArray2 = entityDefImpl.getPrimaryKeys();
        EntityCache entityCache = entityImpl.getEntityCache();
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        LongRunningStatementHandle longRunningStatementHandle = null;
        if (this.capabilityCanReuseLockStatements()) {
            preparedStatement = entityCache.getPreparedSelectStatement(bl);
        } else if (Diagnostic.isOn()) {
            Diagnostic.println("Skipping attempt to reuse LOCK or FAULT-IN statement");
        }
        if (preparedStatement == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Generating new " + (bl ? "LOCK" : "FAULT-IN") + " statement");
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            this.buildSelectString(stringBuffer, string, attributeDefImplArray, false);
            String string2 = this.getSqlVariantLockTrailer();
            boolean bl2 = this.getLockTrailerIsAtEnd();
            if (bl && !bl2 && string2 != null) {
                stringBuffer.append(" " + string2).toString();
            }
            entityImpl.buildWhereClause(stringBuffer, attributeDefImplArray2, null);
            if (bl && bl2 && string2 != null) {
                stringBuffer.append(" " + string2).toString();
            }
            String string3 = stringBuffer.toString();
            if (Diagnostic.isOn()) {
                Diagnostic.println("Executing " + (bl ? "LOCK" : "FAULT-IN") + " \"" + string3 + "\"");
            }
            preparedStatement = entityCache.createPreparedStatement(string3, bl, 1);
        } else if (Diagnostic.isOn()) {
            Diagnostic.println("Reusing prepared " + (bl ? "LOCK" : "FAULT-IN") + " statement");
        }
        ResultSet resultSet = null;
        try {
            try {
                block44: {
                    block45: {
                        preparedStatement.clearParameters();
                        this.bindWhereClause(entityImpl, preparedStatement, null, 1);
                        if (bl) {
                            longRunningStatementHandle = this.createHandleForCancellableStatements(dBTransactionImpl, preparedStatement);
                        }
                        resultSet = preparedStatement.executeQuery();
                        if (JDBCInteract.mDoTrace) {
                            JDBCInteract.executeQuery(preparedStatement);
                        }
                        if (!resultSet.next()) {
                            throw new RowAlreadyDeletedException(true, entityDefImpl.getName(), entityImpl.getPrimaryKey());
                        }
                        if (bl) {
                            entityImpl.setLocked(true);
                        }
                        AttributeDefImpl[] attributeDefImplArray3 = entityDefImpl.getAttributeDefImpls();
                        int n = entityImpl.getAttributeCount();
                        SparseArray sparseArray = new SparseArray(n);
                        int n2 = 1;
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n) {
                                if (!resultSet.next()) break;
                                throw new TooManyObjectsException(entityDefImpl.getFullName(), entityImpl.getPrimaryKey());
                            }
                            if ((attributeDefImplArray3[n3].getAttributeKind() == 0 || attributeDefImplArray3[n3].getAttributeKind() == 1) && attributeDefImplArray3[n3].isSelected()) {
                                sparseArray.set(n3, attributeDefImplArray3[n3].loadFromResultSet(resultSet, n2++, dBTransactionImpl));
                            }
                            ++n3;
                        }
                        entityCache.freeStatement(preparedStatement);
                        boolean bl3 = true;
                        if (bl || entityImpl.getPostState() != 1) {
                            bl3 = entityImpl.checkConsistency(sparseArray, bl);
                        }
                        int n4 = 0;
                        int[] nArray = new int[n];
                        Object[] objectArray = new Object[n];
                        int n5 = 0;
                        while (true) {
                            if (n5 >= n) {
                                if (bl3) break block44;
                                if (n4 != n) break;
                                entityImpl.notifyAttributesChanged(nArray, objectArray, false);
                                break block45;
                            }
                            if (attributeDefImplArray3[n5].mKind == 0 || attributeDefImplArray3[n5].mKind == 1) {
                                if (!entityImpl.isAttributeChanged(n5)) {
                                    if (entityImpl.isAttributePopulated(n5)) {
                                        nArray[n4] = n5;
                                        objectArray[n4++] = entityImpl.mData.get(n5);
                                    }
                                    entityImpl.populateAttribute(n5, sparseArray.get(n5));
                                } else {
                                    entityImpl.mOrigData.set(n5, sparseArray.get(n5));
                                }
                            }
                            ++n5;
                        }
                        int[] nArray2 = new int[n4];
                        Object[] objectArray2 = new Object[n4];
                        System.arraycopy(nArray, 0, nArray2, 0, n4);
                        System.arraycopy(objectArray, 0, objectArray2, 0, n4);
                        entityImpl.notifyAttributesChanged(nArray2, objectArray2, false);
                    }
                    if (!Diagnostic.isOn()) throw new RowInconsistentException(entityImpl.getPrimaryKey());
                    Diagnostic.println("ERROR: RowInconsistency detected - throwing...");
                    throw new RowInconsistentException(entityImpl.getPrimaryKey());
                }
                Object var32_28 = null;
                if (longRunningStatementHandle != null) {
                    if (longRunningStatementHandle.getState() != 2) {
                        longRunningStatementHandle.setState(0);
                    }
                    dBTransactionImpl.removeLongRunningDMLOperationHandle(longRunningStatementHandle);
                }
                if (resultSet == null) return;
            }
            catch (SQLException sQLException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("SQL failure in doSelect for " + (bl ? "LOCK" : "FAULT-IN") + QOTSTR + sQLException.getMessage() + QOTSTR);
                    Diagnostic.println("SQLcode=" + sQLException.getErrorCode());
                }
                entityCache.freeStatement(preparedStatement);
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz != null) throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, sQLException);
                clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, sQLException);
            }
            catch (Exception exception) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                entityCache.freeStatement(preparedStatement);
                if (exception instanceof JboException) {
                    throw (JboException)exception;
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("SQL92SQLBuilderImpl.doEntitySelect failed...");
                    Diagnostic.printStackTrace(exception);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) != null) throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, exception);
                clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, exception);
            }
        }
        catch (Throwable throwable) {
            Object var32_29 = null;
            if (longRunningStatementHandle != null) {
                if (longRunningStatementHandle.getState() != 2) {
                    longRunningStatementHandle.setState(0);
                }
                dBTransactionImpl.removeLongRunningDMLOperationHandle(longRunningStatementHandle);
            }
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (SQLException sQLException) {}
        resultSet.close();
        return;
    }

    public void setSavepoint(Connection connection, String string) throws SQLException {
        if (Diagnostic.isOn()) {
            Diagnostic.println("BaseSQLBuilder: setSavepoint '" + string + "' ignored");
        }
    }

    public void rollbackToSavepoint(Connection connection, String string) throws SQLException {
        if (Diagnostic.isOn()) {
            Diagnostic.println("BaseSQLBuilder: rollbackToSavepoint '" + string + "' ignored");
        }
    }

    public void releaseSavepoint(Connection connection, String string) throws SQLException {
        if (Diagnostic.isOn()) {
            Diagnostic.println("BaseSQLBuilder: releaseSavepoint '" + string + "' ignored");
        }
    }

    public void doStatementSetRowPrefetch(Statement statement, int n) throws SQLException {
        if (Diagnostic.isOn()) {
            // empty if block
        }
    }

    public void doStatementSetBindingStyle(Statement statement, int n) {
        if (n == 0 || Diagnostic.isOn()) {
            // empty if block
        }
    }

    public void doStatementSetBindingStyleDefault(Statement statement) {
        this.doStatementSetBindingStyle(statement, this.getDefaultBindingStyle());
    }

    public void doPreparedStatementDefineColumnType(PreparedStatement preparedStatement, int n, int n2) throws SQLException {
        if (Diagnostic.isOn()) {
            // empty if block
        }
    }

    public void doPreparedStatementDefines(PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray) {
        if (Diagnostic.isOn()) {
            // empty if block
        }
    }

    public void populateJboTypeMapEntries() {
        String string = PropertyMetadata.PN_SQLTYPEMAP.getProperty();
        if (string != null && string.length() > 0) {
            JboTypeMap.populateEntries(string);
        } else {
            JboTypeMap.populateEntries(this.getTypeMapName());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doLoadFromResultSet(Object object, Object object2, Class clazz, byte by, ResultSet resultSet, int n, DBTransactionImpl dBTransactionImpl) {
        Object object3 = null;
        try {
            Object object4 = resultSet.getObject(n);
            if (resultSet.wasNull()) {
                object4 = null;
            }
            if (!((object3 = TypeFactory.getInstance(clazz, object4)) instanceof BlobDomainInterface)) return object3;
        }
        catch (JboException jboException) {
            if (!Diagnostic.isOn()) throw jboException;
            Diagnostic.println("LoadFromResultSet failed (" + n + ")");
            throw jboException;
        }
        catch (Exception exception) {
            if (!Diagnostic.isOn()) throw new AttributeLoadException(n, clazz, object != null, exception);
            Diagnostic.println("LoadFromResultSet failed (" + n + ")");
            throw new AttributeLoadException(n, clazz, object != null, exception);
        }
        return object3;
    }

    public Object[] doLoadBulkFromResultSet(AttributeDefImpl[] attributeDefImplArray, int n, ResultSet resultSet, int n2, DBTransactionImpl dBTransactionImpl) {
        Class clazz = null;
        Object object = null;
        Object[] objectArray = null;
        try {
            objectArray = new Object[attributeDefImplArray.length - n];
            int n3 = 0;
            while (n < attributeDefImplArray.length) {
                AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
                clazz = attributeDefImpl.getJavaType();
                object = attributeDefImpl.getTypeFactory();
                objectArray[n3] = this.doLoadFromResultSet(attributeDefImpl.getTypeFactory(), attributeDefImpl.getElemFactory(), clazz, attributeDefImpl.getAttrLoad(), resultSet, n2++, dBTransactionImpl);
                ++n;
                ++n3;
            }
        }
        catch (JboException jboException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadBulkFromResultSet failed (" + n2 + ")");
            }
            throw jboException;
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("LoadBulkFromResultSet failed (" + n2 + ")");
            }
            throw new AttributeLoadException(n2, clazz, object != null, exception);
        }
        return objectArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object doLoadFromStatement(Object object, Object object2, Class clazz, PreparedStatement preparedStatement, int n, Transaction transaction) {
        CallableStatement callableStatement = (CallableStatement)preparedStatement;
        Object object3 = null;
        try {
            object3 = TypeFactory.getInstance(clazz, callableStatement.getObject(n));
            if (!(object3 instanceof BlobDomainInterface)) return object3;
        }
        catch (JboException jboException) {
            if (!Diagnostic.isOn()) throw jboException;
            Diagnostic.println("LoadFromStatement failed (" + n + ")");
            throw jboException;
        }
        catch (Exception exception) {
            if (!Diagnostic.isOn()) throw new AttributeLoadException(n, clazz, object != null, exception);
            Diagnostic.println("LoadFromStatement failed (" + n + ")");
            throw new AttributeLoadException(n, clazz, object != null, exception);
        }
        return object3;
    }

    public Object generatePKBasedRef(EntityImpl entityImpl) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
        }
        throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26046", new Object[]{entityImpl.getEntityDef().getName()}, null);
    }

    public Object[] generateRefAndOID(EntityImpl entityImpl) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
        }
        throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26043", new Object[]{entityImpl.getEntityDef().getName()}, null);
    }

    public boolean isStreamType(int n) {
        return false;
    }

    public Object generateRowID(EntityImpl entityImpl) {
        return new Long(Math.round(Math.random() * 1000000.0));
    }

    public Vector getTableList(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        return JboEnvUtil.convertArrayListToVector(this.getTables(connection, string, string2, bl, bl2, bl3, bl4));
    }

    public Vector getTableList(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        return this.getTableList(connection, string, string2, bl, bl2, bl3, bl4);
    }

    public ArrayList getTables(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws Exception {
        ArrayList arrayList;
        block10: {
            arrayList = new ArrayList();
            try {
                String string3;
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string4 = null;
                String string5 = string2;
                String string6 = "%";
                String[] stringArray = this.convertFlags(bl, bl2, bl3, bl4);
                if (!databaseMetaData.supportsSchemasInTableDefinitions() || string2 == null || string2.length() == 0) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Ignoring database schema for this query");
                    }
                    string5 = null;
                }
                if ((string3 = databaseMetaData.getCatalogSeparator()) == null || string3.length() == 0) {
                    string3 = ".";
                }
                if (Diagnostic.isOn()) {
                    Diagnostic.println("JDBC getTables('" + string4 + "','" + string5 + "','" + string6 + "','" + (bl ? "TABLE " : " ") + (bl2 ? "ALIAS " : " ") + (bl3 ? "VIEW " : " ") + (bl4 ? "SNAP " : " ") + "')");
                }
                ResultSet resultSet = databaseMetaData.getTables(string4, string5, string6, stringArray);
                while (resultSet.next()) {
                    String string7 = null;
                    try {
                        string7 = resultSet.getString("TABLE_SCHEM");
                    }
                    catch (SQLException sQLException) {
                        string7 = null;
                    }
                    String string8 = resultSet.getString("TABLE_NAME");
                    if (!databaseMetaData.supportsSchemasInTableDefinitions() || string7 == null || string.equals(string7)) {
                        arrayList.add((Object)string8);
                        continue;
                    }
                    arrayList.add((Object)(string7 + string3 + string8));
                }
            }
            catch (Exception exception) {
                if (!Diagnostic.isOn()) break block10;
                Diagnostic.printStackTrace(exception);
            }
        }
        return arrayList;
    }

    public ArrayList getTables(Connection connection, String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws Exception {
        return this.getTables(connection, string, string2, bl, bl2, bl3, bl4);
    }

    public String checkTableNameForQuotes(String string) {
        if (this.needsQuotedTableName(string)) {
            return this.getQuotationMarkLeft() + string + this.getQuotationMarkRight();
        }
        return string;
    }

    protected boolean needsQuotedTableName(String string) {
        return false;
    }

    protected String getQuotationMarkLeft() {
        return "\"";
    }

    protected String getQuotationMarkRight() {
        return "\"";
    }

    protected boolean getLockTrailerIsAtEnd() {
        return true;
    }

    protected String[] convertFlags(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n = 0;
        if (bl) {
            ++n;
        }
        if (bl2) {
            ++n;
        }
        if (bl3) {
            ++n;
        }
        if (bl4) {
            ++n;
        }
        String[] stringArray = new String[n];
        n = 0;
        if (bl) {
            stringArray[n++] = "TABLE";
        }
        if (bl2) {
            stringArray[n++] = "ALIAS";
        }
        if (bl3) {
            stringArray[n++] = "VIEW";
        }
        if (bl4) {
            stringArray[n++] = "SNAPSHOT";
        }
        return stringArray;
    }

    public Vector getSchemaList(Connection connection) throws Exception {
        return JboEnvUtil.convertArrayListToVector(this.getSchemas(connection));
    }

    public ArrayList getSchemas(Connection connection) throws Exception {
        ArrayList arrayList = new ArrayList();
        if (connection != null) {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData.supportsSchemasInTableDefinitions()) {
                ResultSet resultSet = databaseMetaData.getSchemas();
                while (resultSet.next()) {
                    arrayList.add((Object)resultSet.getString(1));
                }
                resultSet.close();
            } else if (Diagnostic.isOn()) {
                Diagnostic.println("WARNING: database doesn't use schemas");
            }
        }
        return arrayList;
    }

    protected String getWarningText(String string) {
        return "WARNING: SQLBuilder '" + this.getDbType() + "' " + string;
    }

    protected abstract String getJDBCDriverClassName(String var1);

    public StringBuffer buildUpdateStatement(EntityImpl entityImpl, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, boolean bl) {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.mSource;
        if (attributeDefImplArray.length == 0 || string == null) {
            return null;
        }
        String string2 = entityDefImpl.getAliasName();
        AttributeDefImpl[] attributeDefImplArray4 = entityDefImpl.mPrimaryKeys;
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        boolean bl2 = dBTransactionImpl.getLockingMode() == 3;
        StringBuffer stringBuffer = new StringBuffer(100);
        boolean bl3 = true;
        boolean bl4 = bl2 || entityDefImpl.isUpdateChangedColumns();
        stringBuffer.append("UPDATE ").append(string);
        if (this.getSupportsAliasInUpdateStatements()) {
            stringBuffer.append(" ").append(string2);
        }
        stringBuffer.append(" SET ");
        int n = 0;
        while (n < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
            if (attributeDefImpl.getAttributeKind() == 0 && !attributeDefImpl.getColumnName().equals(ORACLE_ROWID_COLUMN) && (bl4 ? entityImpl.isAttributeChanged(attributeDefImpl.getIndex()) : entityImpl.isAttributePopulated(attributeDefImpl.getIndex()))) {
                if (bl3) {
                    bl3 = false;
                } else {
                    stringBuffer.append(",");
                }
                stringBuffer.append(attributeDefImpl.getColumnName()).append("=?");
            }
            ++n;
        }
        if (bl3) {
            return null;
        }
        entityImpl.buildWhereClause(stringBuffer, attributeDefImplArray4, this.getROWID(entityImpl));
        if (bl2) {
            this.buildOptUpdateWhereClause(entityImpl, stringBuffer, attributeDefImplArray);
        }
        return stringBuffer;
    }

    public int bindInsertStatement(EntityImpl entityImpl, PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, HashMap hashMap, boolean bl) throws SQLException {
        int n = 1;
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        boolean bl2 = entityDefImpl.isUpdateChangedColumns();
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n2];
            if (attributeDefImpl.getAttributeKind() == 0 && !attributeDefImpl.getColumnName().equals(ORACLE_ROWID_COLUMN) && (bl2 ? entityImpl.isAttributeChanged(attributeDefImpl.getIndex()) : entityImpl.isAttributePopulated(attributeDefImpl.getIndex()))) {
                Object object = entityImpl.getAttributeInternal(attributeDefImpl.getIndex());
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                if (object != null) {
                    object = attributeDefImpl.convertToStorage(object, dBTransactionImpl);
                }
                if (object != null) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Insert binding param " + n + ": " + object);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setObject(preparedStatement, n, object, attributeDefImpl);
                    }
                    preparedStatement.setObject(n++, object);
                } else {
                    int n3 = attributeDefImpl.getSQLType();
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Insert binding null of type " + n3 + " for " + n);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setNull(preparedStatement, n, n3, attributeDefImpl);
                    }
                    preparedStatement.setNull(n++, n3);
                }
            }
            ++n2;
        }
        return n;
    }

    public int bindUpdateStatement(EntityImpl entityImpl, PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, HashMap hashMap, boolean bl) throws SQLException {
        int n = 1;
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        boolean bl2 = entityDefImpl.isUpdateChangedColumns();
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n2];
            if (attributeDefImpl.getAttributeKind() == 0 && !attributeDefImpl.getColumnName().equals(ORACLE_ROWID_COLUMN) && (bl2 ? entityImpl.isAttributeChanged(attributeDefImpl.getIndex()) : entityImpl.isAttributePopulated(attributeDefImpl.getIndex()))) {
                Object object = entityImpl.getAttributeInternal(attributeDefImpl.getIndex());
                if (object != null) {
                    object = attributeDefImpl.convertToStorage(object, dBTransactionImpl);
                }
                if (object != null) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Update binding param " + n + ": " + object);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setObject(preparedStatement, n, object, attributeDefImpl);
                    }
                    preparedStatement.setObject(n++, object);
                } else {
                    int n3 = attributeDefImpl.getSQLType();
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Update binding null of type " + n3 + " for " + n);
                    }
                    if (JDBCInteract.mDoTrace) {
                        JDBCInteract.setNull(preparedStatement, n, n3, attributeDefImpl);
                    }
                    preparedStatement.setNull(n++, n3);
                }
            }
            ++n2;
        }
        n = this.bindWhereClause(entityImpl, preparedStatement, this.getROWID(entityImpl), n);
        return n;
    }

    public int bindDeleteStatement(EntityImpl entityImpl, PreparedStatement preparedStatement) throws SQLException {
        int n = 1;
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        boolean bl = dBTransactionImpl.getLockingMode() == 3;
        n = this.bindWhereClause(entityImpl, preparedStatement, null, n);
        if (bl) {
            n = this.bindOptUpdateWhereClause(entityImpl, preparedStatement, n);
        }
        return n;
    }

    protected int bindParamValue(int n, Object object, DBTransactionImpl dBTransactionImpl, PreparedStatement preparedStatement, AttributeDefImpl attributeDefImpl, int n2, boolean bl) throws SQLException {
        if (object != null && !(object instanceof NullValue)) {
            if (attributeDefImpl != null) {
                object = attributeDefImpl.convertToStorage(object, dBTransactionImpl);
            }
            if (object != null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Binding param " + n2 + ": " + object);
                }
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.setObject(preparedStatement, n2, object, attributeDefImpl);
                }
                preparedStatement.setObject(n2++, object);
                return n2;
            }
        }
        if (!bl) {
            int n3 = 0;
            if (attributeDefImpl != null) {
                n3 = attributeDefImpl.getSQLType();
            }
            if (n3 == 0) {
                int n4 = n3 = object instanceof NullValue ? ((NullValue)object).getSQLTypeId() : 12;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("Binding null of type " + n3 + " for " + n2);
            }
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.setNull(preparedStatement, n2, n3, attributeDefImpl);
            }
            preparedStatement.setNull(n2++, n3);
        }
        return n2;
    }

    protected int bindWhereAttrValue(EntityImpl entityImpl, DBTransactionImpl dBTransactionImpl, PreparedStatement preparedStatement, AttributeDefImpl attributeDefImpl, int n, boolean bl) throws SQLException {
        int n2 = attributeDefImpl.getIndex();
        Object object = entityImpl.mOrigData.isPopulated(n2) ? entityImpl.mOrigData.get(n2) : entityImpl.mData.get(n2);
        int n3 = attributeDefImpl.getSQLType();
        if (object == null || object instanceof NullValue) {
            if (!bl) {
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.setNull(preparedStatement, n, n3, attributeDefImpl);
                }
                preparedStatement.setNull(n++, n3);
            }
        } else if ((object = attributeDefImpl.convertToStorage(object, dBTransactionImpl)) != null) {
            if (JDBCInteract.mDoTrace) {
                JDBCInteract.setObject(preparedStatement, n, object, attributeDefImpl);
            }
            preparedStatement.setObject(n++, object);
        } else if (!bl) {
            preparedStatement.setNull(n++, n3);
        }
        return n;
    }

    public int bindWhereClause(EntityImpl entityImpl, PreparedStatement preparedStatement, Object object, int n) throws SQLException {
        return entityImpl.bindWhereClause(preparedStatement, entityImpl.getEntityDef().getPrimaryKeys(), object, n);
    }

    public int bindWhereClause(EntityImpl entityImpl, PreparedStatement preparedStatement, AttributeDefImpl[] attributeDefImplArray, Object object, int n) throws SQLException {
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        int n2 = 0;
        while (n2 < attributeDefImplArray.length) {
            n = this.bindWhereAttrValue(entityImpl, dBTransactionImpl, preparedStatement, attributeDefImplArray[n2], n, false);
            ++n2;
        }
        return n;
    }

    public int bindOptUpdateWhereClause(EntityImpl entityImpl, PreparedStatement preparedStatement, int n) throws SQLException {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.getPrimaryKeys();
        DBTransactionImpl dBTransactionImpl = entityImpl.getDBTransactionImpl();
        AttributeDefImpl attributeDefImpl = entityDefImpl.getChangeIndicatorColumn();
        if (attributeDefImpl != null) {
            if (!entityImpl.isAttributePopulated(attributeDefImpl.getIndex())) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "26047", new Object[]{entityDefImpl.getName(), entityImpl.getPrimaryKey()});
            }
            n = this.bindWhereAttrValue(entityImpl, dBTransactionImpl, preparedStatement, attributeDefImpl, n, false);
        } else {
            attributeDefImplArray = entityDefImpl.getAttributeDefImpls();
            int n2 = 0;
            while (n2 < attributeDefImplArray.length) {
                AttributeDefImpl attributeDefImpl2 = attributeDefImplArray[n2];
                if (!attributeDefImpl2.isPrimaryKey() && entityImpl.isAttributePopulated(attributeDefImpl2.getIndex())) {
                    n = this.bindWhereAttrValue(entityImpl, dBTransactionImpl, preparedStatement, attributeDefImpl2, n, true);
                }
                ++n2;
            }
        }
        return n;
    }

    protected Object getROWID(EntityImpl entityImpl) {
        return null;
    }

    public void buildWhereClause(EntityImpl entityImpl, StringBuffer stringBuffer, AttributeDefImpl[] attributeDefImplArray, Object object) {
        boolean bl = false;
        stringBuffer.append(" WHERE ");
        if (object != null) {
            stringBuffer.append(ORACLE_ROWID_COLUMN).append("=?");
            bl = true;
        }
        int n = 0;
        while (n < attributeDefImplArray.length) {
            int n2;
            if (bl) {
                stringBuffer.append(" AND ");
            }
            if (!entityImpl.isAttributePopulated(n2 = attributeDefImplArray[n].getIndex())) {
                throw new JboException("Key attribute \"" + entityImpl.getEntityDef().getName() + "." + attributeDefImplArray[n].getName() + "\" not populated");
            }
            stringBuffer.append(attributeDefImplArray[n].getColumnName()).append("=?");
            bl = true;
            ++n;
        }
    }

    public void buildOptUpdateWhereClause(EntityImpl entityImpl, StringBuffer stringBuffer, AttributeDefImpl[] attributeDefImplArray) {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        AttributeDefImpl attributeDefImpl = entityDefImpl.getChangeIndicatorColumn();
        if (attributeDefImpl != null) {
            int n = attributeDefImpl.getIndex();
            if (!entityImpl.isAttributePopulated(n)) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "26047", new Object[]{entityDefImpl.getName(), entityImpl.getPrimaryKey()});
            }
            stringBuffer.append(" AND ").append(attributeDefImpl.getColumnName()).append("=?");
        } else {
            int n = 0;
            while (n < attributeDefImplArray.length) {
                AttributeDefImpl attributeDefImpl2 = attributeDefImplArray[n];
                int n2 = attributeDefImpl2.getIndex();
                if (!attributeDefImpl2.isPrimaryKey() && entityImpl.isAttributePopulated(n2)) {
                    Object object = entityImpl.mOrigData.isPopulated(n2) ? entityImpl.mOrigData.get(n2) : entityImpl.mData.get(n2);
                    stringBuffer.append(" AND ").append(attributeDefImpl2.getColumnName());
                    if (object == null || object instanceof NullValue) {
                        stringBuffer.append(" IS NULL");
                    } else {
                        stringBuffer.append("=?");
                    }
                }
                ++n;
            }
        }
    }

    public StringBuffer buildInsertStatement(EntityImpl entityImpl, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2, AttributeDefImpl[] attributeDefImplArray3, boolean bl) {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.mSource;
        if (attributeDefImplArray.length == 0 || string == null) {
            return null;
        }
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(100);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        boolean bl3 = entityDefImpl.isUpdateChangedColumns();
        stringBuffer.append("INSERT INTO ").append(string).append("(");
        int n = 0;
        while (n < attributeDefImplArray.length) {
            AttributeDefImpl attributeDefImpl = attributeDefImplArray[n];
            if (attributeDefImpl.getAttributeKind() == 0 && !attributeDefImpl.getColumnName().equals(ORACLE_ROWID_COLUMN) && (bl3 ? entityImpl.isAttributeChanged(attributeDefImpl.getIndex()) : entityImpl.isAttributePopulated(attributeDefImpl.getIndex()))) {
                if (bl2) {
                    stringBuffer.append(",");
                    stringBuffer2.append(",?");
                } else {
                    stringBuffer2.append("?");
                }
                stringBuffer.append(attributeDefImpl.getColumnName());
                bl2 = true;
            }
            ++n;
        }
        if (!bl2) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "26018", new Object[]{entityDefImpl.getName()});
        }
        stringBuffer.append(") VALUES (").append(stringBuffer2.toString()).append(")");
        if (attributeDefImplArray3 != null && attributeDefImplArray3.length > 0 && Diagnostic.isOn()) {
            Diagnostic.println("Warning: BaseSQLBuilder does not support RETURNING (key-cols) clause....");
        }
        if (attributeDefImplArray2 != null && attributeDefImplArray2.length != 0 && Diagnostic.isOn()) {
            Diagnostic.println("Warning: BaseSQLBuilder does not support RETURNING (cols) clause....");
        }
        return stringBuffer;
    }

    public StringBuffer buildDeleteStatement(EntityImpl entityImpl) {
        EntityDefImpl entityDefImpl = entityImpl.getEntityDef();
        String string = entityDefImpl.mSource;
        if (string == null) {
            return null;
        }
        AttributeDefImpl[] attributeDefImplArray = entityDefImpl.mPrimaryKeys;
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("DELETE FROM ").append(string);
        entityImpl.buildWhereClause(stringBuffer, attributeDefImplArray, this.getROWID(entityImpl));
        return stringBuffer;
    }

    public static void baseBuildSelectList(StringBuffer stringBuffer, AttributeDef[] attributeDefArray, String string) {
        int n = 0;
        while (n < attributeDefArray.length) {
            if (attributeDefArray[n].getAttributeKind() == 0 || attributeDefArray[n].getAttributeKind() == 1) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(attributeDefArray[n].getColumnName());
            }
            ++n;
        }
    }

    public void buildSelectList(StringBuffer stringBuffer, AttributeDef[] attributeDefArray, String string) {
        BaseSQLBuilderImpl.baseBuildSelectList(stringBuffer, attributeDefArray, string);
    }

    public void buildSelectString(DBTransactionImpl dBTransactionImpl, StringBuffer stringBuffer, String string, String string2, AttributeDefImpl[] attributeDefImplArray, boolean bl, int n) {
        this.buildSelectString(stringBuffer, string, attributeDefImplArray, bl);
    }

    protected void buildSelectString(StringBuffer stringBuffer, String string, AttributeDefImpl[] attributeDefImplArray, boolean bl) {
        stringBuffer.append("SELECT ");
        this.buildSelectList(stringBuffer, attributeDefImplArray, string);
        if (bl) {
            stringBuffer.append(" INTO ");
            int n = 0;
            while (n < attributeDefImplArray.length) {
                if (attributeDefImplArray[n].getAttributeKind() == 0 || attributeDefImplArray[n].getAttributeKind() == 1) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("?");
                }
                ++n;
            }
        }
        stringBuffer.append(" FROM ").append(string);
        if (Diagnostic.isOn()) {
            Diagnostic.println("Built select: '" + stringBuffer.toString() + QOTSTR);
        }
    }

    public Vector getConstraints(Connection connection, String string, String string2, String string3) throws SQLException {
        return JboEnvUtil.convertArrayListToVector(this.getConstraintsList(connection, string, string2, string3));
    }

    public ArrayList getConstraintsList(Connection connection, String string, String string2, String string3) throws SQLException {
        String string4 = null;
        String string5 = null;
        int n = string3.indexOf(".");
        if (n == -1) {
            string4 = string2;
            string5 = string3;
        } else {
            string4 = string3.substring(0, n);
            string5 = string3.substring(n + 1);
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        ArrayList arrayList = new ArrayList();
        try {
            resultSet = databaseMetaData.getPrimaryKeys(string, string4, string5);
            while (resultSet.next()) {
                Object[] objectArray = new Object[14];
                objectArray[0] = resultSet.getString(2) != null ? resultSet.getString(2).trim() : "";
                objectArray[3] = resultSet.getString(3).trim();
                objectArray[10] = resultSet.getString(4).trim();
                objectArray[11] = new Integer(resultSet.getInt(5));
                objectArray[1] = resultSet.getString(6) != null ? resultSet.getString(6).trim() : "";
                objectArray[2] = "P";
                objectArray[4] = "";
                objectArray[5] = new Integer(0);
                objectArray[6] = new Integer(1);
                objectArray[7] = new Integer(2);
                objectArray[8] = new Integer(0);
                objectArray[9] = new Integer(1);
                objectArray[12] = "";
                objectArray[13] = "";
                arrayList.add((Object)objectArray);
                BaseSQLBuilderImpl.dumpConstraint(objectArray);
                if (!Diagnostic.isOn()) continue;
            }
            resultSet.close();
            resultSet = databaseMetaData.getImportedKeys(string, string4, string5);
            while (resultSet.next()) {
                Object[] objectArray = new Object[14];
                objectArray[0] = resultSet.getString(2) != null ? resultSet.getString(2) : "";
                objectArray[13] = resultSet.getString(6) != null ? resultSet.getString(6) : "";
                objectArray[3] = resultSet.getString(7);
                objectArray[10] = resultSet.getString(8);
                objectArray[11] = new Integer(resultSet.getInt(9));
                int n2 = resultSet.getInt(11);
                int n3 = 0;
                if (n2 == 0) {
                    n3 = 1;
                }
                objectArray[5] = new Integer(n3);
                objectArray[1] = resultSet.getString(12);
                objectArray[12] = resultSet.getString(13);
                int n4 = resultSet.getInt(14);
                int n5 = 0;
                int n6 = 2;
                if (n4 != 7) {
                    n6 = 0;
                }
                if (n4 == 5) {
                    n5 = 1;
                }
                objectArray[2] = "R";
                objectArray[4] = null;
                objectArray[6] = new Integer(1);
                objectArray[7] = new Integer(n6);
                objectArray[8] = new Integer(n5);
                objectArray[9] = new Integer(1);
                arrayList.add((Object)objectArray);
                BaseSQLBuilderImpl.dumpConstraint(objectArray);
                if (!Diagnostic.isOn()) continue;
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("SQL-92 Metadata query failed: trying getBestRowIdentifier ...");
                Diagnostic.println(sQLException.getMessage());
            }
            try {
                resultSet = databaseMetaData.getBestRowIdentifier(null, null, string5, 0, false);
                while (resultSet.next()) {
                    Object[] objectArray = new Object[14];
                    objectArray[11] = new Integer(resultSet.getInt(1));
                    objectArray[10] = resultSet.getString(2);
                    objectArray[0] = string4;
                    objectArray[3] = string5;
                    objectArray[1] = string5 + "pk" + objectArray[11];
                    objectArray[2] = "P";
                    objectArray[4] = "";
                    objectArray[5] = new Integer(0);
                    objectArray[6] = new Integer(1);
                    objectArray[7] = new Integer(2);
                    objectArray[8] = new Integer(0);
                    objectArray[9] = new Integer(1);
                    objectArray[12] = "";
                    objectArray[13] = "";
                    arrayList.add((Object)objectArray);
                    BaseSQLBuilderImpl.dumpConstraint(objectArray);
                    if (!Diagnostic.isOn()) continue;
                }
                resultSet.close();
            }
            catch (SQLException sQLException2) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException3) {
                    // empty catch block
                }
            }
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("SQL-92: found " + arrayList.size() + " constraints for table: '" + string5 + QOTSTR);
        }
        return arrayList;
    }

    public String getBaseTable(Connection connection, String string, String string2) throws SQLException {
        return string2;
    }

    public DataSource lookupDataSource(String string, String string2, String string3, String string4) throws JboException {
        Class clazz = class$oracle$jbo$common$CommonMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$common$CommonMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.common.CommonMessageBundle");
        }
        throw new JboException(clazz, "33006", new Object[]{string4});
    }

    public boolean isDataSourceJTABased(DataSource dataSource) {
        return false;
    }

    public boolean supportsReturningClause() {
        return false;
    }

    public boolean supportsRowNumQuery() {
        return false;
    }

    protected boolean capabilityCanReuseLockStatements() {
        return true;
    }

    protected String getSqlVariantLockTrailer() {
        return null;
    }

    protected boolean getSupportsAliasInUpdateStatements() {
        return true;
    }

    protected static void dumpConstraint(Object[] objectArray) {
        boolean bl = true;
        if (bl) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < 5) {
            String string = "X";
            if (objectArray[n] != null) {
                string = objectArray[n].toString();
            }
            stringBuffer.append(n + "-" + string + " ");
            ++n;
        }
        stringBuffer.setLength(0);
        int n2 = 5;
        while (n2 < objectArray.length) {
            String string = "X";
            if (objectArray[n2] != null) {
                string = objectArray[n2].toString();
            }
            stringBuffer.append(n2 + "-" + string + " ");
            ++n2;
        }
    }

    public ViewCriteriaAdapter getViewCriteriaAdapter() {
        return this;
    }

    protected Object convertValueToWhereFragment(AttributeDef attributeDef, String string) {
        return this.convertValueToWhereFragment(null, attributeDef, string);
    }

    protected Object convertValueToWhereFragment(ViewObject viewObject, ViewCriteria viewCriteria, AttributeDef attributeDef, String string) {
        return this.convertValueToWhereFragment(null, attributeDef, string);
    }

    public String getViewCriteriaClause(ViewObject viewObject, ViewCriteria viewCriteria) {
        return super.getCriteriaClause(viewObject.getAttributeDefs(), viewCriteria);
    }

    protected String getFormattedRHSCompareFragment(AttributeDef attributeDef, int n, String string) {
        return this.getFormattedRHSCompareFragment(null, null, attributeDef, n, string);
    }

    protected String getFormattedRHSCompareFragment(ViewCriteria viewCriteria, AttributeDef attributeDef, int n, String string) {
        return this.getFormattedRHSCompareFragment(viewCriteria.getViewObject(), viewCriteria, attributeDef, n, string);
    }

    protected Object formatAttributeValue(ViewCriteria viewCriteria, AttributeDef attributeDef, String string) {
        Object object = string;
        try {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)attributeDef;
            LocaleContext localeContext = viewCriteria.getViewObject().getApplicationModule().getSession().getLocaleContext();
            object = attributeDefImpl.parseFormattedAttribute(string, localeContext);
            if (attributeDefImpl.hasFormatInformation(localeContext) && JboTypeMap.isCharType(attributeDefImpl.getSQLType())) {
                Formatter formatter = attributeDefImpl.getFormatter(localeContext);
                object = formatter.format(formatter.getDefaultFormatString(), object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    protected String getFormattedRHSCompareFragment(ViewObject viewObject, ViewCriteria viewCriteria, AttributeDef attributeDef, int n, String string) {
        if (this.isNumericType(n)) {
            return string;
        }
        return QOTSTR + string + '\'';
    }

    protected String getFormattedLHSCompareFragment(AttributeDef attributeDef, int n, String string, Object object) {
        return string;
    }

    protected final String getFormattedLHSCompareFragment(ViewCriteria viewCriteria, AttributeDef attributeDef, int n, String string, Object object) {
        return this.getFormattedLHSCompareFragment(viewCriteria.getViewObject(), viewCriteria, attributeDef, n, string, object);
    }

    protected String getFormattedLHSCompareFragment(ViewObject viewObject, ViewCriteria viewCriteria, AttributeDef attributeDef, int n, String string, Object object) {
        return string;
    }

    protected String getColumnNameWithFormatForQuery(String string, AttributeDef attributeDef, int n) {
        return this.getFormattedLHSCompareFragment(attributeDef, n, string, null);
    }

    /*
     * Loose catch block
     */
    public Timestamp getCurrentDbTime(Connection connection) {
        Timestamp timestamp;
        block22: {
            String string;
            ResultSet resultSet;
            Statement statement;
            block20: {
                statement = null;
                resultSet = null;
                timestamp = null;
                string = this.getDbTimeQuery();
                if (string == null || string.length() == 0) {
                    return null;
                }
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                statement = connection.createStatement();
                resultSet = statement.executeQuery(string);
                if (!resultSet.next()) {
                    Class clazz = class$oracle$jbo$common$CommonMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$common$CommonMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.common.CommonMessageBundle");
                    }
                    throw new SQLStmtException(clazz, "33020", string, null);
                }
                timestamp = resultSet.getTimestamp(1);
                Object var11_6 = null;
                if (resultSet == null) break block20;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            resultSet = null;
            if (statement == null) break block22;
            try {
                statement.close();
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.closeStmt(statement);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = null;
            {
                break block22;
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**getCurrentDbTime** failed, sqlStmt=" + string);
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$common$CommonMessageBundle) == null) {
                        clazz = class$oracle$jbo$common$CommonMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.common.CommonMessageBundle");
                    }
                    SQLStmtException sQLStmtException = new SQLStmtException(clazz, "33020", string, sQLException);
                    sQLStmtException.addToDetails(sQLException);
                    throw sQLStmtException;
                }
            }
            catch (Throwable throwable) {
                Object var11_7 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                resultSet = null;
                if (statement != null) {
                    try {
                        statement.close();
                        if (JDBCInteract.mDoTrace) {
                            JDBCInteract.closeStmt(statement);
                        }
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    statement = null;
                }
                throw throwable;
            }
        }
        return timestamp;
    }

    /*
     * Loose catch block
     */
    public void doRefreshSQL(EntityImpl entityImpl, int n, AttributeDefImpl[] attributeDefImplArray, AttributeDefImpl[] attributeDefImplArray2) {
        block33: {
            ResultSet resultSet;
            PreparedStatement preparedStatement;
            DBTransactionImpl dBTransactionImpl;
            EntityDefImpl entityDefImpl;
            block32: {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("BaseSQLBuilder.doRefreshSQL, Executing Select for Refresh-on-insert or update attributes");
                }
                entityDefImpl = entityImpl.getEntityDef();
                EntityCache entityCache = entityImpl.getEntityCache();
                dBTransactionImpl = entityImpl.getDBTransactionImpl();
                int n2 = attributeDefImplArray.length;
                StringBuffer stringBuffer = new StringBuffer(200);
                AttributeDefImpl[] attributeDefImplArray3 = entityImpl.buildRefreshSQL(stringBuffer, n, attributeDefImplArray, attributeDefImplArray2, false);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Executing Refresh SQL..." + stringBuffer);
                }
                preparedStatement = entityCache.createRefreshPreparedStatement(stringBuffer.toString());
                resultSet = null;
                this.bindWhereClause(entityImpl, preparedStatement, attributeDefImplArray3, null, 1);
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                resultSet = preparedStatement.executeQuery();
                if (JDBCInteract.mDoTrace) {
                    JDBCInteract.executeQuery(preparedStatement);
                }
                if (!resultSet.next()) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new RowNotFoundException(clazz, "28203", new Object[]{entityDefImpl.getName(), entityImpl.getPrimaryKey()});
                }
                SparseArray sparseArray = new SparseArray(n2);
                int n3 = 1;
                int n4 = 0;
                while (n4 < n2) {
                    sparseArray.set(n4, attributeDefImplArray[n4].loadFromResultSet(resultSet, n3++, dBTransactionImpl));
                    ++n4;
                }
                if (resultSet.next()) {
                    throw new TooManyObjectsException(entityDefImpl.getFullName(), entityImpl.getPrimaryKey());
                }
                n4 = 0;
                while (n4 < n2) {
                    entityImpl.populateAttribute(attributeDefImplArray[n4].getIndex(), sparseArray.get(n4));
                    ++n4;
                }
                int[] nArray = new int[n2];
                Object[] objectArray = new Object[n2];
                n4 = 0;
                while (n4 < n2) {
                    nArray[n4] = n3 = attributeDefImplArray[n4].getIndex();
                    objectArray[n4] = entityImpl.mOrigData.get(n3);
                    ++n4;
                }
                entityImpl.notifyAttributesChanged(nArray, objectArray, false);
                Object var23_18 = null;
                if (resultSet == null) break block32;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (preparedStatement != null) {
                try {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Close prepared statement for refresh SQL");
                    }
                    dBTransactionImpl.closeStatement(preparedStatement, true);
                }
                catch (Exception exception) {}
            }
            break block33;
            {
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("SQL failure in doRefreshSQL - '" + sQLException.getMessage() + QOTSTR);
                        Diagnostic.println("SQLcode=" + sQLException.getErrorCode());
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, sQLException);
                }
                catch (Exception exception) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("General failure in select : " + exception.getMessage());
                    }
                    if (exception instanceof JboException) {
                        throw (JboException)exception;
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("EntityImpl.doRefreshSQL failed...");
                        Diagnostic.printStackTrace(exception);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
                    }
                    throw new DMLException(clazz, entityImpl, entityImpl.getTransPostHandle(), "26080", new Object[]{entityDefImpl.getName()}, exception);
                }
            }
            catch (Throwable throwable) {
                Object var23_19 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (preparedStatement != null) {
                    try {
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("Close prepared statement for refresh SQL");
                        }
                        dBTransactionImpl.closeStatement(preparedStatement, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public String getQueryHitCountSQL(RowSet rowSet) {
        int n;
        ViewObject viewObject = rowSet.getViewObject();
        String string = ((ViewObjectImpl)viewObject).buildQuery(n = rowSet.getWhereClauseParams().length, true);
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append("SELECT count(1) FROM (");
        stringBuffer.append(string);
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    /*
     * Loose catch block
     */
    public boolean isConnectionAlive(Connection connection) {
        boolean bl;
        block11: {
            Statement statement = null;
            bl = true;
            statement = connection.createStatement();
            Object var7_4 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                break block11;
            }
            catch (SQLException sQLException) {}
            break block11;
            {
                catch (SQLException sQLException) {
                    bl = false;
                    Object var7_5 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        break block11;
                    }
                    catch (SQLException sQLException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return bl;
    }

    public Object convertValueToStorageType(Object object) {
        return !(object instanceof NullValue) && object instanceof DomainInterface ? ((DomainInterface)object).getData() : object;
    }

    public void jdbcClientSideSecurity(Properties properties, Hashtable hashtable) {
    }

    public boolean compareFetchedValue(EntityImpl entityImpl, AttributeDefImpl attributeDefImpl, Object object, Object object2) {
        return EntityImpl.compareAttrVals(object, object2);
    }

    public void bindParametersForStmt(int n, Object[] objectArray, PreparedStatement preparedStatement) throws SQLException {
        int n2 = 0;
        if (objectArray != null) {
            n2 = 0;
            while (n2 < objectArray.length) {
                this.bindParamValue(n, objectArray[n2], null, preparedStatement, null, n2 + 1, false);
                ++n2;
            }
        }
    }

    public void processException(String string, Exception exception, Object[] objectArray) {
        if (string.equals("27122")) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = BaseSQLBuilderImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new SQLStmtException(clazz, "27122", (String)objectArray[0], exception);
        }
        throw new JboException(exception);
    }

    public boolean invalidDatumFactoryUsage(String string, int n, Class clazz) {
        return true;
    }

    public int getMaxTableNameLength(Connection connection) {
        if (connection != null) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                int n = databaseMetaData.getMaxTableNameLength();
                return n;
            }
            catch (SQLException sQLException) {
                int n = 0;
                return n;
            }
        }
        return 0;
    }

    public boolean isNewLineAllowedInSQL(Connection connection) {
        return true;
    }

    public void setSessionTimeZone(Connection connection, String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

