/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import oracle.jbo.AttrValException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeHints;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.LocaleContext;
import oracle.jbo.PersistenceException;
import oracle.jbo.ReadOnlyAttrException;
import oracle.jbo.Row;
import oracle.jbo.Transaction;
import oracle.jbo.common.AttributeDefHelper;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.common.JboTypeMap;
import oracle.jbo.common.JboXMLUtil;
import oracle.jbo.common.NamedObjectImpl;
import oracle.jbo.common.StringManager;
import oracle.jbo.common.WeakHashtable;
import oracle.jbo.domain.DataCreationException;
import oracle.jbo.domain.DomainAttributeDef;
import oracle.jbo.domain.DomainInterface;
import oracle.jbo.domain.DomainOwnerInterface;
import oracle.jbo.domain.TypeFactory;
import oracle.jbo.domain.XMLDomainFactory;
import oracle.jbo.domain.XMLDomainReaderFactory;
import oracle.jbo.domain.XMLValueFactory;
import oracle.jbo.format.Formatter;
import oracle.jbo.format.FormatterFactory;
import oracle.jbo.mom.xml.DefElement;
import oracle.jbo.rules.JboPrecisionScaleValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.JboValidatorInterface;
import oracle.jbo.rules.RulesBeanUtils;
import oracle.jbo.server.ComponentObjectImpl;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.DefObject;
import oracle.jbo.server.DomainDefImpl;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.EntityImpl;
import oracle.jbo.server.RowDef;
import oracle.jbo.server.RowImpl;
import oracle.jbo.server.RowSetImpl;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.SQLBuilderFactory;
import oracle.jbo.server.SessionImpl;
import oracle.jbo.server.SparseArrayInterface;
import oracle.jbo.server.ViewDefImpl;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.server.util.PropertyChangeEvent;
import oracle.jbo.server.util.PropertyChangeListener;
import oracle.jbo.server.util.VetoableChangeListener;
import oracle.sql.CustomDatumFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeDefImpl
extends DefObject
implements AttributeHints,
AttributeDef {
    public static final byte ATTR_LOAD_EACH = 0;
    public static final byte ATTR_LOAD_BULK = 1;
    public static final byte ATTR_LOAD_SKIP = 2;
    static final String OBJTAB_REF_ATTR_NAME = "REF$".intern();
    static final String OBJTAB_OID_ATTR_NAME = "SYS_NC_OID$".intern();
    protected String mColumnName;
    private boolean mSelected;
    protected boolean mQueriable;
    protected boolean mUnique;
    protected boolean mPrimaryKey;
    protected boolean mDiscrColumn;
    protected boolean mMandatory;
    protected boolean mRetrievedOnInsert;
    protected boolean mRetrievedOnUpdate;
    protected RowDef mDef;
    protected boolean mObjectTableRef;
    protected boolean mObjectTableOID;
    protected String[] mOIDAttrNames;
    protected String mObjectType;
    protected boolean mNotNull;
    protected int mPrecision;
    protected int mScale;
    protected byte mUpdateable;
    protected byte mKind;
    private boolean mIsSessionScope;
    protected byte mAttrLoad;
    protected int mType;
    protected int mIndex;
    protected Object mDefaultValue;
    protected String mDomainName;
    protected Class mJavaType;
    protected Class mElemType;
    private ArrayList mBeforeVec;
    private ArrayList mValidators;
    private ArrayList mAfterVec;
    protected Method mReadMethod;
    protected Method mWriteMethod;
    protected Object mTypeFactory;
    protected Object mElemFactory;
    protected boolean mTypeFactoryInitialized;
    protected SQLBuilder mSQLBuilder;
    protected boolean mResolveAccessors;
    private boolean mCascadeUpdateParticipant;
    private HashMap mContextMap;
    private final byte FORMAT_INFO_UNINITIALIZED;
    private final byte FORMAT_INFO_NOT_AVAILABLE;
    private final byte FORMAT_INFO_AVAILABLE;
    private byte mHasFormatInfo;
    String mName;
    static final String XML_NULL_ATTR_TAG = "null".intern();
    static final String XML_NULL_ATTR_VAL = "true";
    public static final byte HISTORY_NOT_DEFINED = 0;
    public static final byte HISTORY_CREATE_DATE = 1;
    public static final byte HISTORY_MODIFY_DATE = 2;
    public static final byte HISTORY_CREATE_USER = 3;
    public static final byte HISTORY_MODIFY_USER = 4;
    public static final byte HISTORY_MODIFY_VERSION = 5;
    protected byte mHistoryKind;
    static final byte XML_FAC_UNINIT = 0;
    static final byte XML_FAC_INIT = 1;
    static final byte XML_FAC_DOMAINFAC = 2;
    static final byte XML_FAC_SERIALIZER = 3;
    static final byte XML_FAC_BOTH = 4;
    byte mXMLFactoryInit;
    XMLValueFactory mXMLDomainFactory;
    static WeakHashtable xmlFactoryMap = null;
    private static /* synthetic */ Class class$java$lang$Long;
    private static /* synthetic */ Class class$java$lang$Class;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$AttributeList;
    private static /* synthetic */ Class class$oracle$jbo$server$ViewAttributeDefImpl;
    private static /* synthetic */ Class class$oracle$jbo$server$EntityImpl;

    private /* synthetic */ void $init$() {
        this.mSelected = true;
        this.mQueriable = false;
        this.mUnique = false;
        this.mPrimaryKey = false;
        this.mDiscrColumn = false;
        this.mMandatory = false;
        this.mRetrievedOnInsert = false;
        this.mRetrievedOnUpdate = false;
        this.mObjectTableRef = false;
        this.mObjectTableOID = false;
        this.mOIDAttrNames = null;
        this.mObjectType = null;
        this.mNotNull = false;
        this.mPrecision = 0;
        this.mScale = -127;
        this.mUpdateable = 0;
        this.mType = 12;
        this.mDomainName = null;
        this.mJavaType = null;
        this.mElemType = null;
        this.mBeforeVec = new ArrayList(2);
        this.mValidators = new ArrayList(3);
        this.mReadMethod = null;
        this.mWriteMethod = null;
        this.mTypeFactory = null;
        this.mElemFactory = null;
        this.mTypeFactoryInitialized = false;
        this.mSQLBuilder = null;
        this.mResolveAccessors = false;
        this.mCascadeUpdateParticipant = false;
        this.mContextMap = null;
        this.FORMAT_INFO_UNINITIALIZED = (byte)-1;
        this.FORMAT_INFO_NOT_AVAILABLE = 0;
        this.FORMAT_INFO_AVAILABLE = 1;
        this.mHasFormatInfo = (byte)-1;
        this.mName = null;
        this.mHistoryKind = 0;
        this.mXMLFactoryInit = 0;
    }

    protected AttributeDefImpl() {
        this.$init$();
    }

    AttributeDefImpl(String string, String string2, RowDef rowDef, Object object, byte by, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, byte by2, int n, int n2, byte by3, Class clazz, Class clazz2) {
        this.$init$();
        this.initAttributeDef(string, string2, rowDef, object, by, bl, bl2, bl3, bl4, bl5, by2, n, n2, by3, clazz, clazz2);
    }

    void initAttributeDef(String string, String string2, RowDef rowDef, Object object, byte by, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, byte by2, int n, int n2, byte by3, Class clazz, Class clazz2) {
        this.setName(string.intern());
        this.mColumnName = string2 != null ? string2.intern() : null;
        this.mDef = rowDef;
        this.mUpdateable = by;
        this.mPrimaryKey = bl;
        this.mDiscrColumn = bl2;
        this.mRetrievedOnInsert = bl3;
        this.mRetrievedOnUpdate = bl4;
        this.mNotNull = bl5;
        this.mIndex = n;
        this.mType = n2 != 1 ? n2 : 12;
        this.mKind = by3;
        this.mAttrLoad = by2;
        this.mJavaType = clazz;
        this.mElemType = clazz2;
        this.mDefaultValue = this.convertToJava(object);
        if (this.mName == OBJTAB_REF_ATTR_NAME) {
            this.mObjectTableRef = true;
        } else if (this.mName == OBJTAB_OID_ATTR_NAME) {
            this.mObjectTableOID = true;
        } else if (this.mColumnName == EntityImpl.ORACLE_ROWID_COLUMN && bl) {
            this.mRetrievedOnInsert = true;
            this.checkForBatchUpdate();
        }
    }

    void copyAttribute(AttributeDefImpl attributeDefImpl) {
        this.mColumnName = attributeDefImpl.mColumnName;
        this.mSelected = attributeDefImpl.mSelected;
        this.mQueriable = attributeDefImpl.mQueriable;
        this.mUnique = attributeDefImpl.mUnique;
        this.mUpdateable = attributeDefImpl.mUpdateable;
        this.mPrimaryKey = attributeDefImpl.mPrimaryKey;
        this.mNotNull = attributeDefImpl.mNotNull;
        this.mRetrievedOnInsert = attributeDefImpl.mRetrievedOnInsert;
        this.mRetrievedOnUpdate = attributeDefImpl.mRetrievedOnUpdate;
        this.mPrecision = attributeDefImpl.mPrecision;
        this.mScale = attributeDefImpl.mScale;
        this.mKind = attributeDefImpl.mKind;
        this.mType = attributeDefImpl.mType;
        this.mDefaultValue = attributeDefImpl.mDefaultValue;
        this.mJavaType = attributeDefImpl.mJavaType;
        this.mElemType = attributeDefImpl.mElemType;
        this.mObjectTableRef = attributeDefImpl.mObjectTableRef;
        this.mObjectTableOID = attributeDefImpl.mObjectTableOID;
        if (attributeDefImpl.mProperties != null) {
            this.mProperties = (HashMap)attributeDefImpl.mProperties.clone();
        }
        if (attributeDefImpl.mObjectTableOID && this.mDef instanceof ViewDefImpl) {
            this.mUpdateable = 0;
        }
    }

    protected void setName(String string) {
        this.mName = string;
        if (this.mName == OBJTAB_REF_ATTR_NAME) {
            this.mObjectTableRef = true;
        } else if (this.mName == OBJTAB_OID_ATTR_NAME) {
            this.mObjectTableOID = true;
        }
        super.setName(string);
    }

    void initAccessors(Class clazz) {
        this.mResolveAccessors = true;
        String string = "get" + this.mName;
        Class[] classArray = new Class[]{};
        Class clazz2 = class$oracle$jbo$server$EntityImpl;
        if (clazz2 == null) {
            clazz2 = class$oracle$jbo$server$EntityImpl = AttributeDefImpl.class$("oracle.jbo.server.EntityImpl");
        }
        this.mReadMethod = JboNameUtil.findMethod(clazz, string, classArray, clazz2);
        String string2 = "set" + this.mName;
        Class[] classArray2 = new Class[]{this.mJavaType};
        Class clazz3 = class$oracle$jbo$server$EntityImpl;
        if (clazz3 == null) {
            clazz3 = class$oracle$jbo$server$EntityImpl = AttributeDefImpl.class$("oracle.jbo.server.EntityImpl");
        }
        this.mWriteMethod = JboNameUtil.findMethod(clazz, string2, classArray2, clazz3);
    }

    Class getComponentClass() {
        Class clazz = class$oracle$jbo$server$ViewAttributeDefImpl;
        if (clazz == null) {
            clazz = class$oracle$jbo$server$ViewAttributeDefImpl = AttributeDefImpl.class$("oracle.jbo.server.ViewAttributeDefImpl");
        }
        return clazz;
    }

    boolean isTransient() {
        return this.mKind == 3;
    }

    boolean isDynamic() {
        return this.mKind == 4;
    }

    boolean isPersistent() {
        return this.mKind == 0;
    }

    boolean isEntityDerived() {
        return this.mKind == 5;
    }

    boolean isRow() {
        return this.mKind == 2;
    }

    boolean isRowIterator() {
        return this.mKind == 6;
    }

    boolean isConstrained() {
        return this.mBeforeVec.size() != 0 || this.mValidators.size() != 0;
    }

    boolean isBound() {
        return this.mAfterVec != null && this.mAfterVec.size() > 0;
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    public void setSelected(boolean bl) {
        this.mSelected = bl;
    }

    public boolean isQueriable() {
        return this.mQueriable;
    }

    public void setQueriable(boolean bl) {
        this.mQueriable = bl;
    }

    public byte getUpdateableFlag() {
        return this.mUpdateable;
    }

    public void setUpdateableFlag(byte by) {
        this.mUpdateable = by;
    }

    public boolean isSessionScope() {
        return this.mIsSessionScope;
    }

    void setSessionScope(boolean bl) {
        this.mIsSessionScope = bl;
    }

    public boolean isDiscrColumn() {
        return this.mDiscrColumn;
    }

    public void setDiscrColumn(boolean bl) {
        this.mDiscrColumn = bl;
    }

    public boolean isPrimaryKey() {
        return this.mPrimaryKey;
    }

    public void setPrimaryKey(boolean bl) {
        this.mPrimaryKey = bl;
    }

    public boolean isRetrievedOnInsert() {
        return this.mRetrievedOnInsert;
    }

    public void setRetrievedOnInsert(boolean bl) {
        this.mRetrievedOnInsert = bl;
    }

    public boolean isRetrievedOnUpdate() {
        return this.mRetrievedOnUpdate;
    }

    public void setRetrievedOnUpdate(boolean bl) {
        this.mRetrievedOnUpdate = bl;
    }

    public boolean isMandatory() {
        return this.mNotNull;
    }

    public void setMandatory(boolean bl) {
        this.mNotNull = bl;
    }

    public boolean isObjectTableRef() {
        return this.mObjectTableRef;
    }

    public boolean isObjectTableOID() {
        return this.mObjectTableOID;
    }

    public String[] getOIDAttrNames() {
        return this.mOIDAttrNames;
    }

    void setOIDAttrNames(String[] stringArray) {
        if (this.isObjectTableRef()) {
            this.mOIDAttrNames = stringArray;
        }
    }

    public String getObjectType() {
        return this.mObjectType;
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public int getScale() {
        return this.mScale;
    }

    public void setPrecisionScale(int n, int n2) {
        this.mPrecision = n;
        this.mScale = n2;
        if (this.mPrecision > 0) {
            JboPrecisionScaleValidator jboPrecisionScaleValidator = new JboPrecisionScaleValidator();
            jboPrecisionScaleValidator.setPrecision(this.mPrecision);
            jboPrecisionScaleValidator.setScale(this.mScale);
            if (jboPrecisionScaleValidator != null) {
                this.addValidator(jboPrecisionScaleValidator);
            }
        }
    }

    public EntityDefImpl getEntityDef() {
        return this.mDef instanceof EntityDefImpl ? (EntityDefImpl)this.mDef : null;
    }

    public RowDef getDef() {
        return this.mDef;
    }

    void setDef(RowDef rowDef) {
        this.mDef = rowDef;
    }

    public int getIndex() {
        return this.mIndex;
    }

    void setIndex(int n) {
        this.mIndex = n;
    }

    public int getSQLType() {
        return this.mType;
    }

    public void setSQLType(int n) {
        this.mType = n;
    }

    public void setDomainName(String string) {
        this.mDomainName = string;
    }

    public String getDomainName() {
        return this.mDomainName;
    }

    public void setObjectType(String string) {
        this.mObjectType = string;
    }

    public byte getAttributeKind() {
        return this.mKind;
    }

    void setAttributeKind(byte by) {
        this.mKind = by;
    }

    public byte getAttrLoad() {
        return this.mAttrLoad;
    }

    public void setAttrLoad(byte by) {
        this.mAttrLoad = by;
    }

    public Class getJavaType() {
        return this.mJavaType;
    }

    void setJavaType(Class clazz) {
        this.mJavaType = clazz;
    }

    public Class getElemType() {
        return this.mElemType;
    }

    public int getElemSQLType() {
        int n = 0;
        if (this.mElemType != null && (n = JboTypeMap.javaTypeToSQLTypeId(this.mElemType.getName())) == 0) {
            Class clazz = class$oracle$jbo$AttributeList;
            if (clazz == null) {
                clazz = class$oracle$jbo$AttributeList = AttributeDefImpl.class$("oracle.jbo.AttributeList");
            }
            if (clazz.isAssignableFrom(this.mElemType)) {
                return JboTypeMap.columnTypeToSQLTypeId("STRUCT", 0);
            }
        }
        return n;
    }

    public void setElemType(Class clazz) {
        this.mElemType = clazz;
    }

    public Object getDefaultValue() {
        return this.mPrimaryKey ? TypeFactory.getInstance(this.mJavaType, this.mDefaultValue, true) : this.mDefaultValue;
    }

    public void setDefaultValue(Object object) {
        this.mDefaultValue = object;
    }

    void setColumnName(String string) {
        this.mColumnName = string;
    }

    public String getColumnName() {
        return this.mColumnName;
    }

    public String getColumnNameForQuery() {
        String string = this.getDef().getAliasName();
        String string2 = this.isObjectTableRef() ? "REF(" + string + ")" : string + "." + this.getColumnName();
        return string2;
    }

    public Object convertToJava(Object object) throws DataCreationException {
        if (this.mJavaType != null) {
            return TypeFactory.getInstance(this.mJavaType, object);
        }
        return object;
    }

    void initTypeFactory() {
        if (!this.mTypeFactoryInitialized && this.mTypeFactory == null) {
            this.mTypeFactoryInitialized = true;
            SQLBuilder sQLBuilder = this.getSQLBuilder();
            try {
                Method method = this.mJavaType.getDeclaredMethod("getCustomDatumFactory", new Class[0]);
                this.mTypeFactory = (CustomDatumFactory)method.invoke(null, null);
                if (this.mTypeFactory != null && sQLBuilder.invalidDatumFactoryUsage(this.getColumnType(), this.getSQLType(), this.getJavaType())) {
                    this.mTypeFactory = null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.mElemType != null) {
                try {
                    Method method = this.mElemType.getDeclaredMethod("getCustomDatumFactory", new Class[0]);
                    this.mElemFactory = (CustomDatumFactory)method.invoke(null, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public Object getTypeFactory() {
        if (!this.mTypeFactoryInitialized) {
            this.initTypeFactory();
        }
        return this.mTypeFactory;
    }

    public Object getElemFactory() {
        if (!this.mTypeFactoryInitialized) {
            this.initTypeFactory();
        }
        return this.mElemFactory;
    }

    private void initDomainContextMap() {
        if (this.mContextMap == null) {
            this.mContextMap = new HashMap(4);
            if (this.mElemType != null) {
                this.mContextMap.put((Object)"1", this.mElemFactory);
                this.mContextMap.put((Object)"4", (Object)this.getColumnType());
                this.mContextMap.put((Object)"5", (Object)this.getElemType());
            }
            this.mContextMap.put((Object)"0", (Object)new Integer(this.mIndex));
        }
    }

    void processDomainValue(DomainInterface domainInterface, DomainOwnerInterface domainOwnerInterface, DBTransaction dBTransaction) {
        if (!this.mTypeFactoryInitialized) {
            this.initTypeFactory();
        }
        if (this.mContextMap == null) {
            this.initDomainContextMap();
        }
        domainInterface.setContext(domainOwnerInterface, dBTransaction, this.mContextMap);
    }

    final void setValueInSparseArray(Object object, SparseArrayInterface sparseArrayInterface, EntityImpl entityImpl, DBTransaction dBTransaction) {
        if (object instanceof DomainInterface) {
            this.processDomainValue((DomainInterface)object, entityImpl, dBTransaction);
        }
        sparseArrayInterface.set(this.mIndex, object);
    }

    public Object loadFromResultSet(ResultSet resultSet, int n, DBTransactionImpl dBTransactionImpl) throws DataCreationException {
        Object object;
        if (!this.mTypeFactoryInitialized) {
            this.initTypeFactory();
        }
        if ((object = this.getSQLBuilder().doLoadFromResultSet(this.mTypeFactory, this.mElemFactory, this.getJavaType(), this.getAttrLoad(), resultSet, n, dBTransactionImpl)) instanceof DomainInterface) {
            this.processDomainValue((DomainInterface)object, null, dBTransactionImpl);
        }
        return object;
    }

    public Object loadFromStatement(PreparedStatement preparedStatement, int n, Transaction transaction) throws DataCreationException {
        if (!this.mTypeFactoryInitialized) {
            this.initTypeFactory();
        }
        return this.getSQLBuilder().doLoadFromStatement(this.mTypeFactory, this.mElemFactory, this.getJavaType(), preparedStatement, n, transaction);
    }

    public Object convertToStorage(Object object, DBTransactionImpl dBTransactionImpl) {
        if (this.mTypeFactory == null && object instanceof DomainInterface) {
            return ((DomainInterface)object).getData();
        }
        return object;
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.mAfterVec == null) {
            this.mAfterVec = new ArrayList(2);
        }
        this.mAfterVec.add((Object)propertyChangeListener);
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.mAfterVec != null) {
            this.mAfterVec.remove((Object)propertyChangeListener);
        }
    }

    void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.mBeforeVec.add((Object)vetoableChangeListener);
    }

    ArrayList getVetoableChangeListener() {
        return this.mBeforeVec;
    }

    void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.mBeforeVec.remove((Object)vetoableChangeListener);
    }

    public void addValidator(JboValidatorInterface jboValidatorInterface) {
        this.mValidators.add((Object)jboValidatorInterface);
    }

    public ArrayList getValidators() {
        return (ArrayList)this.mValidators.clone();
    }

    public void removeValidator(JboValidatorInterface jboValidatorInterface) {
        this.mValidators.remove((Object)jboValidatorInterface);
    }

    Object get(Row row) {
        if (row == null) {
            return null;
        }
        return ((RowImpl)row).getAttributeInternal(this.mIndex);
    }

    Object get(Row row, ViewDefImpl viewDefImpl) {
        return this.get(row);
    }

    void set(Row row, Object object) {
        int n;
        AttrValException attrValException;
        if (row == null) {
            return;
        }
        EntityImpl entityImpl = (EntityImpl)row;
        if (!entityImpl.isAttributeUpdateable(this.mIndex)) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = AttributeDefImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new ReadOnlyAttrException(121, clazz, "27004", this.getDef().getFullName(), this.getName());
        }
        PropertyChangeEvent propertyChangeEvent = null;
        if (this.mBeforeVec.size() > 0 && (attrValException = this.validate(entityImpl, propertyChangeEvent = new PropertyChangeEvent(row, this.mName, entityImpl.getAttributeValue(this), object), entityImpl.getDBTransactionImpl().isBundledExceptionMode() ^ true)) != null) {
            throw attrValException;
        }
        if (this.mValidators.size() > 0) {
            JboValidatorContext jboValidatorContext = new JboValidatorContext(121, row, entityImpl.getEntityDef().getFullName(), this, entityImpl.getAttributeValue(this), object);
            AttrValException attrValException2 = RulesBeanUtils.validate(JboEnvUtil.javaIterator(this.mValidators.iterator()), entityImpl, jboValidatorContext, entityImpl.getDBTransactionImpl().isBundledExceptionMode() ^ true);
            if (attrValException2 != null) {
                throw attrValException2;
            }
        }
        entityImpl.setAttributeValue(this.mIndex, object);
        if (this.mAfterVec != null && (n = this.mAfterVec.size()) > 0) {
            if (propertyChangeEvent == null) {
                propertyChangeEvent = new PropertyChangeEvent(row, this.mName, entityImpl.getAttributeValue(this), object);
            }
            int n2 = 0;
            while (n2 < n) {
                ((PropertyChangeListener)this.mAfterVec.get(n2)).propertyChange(propertyChangeEvent);
                ++n2;
            }
        }
    }

    AttrValException validate(EntityImpl entityImpl, PropertyChangeEvent propertyChangeEvent, boolean bl) {
        ArrayList arrayList = null;
        int n = this.mBeforeVec.size();
        if (bl) {
            int n2 = 0;
            while (n2 < n) {
                ((VetoableChangeListener)this.mBeforeVec.get(n2)).vetoableChange(propertyChangeEvent);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                try {
                    ((VetoableChangeListener)this.mBeforeVec.get(n3)).vetoableChange(propertyChangeEvent);
                }
                catch (JboException jboException) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(5);
                    }
                    arrayList.add((Object)jboException);
                }
                ++n3;
            }
            if (arrayList != null) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = AttributeDefImpl.class$("oracle.jbo.CSMessageBundle");
                }
                AttrValException attrValException = new AttrValException(clazz, "27025", this.getDef().getFullName(), this.getName(), propertyChangeEvent.getNewValue(), arrayList, true);
                attrValException.setRowKey(121, entityImpl.getKey());
                return attrValException;
            }
        }
        return null;
    }

    Object resolveGet(Row row) throws Exception {
        Method method;
        if (!this.mResolveAccessors) {
            this.initAccessors(row.getClass());
        }
        if ((method = this.mReadMethod) == null) {
            return this.get(row);
        }
        return method.invoke((Object)row, null);
    }

    void resolveSet(EntityImpl entityImpl, Object object) throws Exception {
        Method method;
        if (!this.mResolveAccessors) {
            this.initAccessors(entityImpl.getClass());
        }
        if ((method = this.mWriteMethod) == null) {
            this.set(entityImpl, object);
        } else {
            Object[] objectArray = new Object[]{object};
            method.invoke((Object)entityImpl, objectArray);
        }
    }

    private void loadPrecisionValidator(DefElement defElement) {
        this.mPrecision = defElement.readInt("Precision");
        if (this.mPrecision > 0) {
            String string = this.getColumnType();
            if (string != null && JboTypeMap.isNumericType(this.mType)) {
                this.mScale = defElement.readInt("Scale");
            }
            if (defElement.readBoolean("PrecisionRule")) {
                this.setPrecisionScale(this.mPrecision, this.mScale);
            }
        }
    }

    static byte convertUpdateableStringToFlag(String string) {
        return AttributeDefHelper.convertUpdateableStringToFlag(string);
    }

    static byte convertAttrLoadStringToEnum(String string) {
        if (string != null) {
            if (string.equals("Each")) {
                return 0;
            }
            if (string.equals("Bulk")) {
                return 1;
            }
            if (string.equals("Skip")) {
                return 2;
            }
        }
        return 0;
    }

    static byte convertKindStringToFlag(String string) {
        if (string != null) {
            if (string.equals("Calculated")) {
                return 1;
            }
            if (string.equals("Transient")) {
                return 3;
            }
        }
        return 0;
    }

    static AttributeDefImpl loadFromXML(DefElement defElement, RowDef rowDef, int n) {
        AttributeDefImpl attributeDefImpl = new AttributeDefImpl();
        attributeDefImpl.initFromXML(defElement, rowDef, n);
        return attributeDefImpl;
    }

    protected void initFromXML(DefElement defElement, RowDef rowDef, int n) {
        String string = defElement.readString("Name").intern();
        String string2 = defElement.readString("ColumnName");
        String string3 = defElement.readString("DefaultValue");
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        byte by = string2.equalsIgnoreCase(EntityImpl.ORACLE_ROWID_COLUMN) ? (byte)0 : AttributeDefImpl.convertUpdateableStringToFlag(defElement.readString("IsUpdateable"));
        boolean bl = defElement.readBoolean("IsSessionScope");
        boolean bl2 = defElement.readBoolean("PrimaryKey");
        boolean bl3 = defElement.readBoolean("DiscrColumn");
        boolean bl4 = defElement.readBoolean("RetrievedOnInsert");
        boolean bl5 = defElement.readBoolean("RetrievedOnUpdate");
        boolean bl6 = defElement.readBoolean("IsNotNull");
        byte by2 = AttributeDefImpl.convertAttrLoadStringToEnum(defElement.readString("AttrLoad"));
        boolean bl7 = defElement.readBoolean("ChangeIndicator");
        byte by3 = AttributeDefImpl.convertHistoryColumnStringToFlag(defElement.readString("HistoryColumn"), by);
        byte by4 = defElement.readBoolean("IsPersistent") ? (byte)0 : 3;
        String string4 = defElement.readString("Type");
        String string5 = defElement.readString("ElemType");
        String string6 = defElement.readString("SQLType");
        if (string2.equals("$none$")) {
            string2 = null;
        }
        if (string6 != null && string6.equals("$none$")) {
            string6 = null;
        }
        int n2 = AttributeDefImpl.getSQLTypeStringToId(string6);
        Class clazz = JBOClass.findDataClass(string4);
        Class clazz2 = null;
        if (string5 != null) {
            clazz2 = JBOClass.findDataClass(string5);
        }
        this.initAttributeDef(string, string2, rowDef, string3, by, bl2, bl3, bl4, bl5, bl6, by2, n, n2, by4, clazz, clazz2);
        this.mDomainName = defElement.readString("Domain");
        this.mSelected = defElement.readBoolean("IsSelected");
        this.mQueriable = defElement.readBoolean("IsQueriable");
        this.mUnique = defElement.readBoolean("IsUnique");
        if (this.isObjectTableRef()) {
            int n3;
            String string7 = defElement.readString("OIDAttrNames");
            ArrayList arrayList = new ArrayList();
            while (string7 != null && string7.length() > 0) {
                int n4 = string7.indexOf(59);
                if (n4 < 0) break;
                arrayList.add((Object)string7.substring(0, n4));
                string7 = string7.substring(n4 + 1);
            }
            if ((n3 = arrayList.size()) > 0) {
                this.setOIDAttrNames((String[])arrayList.toArray((Object[])new String[n3]));
            }
        }
        this.readObjectType(defElement);
        this.loadPrecisionValidator(defElement);
        this.loadProperties(defElement);
        if (bl7) {
            ((EntityDefImpl)rowDef).setChangeIndicatorColumn(this);
        }
        this.setHistoryKind(by3);
        String string8 = defElement.readString("Expression");
        if (string8 != null) {
            this.setAttributeKind((byte)1);
            this.setColumnName(string8);
        }
        this.setSessionScope(bl);
        defElement = null;
        if (bl2 && bl4) {
            this.checkForBatchUpdate();
        }
    }

    final void checkForBatchUpdate() {
        if (this.mPrimaryKey && (this.mRetrievedOnInsert || this.mRetrievedOnUpdate) && ((EntityDefImpl)this.mDef).mBatchThreshold > 0) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("*** WARNING : BatchThreshold Reset to 0 as key attribute:" + this.getName() + " with Refresh-On-Insert or Update property.");
                Diagnostic.println("*** Entity definition name :" + this.mDef.getName());
            }
            ((EntityDefImpl)this.mDef).mBatchThreshold = 0;
        }
    }

    void loadUserDefinedAttr(DefElement defElement, RowDef rowDef, int n) {
        this.setName(defElement.readString("Name").intern());
        this.setDef(rowDef);
        this.setParent(rowDef);
        this.setUpdateableFlag(AttributeDefImpl.convertUpdateableStringToFlag(defElement.readString("IsUpdateable")));
        this.setSessionScope(defElement.readBoolean("IsSessionScope"));
        this.setPrimaryKey(defElement.readBoolean("PrimaryKey"));
        this.setDiscrColumn(defElement.readBoolean("DiscrColumn"));
        this.setRetrievedOnInsert(defElement.readBoolean("RetrievedOnInsert"));
        this.setRetrievedOnUpdate(defElement.readBoolean("RetrievedOnUpdate"));
        this.setMandatory(defElement.readBoolean("IsNotNull"));
        this.setIndex(n);
        String string = defElement.readString("Type");
        Class clazz = string != null ? JBOClass.findDataClass(string) : null;
        this.setJavaType(clazz);
        string = defElement.readString("ElemType");
        clazz = string != null ? JBOClass.findDataClass(string) : null;
        this.setElemType(clazz);
        this.setAttrLoad(AttributeDefImpl.convertAttrLoadStringToEnum(defElement.readString("AttrLoad")));
        this.setDefaultValue(this.convertToJava(defElement.readString("DefaultValue")));
        this.setAttributeKind(defElement.readBoolean("IsPersistent") ? (byte)0 : 3);
        String string2 = defElement.readString("SQLType");
        String string3 = defElement.readString("Expression");
        if (string3 != null) {
            if (string2 == null) {
                throw new PersistenceException("26011", new String[]{this.mName});
            }
            this.setAttributeKind((byte)1);
            this.setColumnName(string3);
        } else {
            this.setAttributeKind((byte)3);
        }
        this.setSQLType(AttributeDefImpl.getSQLTypeStringToId(string2));
        switch (this.getSQLType()) {
            case 0: 
            case 1: {
                this.mType = 12;
            }
        }
        this.setSelected(defElement.readBoolean("IsSelected"));
        this.setQueriable(defElement.readBoolean("IsQueriable"));
        this.readObjectType(defElement);
        this.loadPrecisionValidator(defElement);
        this.loadProperties(defElement);
    }

    protected void loadProperties(DefElement defElement) {
        RowDef rowDef = (RowDef)this.getDef().getBaseDefObject();
        if (rowDef == null) {
            this.mProperties = defElement.loadPropertiesMap();
        } else {
            AttributeDefImpl attributeDefImpl = (AttributeDefImpl)rowDef.lookupAttributeDef(this.getName());
            if (attributeDefImpl != null) {
                this.mProperties = (HashMap)((NamedObjectImpl)attributeDefImpl).getPropertiesMap().clone();
                HashMap hashMap = defElement.loadPropertiesMap();
                if (hashMap != null) {
                    this.mProperties.putAll((Map)hashMap);
                }
            } else {
                this.mProperties = defElement.loadPropertiesMap();
            }
        }
    }

    void loadAttributeCustomizations(DefElement defElement, AttributeDefImpl attributeDefImpl) {
        String string = defElement.readString("DefaultValue");
        if (string != null) {
            try {
                this.mDefaultValue = this.convertToJava(string);
            }
            catch (DataCreationException dataCreationException) {
                // empty catch block
            }
        }
        if (this.mDef instanceof EntityDefImpl) {
            ArrayList arrayList;
            ((EntityDefImpl)this.mDef).loadValidators(defElement, this, true);
            if (attributeDefImpl != null && (arrayList = attributeDefImpl.getVetoableChangeListener()) != null && arrayList.size() > 0) {
                int n = 0;
                while (n < arrayList.size()) {
                    this.getVetoableChangeListener().add(arrayList.get(n));
                    ++n;
                }
            }
        }
    }

    public static int getSQLTypeStringToId(String string) {
        if (string != null) {
            return JboTypeMap.sqlTypeToSQLTypeId(string);
        }
        return 0;
    }

    public static String getSQLTypeIdToString(int n) {
        String string = JboTypeMap.sqlTypeIdToSQLType(n);
        if (string == null) {
            return "UNKNOWN_SQLTYPE_" + n;
        }
        return string;
    }

    public HashMap getPropertiesMap() {
        HashMap hashMap;
        HashMap hashMap2;
        DomainDefImpl domainDefImpl;
        HashMap hashMap3;
        HashMap hashMap4 = new HashMap(20);
        if (this.mDomainName != null && (hashMap3 = (domainDefImpl = DomainDefImpl.findDefObject(this.mDomainName)).getPropertiesMap()) != null) {
            hashMap4.putAll((Map)hashMap3);
        }
        if (this.getBaseDefObject() != null && (hashMap2 = this.getBaseDefObject().getPropertiesMap()) != null) {
            hashMap4.putAll((Map)hashMap2);
        }
        if ((hashMap = super.getPropertiesMap()) != null) {
            hashMap4.putAll((Map)hashMap);
        }
        return hashMap4;
    }

    void setDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    void unsetDefForComponent(ComponentObjectImpl componentObjectImpl) {
    }

    protected SQLBuilder getSQLBuilder() {
        if (this.mSQLBuilder == null) {
            this.mSQLBuilder = SQLBuilderFactory.create();
        }
        return this.mSQLBuilder;
    }

    public void storeToBean(Object object, Row row) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getField(this.getName());
            Object object2 = row.getAttribute(this.getIndex());
            field.set(object, TypeFactory.getInstance(field.getType(), object2));
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JboException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JboException(noSuchFieldException);
        }
    }

    public void beanToStore(Object object, Row row) {
        Class<?> clazz = object.getClass();
        try {
            Field field = clazz.getField(this.getName());
            Object object2 = field.get(object);
            row.setAttribute(this.getIndex(), object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new JboException(illegalAccessException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new JboException(noSuchFieldException);
        }
    }

    public String getXMLElementTag() {
        String string = (String)this.getProperty("XML_ELEMENT");
        return string != null ? string : this.getName();
    }

    Object getXMLContentValue(Element element, boolean bl) {
        Object object = null;
        String string = null;
        if (element != null && this.mXMLFactoryInit == 0) {
            if (this.mElemType == null) {
                byte[] byArray = new byte[]{1};
                this.mXMLDomainFactory = AttributeDefImpl.getXMLValueFactory(this.mJavaType, byArray);
                this.mXMLFactoryInit = byArray[0];
            } else {
                try {
                    Object[] objectArray = new Class[]{this.mElemType == null ? this.mJavaType : this.mElemType};
                    Class[] classArray = new Class[1];
                    Class clazz = class$java$lang$Class;
                    if (clazz == null) {
                        clazz = class$java$lang$Class = AttributeDefImpl.class$("java.lang.Class");
                    }
                    classArray[0] = clazz;
                    Method method = this.mJavaType.getMethod("getXMLDomainFactory", classArray);
                    this.mXMLDomainFactory = (XMLValueFactory)method.invoke(null, objectArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mXMLFactoryInit = (byte)(this.mXMLDomainFactory instanceof XMLDomainReaderFactory ? (this.mXMLDomainFactory instanceof XMLDomainFactory ? 4 : 3) : (this.mXMLDomainFactory instanceof XMLDomainFactory ? 2 : 1));
            }
        }
        if (!XML_NULL_ATTR_VAL.equalsIgnoreCase(element.getAttribute(XML_NULL_ATTR_TAG))) {
            if (this.mXMLDomainFactory == null || this.mXMLFactoryInit == 1) {
                Node node = JboXMLUtil.getFirstChildByType(element, (short)3);
                if (node == null) {
                    node = JboXMLUtil.getFirstChildByType(element, (short)4);
                }
                if (node != null) {
                    string = node.getNodeValue();
                    if (string != null) {
                        object = this.convertToJava(string);
                    }
                } else {
                    object = this.convertToJava("");
                }
            } else if (bl && this.mXMLFactoryInit > 3) {
                object = ((XMLDomainReaderFactory)this.mXMLDomainFactory).createDomainFromSerializedXML(element);
            } else if (this.mXMLFactoryInit == 2 || this.mXMLFactoryInit == 4) {
                object = ((XMLDomainFactory)this.mXMLDomainFactory).createDomainFromXMLElement(element);
            }
        }
        return object;
    }

    static Object getXMLContentValueForParam(String string, Element element, boolean bl) {
        try {
            Class clazz = JBOClass.forName(string);
            byte[] byArray = new byte[]{1};
            XMLValueFactory xMLValueFactory = AttributeDefImpl.getXMLValueFactory(clazz, byArray);
            if (byArray[0] == 1) {
                Object object = TypeFactory.getInstance(clazz, (Object)element.getFirstChild().getNodeValue());
                return object;
            }
            if (bl && byArray[0] > 3) {
                Object object = ((XMLDomainReaderFactory)xMLValueFactory).createDomainFromSerializedXML(element);
                return object;
            }
            if (byArray[0] == 2 || byArray[0] == 4) {
                DomainInterface domainInterface = ((XMLDomainFactory)xMLValueFactory).createDomainFromXMLElement((Element)element.getFirstChild());
                return domainInterface;
            }
            Object object = TypeFactory.getInstance(clazz, (Object)element.getFirstChild().getNodeValue());
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Warning! Ignoring following exception during parameter activation.");
                Diagnostic.println(classNotFoundException.getMessage());
            }
            String string2 = element.getFirstChild().getNodeValue();
            return string2;
        }
    }

    static XMLValueFactory getXMLValueFactory(Class clazz) {
        return AttributeDefImpl.getXMLValueFactory(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XMLValueFactory getXMLValueFactory(Class clazz, byte[] byArray) {
        Object object;
        if (xmlFactoryMap == null) {
            String string = XML_NULL_ATTR_TAG;
            synchronized (string) {
                xmlFactoryMap = new WeakHashtable();
                ArrayList arrayList = JboTypeMap.getDomainsWithNoXMLFactory();
                if (arrayList != null) {
                    int n = 0;
                    while (n < arrayList.size()) {
                        xmlFactoryMap.put(arrayList.get(n), XML_NULL_ATTR_TAG);
                        ++n;
                    }
                }
            }
        }
        if ((object = xmlFactoryMap.get(clazz)) != null) {
            if (object == XML_NULL_ATTR_TAG) {
                return null;
            }
            if (byArray != null) {
                byArray[0] = ((1FacObj)object).facType;
            }
            return ((1FacObj)object).xmlFac;
        }
        int n = 1;
        XMLValueFactory xMLValueFactory = null;
        if (!clazz.getName().startsWith("java.")) {
            block19: {
                Object[] objectArray = new Class[]{clazz};
                try {
                    Method method;
                    Class[] classArray = new Class[1];
                    Class clazz2 = class$java$lang$Class;
                    if (clazz2 == null) {
                        clazz2 = classArray[0] = (class$java$lang$Class = AttributeDefImpl.class$("java.lang.Class"));
                    }
                    n = (xMLValueFactory = (XMLValueFactory)(method = clazz.getMethod("getXMLDomainFactory", classArray)).invoke(null, objectArray)) instanceof XMLDomainReaderFactory ? (xMLValueFactory instanceof XMLDomainFactory ? 4 : 3) : (xMLValueFactory instanceof XMLDomainFactory ? 2 : 1);
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block19;
                    Diagnostic.println("Warning! Ignoring following exception getXMLDomainFactory.");
                    Diagnostic.println(exception.getMessage());
                }
            }
            String string = XML_NULL_ATTR_TAG;
            synchronized (string) {
                if (n != 1) {
                    xmlFactoryMap.put(clazz, new 1FacObj(xMLValueFactory, (byte)n));
                } else {
                    xmlFactoryMap.put(clazz, XML_NULL_ATTR_TAG);
                }
            }
            if (byArray != null) {
                byArray[0] = n;
            }
        }
        return xMLValueFactory;
    }

    protected String printXMLDefinition(Row row, Hashtable hashtable, PrintWriter printWriter, int n) {
        String string = this.getXMLElementTag();
        if (string.equals("#hide")) {
            return null;
        }
        if (hashtable.get(string) == null) {
            switch (this.mKind) {
                case 2: {
                    if (n > 0) {
                        RowImpl rowImpl = (RowImpl)row.getAttribute(this.mIndex);
                        String string2 = rowImpl.printXMLDefinition(hashtable, printWriter, n);
                        printWriter.println("<!ELEMENT " + string + " (" + string2 + "+)>");
                        hashtable.put(string, string);
                        string = string + "?";
                        break;
                    }
                    string = null;
                    break;
                }
                case 6: {
                    if (n > 0) {
                        String string3;
                        if (this.mKind == 6) {
                            RowSetImpl rowSetImpl = (RowSetImpl)row.getAttribute(this.mIndex);
                            string3 = rowSetImpl.printXMLDefinition(hashtable, printWriter, n);
                        } else {
                            string3 = ((ViewRowImpl)row.getAttribute(this.mIndex)).printXMLDefinition(hashtable, printWriter, n);
                        }
                        printWriter.println("<!ELEMENT " + string + " (" + string3 + "+)>");
                        hashtable.put(string, string);
                        string = string + "?";
                        break;
                    }
                    string = null;
                    break;
                }
                default: {
                    string = DomainAttributeDef.printAttrXMLDefinition(row, string, this, hashtable, printWriter, n > 0);
                }
            }
        }
        return string;
    }

    private void readObjectType(DefElement defElement) {
        this.mObjectType = defElement.readString("ColumnType");
        if (this.mObjectType != null && this.mObjectType.startsWith("REF ")) {
            this.mObjectType = this.mObjectType.substring(4);
        }
    }

    private String getColumnType() {
        return this.getObjectType();
    }

    public AttributeHints getUIHelper() {
        return this;
    }

    public String getLocaleName(LocaleContext localeContext, String string) {
        return JboNameUtil.getLocaleName(localeContext, string);
    }

    final String resolveResourceProperty(String string, LocaleContext localeContext) {
        String string2;
        String string3 = null;
        HashMap hashMap = this.getPropertiesMap();
        string3 = (String)hashMap.get((Object)(string2 = this.getLocaleName(localeContext, string)));
        if (string3 == null && !hashMap.containsKey((Object)string2)) {
            string3 = (String)hashMap.get((Object)string);
            if (string3 == null) {
                string3 = this.getStringFromMessageBundle(string, localeContext);
            }
            this.setProperty(string2, string3);
        }
        return string3;
    }

    public final String getLabel(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("LABEL", localeContext);
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public final String getTooltip(LocaleContext localeContext) {
        return this.resolveResourceProperty("TOOLTIP", localeContext);
    }

    public final String getDisplayHint(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYHINT", localeContext);
        if (string == null) {
            string = "Display";
        }
        return string;
    }

    public final int getControlType(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("CONTROLTYPE", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 100;
    }

    public final int getDisplayWidth(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYWIDTH", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return this.getPrecision();
    }

    public final int getDisplayHeight(LocaleContext localeContext) {
        String string = this.resolveResourceProperty("DISPLAYHEIGHT", localeContext);
        if (string != null) {
            return Integer.parseInt(string);
        }
        return 1;
    }

    public String getHint(LocaleContext localeContext, String string) {
        if (string.equals("LABEL")) {
            return this.getLabel(localeContext);
        }
        if (string.equals("TOOLTIP")) {
            return this.getTooltip(localeContext);
        }
        if (string.equals("DISPLAYWIDTH")) {
            return Integer.toString(this.getDisplayWidth(localeContext));
        }
        if (string.equals("DISPLAYHEIGHT")) {
            return Integer.toString(this.getDisplayHeight(localeContext));
        }
        if (string.equals("CONTROLTYPE")) {
            return Integer.toString(this.getControlType(localeContext));
        }
        if (string.equals("DISPLAYHINT")) {
            return this.getDisplayHint(localeContext);
        }
        return this.resolveResourceProperty(string, localeContext);
    }

    public String getHintValue(LocaleContext localeContext, String string) {
        return this.resolveResourceProperty(string, localeContext);
    }

    public final String getFormat(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        String string = this.resolveResourceProperty("FMT_FORMAT", localeContext);
        if (string == null) {
            string = this.getFormatter(localeContext).getDefaultFormatString();
        }
        return string;
    }

    public final Formatter getFormatter(LocaleContext localeContext) {
        if (!this.hasFormatInformation(localeContext)) {
            return null;
        }
        return FormatterFactory.getFormatter((String)this.getFormatterClassName(localeContext), (LocaleContext)localeContext);
    }

    public final boolean hasFormatInformation(LocaleContext localeContext) {
        if (this.mHasFormatInfo == -1) {
            String string = this.getFormatterClassName(localeContext);
            this.mHasFormatInfo = string == null || string.equals("") ? (byte)0 : 1;
        }
        return this.mHasFormatInfo == 1;
    }

    public final String getFormattedAttribute(AttributeList attributeList, LocaleContext localeContext) {
        Object object = attributeList.getAttribute(this.getIndex());
        if (object == null) {
            return null;
        }
        if ("".equals(object)) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return object.toString();
        }
        try {
            String string;
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            String string3 = string = formatter.format(string2, object);
            return string3;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public final Object parseFormattedAttribute(String string, LocaleContext localeContext) {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return "";
        }
        if (!this.hasFormatInformation(localeContext)) {
            return string;
        }
        try {
            Formatter formatter = this.getFormatter(localeContext);
            String string2 = this.getFormat(localeContext);
            formatter.setLocale(localeContext);
            Object object = formatter.parse(string2, string);
            if (object == null) {
                String string3 = string;
                return string3;
            }
            Object object2 = this.convertToJava(object);
            return object2;
        }
        catch (ParseException parseException) {
            String string4 = string;
            return string4;
        }
        catch (Exception exception) {
            throw new JboException(exception);
        }
    }

    public final boolean displayInShortForm(LocaleContext localeContext) {
        return "Summary".equals(this.resolveResourceProperty("FORMTYPE", localeContext));
    }

    public final String getFormatterClassName(LocaleContext localeContext) {
        return this.resolveResourceProperty("FMT_FORMATTER", localeContext);
    }

    String getStringFromMessageBundle(String string, LocaleContext localeContext) {
        Class clazz = null;
        if (this.getDef() != null) {
            clazz = this.getDef().getMessageBundleClass();
        }
        String string2 = null;
        if (clazz != null) {
            AttributeDefImpl attributeDefImpl;
            String string3 = this.getName() + "_" + string;
            string2 = StringManager.getLocalizedString(clazz.getName(), string3, null, localeContext != null ? localeContext.getLocale() : null, false);
            if (string2 == null && (attributeDefImpl = (AttributeDefImpl)this.getBaseDefObject()) != null) {
                string2 = attributeDefImpl.getStringFromMessageBundle(string, localeContext);
            }
        }
        return string2;
    }

    public HashMap getHintsFromResource(LocaleContext localeContext) {
        Class clazz;
        EntityDefImpl entityDefImpl = this.getEntityDef();
        if (entityDefImpl != null && (clazz = entityDefImpl.getMessageBundleClass()) != null) {
            return this.loadAllResForAttr(clazz.getName(), localeContext);
        }
        return null;
    }

    HashMap loadAllResForAttr(String string, LocaleContext localeContext) {
        Enumeration<String> enumeration = null;
        try {
            ResourceBundle resourceBundle = JBOClass.loadResourceBundle(string, localeContext.getLocale());
            enumeration = resourceBundle.getKeys();
            if (enumeration != null) {
                String string2 = this.getName();
                HashMap hashMap = new HashMap(8);
                while (enumeration.hasMoreElements()) {
                    String string3;
                    String string4 = enumeration.nextElement();
                    if (string4 == null || (string3 = string4.toString()).indexOf(string2) != 0) continue;
                    hashMap.put((Object)string3, (Object)resourceBundle.getString(string3));
                }
                if (hashMap.size() > 0) {
                    HashMap hashMap2 = hashMap;
                    return hashMap2;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public byte getHistoryKind() {
        return this.mHistoryKind;
    }

    Object getHistoryContext(EntityImpl entityImpl, DBTransaction dBTransaction) {
        Object object = null;
        switch (this.mHistoryKind) {
            case 1: 
            case 2: {
                object = this.convertToJava(entityImpl.getEntityCache().getCurrentDbTime());
                break;
            }
            case 3: 
            case 4: {
                object = this.convertToJava(((SessionImpl)((DBTransactionImpl)dBTransaction).getSession()).getUserPrincipalName());
                break;
            }
            case 5: {
                object = this.getNextValueForHistoryVerison(entityImpl.getAttributeInternal(this.mIndex));
            }
        }
        return object;
    }

    void setHistoryKind(byte by) {
        this.mHistoryKind = by;
    }

    boolean isHistoryColumn() {
        return this.mHistoryKind != 0;
    }

    static byte convertHistoryColumnStringToFlag(String string, byte by) {
        if (by == 0) {
            return 0;
        }
        if (string != null) {
            if (string.equals("DateHistory")) {
                return by == 1 ? (byte)1 : 2;
            }
            if (string.equals("UserHistory")) {
                return by == 1 ? (byte)3 : 4;
            }
            if (string.equals("VersionHistory")) {
                return 5;
            }
        }
        return 0;
    }

    Object getNextValueForHistoryVerison(Object object) {
        if (object == null) {
            object = this.convertToJava(new Long(1L));
        } else {
            Class clazz = class$java$lang$Long;
            if (clazz == null) {
                clazz = class$java$lang$Long = AttributeDefImpl.class$("java.lang.Long");
            }
            Long l = (Long)TypeFactory.getInstance(clazz, object);
            object = this.convertToJava(new Long(l + 1L));
        }
        return object;
    }

    void setCascadeUpdateParticipant(boolean bl) {
        this.mCascadeUpdateParticipant = bl;
    }

    protected final boolean isCascadeUpdateParticipant() {
        return this.mCascadeUpdateParticipant;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class 1FacObj {
        byte facType;
        XMLValueFactory xmlFac;

        1FacObj(XMLValueFactory xMLValueFactory, byte by) {
            this.xmlFac = xMLValueFactory;
            this.facType = by;
        }
    }
}

