/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.rules;

import oracle.jbo.AttributeDef;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.StructureDef;
import oracle.jbo.rules.AbstractValidator;
import oracle.jbo.rules.JboValidatorContext;
import oracle.jbo.rules.RulesBeanUtils;

public abstract class JboAbstractValidator
extends AbstractValidator {
    protected AttributeDef mValidatingAttr;
    protected String mValidatingAttrName;
    boolean mInit;

    private /* synthetic */ void $init$() {
        this.mInit = false;
    }

    protected void initialize(JboValidatorContext jboValidatorContext) {
        if (this.mValidatingAttr == null) {
            if (this.mValidatingAttrName != null) {
                AttributeDef attributeDef = jboValidatorContext.getAttributeDef();
                if (attributeDef != null && this.mValidatingAttrName.equals(attributeDef.getName())) {
                    this.mValidatingAttr = attributeDef;
                } else {
                    StructureDef structureDef = ((Row)jboValidatorContext.getSource()).getStructureDef();
                    this.mValidatingAttr = structureDef.findAttributeDef(this.mValidatingAttrName);
                }
            } else {
                this.mValidatingAttr = jboValidatorContext.getAttributeDef();
            }
            this.mInit = true;
        }
    }

    public abstract boolean validateValue(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(JboValidatorContext jboValidatorContext) {
        boolean bl = false;
        try {
            Object object;
            Object object2 = jboValidatorContext.getSource();
            if (!this.mInit) {
                JboAbstractValidator jboAbstractValidator = this;
                synchronized (jboAbstractValidator) {
                    this.initialize(jboValidatorContext);
                }
            }
            if (this.mValidatingAttr != null && !this.mValidatingAttr.getName().equals(jboValidatorContext.getAttributeName()) && object2 instanceof Row) {
                object = ((Row)object2).getAttribute(this.mValidatingAttr.getIndex());
                this.setNewValue(object);
            } else {
                object = jboValidatorContext.getNewValue();
                this.setNewValue(object);
            }
            bl = this.validateValue(object);
            if (this.mbInverse == bl) {
                this.raiseException(null, jboValidatorContext);
            }
        }
        catch (JboException jboException) {
            if (this.mbInverse == bl) {
                if (jboValidatorContext.getSourceType() == 111) {
                    jboException.setNeedsEntityToVOMapping(false);
                }
                throw jboException;
            }
        }
        catch (Exception exception) {
            this.raiseException(exception, jboValidatorContext);
        }
    }

    void raiseException(Exception exception, JboValidatorContext jboValidatorContext) {
        RulesBeanUtils.raiseException(this.getErrorMessageClass(), this.getErrorMsgId(), jboValidatorContext.getSource(), jboValidatorContext.getSourceType(), jboValidatorContext.getSourceFullName(), this.mValidatingAttr, this.getValueToValidate(jboValidatorContext), null, exception);
    }

    protected void setNewValue(Object object) throws Exception {
    }

    protected Object getValueToValidate(JboValidatorContext jboValidatorContext) {
        Object object = jboValidatorContext.getSource();
        if (this.mValidatingAttr != null && !this.mValidatingAttr.getName().equals(jboValidatorContext.getAttributeName())) {
            return ((Row)object).getAttribute(this.mValidatingAttr.getIndex());
        }
        return jboValidatorContext.getNewValue();
    }

    public void setValidatingAttributeName(String string) {
        this.mValidatingAttrName = string;
    }

    public void setValidatingAttribute(AttributeDef attributeDef) {
        this.mValidatingAttr = attributeDef;
    }

    public void setValidatingAttribute(StructureDef structureDef, String string) {
        this.mValidatingAttr = structureDef.findAttributeDef(string);
    }

    public String getValidatingAttributeName() {
        return this.mValidatingAttr != null ? this.mValidatingAttr.getName() : this.mValidatingAttrName;
    }

    public JboAbstractValidator() {
        this.$init$();
    }
}

