/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.pcoll;

import com.sun.java.util.collections.ArrayList;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import oracle.jbo.PCollException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.pcoll.PCollKeyInfo;
import oracle.jbo.pcoll.PCollManager;
import oracle.jbo.pcoll.PCollNode;
import oracle.jbo.pcoll.PCollection;
import oracle.jbo.pcoll.PersistManager;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.BLOB;

public class OraclePersistManager
implements PersistManager {
    private PCollManager mPCollManager;
    private boolean mTableCreated;
    private boolean mKeyInfoTableCreated;
    private int mNumPendingOps;
    private String mTableName;
    private String mTxnSeqName;
    private final String mControlTableName;
    private String mKeyInfoTableName;
    private int mCommitThreshhold;
    boolean mPersistent;
    private boolean mControlTabCreated;
    private static final long TIME_LIM_FOR_RETIRING_CNTL_ROW = 60000L;
    private static final long TIME_LIM_FOR_LOCKING_CNTL_ROW = 10000L;
    private static final int SQL_ERROR_LOCK_CONFLICT = 54;
    private static final int SQL_ERROR_TABLE_ALREADY_EXISTS = 955;
    private static final int SQL_ERROR_TABLE_DOES_NOT_EXIST = 942;
    private static final int SQL_ERROR_INVALID_LOB_LOCATOR = 22275;
    private long mSequenceIncrementSize;
    private static long mSequenceBase = -1;
    private static long mSequenceIncrementCount = -1;
    private static final Object mStaticLock = new Object();
    public static final boolean mDebugOn = true;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mPCollManager = null;
        this.mTableCreated = false;
        this.mKeyInfoTableCreated = false;
        this.mNumPendingOps = 0;
        this.mTableName = null;
        this.mTxnSeqName = null;
        this.mKeyInfoTableName = null;
        this.mCommitThreshhold = 10;
        this.mPersistent = false;
        this.mControlTabCreated = false;
        this.mSequenceIncrementSize = -1;
    }

    public OraclePersistManager() {
        this.$init$();
        String string = PropertyMetadata.ENV_CONTROL_TABLE_NAME.getProperty();
        this.mControlTableName = string == null || string.length() <= 0 ? PropertyMetadata.ENV_CONTROL_TABLE_NAME.pDefault : string;
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int n) {
        block4: {
            Connection connection = this.mPCollManager.getConnection();
            if (connection != null) {
                try {
                    connection.rollback();
                    if (this.mTableCreated && !this.mPersistent && (n & 1) == 0) {
                        this.dropTable();
                        this.deleteControlRow(this.mTableName);
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block4;
                    Diagnostic.printStackTrace(exception);
                }
            }
        }
    }

    public int getMaxTabNameLength() {
        return 30 - "_seq".length();
    }

    public void setPCollManager(PCollManager pCollManager) {
        this.mPCollManager = pCollManager;
    }

    public synchronized Connection getConnection() {
        return this.mPCollManager.ensureConnection();
    }

    public void setTableName(String string) {
        this.mTableName = string;
    }

    public void setCommitThreshhold(int n) {
        if (n <= 1) {
            n = 1;
        }
        this.mCommitThreshhold = n;
    }

    public void setPersistent(boolean bl) {
        this.mPersistent = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableCreated(boolean bl) {
        OraclePersistManager oraclePersistManager = this;
        synchronized (oraclePersistManager) {
            this.mTableCreated = bl;
        }
    }

    static void closeStmt(Statement statement) {
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    static void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized void commit() {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**commit** #pending ops=" + this.mNumPendingOps);
        }
        if (!this.mPersistent) {
            this.updateControlRow(this.mTableName, "updatedate");
        }
        try {
            this.getConnection().commit();
        }
        catch (SQLException sQLException) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
            }
            PCollException.throwException(clazz, "28007", new Object[]{this.mTableName}, sQLException);
        }
        this.mNumPendingOps = 0;
        this.waitForTableName(this.mTableName);
    }

    synchronized void commitIfNeeded() {
        if (++this.mNumPendingOps >= this.mCommitThreshhold) {
            this.commit();
        }
    }

    void setTxnSeqName(String string) {
        this.mTxnSeqName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createControlTable() {
        if (this.mControlTabCreated) return;
        if (this.mPersistent) {
            return;
        }
        OraclePersistManager oraclePersistManager = this;
        synchronized (oraclePersistManager) {
            block29: {
                Statement statement;
                block27: {
                    ResultSet resultSet;
                    block24: {
                        block25: {
                            if (this.mControlTabCreated) {
                                return;
                            }
                            this.mPCollManager.resolveName();
                            if (this.mControlTabCreated) {
                                return;
                            }
                            statement = null;
                            resultSet = null;
                            try {
                                try {
                                    statement = this.getConnection().createStatement();
                                    resultSet = statement.executeQuery("select * from " + this.mControlTableName + " where 1 = 2");
                                    int n = resultSet.getMetaData().getColumnType(2);
                                    if (n == 2) {
                                        OraclePersistManager.closeResultSet(resultSet);
                                        resultSet = null;
                                        statement.executeUpdate("drop table " + this.mControlTableName + " cascade constraints");
                                        this.getConnection().commit();
                                        break block24;
                                    }
                                    this.mControlTabCreated = true;
                                    Object var10_5 = null;
                                    if (resultSet == null) break block25;
                                }
                                catch (SQLException sQLException) {
                                    Object var10_7 = null;
                                    if (resultSet != null) {
                                        OraclePersistManager.closeResultSet(resultSet);
                                        resultSet = null;
                                    }
                                    if (statement != null) {
                                        OraclePersistManager.closeStmt(statement);
                                        statement = null;
                                    }
                                    break block27;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var10_8 = null;
                                if (resultSet != null) {
                                    OraclePersistManager.closeResultSet(resultSet);
                                    resultSet = null;
                                }
                                if (statement == null) throw throwable;
                                OraclePersistManager.closeStmt(statement);
                                statement = null;
                                throw throwable;
                            }
                            OraclePersistManager.closeResultSet(resultSet);
                            resultSet = null;
                        }
                        if (statement == null) return;
                        OraclePersistManager.closeStmt(statement);
                        return;
                    }
                    Object var10_6 = null;
                    if (resultSet != null) {
                        OraclePersistManager.closeResultSet(resultSet);
                        resultSet = null;
                    }
                    if (statement != null) {
                        OraclePersistManager.closeStmt(statement);
                        statement = null;
                    }
                }
                try {
                    block28: {
                        try {
                            statement = this.getConnection().createStatement();
                            String string = "create table " + this.mControlTableName + "(tabname varchar2(128), rowcreatedate date, createdate date, updatedate date, " + "constraint " + this.mControlTableName + "_pk primary key (tabname))";
                            statement.execute(string);
                            if (!Diagnostic.isOn()) break block28;
                            Diagnostic.println("**createControlTable** tabname=" + this.mControlTableName + " created");
                        }
                        catch (SQLException sQLException) {
                            int n = sQLException.getErrorCode();
                            if (n != 955) {
                                Class clazz;
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("**createControlTable** unexpected table creation error");
                                    Diagnostic.printStackTrace(sQLException);
                                }
                                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                                }
                                PCollException.throwException(clazz, "28002", new Object[]{this.mControlTableName}, sQLException);
                            }
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**createControlTable** tabname=" + this.mControlTableName + " already exists");
                            }
                            Object var12_13 = null;
                            OraclePersistManager.closeStmt(statement);
                            statement = null;
                            break block29;
                        }
                    }
                    Object var12_12 = null;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    OraclePersistManager.closeStmt(statement);
                    statement = null;
                    throw throwable;
                }
                OraclePersistManager.closeStmt(statement);
                statement = null;
            }
            this.mControlTabCreated = true;
            return;
        }
    }

    void dropTable() {
        block16: {
            String string;
            Statement statement;
            block15: {
                block14: {
                    statement = null;
                    try {
                        statement = this.getConnection().createStatement();
                    }
                    catch (SQLException sQLException) {
                        Class clazz;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createStatement failed**");
                            Diagnostic.printStackTrace(sQLException);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                    }
                    string = null;
                    try {
                        string = "drop table \"" + this.mTableName + "\" cascade constraints";
                        statement.execute(string);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**dropTable** drop table, tabname=" + this.mTableName);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!Diagnostic.isOn()) break block14;
                        Diagnostic.println("**dropTable** drop table failed, tabname=" + this.mTableName);
                    }
                }
                String string2 = this.mTableName + "_ky";
                try {
                    string = "drop table \"" + string2 + "\" cascade constraints";
                    statement.execute(string);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**dropTable** drop table, tabname=" + string2);
                    }
                }
                catch (SQLException sQLException) {
                    if (!Diagnostic.isOn()) break block15;
                    Diagnostic.println("**dropTable** drop table failed, tabname=" + string2);
                }
            }
            string = null;
            if (this.mPersistent) {
                try {
                    string = this.mTxnSeqName != null ? "drop sequence " + this.mTxnSeqName : "drop sequence " + this.mTableName + "_seq";
                    statement.execute(string);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**dropTable** dropped sequence");
                    }
                }
                catch (SQLException sQLException) {
                    if (!Diagnostic.isOn()) break block16;
                    Diagnostic.println("**dropTable** drop sequence failed");
                }
            }
        }
        this.commit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createKeyInfoTable() {
        block27: {
            String string;
            Statement statement;
            block25: {
                if (this.mKeyInfoTableCreated) {
                    return;
                }
                statement = null;
                try {
                    statement = this.getConnection().createStatement();
                }
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createStatement failed**");
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                }
                string = null;
                try {
                    string = "alter table \"" + this.mTableName + "\" add (keycont blob)";
                    statement.execute(string);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createKeyInfoTable** added keycont col");
                    }
                }
                catch (SQLException sQLException) {
                    this.commit();
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createKeyInfoTable** add keycont failed, sqlStmt=" + string);
                        Diagnostic.printStackTrace(sQLException);
                    }
                    OraclePersistManager.closeStmt(statement);
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28012", new Object[]{"keycont", this.mTableName}, sQLException);
                }
                this.mKeyInfoTableName = this.mTableName + "_ky";
                try {
                    string = "drop table \"" + this.mKeyInfoTableName + "\" cascade constraints";
                    statement.execute(string);
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createKeyInfoTable** dropped key info table: " + this.mKeyInfoTableName);
                    }
                }
                catch (SQLException sQLException) {
                    if (!Diagnostic.isOn()) break block25;
                    Diagnostic.println("**createKeyInfoTable** drop table failed, tabname=" + this.mKeyInfoTableName);
                }
            }
            try {
                string = "create table \"" + this.mKeyInfoTableName + "\"(collid number(10), keyid number(20), keyhash number(20), id number(20))";
                statement.execute(string);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**createKeyInfoTable** created key info table: " + this.mKeyInfoTableName);
                }
            }
            catch (SQLException sQLException) {
                this.commit();
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**createKeyInfoTable** create table failed, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                OraclePersistManager.closeStmt(statement);
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28013", new Object[]{this.mKeyInfoTableName}, sQLException);
            }
            String string2 = null;
            string = null;
            try {
                block26: {
                    try {
                        string2 = this.mTableName + "_ki";
                        string = "create index \"" + string2 + "\" on \"" + this.mKeyInfoTableName + "\" (collid, keyid, keyhash)";
                        statement.execute(string);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createKeyInfoTable** created index, indexname=" + string2);
                        }
                        string2 = this.mTableName + "_kj";
                        string = "create index \"" + string2 + "\" on \"" + this.mKeyInfoTableName + "\" (collid, id)";
                        statement.execute(string);
                        if (!Diagnostic.isOn()) break block26;
                        Diagnostic.println("**createKeyInfoTable** created index, indexname=" + string2);
                    }
                    catch (SQLException sQLException) {
                        Class clazz;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createKeyInfoTable** create index failed, sqlStmt=" + string);
                            Diagnostic.printStackTrace(sQLException);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28008", new Object[]{string2, this.mTableName}, sQLException);
                        Object var10_9 = null;
                        this.commit();
                        OraclePersistManager.closeStmt(statement);
                        statement = null;
                        break block27;
                    }
                }
                Object var10_8 = null;
                this.commit();
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                this.commit();
                OraclePersistManager.closeStmt(statement);
                statement = null;
                throw throwable;
            }
            OraclePersistManager.closeStmt(statement);
            statement = null;
        }
        this.mKeyInfoTableCreated = true;
    }

    /*
     * Loose catch block
     */
    private boolean persistentObjectsExist() {
        boolean bl;
        block23: {
            ResultSet resultSet;
            Statement statement;
            block21: {
                bl = false;
                statement = null;
                resultSet = null;
                String string = null;
                try {
                    statement = this.getConnection().createStatement();
                    string = this.mTxnSeqName != null ? this.mTxnSeqName : this.mTableName + "_seq";
                }
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**createStatement failed**");
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                }
                StringBuffer stringBuffer = new StringBuffer("select ").append(string).append(".nextval from dual");
                statement.execute(stringBuffer.toString());
                stringBuffer = new StringBuffer("select 0 from ").append(this.mTableName).append(" where 0=1");
                statement.execute(stringBuffer.toString());
                bl = true;
                Object var11_7 = null;
                if (resultSet == null) break block21;
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
            break block23;
            {
                catch (SQLException sQLException) {
                    Object var11_8 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void createTable() {
        if (this.mTableCreated) return;
        OraclePersistManager oraclePersistManager = this;
        synchronized (oraclePersistManager) {
            block38: {
                String string;
                Statement statement;
                block36: {
                    if (this.mTableCreated) {
                        return;
                    }
                    this.createControlTable();
                    if (this.mPersistent && this.persistentObjectsExist()) {
                        this.mTableCreated = true;
                        return;
                    }
                    statement = null;
                    ResultSet resultSet = null;
                    try {
                        statement = this.getConnection().createStatement();
                    }
                    catch (SQLException sQLException) {
                        Class clazz;
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**createStatement failed**");
                            Diagnostic.printStackTrace(sQLException);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                    }
                    if (!this.mPersistent) {
                        this.dropTable();
                    }
                    string = null;
                    if (this.mPersistent) {
                        String string2 = null;
                        try {
                            try {
                                block34: {
                                    string2 = this.mTxnSeqName != null ? this.mTxnSeqName : this.mTableName + "_seq";
                                    StringBuffer stringBuffer = new StringBuffer("create sequence ").append(string2);
                                    if (this.mSequenceIncrementSize > 1L) {
                                        stringBuffer.append(" increment by ").append(this.mSequenceIncrementSize).toString();
                                    }
                                    string = stringBuffer.toString();
                                    boolean bl = false;
                                    statement.execute(string);
                                    if (Diagnostic.isOn()) {
                                        Diagnostic.println("**createTable** created sequence, seqName=" + string2);
                                    }
                                    try {
                                        long l;
                                        string = "select max(collid) from " + this.mTableName;
                                        resultSet = statement.executeQuery(string);
                                        if (!resultSet.next() || (l = resultSet.getLong(1)) <= 1L) break block34;
                                        string = "alter sequence " + string2 + " increment by " + l;
                                        statement.executeQuery(string);
                                        string = "select " + string2 + ".nextval from dual";
                                        statement.executeQuery(string);
                                        stringBuffer = new StringBuffer("alter sequence ").append(string2);
                                        if (this.mSequenceIncrementSize > 1L) {
                                            stringBuffer.append(" increment by ").append(this.mSequenceIncrementSize);
                                        }
                                        string = stringBuffer.toString();
                                        statement.executeQuery(string);
                                        if (Diagnostic.isOn()) {
                                            Diagnostic.println("**createTable** updated sequence start with " + l);
                                        }
                                    }
                                    catch (SQLException sQLException) {
                                        Class clazz;
                                        if (942 == sQLException.getErrorCode()) break block34;
                                        if (Diagnostic.isOn()) {
                                            Diagnostic.println("**createTable** update sequence error, sqlStmt=" + string);
                                            Diagnostic.printStackTrace(sQLException);
                                        }
                                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                            clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                                        }
                                        PCollException.throwException(clazz, "28006", new Object[]{string2}, sQLException);
                                    }
                                }
                                Object var15_11 = null;
                            }
                            catch (SQLException sQLException) {
                                if (955 != sQLException.getErrorCode()) {
                                    Class clazz;
                                    if (Diagnostic.isOn()) {
                                        Diagnostic.println("**createTable** created sequence error, sqlStmt=" + string);
                                        Diagnostic.printStackTrace(sQLException);
                                    }
                                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                                    }
                                    PCollException.throwException(clazz, "28006", new Object[]{string2}, sQLException);
                                }
                                Object var15_12 = null;
                                OraclePersistManager.closeResultSet(resultSet);
                                resultSet = null;
                                break block36;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var15_13 = null;
                            OraclePersistManager.closeResultSet(resultSet);
                            resultSet = null;
                            throw throwable;
                        }
                        OraclePersistManager.closeResultSet(resultSet);
                        resultSet = null;
                    }
                }
                try {
                    block37: {
                        try {
                            string = "create table \"" + this.mTableName + "\"(id number(20)" + ", parentid number(20)" + ", collid number(10), " + "content blob, " + (this.mPersistent ? "creation_date date DEFAULT sysdate, " : "") + "constraint " + this.mTableName + "_pk primary key (collid, id)) storage (maxextents unlimited)" + "lob (content) store as (enable storage in row chunk 4096 cache)";
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**createTable** create table stmt: " + string);
                            }
                            statement.execute(string);
                            if (!Diagnostic.isOn()) break block37;
                            Diagnostic.println("**createTable** created table, tabname=" + this.mTableName);
                        }
                        catch (SQLException sQLException) {
                            if (955 != sQLException.getErrorCode()) {
                                Class clazz;
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("**createTable** created table error, sqlStmt=" + string);
                                    Diagnostic.printStackTrace(sQLException);
                                }
                                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                                }
                                PCollException.throwException(clazz, "28006", new Object[]{this.mTableName}, sQLException);
                            }
                            Object var17_17 = null;
                            this.commit();
                            OraclePersistManager.closeStmt(statement);
                            statement = null;
                            break block38;
                        }
                    }
                    Object var17_16 = null;
                    this.commit();
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    this.commit();
                    OraclePersistManager.closeStmt(statement);
                    statement = null;
                    throw throwable;
                }
                OraclePersistManager.closeStmt(statement);
                statement = null;
            }
            this.mTableCreated = true;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Date getCurrentTimeFromDb() {
        Statement statement = null;
        ResultSet resultSet = null;
        Date date = null;
        String string = "select sysdate from dual";
        try {
            try {
                statement = this.getConnection().createStatement();
                resultSet = statement.executeQuery(string);
                if (!resultSet.next()) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28009", null, null);
                }
                date = (Date)resultSet.getObject(1);
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**getCurrentTimeFromDb** failed, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28009", null, sQLException);
                Object var7_6 = null;
                OraclePersistManager.closeResultSet(resultSet);
                resultSet = null;
                OraclePersistManager.closeStmt(statement);
                return date;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            OraclePersistManager.closeResultSet(resultSet);
            resultSet = null;
            OraclePersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        OraclePersistManager.closeResultSet(resultSet);
        resultSet = null;
        OraclePersistManager.closeStmt(statement);
        return date;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteControlRow(String string) {
        this.createControlTable();
        Statement statement = null;
        String string2 = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                string2 = "delete " + this.mControlTableName + " where tabname='" + string + "'";
                statement.executeUpdate(string2);
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**deleteControlRow** tabName=" + string + " delete error, sqlStmt=" + string2);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28003", new Object[]{string}, null);
                Object var6_5 = null;
                OraclePersistManager.closeStmt(statement);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OraclePersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt(statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void updateControlRow(String string, String string2) {
        this.createControlTable();
        Statement statement = null;
        String string3 = null;
        try {
            try {
                statement = this.getConnection().createStatement();
                string3 = "update " + this.mControlTableName + " set " + string2 + "=sysdate where tabname='" + string + "'";
                statement.executeUpdate(string3);
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**updateControlRow** tabName=" + string + ", " + string2 + " update error, sqlStmt=" + string3);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28005", new Object[]{string}, null);
                Object var7_6 = null;
                OraclePersistManager.closeStmt(statement);
                return;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            OraclePersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt(statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized long queryControlRow(String string, String string2) {
        this.createControlTable();
        Statement statement = null;
        String string3 = null;
        ResultSet resultSet = null;
        long l = -1;
        try {
            try {
                statement = this.getConnection().createStatement();
                string3 = "select " + string2 + " from " + this.mControlTableName + " where tabname='" + string + "'";
                resultSet = statement.executeQuery(string3);
                if (resultSet.next()) {
                    Date date = (Date)resultSet.getObject(1);
                    l = date.getTime();
                }
            }
            catch (SQLException sQLException) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**queryControlRow** tabName=" + string + ", " + string2 + " update error, sqlStmt=" + string3);
                    Diagnostic.printStackTrace(sQLException);
                }
                Object var11_9 = null;
                OraclePersistManager.closeResultSet(resultSet);
                resultSet = null;
                OraclePersistManager.closeStmt(statement);
                return l;
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            OraclePersistManager.closeResultSet(resultSet);
            resultSet = null;
            OraclePersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        OraclePersistManager.closeResultSet(resultSet);
        resultSet = null;
        OraclePersistManager.closeStmt(statement);
        return l;
    }

    public long getTableSignature(String string) {
        this.createControlTable();
        if (this.mPersistent) {
            return -1;
        }
        return this.queryControlRow(string, "updatedate");
    }

    public void init(int n) {
        if ((n & 1) > 0) {
            this.createControlTable();
            this.mTableCreated = true;
            this.mKeyInfoTableName = this.mTableName + "_ky";
            this.mKeyInfoTableCreated = true;
        } else {
            this.createTable();
        }
    }

    public boolean waitForTableName(String string) {
        long l = System.currentTimeMillis();
        do {
            if (!this.holdTableName(string, false)) continue;
            return true;
        } while (System.currentTimeMillis() - l <= 10000L);
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
        }
        PCollException.throwException(clazz, "28004", new Object[]{this.mTableName}, null);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean holdTableName(String string, boolean bl) {
        ResultSet resultSet;
        Statement statement;
        block21: {
            boolean bl2;
            block20: {
                boolean bl3;
                block19: {
                    this.createControlTable();
                    if (this.mPersistent) {
                        return true;
                    }
                    statement = null;
                    resultSet = null;
                    boolean bl4 = false;
                    try {
                        try {
                            String string2;
                            statement = this.getConnection().createStatement();
                            while (!(resultSet = statement.executeQuery(string2 = "select tabname, updatedate from " + this.mControlTableName + " where tabname='" + string + "' for update nowait")).next()) {
                                if (bl) {
                                    if (Diagnostic.isOn()) {
                                        Diagnostic.println("**holdTableName** tabName=" + string + " not found in controltab");
                                    }
                                    try {
                                        string2 = "insert into " + this.mControlTableName + " values ('" + string + "', sysdate, sysdate, sysdate)";
                                        statement.execute(string2);
                                        this.getConnection().commit();
                                        bl4 = true;
                                        if (!Diagnostic.isOn()) continue;
                                        Diagnostic.println("**holdTableName** tabName=" + string + " inserted into controltab");
                                        continue;
                                    }
                                    catch (SQLException sQLException) {
                                        if (Diagnostic.isOn()) {
                                            Diagnostic.println("**holdTableName** tabName=" + string + " insertion failed");
                                            Diagnostic.printStackTrace(sQLException);
                                        }
                                        boolean bl5 = false;
                                        Object var21_9 = null;
                                        OraclePersistManager.closeResultSet(resultSet);
                                        resultSet = null;
                                        OraclePersistManager.closeStmt(statement);
                                        return bl5;
                                    }
                                }
                                if (Diagnostic.isOn()) {
                                    Diagnostic.println("**holdTableName** tabName=" + string + " could not be located after commit");
                                }
                                bl3 = false;
                                Object var21_10 = null;
                                break block19;
                            }
                            if (!bl4 && bl) {
                                Date date = (Date)resultSet.getObject(2);
                                Date date2 = this.getCurrentTimeFromDb();
                                long l = date.getTime();
                                long l2 = date2.getTime();
                                if (l2 < l || l2 - l <= 60000L) {
                                    this.getConnection().commit();
                                    bl2 = false;
                                    break block20;
                                }
                                this.updateControlRow(string, "createdate");
                            }
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**holdTableName** tabName=" + string + " locked in controltab");
                            }
                            break block21;
                        }
                        catch (SQLException sQLException) {
                            Class clazz;
                            int n = sQLException.getErrorCode();
                            if (n == 54) {
                                if (bl && Diagnostic.isOn()) {
                                    Diagnostic.println("**holdTableName** tabName=" + string + " locked by someone else");
                                }
                                boolean bl6 = false;
                                Object var21_13 = null;
                                OraclePersistManager.closeResultSet(resultSet);
                                resultSet = null;
                                OraclePersistManager.closeStmt(statement);
                                return bl6;
                            }
                            if (Diagnostic.isOn()) {
                                Diagnostic.println("**holdTableName** tabName=" + string + " select error");
                                Diagnostic.printStackTrace(sQLException);
                            }
                            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                                clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                            }
                            PCollException.throwException(clazz, "28004", new Object[]{string}, sQLException);
                            Object var21_14 = null;
                            OraclePersistManager.closeResultSet(resultSet);
                            resultSet = null;
                            OraclePersistManager.closeStmt(statement);
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var21_15 = null;
                        OraclePersistManager.closeResultSet(resultSet);
                        resultSet = null;
                        OraclePersistManager.closeStmt(statement);
                        statement = null;
                        throw throwable;
                    }
                }
                OraclePersistManager.closeResultSet(resultSet);
                resultSet = null;
                OraclePersistManager.closeStmt(statement);
                return bl3;
            }
            Object var21_11 = null;
            OraclePersistManager.closeResultSet(resultSet);
            resultSet = null;
            OraclePersistManager.closeStmt(statement);
            return bl2;
        }
        Object var21_12 = null;
        OraclePersistManager.closeResultSet(resultSet);
        resultSet = null;
        OraclePersistManager.closeStmt(statement);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long queryNextCollectionId() {
        this.createTable();
        Statement statement = null;
        ResultSet resultSet = null;
        long l = 1L;
        String string = null;
        string = this.mPersistent && this.mTxnSeqName != null ? this.mTxnSeqName : this.mTableName + "_seq";
        String string2 = null;
        try {
            block14: {
                try {
                    string2 = "select " + string + ".nextval from dual";
                    if (this.mSequenceIncrementSize > 1L) {
                        Object object = mStaticLock;
                        synchronized (object) {
                            long l2 = -1;
                            boolean bl = false;
                            if (mSequenceIncrementCount >= this.mSequenceIncrementSize || mSequenceIncrementCount == (long)-1) {
                                statement = this.getConnection().createStatement();
                                resultSet = statement.executeQuery(string2);
                                if (resultSet.next()) {
                                    l2 = resultSet.getLong(1);
                                }
                                bl = true;
                            }
                            if (bl) {
                                mSequenceBase = l2;
                                mSequenceIncrementCount = 0L;
                            }
                            l = mSequenceBase + mSequenceIncrementCount;
                            ++mSequenceIncrementCount;
                            break block14;
                        }
                    }
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(string2);
                    if (resultSet.next()) {
                        l = resultSet.getLong(1);
                    }
                }
                catch (SQLException sQLException) {
                    Class clazz;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("**queryNextCollectionId** error, sqlStmt=" + string2);
                        Diagnostic.printStackTrace(sQLException);
                    }
                    if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28010", new Object[]{string}, sQLException);
                    Object var13_10 = null;
                    OraclePersistManager.closeResultSet(resultSet);
                    resultSet = null;
                    OraclePersistManager.closeStmt(statement);
                    return l;
                }
            }
            Object var13_9 = null;
        }
        catch (Throwable throwable) {
            Object var13_11 = null;
            OraclePersistManager.closeResultSet(resultSet);
            resultSet = null;
            OraclePersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        OraclePersistManager.closeResultSet(resultSet);
        resultSet = null;
        OraclePersistManager.closeStmt(statement);
        return l;
    }

    public long queryNextObjId(int n) {
        return this.queryNextId("id", true, " where collid=:1", n);
    }

    public long queryNextNodeId(int n) {
        return this.queryNextId("id", false, " where collid=:1", n);
    }

    long queryNextId(String string, boolean bl, String string2) {
        return this.queryNextId(string, bl, string2, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long queryNextId(String string, boolean bl, String string2, int n) {
        this.createTable();
        Statement statement = null;
        ResultSet resultSet = null;
        long l = 1L;
        String string3 = null;
        try {
            try {
                string3 = "select " + (bl ? "max(" : "min(") + string + ") from " + this.mTableName + string2;
                if (n == -1) {
                    statement = this.getConnection().createStatement();
                    resultSet = statement.executeQuery(string3);
                } else {
                    statement = this.getConnection().prepareStatement(string3);
                    OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)statement;
                    oraclePreparedStatement.setEscapeProcessing(false);
                    oraclePreparedStatement.setInt(1, n);
                    resultSet = oraclePreparedStatement.executeQuery();
                }
                if (resultSet.next()) {
                    l = resultSet.getLong(1);
                    l = bl ? (l <= 0L ? 1L : (l = l + 1L)) : (l >= 0L ? (long)-1 : (l = l - 1L));
                }
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**queryNextId** error, sqlStmt=" + string3);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28011", new Object[]{this.mTableName, string, new Integer(n)}, sQLException);
                Object var13_11 = null;
                OraclePersistManager.closeResultSet(resultSet);
                resultSet = null;
                OraclePersistManager.closeStmt(statement);
                return l;
            }
            Object var13_10 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            OraclePersistManager.closeResultSet(resultSet);
            resultSet = null;
            OraclePersistManager.closeStmt(statement);
            statement = null;
            throw throwable;
        }
        OraclePersistManager.closeResultSet(resultSet);
        resultSet = null;
        OraclePersistManager.closeStmt(statement);
        return l;
    }

    private PCollKeyInfo[] deserializeKeyArr(ObjectInputStream objectInputStream) throws Exception {
        int n = objectInputStream.readInt();
        PCollKeyInfo[] pCollKeyInfoArray = new PCollKeyInfo[n];
        int n2 = 0;
        while (n2 < n) {
            pCollKeyInfoArray[n2] = (PCollKeyInfo)objectInputStream.readObject();
            ++n2;
        }
        return pCollKeyInfoArray;
    }

    private byte[] serializeKeyArr(PCollKeyInfo[] pCollKeyInfoArray) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        byte[] byArray = null;
        try {
            objectOutputStream.writeInt(pCollKeyInfoArray.length);
            int n = 0;
            while (n < pCollKeyInfoArray.length) {
                objectOutputStream.writeObject(pCollKeyInfoArray[n]);
                ++n;
            }
            byteArrayOutputStream.flush();
            byArray = byteArrayOutputStream.toByteArray();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            PCollNode.closeOutputStream(objectOutputStream);
            objectOutputStream = null;
            PCollNode.closeOutputStream(byteArrayOutputStream);
            byteArrayOutputStream = null;
            throw throwable;
        }
        PCollNode.closeOutputStream(objectOutputStream);
        objectOutputStream = null;
        PCollNode.closeOutputStream(byteArrayOutputStream);
        byteArrayOutputStream = null;
        return byArray;
    }

    void updateBlobs(long l, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray, int n2, OracleCallableStatement oracleCallableStatement) throws Exception {
        int n3 = pCollKeyInfoArray == null ? 0 : pCollKeyInfoArray.length;
        OutputStream outputStream = null;
        try {
            BLOB bLOB = null;
            BLOB bLOB2 = oracleCallableStatement.getBLOB(n2++);
            outputStream = bLOB2.getBinaryOutputStream();
            outputStream.write(byArray);
            outputStream.close();
            outputStream = null;
            if (n3 > 0) {
                bLOB = oracleCallableStatement.getBLOB(n2++);
                outputStream = bLOB.getBinaryOutputStream();
                outputStream.write(this.serializeKeyArr(pCollKeyInfoArray));
                outputStream.close();
                outputStream = null;
            }
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            PCollNode.closeOutputStream(outputStream);
            outputStream = null;
            throw throwable;
        }
        PCollNode.closeOutputStream(outputStream);
        outputStream = null;
    }

    public void updateKeyInfo(long l, int n, PCollKeyInfo[] pCollKeyInfoArray) throws SQLException {
        if (!this.mKeyInfoTableCreated) {
            return;
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        String string = null;
        try {
            string = "delete \"" + this.mKeyInfoTableName + "\" where collid=:1";
            if (l != 0L) {
                string = string + " and id=:2";
            }
            oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
            oraclePreparedStatement.setEscapeProcessing(false);
            oraclePreparedStatement.setInt(1, n);
            if (l != 0L) {
                oraclePreparedStatement.setLong(2, l);
            }
            if (Diagnostic.isOn()) {
                Diagnostic.println("   stmt: " + string);
            }
            oraclePreparedStatement.execute();
            OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
            oraclePreparedStatement = null;
            string = "insert into \"" + this.mKeyInfoTableName + "\" values (:1, :2, :3, :4)";
            oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
            oraclePreparedStatement.setEscapeProcessing(false);
            if (Diagnostic.isOn()) {
                Diagnostic.println("   stmt: " + string);
            }
            if (pCollKeyInfoArray != null) {
                int n2 = 0;
                while (n2 < pCollKeyInfoArray.length) {
                    int n3 = pCollKeyInfoArray[n2].mKeyId;
                    Object object = pCollKeyInfoArray[n2].mKey;
                    if (object != null) {
                        int n4 = object.hashCode();
                        oraclePreparedStatement.setInt(1, n);
                        oraclePreparedStatement.setInt(2, n3);
                        oraclePreparedStatement.setInt(3, n4);
                        oraclePreparedStatement.setLong(4, l);
                        oraclePreparedStatement.execute();
                    }
                    ++n2;
                }
            }
            Object var12_10 = null;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            OraclePersistManager.closeStmt(oraclePreparedStatement);
            oraclePreparedStatement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
        oraclePreparedStatement = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void insert(long l, long l2, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**insert** id=" + l + ", parid=" + l2 + ", collid=" + n + ", keyArr.len=" + (pCollKeyInfoArray == null ? -1 : pCollKeyInfoArray.length) + ", cont.len=" + byArray.length);
        }
        int n2 = pCollKeyInfoArray == null ? 0 : pCollKeyInfoArray.length;
        this.createTable();
        if (n2 > 0) {
            this.createKeyInfoTable();
        }
        Object var9_7 = null;
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            try {
                int n3 = 1;
                string = "begin insert into \"" + this.mTableName + "\" values (:1, :2, :3, empty_blob()";
                if (this.mKeyInfoTableCreated) {
                    string = string + (n2 > 0 ? ", empty_blob()" : ", null");
                }
                string = string + (this.mPersistent ? ", sysdate" : "") + ") returning ";
                string = n2 > 0 ? string + "content, keycont into :4, :5; end;" : string + "content into :4; end;";
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall(string);
                oracleCallableStatement.setEscapeProcessing(false);
                oracleCallableStatement.setLong(n3++, l);
                oracleCallableStatement.setLong(n3++, l2);
                oracleCallableStatement.setInt(n3++, n);
                int n4 = n3;
                if (n2 > 0) {
                    oracleCallableStatement.registerOutParameter(n3++, 2004);
                }
                oracleCallableStatement.registerOutParameter(n3++, 2004);
                oracleCallableStatement.execute();
                string = null;
                this.updateBlobs(l, n, pCollKeyInfoArray, byArray, n4, oracleCallableStatement);
                this.updateKeyInfo(l, n, pCollKeyInfoArray);
                this.commitIfNeeded();
            }
            catch (Exception exception) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**insert** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(exception);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28030", new Object[]{this.mTableName, new Integer(n), new Long(l)}, exception);
                Object var16_13 = null;
                OraclePersistManager.closeStmt(oracleCallableStatement);
                oracleCallableStatement = null;
                OraclePersistManager.closeStmt(var9_7);
                return;
            }
            Object var16_12 = null;
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            OraclePersistManager.closeStmt(oracleCallableStatement);
            oracleCallableStatement = null;
            OraclePersistManager.closeStmt(var9_7);
            var9_7 = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt((Statement)oracleCallableStatement);
        oracleCallableStatement = null;
        OraclePersistManager.closeStmt(var9_7);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void update(long l, long l2, int n, PCollKeyInfo[] pCollKeyInfoArray, byte[] byArray) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**update** id=" + l + ", parid=" + l2 + ", collid=" + n + ", keyArr.len=" + (pCollKeyInfoArray == null ? -1 : pCollKeyInfoArray.length) + ", cont.len=" + byArray.length);
        }
        int n2 = pCollKeyInfoArray == null ? 0 : pCollKeyInfoArray.length;
        this.createTable();
        if (n2 > 0) {
            this.createKeyInfoTable();
        }
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            try {
                int n3 = 1;
                string = "begin update \"" + this.mTableName + "\" set content=empty_blob(), parentid=:1";
                string = n2 > 0 ? string + ", keycont=empty_blob() where collid=:2 and id=:3 returning content, keycont into :4, :5; end;" : string + " where collid=:2 and id=:3 returning content into :4; end;";
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                oracleCallableStatement = (OracleCallableStatement)this.getConnection().prepareCall(string);
                oracleCallableStatement.setEscapeProcessing(false);
                oracleCallableStatement.setLong(n3++, l2);
                oracleCallableStatement.setInt(n3++, n);
                oracleCallableStatement.setLong(n3++, l);
                int n4 = n3;
                if (n2 > 0) {
                    oracleCallableStatement.registerOutParameter(n3++, 2004);
                    oracleCallableStatement.registerOutParameter(n3++, 2004);
                } else {
                    oracleCallableStatement.registerOutParameter(n3++, 2004);
                }
                int n5 = oracleCallableStatement.executeUpdate();
                if (n5 != 1) {
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28041", new Object[]{this.mTableName, new Integer(n), new Long(l)}, null);
                }
                string = null;
                try {
                    this.updateBlobs(l, n, pCollKeyInfoArray, byArray, n4, oracleCallableStatement);
                }
                catch (SQLException sQLException) {
                    int n6 = sQLException.getErrorCode();
                    if (n6 != 22275) {
                        throw sQLException;
                    }
                    Class clazz = class$oracle$jbo$CSMessageBundle;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                    }
                    PCollException.throwException(clazz, "28041", new Object[]{this.mTableName, new Integer(n), new Long(l)}, sQLException);
                }
                this.updateKeyInfo(l, n, pCollKeyInfoArray);
                this.commitIfNeeded();
            }
            catch (Exception exception) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**update** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(exception);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28031", new Object[]{this.mTableName, new Integer(n), new Long(l)}, exception);
                Object var18_15 = null;
                OraclePersistManager.closeStmt((Statement)oracleCallableStatement);
                return;
            }
            Object var18_14 = null;
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            OraclePersistManager.closeStmt(oracleCallableStatement);
            oracleCallableStatement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt((Statement)oracleCallableStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void changeParent(long l, long l2, int n) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**changeParent** id=" + l + ", parid=" + l2 + ", collid=" + n);
        }
        this.createTable();
        PreparedStatement preparedStatement = null;
        String string = null;
        try {
            try {
                string = "update \"" + this.mTableName + "\" set parentid=:1 where id=:2 and collid=:3";
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                preparedStatement = this.getConnection().prepareStatement(string);
                preparedStatement.setEscapeProcessing(false);
                preparedStatement.setLong(1, l2);
                preparedStatement.setLong(2, l);
                preparedStatement.setInt(3, n);
                preparedStatement.execute();
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**changeParent** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28031", new Object[]{this.mTableName, new Integer(n), new Long(l)}, sQLException);
                Object var10_7 = null;
                OraclePersistManager.closeStmt(preparedStatement);
                return;
            }
            Object var10_6 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            OraclePersistManager.closeStmt(preparedStatement);
            preparedStatement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt(preparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void delete(long l, int n) {
        if (Diagnostic.isOn()) {
            Diagnostic.println("**delete** id=" + l + ", collid=" + n);
        }
        this.createTable();
        OraclePreparedStatement oraclePreparedStatement = null;
        String string = null;
        try {
            try {
                string = "delete \"" + this.mTableName + "\" where collid=:1 and id=:2";
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
                oraclePreparedStatement.setEscapeProcessing(false);
                oraclePreparedStatement.setInt(1, n);
                oraclePreparedStatement.setLong(2, l);
                oraclePreparedStatement.execute();
                string = null;
                this.updateKeyInfo(l, n, null);
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**delete** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28032", new Object[]{this.mTableName, new Integer(n), new Long(l)}, sQLException);
                Object var8_6 = null;
                OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
                return;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            OraclePersistManager.closeStmt(oraclePreparedStatement);
            oraclePreparedStatement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void deleteAll(int n) {
        if (!this.mTableCreated && !this.mPersistent) {
            return;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("**deleteAll** collid=" + n);
        }
        this.createTable();
        OraclePreparedStatement oraclePreparedStatement = null;
        String string = null;
        try {
            try {
                string = "delete \"" + this.mTableName + "\" where collid=:1";
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
                oraclePreparedStatement.setEscapeProcessing(false);
                oraclePreparedStatement.setInt(1, n);
                oraclePreparedStatement.execute();
                string = null;
                this.updateKeyInfo(0L, n, null);
                this.commitIfNeeded();
            }
            catch (SQLException sQLException) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**deleteAll** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(sQLException);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28038", new Object[]{this.mTableName, new Integer(n)}, sQLException);
                Object var6_5 = null;
                OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
                return;
            }
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OraclePersistManager.closeStmt(oraclePreparedStatement);
            oraclePreparedStatement = null;
            throw throwable;
        }
        OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object[] retrieve(long l, int n, boolean bl, long[] lArray) {
        String string;
        InputStream inputStream;
        PCollKeyInfo[] pCollKeyInfoArray;
        block19: {
            if (!this.mTableCreated && !this.mPersistent) {
                return null;
            }
            if (Diagnostic.isOn()) {
                Diagnostic.print("**retrieve** id=" + l + ", collid=" + n + ", keyonly=" + bl);
            }
            OraclePreparedStatement oraclePreparedStatement = null;
            OracleResultSet oracleResultSet = null;
            pCollKeyInfoArray = null;
            InputStream inputStream2 = null;
            ObjectInputStream objectInputStream = null;
            inputStream = null;
            string = null;
            try {
                block18: {
                    try {
                        BLOB bLOB;
                        string = bl ? (this.mKeyInfoTableCreated ? "select parentId, keycont from \"" + this.mTableName + "\" where id=:1 and collid=:2" : "select parentId from \"" + this.mTableName + "\" where id=:1 and collid=:2") : (this.mKeyInfoTableCreated ? "select parentId, content, keycont from \"" + this.mTableName + "\" where id=:1 and collid=:2" : "select parentId, content from \"" + this.mTableName + "\" where id=:1 and collid=:2");
                        oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
                        oraclePreparedStatement.setEscapeProcessing(false);
                        oraclePreparedStatement.setLong(1, l);
                        oraclePreparedStatement.setInt(2, n);
                        oraclePreparedStatement.defineColumnType(1, 4);
                        if (bl) {
                            if (this.mKeyInfoTableCreated) {
                                oraclePreparedStatement.defineColumnType(2, 2004);
                            }
                        } else if (this.mKeyInfoTableCreated) {
                            oraclePreparedStatement.defineColumnType(2, 2004);
                            oraclePreparedStatement.defineColumnType(3, 2004);
                        } else {
                            oraclePreparedStatement.defineColumnType(2, 2004);
                        }
                        int n2 = 1;
                        oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                        if (!oracleResultSet.next()) break block18;
                        lArray[0] = oracleResultSet.getLong(n2++);
                        if (!bl) {
                            BLOB bLOB2 = oracleResultSet.getBLOB(n2++);
                            inputStream = bLOB2.getBinaryStream();
                        }
                        if (!this.mKeyInfoTableCreated || (bLOB = oracleResultSet.getBLOB(n2++)) == null) break block18;
                        inputStream2 = bLOB.getBinaryStream();
                        objectInputStream = new ObjectInputStream(inputStream2);
                        pCollKeyInfoArray = this.deserializeKeyArr(objectInputStream);
                    }
                    catch (Exception exception) {
                        Class clazz;
                        if (this.mPersistent && exception instanceof SQLException && 942 == ((SQLException)exception).getErrorCode()) {
                            Object[] objectArray = null;
                            Object var19_16 = null;
                            PCollNode.closeInputStream(objectInputStream);
                            objectInputStream = null;
                            PCollNode.closeInputStream(inputStream2);
                            inputStream2 = null;
                            OraclePersistManager.closeResultSet(oracleResultSet);
                            oracleResultSet = null;
                            OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
                            return objectArray;
                        }
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("**retrieve** error, sqlStmt=" + string);
                            Diagnostic.printStackTrace(exception);
                        }
                        if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                            clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                        }
                        PCollException.throwException(clazz, "28033", new Object[]{this.mTableName, new Integer(n), new Long(l)}, exception);
                        Object var19_17 = null;
                        PCollNode.closeInputStream(objectInputStream);
                        objectInputStream = null;
                        PCollNode.closeInputStream(inputStream2);
                        inputStream2 = null;
                        OraclePersistManager.closeResultSet(oracleResultSet);
                        oracleResultSet = null;
                        OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
                        oraclePreparedStatement = null;
                        break block19;
                    }
                }
                Object var19_15 = null;
            }
            catch (Throwable throwable) {
                Object var19_18 = null;
                PCollNode.closeInputStream(objectInputStream);
                objectInputStream = null;
                PCollNode.closeInputStream(inputStream2);
                inputStream2 = null;
                OraclePersistManager.closeResultSet(oracleResultSet);
                oracleResultSet = null;
                OraclePersistManager.closeStmt(oraclePreparedStatement);
                oraclePreparedStatement = null;
                throw throwable;
            }
            PCollNode.closeInputStream(objectInputStream);
            objectInputStream = null;
            PCollNode.closeInputStream(inputStream2);
            inputStream2 = null;
            OraclePersistManager.closeResultSet((ResultSet)oracleResultSet);
            oracleResultSet = null;
            OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
            oraclePreparedStatement = null;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.print(", parid=" + lArray[0]);
            if (inputStream == null) {
                Diagnostic.println(", null");
            } else {
                Diagnostic.println(", ret=" + inputStream.getClass().getName());
            }
            Diagnostic.println("   stmt: " + string);
        }
        return new Object[]{pCollKeyInfoArray, inputStream};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized long[] retrieveIdsWithKey(int n, Object object, int n2) {
        if (!(this.mTableCreated && this.mKeyInfoTableCreated || this.mPersistent)) {
            return new long[0];
        }
        int n3 = object.hashCode();
        if (Diagnostic.isOn()) {
            Diagnostic.println("**retrieveIdsWithKey** keyId=" + n + ", keyval.hash=" + n3 + ", collid=" + n2);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        OracleResultSet oracleResultSet = null;
        PCollKeyInfo[] pCollKeyInfoArray = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        long[] lArray = null;
        String string = null;
        try {
            Object var19_16;
            try {
                string = "select k.id, t.keycont from \"" + this.mKeyInfoTableName + "\" k, \"" + this.mTableName + "\" t where k.collid=:1 and k.keyid=:2 and k.keyhash=:3 and k.collid=t.collid and k.id=t.id";
                oraclePreparedStatement = (OraclePreparedStatement)this.getConnection().prepareStatement(string);
                oraclePreparedStatement.setEscapeProcessing(false);
                oraclePreparedStatement.setInt(1, n2);
                oraclePreparedStatement.setInt(2, n);
                oraclePreparedStatement.setInt(3, n3);
                oraclePreparedStatement.defineColumnType(1, 4);
                oraclePreparedStatement.defineColumnType(2, 2004);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("   stmt: " + string);
                }
                oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
                ArrayList arrayList = new ArrayList();
                block4: while (oracleResultSet.next()) {
                    BLOB bLOB = oracleResultSet.getBLOB(2);
                    if (bLOB == null || (pCollKeyInfoArray = this.deserializeKeyArr(objectInputStream = new ObjectInputStream(inputStream = bLOB.getBinaryStream()))) == null) continue;
                    int n4 = 0;
                    while (n4 < pCollKeyInfoArray.length) {
                        if (n == pCollKeyInfoArray[n4].mKeyId && object.equals(pCollKeyInfoArray[n4].mKey)) {
                            arrayList.add((Object)new Long(oracleResultSet.getLong(1)));
                            continue block4;
                        }
                        ++n4;
                    }
                }
                lArray = new long[arrayList.size()];
                int n5 = 0;
                while (n5 < lArray.length) {
                    lArray[n5] = (Long)arrayList.get(n5);
                    ++n5;
                }
            }
            catch (Exception exception) {
                Class clazz;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("**retrieveIdsWithKey** error, sqlStmt=" + string);
                    Diagnostic.printStackTrace(exception);
                }
                if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = OraclePersistManager.class$("oracle.jbo.CSMessageBundle");
                }
                PCollException.throwException(clazz, "28040", new Object[]{this.mTableName, new Integer(n), new Integer(n3)}, exception);
                var19_16 = null;
                PCollNode.closeInputStream(objectInputStream);
                objectInputStream = null;
                PCollNode.closeInputStream(inputStream);
                inputStream = null;
                OraclePersistManager.closeResultSet(oracleResultSet);
                oracleResultSet = null;
                OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
                oraclePreparedStatement = null;
            }
            var19_16 = null;
            PCollNode.closeInputStream(objectInputStream);
            objectInputStream = null;
            PCollNode.closeInputStream(inputStream);
            inputStream = null;
            OraclePersistManager.closeResultSet((ResultSet)oracleResultSet);
            oracleResultSet = null;
            OraclePersistManager.closeStmt((Statement)oraclePreparedStatement);
            oraclePreparedStatement = null;
        }
        catch (Throwable throwable) {
            Object var19_17 = null;
            PCollNode.closeInputStream(objectInputStream);
            objectInputStream = null;
            PCollNode.closeInputStream(inputStream);
            inputStream = null;
            OraclePersistManager.closeResultSet(oracleResultSet);
            oracleResultSet = null;
            OraclePersistManager.closeStmt(oraclePreparedStatement);
            oraclePreparedStatement = null;
            throw throwable;
        }
        if (lArray == null) {
            lArray = new long[]{};
        }
        if (Diagnostic.isOn()) {
            Diagnostic.print("   ret=");
            int n6 = 0;
            while (n6 < lArray.length) {
                Diagnostic.print("[" + n6 + "]" + lArray[n6]);
                if (n6 + 1 < lArray.length) {
                    Diagnostic.print(",");
                }
                ++n6;
            }
            Diagnostic.println("");
        }
        return lArray;
    }

    public void notifyPCollEvent(int n, Object object, Object object2) {
        if (PCollection.mEventTrace) {
            PCollection.printPCollEvent(n, object, object2);
        }
    }

    public void setSequenceIncrementSize(long l) {
        this.mSequenceIncrementSize = l;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

