/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.mom;

import oracle.adf.share.ADFContext;
import oracle.jbo.NoXMLFileException;
import oracle.jbo.PersistenceException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboNameUtil;
import oracle.jbo.mom.DefinitionManager;
import oracle.jbo.mom.MOMParser;
import oracle.jbo.mom.xml.DefDocument;
import oracle.jbo.mom.xml.DefDocumentImplMDS;
import oracle.mds.core.MDSSession;
import oracle.mds.core.MetadataNotFoundException;
import oracle.mds.core.MetadataObject;
import oracle.mds.exception.MDSException;

public class MOMParserMDS
extends MOMParser {
    MOMParserMDS(DefinitionManager definitionManager) {
        super(definitionManager);
    }

    DefDocument readAndParse(String string) {
        String string2 = JboNameUtil.getDocumentName(string);
        DefDocumentImplMDS defDocumentImplMDS = null;
        MetadataObject metadataObject = null;
        try {
            metadataObject = this.getMDSSession().getMetadataObject(string2);
            defDocumentImplMDS = new DefDocumentImplMDS(metadataObject);
        }
        catch (MetadataNotFoundException metadataNotFoundException) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("No XML file " + string2 + " for metaobject " + string);
                Diagnostic.println(metadataNotFoundException.getErrorMessage());
            }
            throw new NoXMLFileException(string2);
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                String string3 = metadataObject == null ? "getMetadataObject" : "getMElement";
                Diagnostic.println("Generic exception trying to " + string3 + " for XML file " + string2);
                if (exception instanceof MDSException) {
                    Diagnostic.println(((MDSException)exception).getErrorMessage());
                }
                Diagnostic.printStackTrace(exception);
            }
            PersistenceException persistenceException = new PersistenceException("26000", null);
            persistenceException.addToDetails(exception);
            throw persistenceException;
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("Loading from XML file " + string2);
        }
        return defDocumentImplMDS;
    }

    private MDSSession getMDSSession() {
        Exception exception = null;
        MDSSession mDSSession = null;
        try {
            mDSSession = (MDSSession)ADFContext.getCurrent().getMDSSessionAsObject();
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (mDSSession == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("Generic exception trying to get MDSSession");
                if (exception instanceof MDSException) {
                    Diagnostic.println(((MDSException)exception).getErrorMessage());
                }
                Diagnostic.printStackTrace(exception);
            }
            PersistenceException persistenceException = new PersistenceException("26000", null);
            if (exception != null) {
                persistenceException.addToDetails(exception);
            }
            throw persistenceException;
        }
        return mDSSession;
    }
}

