/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.expr;

import java.io.IOException;
import java.io.LineNumberReader;
import oracle.jbo.expr.JIException;
import oracle.jbo.expr.JIToken;

public class JIInput {
    public static final int WORD_POS_STACK_DEPTH = 20;
    public static final int WORD_TYP_UNKNOWN = -1;
    public static final int WORD_TYP_NONE = 0;
    public static final int WORD_TYP_IDENT = 1;
    public static final int WORD_TYP_INTEGER = 2;
    public static final int WORD_TYP_STRING = 3;
    public static final int WORD_TYP_BOOLEAN = 4;
    public static final int WORD_TYP_CHAR = 5;
    public static final int WORD_TYP_NULL = 20;
    protected char lexStringBegin;
    protected char lexStringEnd;
    protected char lexCharBegin;
    protected char lexCharEnd;
    private int[] mWordPosStack;
    private int mWordPosStackIndx;
    private LineNumberReader mInStream;
    private String mLn;
    private int mLnPos;
    private int mLnLen;
    private boolean mContinueRead;
    private boolean mIdentToUpper;

    private /* synthetic */ void $init$() {
        this.lexStringBegin = (char)34;
        this.lexStringEnd = (char)34;
        this.lexCharBegin = (char)39;
        this.lexCharEnd = (char)39;
        this.mWordPosStackIndx = -1;
        this.mLn = null;
        this.mLnPos = 0;
        this.mLnLen = 0;
        this.mContinueRead = false;
        this.mIdentToUpper = false;
    }

    public JIInput() {
        this.$init$();
        this.mWordPosStack = new int[20];
        this.initLexChars();
    }

    public JIInput(LineNumberReader lineNumberReader) {
        this();
        this.setInStream(lineNumberReader);
    }

    protected void initLexChars() {
    }

    public void setContinueRead(boolean bl) {
        this.mContinueRead = bl;
    }

    public void setIdentToUpper(boolean bl) {
        this.mIdentToUpper = bl;
    }

    public LineNumberReader getInStream() {
        return this.mInStream;
    }

    public void setInStream(LineNumberReader lineNumberReader) {
        this.mInStream = lineNumberReader;
    }

    public String getLine() {
        return this.mLn;
    }

    public void setLine(String string) {
        this.mLn = string;
        this.mLnPos = 0;
        this.mLnLen = this.mLn.length();
        this.mWordPosStackIndx = -1;
    }

    public int getPos() {
        return this.mLnPos;
    }

    public void setPos(int n) {
        this.mLnPos = n;
    }

    public boolean readLine() throws IOException {
        this.mLn = this.mInStream.readLine();
        this.mLnPos = 0;
        this.mLnLen = this.mLn != null ? this.mLn.length() : 0;
        if (!this.mContinueRead) {
            this.mWordPosStackIndx = -1;
        }
        return this.mLn != null;
    }

    public String getTheRestOfLine() {
        char c;
        while (this.mLnPos < this.mLnLen && ((c = this.mLn.charAt(this.mLnPos)) == ' ' || c == '\t' || c == '\n' || c == '\r')) {
            ++this.mLnPos;
        }
        String string = this.mLn.substring(this.mLnPos, this.mLnLen);
        this.mLnPos = this.mLnLen;
        this.pushWord();
        return string;
    }

    public String getTheRestOfLineTrim() {
        return this.getTheRestOfLine().trim();
    }

    public void pushWord() {
        if (this.mWordPosStackIndx + 1 >= 20) {
            int n = 0;
            while (n < 19) {
                this.mWordPosStack[n] = this.mWordPosStack[n + 1];
                ++n;
            }
        } else {
            ++this.mWordPosStackIndx;
        }
        this.mWordPosStack[this.mWordPosStackIndx] = this.mLnPos;
    }

    public void rewindWord() {
        if (this.mWordPosStackIndx < 0) {
            throw new JIException("No word to rewind");
        }
        if (this.mWordPosStackIndx == 0) {
            this.mLnPos = 0;
            this.mWordPosStackIndx = -1;
        } else {
            this.mLnPos = this.mWordPosStack[--this.mWordPosStackIndx];
        }
    }

    public static boolean isAlpha(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    public static boolean isNumber(int n) {
        return n >= 48 && n <= 57;
    }

    /*
     * Unable to fully structure code
     */
    public JIToken findNextWord(boolean var1_1, boolean var2_2) {
        do {
            if (!this.mContinueRead || this.mLnPos < this.mLnLen) ** GOTO lbl13
            try {
                if (!this.readLine()) {
                    if (var2_2) {
                        this.pushWord();
                    }
                    var8_5 = new JIToken("", 0, this.mIdentToUpper);
                    return var8_5;
                }
                ** GOTO lbl13
            }
            catch (IOException var4_6) {
                throw new JIException("readline error", var4_6);
            }
lbl-1000:
            // 1 sources

            {
                ++this.mLnPos;
lbl13:
                // 3 sources

                ** while (this.mLnPos < this.mLnLen && ((var3_3 = this.mLn.charAt((int)this.mLnPos)) == ' ' || var3_3 == '\t' || var3_3 == '\n' || var3_3 == '\r'))
            }
lbl14:
            // 1 sources

            var5_4 = this.mLnPos;
            if (this.mLnPos < this.mLnLen && this.mLn.charAt(this.mLnPos) == this.lexStringBegin) {
                var6_7 = "";
                ++this.mLnPos;
                while (this.mLnPos < this.mLnLen) {
                    var3_3 = this.mLn.charAt(this.mLnPos);
                    if (var3_3 == this.lexStringEnd) {
                        ++this.mLnPos;
                        break;
                    }
                    if (var3_3 == '\\') {
                        ++this.mLnPos;
                        if (this.mLnPos >= this.mLnLen) {
                            throw new JIException("Improper string literal");
                        }
                        var3_3 = this.mLn.charAt(this.mLnPos);
                    }
                    var6_7 = var6_7 + var3_3;
                    ++this.mLnPos;
                }
                if (var2_2) {
                    this.pushWord();
                }
                return new JIToken(var6_7, 3, this.mIdentToUpper);
            }
            if (this.mLnPos < this.mLnLen && this.mLn.charAt(this.mLnPos) == this.lexCharBegin) {
                var7_8 = "";
                ++this.mLnPos;
                while (this.mLnPos < this.mLnLen) {
                    var3_3 = this.mLn.charAt(this.mLnPos);
                    if (var3_3 == this.lexCharEnd) {
                        ++this.mLnPos;
                        break;
                    }
                    if (var3_3 == '\\') {
                        ++this.mLnPos;
                        if (this.mLnPos >= this.mLnLen) {
                            throw new JIException("Improper character literal");
                        }
                        var3_3 = this.mLn.charAt(this.mLnPos);
                    }
                    var7_8 = var7_8 + var3_3;
                    ++this.mLnPos;
                }
                if (var7_8.length() != 1) {
                    throw new JIException("Improper character literal");
                }
                if (var2_2) {
                    this.pushWord();
                }
                return new JIToken(var7_8, 5, this.mIdentToUpper);
            }
            if (var1_1) {
                while (this.mLnPos < this.mLnLen && (var3_3 = this.mLn.charAt(this.mLnPos)) != ' ' && var3_3 != '\t' && var3_3 != '\n' && var3_3 != '\r') {
                    ++this.mLnPos;
                }
            } else if (this.mLnPos < this.mLnLen) {
                var3_3 = this.mLn.charAt(this.mLnPos);
                ++this.mLnPos;
                if (JIInput.isNumber(var3_3) || JIInput.isAlpha(var3_3) || var3_3 == '_') {
                    while (this.mLnPos < this.mLnLen && (JIInput.isNumber(var3_3 = this.mLn.charAt(this.mLnPos)) || JIInput.isAlpha(var3_3) || var3_3 == '_')) {
                        ++this.mLnPos;
                    }
                }
            }
            if (var5_4 < this.mLnLen && this.mLnPos - var5_4 > 0) {
                if (var2_2) {
                    this.pushWord();
                }
                return new JIToken(this.mLn.substring(var5_4, this.mLnPos), -1, this.mIdentToUpper);
            }
            this.mLnPos = this.mLnLen;
        } while (this.mContinueRead);
        if (var2_2) {
            this.pushWord();
        }
        return new JIToken("", 0, this.mIdentToUpper);
    }

    public JIToken findNextWord(boolean bl) {
        return this.findNextWord(bl, true);
    }
}

