/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ws;

import java.util.BitSet;
import oracle.jbo.ApplicationModule;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.ws.WSApplicationModuleImpl;
import oracle.jbo.common.ws.WSObject;

public abstract class WSAMComponent
extends WSObject {
    private BitSet mChangeFlags;
    protected transient Class mMsgBundleClass;
    private String mMsgBundleClassName;

    private /* synthetic */ void $init$() {
        this.mChangeFlags = null;
    }

    WSAMComponent() {
        this.$init$();
        int n = this.getNumChangeFlags();
        if (n > 0) {
            this.mChangeFlags = new BitSet(n);
        }
    }

    int getNumChangeFlags() {
        return 0;
    }

    boolean isClient() {
        return ((WSApplicationModuleImpl)this.getApplicationModule()).isClient();
    }

    void afterCreate() {
        if (!this.isClient()) {
            this.doInit();
        }
    }

    abstract void doInit();

    abstract ApplicationModule getApplicationModule();

    final void processWSException(Exception exception) {
        WSApplicationModuleImpl wSApplicationModuleImpl = (WSApplicationModuleImpl)this.getApplicationModule();
        wSApplicationModuleImpl.processWSException(exception, this);
    }

    boolean getChangeFlag(int n) {
        return this.mChangeFlags.get(n);
    }

    void setChangeFlag(int n, boolean bl) {
        if (bl) {
            this.mChangeFlags.set(n);
        } else {
            this.mChangeFlags.clear(n);
        }
        ((WSApplicationModuleImpl)this.getApplicationModule()).setIsSyncNeeded(true);
    }

    void clearChangeFlags() {
        this.mChangeFlags.clear();
    }

    protected void internalSetMessageBundleClass(Class clazz) {
        this.mMsgBundleClass = clazz;
        this.mMsgBundleClassName = clazz.getName();
    }

    public Class getMessageBundleClass() {
        block3: {
            if (this.mMsgBundleClass == null && this.mMsgBundleClassName != null) {
                try {
                    this.mMsgBundleClass = JBOClass.forName(this.mMsgBundleClassName);
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block3;
                    Diagnostic.println("Cannot find message bundle class :" + this.mMsgBundleClassName);
                    exception.printStackTrace();
                }
            }
        }
        return this.mMsgBundleClass;
    }
}

