/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import oracle.jbo.pool.AgeHistogram;
import oracle.jbo.pool.ResourcePoolStatistics;

public class Statistics
extends ResourcePoolStatistics {
    public long mNumOfStateActivations;
    public long mNumOfStatePassivations;
    public long mNumOfInstancesReused;
    public long mNumOfReferencedInstancesRecycled;
    public long mNumOfUnreferencedInstancesRecycled;
    public int mReferencedApplicationModules;
    public int mNumOfSessions;
    public long mAvgNumOfSessionsReferencingState;
    public AgeHistogram mSessionAgeHistogram;
    public AgeHistogram mRefInstanceAgeHistogram;
    public AgeHistogram mUnrefInstanceAgeHistogram;

    private /* synthetic */ void $init$() {
        this.mNumOfStateActivations = 0L;
        this.mNumOfStatePassivations = 0L;
        this.mNumOfInstancesReused = 0L;
        this.mNumOfReferencedInstancesRecycled = 0L;
        this.mNumOfUnreferencedInstancesRecycled = 0L;
        this.mReferencedApplicationModules = 0;
        this.mNumOfSessions = 0;
        this.mAvgNumOfSessionsReferencingState = 0L;
        this.mSessionAgeHistogram = null;
        this.mRefInstanceAgeHistogram = null;
        this.mUnrefInstanceAgeHistogram = null;
    }

    public Object clone() {
        return super.clone();
    }

    public void add(ResourcePoolStatistics resourcePoolStatistics) {
        super.add(resourcePoolStatistics);
        Statistics statistics = (Statistics)resourcePoolStatistics;
        this.mNumOfStateActivations += statistics.mNumOfStateActivations;
        this.mNumOfStatePassivations += statistics.mNumOfStatePassivations;
        this.mNumOfInstancesReused += statistics.mNumOfInstancesReused;
        this.mNumOfReferencedInstancesRecycled += statistics.mNumOfReferencedInstancesRecycled;
        this.mNumOfUnreferencedInstancesRecycled += statistics.mNumOfUnreferencedInstancesRecycled;
        this.mReferencedApplicationModules += statistics.mReferencedApplicationModules;
        this.mNumOfSessions += statistics.mNumOfSessions;
        this.mAvgNumOfSessionsReferencingState = (statistics.mNumOfSessions + this.mNumOfSessions) / 2;
        if (this.mSessionAgeHistogram != null && statistics.mSessionAgeHistogram != null) {
            this.mSessionAgeHistogram.add(statistics.mSessionAgeHistogram);
        }
        if (this.mRefInstanceAgeHistogram != null && statistics.mRefInstanceAgeHistogram != null) {
            this.mRefInstanceAgeHistogram.add(statistics.mRefInstanceAgeHistogram);
        }
        if (this.mUnrefInstanceAgeHistogram != null && statistics.mUnrefInstanceAgeHistogram != null) {
            this.mUnrefInstanceAgeHistogram.add(statistics.mUnrefInstanceAgeHistogram);
        }
    }

    public Statistics() {
        this.$init$();
    }
}

