/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common.ampool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class AMStatistics
implements Serializable,
Cloneable {
    static final long serialVersionUID = -3614862695406879642L;
    public long mNumOfVOs;
    public long mNumOfViewLinks;
    public long mNumNestedAppModules;
    public String mSessionID;
    public long mLockTime;
    public long mCreationTimeMillis;
    public long mReleaseTime;
    public long mTimeToCreateMillis;
    public String mName;
    public int mID;
    public long startTime;
    public long lastSampleTime;
    private Map customStats;

    private /* synthetic */ void $init$() {
        this.mNumOfVOs = 0L;
        this.mNumOfViewLinks = 0L;
        this.mNumNestedAppModules = 0L;
        this.mCreationTimeMillis = 0L;
        this.mReleaseTime = 0L;
        this.mTimeToCreateMillis = 0L;
        this.startTime = new Date().getTime();
        this.customStats = null;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return object;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime;
    }

    public List getStatisticsInfo(Locale locale) {
        ArrayList<StatsInfo> arrayList = new ArrayList<StatsInfo>();
        arrayList.add(new CountStatsInfo(this.mNumOfVOs, "NumOfVOs", "Number of View Objects"));
        arrayList.add(new CountStatsInfo(this.mNumOfViewLinks, "NumOfViewLinks", "Number of View Links"));
        arrayList.add(new CountStatsInfo(this.mNumNestedAppModules, "NumNestedAppModules", "Number of Nested Application Modules"));
        arrayList.add(new StringStatsInfo(this.mSessionID, "SessionID", "Session ID"));
        arrayList.add(new CountStatsInfo(this.mLockTime, "LockTime", "Lock Time"));
        arrayList.add(new CountStatsInfo(this.mCreationTimeMillis, "mCreationTimeMillis", "Creation time for this Application Module"));
        arrayList.add(new CountStatsInfo(this.mReleaseTime, "ReleaseTime", "ApplicationModule Release Time"));
        arrayList.add(new CountStatsInfo(this.mTimeToCreateMillis, "TimeToCreateinMilliSeconds", "Time to Create the Applicaiton Module"));
        arrayList.add(new StringStatsInfo(this.mName, "Name", "Application Module Name"));
        arrayList.add(new CountStatsInfo(this.mID, "ID", "Application Module ID"));
        if (this.customStats != null) {
            Iterator iterator = this.customStats.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add((StatsInfo)this.customStats.get(iterator.next()));
            }
        }
        return arrayList;
    }

    public void add(String string, StatsInfo statsInfo) {
        if (string == null || statsInfo == null) {
            return;
        }
        if (this.customStats == null) {
            this.customStats = new Hashtable();
        }
        this.customStats.put(string, statsInfo);
    }

    public AMStatistics() {
        this.$init$();
    }

    public static class CountStatsInfo
    extends StatsInfo {
        private long _value;

        public CountStatsInfo(long l, String string, String string2) {
            this._value = l;
            this._name = string;
            this._description = string2;
            this._type = "Count";
            this._valueAsObject = new Long(l);
        }

        public long getValue() {
            return this._value;
        }
    }

    public static class StringStatsInfo
    extends StatsInfo {
        String _value;

        public StringStatsInfo(String string, String string2, String string3) {
            this._value = string;
            this._name = string2;
            this._description = string3;
            this._type = "Value";
            this._valueAsObject = string;
        }

        public String getValue() {
            return this._value;
        }
    }

    public static abstract class StatsInfo
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 3826360572486478372L;
        protected String _type;
        protected String _name;
        protected String _description;
        protected Object _valueAsObject;

        public String getName() {
            return this._name;
        }

        public Object getValueAsObject() {
            return this._valueAsObject;
        }

        public String getType() {
            return this._type;
        }

        public String getDescription() {
            return this._description;
        }
    }
}

