/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;

public class SerializationUtils {
    public static byte[] getBytesFromObject(Object object) {
        return SerializationUtils.getBytesFromObject(object, -1);
    }

    public static byte[] getBytesFromObject(Object object, int n) {
        if (object == null) {
            return null;
        }
        if (n == -1) {
            n = 512;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static Object getObjectFromBytes(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                Object object = objectInputStream.readObject();
                return object;
            }
            catch (Exception exception) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Failed to getObjectFromBytes, msg:\n" + exception.getMessage());
                }
                if (!(exception instanceof JboException)) {
                    throw new JboException(exception);
                }
                throw (JboException)exception;
            }
        }
        return null;
    }
}

