/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import oracle.bali.share.nls.StringUtils;

public final class ResourceUtils {
    private static final char _MNEMONIC_INDICATOR = '&';

    private ResourceUtils() {
    }

    public static void resLabel(JLabel jLabel, Component component, String string) {
        jLabel.setText(ResourceUtils.stripMnemonic(string));
        jLabel.setDisplayedMnemonic(ResourceUtils.getMnemonicKeyCode(string));
        jLabel.setLabelFor(component);
    }

    public static void resButton(AbstractButton abstractButton, String string) {
        abstractButton.setText(ResourceUtils.stripMnemonic(string));
        abstractButton.setMnemonic(ResourceUtils.getMnemonicKeyCode(string));
    }

    public static int getMnemonicKeyCode(String string) {
        return ResourceUtils._getMnemonicKeyCode(string);
    }

    public static String stripMnemonic(String string) {
        return StringUtils.stripMnemonic((String)string);
    }

    private static int _getMnemonicKeyCode(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length() - 1;
        int n2 = 0;
        while (n2 < n) {
            int n3 = string.indexOf(38, n2);
            if (n3 == -1 || n3 >= n) break;
            char c = string.charAt(n3 + 1);
            if (c != '&') {
                return Character.toUpperCase(c);
            }
            n2 = n3 + 2;
        }
        return 0;
    }
}

