/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import oracle.jbo.PiggybackException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PiggybackInputStream;

public class PiggybackInput {
    private Serializable[] mEntries;
    private Class mEntryClass;

    public PiggybackInput() {
        this.mEntries = null;
        this.mEntryClass = null;
    }

    public PiggybackInput(byte[] byArray) {
        this(null, byArray);
    }

    public PiggybackInput(ObjectMarshaller objectMarshaller, byte[] byArray) {
        try {
            if (byArray == null || byArray.length <= 4) {
                this.mEntries = new Serializable[0];
            } else {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                PiggybackInputStream piggybackInputStream = new PiggybackInputStream(objectMarshaller, byteArrayInputStream);
                int n = piggybackInputStream.readInt();
                String string = piggybackInputStream.readUTF();
                this.mEntryClass = JBOClass.forName(string);
                this.mEntries = new Serializable[n];
                int n2 = 0;
                while (n2 < n) {
                    this.mEntries[n2] = (Serializable)piggybackInputStream.readObject();
                    ++n2;
                }
            }
        }
        catch (Exception exception) {
            if (Diagnostic.isOn()) {
                Diagnostic.printStackTrace(exception);
            }
            PiggybackException piggybackException = new PiggybackException("JBO-28300: Piggyback read error");
            piggybackException.addToDetails(exception);
            throw piggybackException;
        }
    }

    public Class getEntryClass() {
        return this.mEntryClass;
    }

    public Serializable[] getPiggybackEntries() {
        return this.mEntries;
    }

    public int getNumOfEntries() {
        return this.mEntries.length;
    }
}

